/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIBONEEL {
    public static AISTATE boneelIdle;
    public static AISTATE boneelChase;
    public static AISTATE boneelGoto;
    public static AISTATE boneelBite;
    public static AISTATE boneelRecoil;
    public static AISTATE boneelSearch;
    public static AISTATE boneelDown;
    public static AISTATE boneelUp;
    public static AISTATE boneelTurn;

    public static void Init() {
        boneelIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.myThinkTarget(sprite, xsprite);
            }
        };
        boneelChase = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, boneelIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 0, null, 600, false, false, true, boneelIdle){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.thinkGoto(sprite, xsprite);
            }
        };
        boneelBite = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIBONEEL.BiteCallback(nXSprite);
            }
        }, 60, false, false, false, boneelChase);
        boneelRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 1, false, false, false, boneelChase){

            @Override
            public void callback(int nXSprite) {
                if (DEMO.IsOriginalDemo()) {
                    AIBONEEL.BiteCallback(nXSprite);
                }
            }
        };
        boneelSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 120, false, true, true, boneelIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.thinkSearch(sprite, xsprite);
            }
        };
        boneelDown = new AISTATE(AISTATEFUNC.Type.other, 0, null, 60, false, true, true, boneelChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelUp = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, boneelChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelTurn = new AISTATE(AISTATEFUNC.Type.other, 0, null, 60, false, true, false, boneelChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
    }

    private static void BiteCallback(int nXIndex) {
        int dz;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        if (DEMO.IsOriginalDemo()) {
            if (!Actor.IsDudeSprite(pTarget)) {
                return;
            }
            dz = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat << 2;
            dz -= DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat << 2;
        } else {
            dz = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat;
            if (pXSprite.target != -1) {
                dz = pTarget.z - pSprite.z;
            }
        }
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 7);
    }

    private static void myMoveDown(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(16384) || Main.engine.qdist(dx, dy) > 921L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * (pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = 139810L;
        }
    }

    private static void myMoveUp(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 921L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * (pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = -32768L;
        }
    }

    private static void myMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        int dy;
        int dx;
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        if (Main.engine.qdist(dx = pXSprite.targetX - pSprite.x, dy = pXSprite.targetY - pSprite.y) > 921L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * (pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += fvel) : (vel += fvel >> 1);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        AIBONEEL.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
        }
        AIBONEEL.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, boneelGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            Gameutils.GetSpriteExtents(pSprite);
            int zTop1 = Gameutils.extents_zTop;
            Gameutils.GetSpriteExtents(pTarget);
            int zTop2 = Gameutils.extents_zTop;
            int zBot2 = Gameutils.extents_zBot;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                if (dist <= 921 && Pragmas.klabs(losAngle) < 85) {
                    if (zTop2 > zTop1) {
                        Ai.aiNewState(pSprite, pXSprite, boneelDown);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, boneelBite);
                    }
                    return;
                }
                if (zBot2 > zTop1 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, boneelDown);
                } else if (zTop2 < zTop1 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, boneelUp);
                }
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            pXSprite.target = -1;
        }
    }

    private static void myThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (Ai.aiActive[pSprite.xvel] != 0) {
            if (Ai.aiThinkTime[pSprite.xvel] >= 10) {
                Ai.aiThinkTime[pSprite.xvel] = 0;
                pXSprite.goalAng += 256;
                Vector3 kSprite = Trigger.ksprite[pSprite.xvel];
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, boneelTurn);
                return;
            }
            short s = pSprite.xvel;
            Ai.aiThinkTime[s] = Ai.aiThinkTime[s] + 1;
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                int dist = (int)Main.engine.qdist(dx, dy);
                if ((dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < pDudeInfo.hearDist) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }
}

