/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AICALEB {
    public static AISTATE[] calebIdle = new AISTATE[2];
    public static AISTATE[] calebSearch = new AISTATE[2];
    public static AISTATE[] calebGoto = new AISTATE[2];
    public static AISTATE[] calebDodge = new AISTATE[2];
    public static AISTATE[] calebChase = new AISTATE[2];
    public static AISTATE[] calebRecoil = new AISTATE[2];
    public static AISTATE[] calebHack = new AISTATE[2];
    public static AISTATE calebRTesla;
    public static AISTATE calebMoveTarget;

    public static void Init() {
        AICALEB.calebIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AICALEB.calebIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AICALEB.calebChase[0] = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkChase(sprite, xsprite);
            }
        };
        AICALEB.calebChase[1] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
        AICALEB.calebDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 6, null, 90, false, true, false, calebChase[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AICALEB.calebDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 90, false, true, false, calebChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AICALEB.calebGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 6, null, 600, false, true, true, calebIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkGoto(sprite, xsprite);
            }
        };
        AICALEB.calebGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, calebIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkGotoWater(sprite, xsprite);
            }
        };
        CALLPROC hackCallback = new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AICALEB.HackCallback(nXSprite);
            }
        };
        AICALEB.calebHack[0] = new AISTATE(AISTATEFUNC.Type.other, 0, hackCallback, 120, false, false, false, calebChase[0]);
        AICALEB.calebHack[1] = new AISTATE(AISTATEFUNC.Type.other, 10, hackCallback, 0, false, false, true, calebChase[1]){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
        AICALEB.calebSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 6, null, 120, false, true, true, calebIdle[0]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkSearch(sprite, xsprite);
            }
        };
        AICALEB.calebSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 8, null, 120, false, true, true, calebIdle[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkSearch(sprite, xsprite);
            }
        };
        AICALEB.calebRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, calebDodge[0]);
        AICALEB.calebRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, calebDodge[1]);
        calebRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, calebDodge[0]);
        calebMoveTarget = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, calebChase[1]){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
    }

    private static void HackCallback(int nXSprite) {
        int nSprite = DB.xsprite[nXSprite].reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        int dz = Ai.gDudeSlope[nXSprite];
        dx += Gameutils.BiRandom(1500);
        dy += Gameutils.BiRandom(1500);
        dz += Gameutils.BiRandom(1500);
        int i = 0;
        while (i < 2) {
            int vz = dz + Gameutils.BiRandom2(500);
            int vy = dy + Gameutils.BiRandom2(1000);
            int vx = dx + Gameutils.BiRandom2(1000);
            Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 1);
            ++i;
        }
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(5) + 10000, -1, 0);
        }
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, 1001, -1, 0);
        } else {
            SOUND.sfxStart3DSound(pSprite, 1002, -1, 0);
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        short nXSector = Engine.sector[pSprite.sectnum].extra;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGotoWater(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        short nXSector = Engine.sector[pSprite.sectnum].extra;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        if (pXSprite.target == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiPlaySound(pSprite, Gameutils.Random(4) + 11000, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    short nXSprite = Engine.sprite[pXSprite.reference].extra;
                    if (dist > 0) {
                        Ai.gDudeSlope[nXSprite] = Pragmas.divscale(pTarget.z - pSprite.z, dist, 10);
                    }
                    if (dist < 1433 && Pragmas.klabs(losAngle) < 28) {
                        int hitType = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                        if (hitType == 3 && Engine.sprite[Engine.pHitInfo.hitsprite].lotag == pSprite.lotag) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, calebDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, calebDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, calebHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, calebHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[0]);
        }
        if (Gameutils.Chance(4096)) {
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(5) + 10000, -1, 0);
        }
        pXSprite.target = -1;
    }

    private static void thinkChaseWater(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.target);
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, calebHack[1]);
                        return;
                    }
                    Ai.aiNewState(pSprite, pXSprite, calebMoveTarget);
                    return;
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebMoveTarget);
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
            pXSprite.target = -1;
        }
    }

    private static void myMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Gameutils.Random(64) >= 32 || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 2));
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void myMoveTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pSprite.ang = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long vel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            vel = (vel >> 1) + (long)Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            int z1 = 0;
            if (pXSprite.target != -1) {
                SPRITE pTarget = Engine.sprite[pXSprite.target];
                z1 = pTarget.z;
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight;
                }
            }
            int z2 = pSprite.z + pDudeInfo.eyeHeight;
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = 8 * (z1 - z2);
        }
    }
}

