/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;

public class AIGARG {
    public static AISTATE gargoyleIdle;
    public static AISTATE gargoyleSearch;
    public static AISTATE gargoyleChase;
    public static AISTATE gargoyleRecoil;
    public static AISTATE gargoyleGoto;
    public static AISTATE gargoyleFThrow;
    public static AISTATE gargoyleFSlash;
    public static AISTATE gargoyleSThrow;
    public static AISTATE gargoyleTurn;
    public static AISTATE gargoyleUp;
    public static AISTATE gargoyleDown;
    public static AISTATE statueIdle;
    public static AISTATE statueFTransform;
    public static AISTATE statueFChase;
    public static AISTATE statueSTransform;
    public static AISTATE statueSChase;
    public static AISTATE statueFTransformNew;
    public static AISTATE statueSTransformNew;
    private static WeaponAim gGargData;

    static {
        gGargData = new WeaponAim(65536, 65536, 256, 85, 0x1AAAAA);
    }

    public static void Init() {
        statueIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, false, null);
        gargoyleIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myThinkTarget(sprite, xsprite);
            }
        };
        statueFTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, gargoyleIdle){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                Actor.actHealDude(xsprite, DudeInfo.dudeInfo[6].startHealth, DudeInfo.dudeInfo[6].startHealth);
                sprite.lotag = (short)206;
            }
        };
        statueFTransformNew = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, true, false, true, statueFTransform){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiPlaySound(sprite, 313, 1, -1);
            }
        };
        statueFChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, false, statueFTransform);
        statueSTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, gargoyleIdle){

            @Override
            public void enter(SPRITE sprite, XSPRITE xsprite) {
                Actor.actHealDude(xsprite, DudeInfo.dudeInfo[7].startHealth, DudeInfo.dudeInfo[7].startHealth);
                sprite.lotag = (short)207;
            }
        };
        statueSTransformNew = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, true, false, true, statueSTransform){

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiPlaySound(sprite, 313, 1, -1);
            }
        };
        statueSChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, false, statueSTransform);
        gargoyleGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 0, null, 600, false, true, true, gargoyleIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.thinkGoto(sprite, xsprite);
            }
        };
        gargoyleSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 120, false, true, true, gargoyleIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.thinkSearch(sprite, xsprite);
            }
        };
        gargoyleChase = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, gargoyleIdle){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gargoyleChase);
        gargoyleFSlash = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIGARG.SlashCallback(nXSprite);
            }
        }, 120, false, false, false, gargoyleChase);
        gargoyleFThrow = new AISTATE(AISTATEFUNC.Type.other, 6, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIGARG.FThrowCallback(nXSprite);
            }
        }, 120, false, false, false, gargoyleChase);
        gargoyleSThrow = new AISTATE(AISTATEFUNC.Type.other, 7, new CALLPROC(){

            @Override
            public void run(int nXSprite) {
                AIGARG.SThrowCallback(nXSprite);
            }
        }, 60, false, true, false, gargoyleChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveAttack(sprite, xsprite);
            }
        };
        gargoyleDown = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, true, gargoyleChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleUp = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, true, gargoyleChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(SPRITE sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleTurn = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, false, gargoyleChase){

            @Override
            public void move(SPRITE sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
    }

    private static void FThrowCallback(int nXIndex) {
        Actor.actFireThing(DB.xsprite[nXIndex].reference, 0, 0, Ai.gDudeSlope[nXIndex] - 7500, 421, 978670);
    }

    private static void SThrowCallback(int nXIndex) {
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        SPRITE pTarget = pXSprite.target != -1 ? Engine.sprite[pXSprite.target] : null;
        Gameutils.bRandom();
        Ai.UpdateEnemyAim(pSprite, nXIndex, gGargData);
        if (Gameutils.IsPlayerSprite(pTarget) || !DEMO.IsOriginalDemo()) {
            Actor.actFireMissile(pSprite, -120, 0, (int)Ai.EnemyAim.x, (int)Ai.EnemyAim.y, (int)Ai.EnemyAim.z, 311);
            Actor.actFireMissile(pSprite, 120, 0, (int)Ai.EnemyAim.x, (int)Ai.EnemyAim.y, (int)Ai.EnemyAim.z, 311);
        }
    }

    private static void SlashCallback(int nXIndex) {
        int dz;
        XSPRITE pXSprite = DB.xsprite[nXIndex];
        int nSprite = pXSprite.reference;
        SPRITE pSprite = Engine.sprite[nSprite];
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        int dx = Trig.Cos(pSprite.ang) >> 16;
        int dy = Trig.Sin(pSprite.ang) >> 16;
        if (DEMO.IsOriginalDemo()) {
            SPRITE pTarget;
            int nZOffset1 = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat << 2;
            int nZOffset2 = 0;
            if (pXSprite.target != -1 && Actor.IsDudeSprite(pTarget = Engine.sprite[pXSprite.target])) {
                nZOffset2 = DudeInfo.dudeInfo[pTarget.lotag - 200].eyeHeight * pTarget.yrepeat << 2;
            }
            dz = nZOffset1 - nZOffset2;
        } else {
            dz = DudeInfo.dudeInfo[pSprite.lotag - 200].eyeHeight * pSprite.yrepeat << 2;
            if (pXSprite.target != -1) {
                SPRITE pTarget = Engine.sprite[pXSprite.target];
                dz = pTarget.z - pSprite.z;
            }
        }
        int vx = dx;
        int vy = dy;
        int vz = dz;
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
        vy = dy - Gameutils.Random(50);
        vx = dx + Gameutils.Random(50);
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
        vy = dy + Gameutils.Random(50);
        vx = dx - Gameutils.Random(50);
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
    }

    private static void myMoveAttack(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.goalAng = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(768) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(fvel >> 1, cos, svel >> 1, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(fvel >> 1, sin, -(svel >> 1), cos, 30);
            if (pSprite.lotag == 206) {
                Actor.sprZVel[pSprite.xvel] = 279620L;
            } else if (pSprite.lotag == 207) {
                Actor.sprZVel[pSprite.xvel] = 218453L;
            }
        }
    }

    private static void myMoveDown(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.goalAng = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(768) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = vel;
        }
    }

    private static void myMoveUp(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            pSprite.ang = (short)(pSprite.ang + 512 & 0x7FF);
            return;
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (!Gameutils.Chance(8192) || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            long fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
            Actor.sprZVel[pSprite.xvel] = -vel;
        }
    }

    private static void myMoveForward(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.goalAng - pSprite.ang & 0x7FF) - 1024;
        pSprite.ang = (short)(pSprite.ang + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF);
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.target == -1) {
            pSprite.ang = (short)(pSprite.ang + 256 & 0x7FF);
        }
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        if (Gameutils.Random(64) >= 32 || Main.engine.qdist(dx, dy) > 1024L) {
            int sin = Trig.Sin(pSprite.ang);
            int cos = Trig.Cos(pSprite.ang);
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], cos, Actor.sprYVel[pSprite.xvel], sin, 30);
            long svel = Pragmas.dmulscale(Actor.sprXVel[pSprite.xvel], sin, -Actor.sprYVel[pSprite.xvel], cos, 30);
            vel = pXSprite.target == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 1));
            Actor.sprXVel[pSprite.xvel] = Pragmas.dmulscale(vel, cos, svel, sin, 30);
            Actor.sprYVel[pSprite.xvel] = Pragmas.dmulscale(vel, sin, -svel, cos, 30);
        }
    }

    private static void myThinkTarget(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        if (Ai.aiActive[pSprite.xvel] != 0) {
            if (Ai.aiThinkTime[pSprite.xvel] >= 10) {
                pXSprite.goalAng += 256;
                Vector3 kSprite = Trigger.ksprite[pSprite.xvel];
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, gargoyleTurn);
                return;
            }
            short s = pSprite.xvel;
            Ai.aiThinkTime[s] = Ai.aiThinkTime[s] + 1;
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.health != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int eyeAboveZ;
                int x = pPlayer.pSprite.x;
                int y = pPlayer.pSprite.y;
                int z = pPlayer.pSprite.z;
                short nSector = pPlayer.pSprite.sectnum;
                int dx = x - pSprite.x;
                int dy = y - pSprite.y;
                int dist = (int)Main.engine.qdist(dx, dy);
                if ((dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) && Main.engine.cansee(x, y, z, nSector, pSprite.x, pSprite.y, pSprite.z - (eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2), pSprite.sectnum)) {
                    short nAngle = Main.engine.getangle(dx, dy);
                    int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
                    if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                    if (dist < pDudeInfo.hearDist) {
                        Ai.aiThinkTime[pSprite.xvel] = 0;
                        Ai.aiSetTarget(pXSprite, x, y, z);
                        Ai.aiActivateDude(pSprite, pXSprite);
                        return;
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void thinkSearch(SPRITE pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.goalAng);
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(SPRITE pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        int dx = pXSprite.targetX - pSprite.x;
        int dy = pXSprite.targetY - pSprite.y;
        short nAngle = Main.engine.getangle(dx, dy);
        int dist = (int)Main.engine.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.ang - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void thinkChase(SPRITE pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.target == -1) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !ru.m210projects.Build.Gameutils.isValidSprite(pXSprite.target)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.lotag - 200];
        SPRITE pTarget = Engine.sprite[pXSprite.target];
        XSPRITE pXTarget = pTarget.extra > 0 ? DB.xsprite[pTarget.extra] : null;
        int dx = pTarget.x - pSprite.x;
        int dy = pTarget.y - pSprite.y;
        Ai.aiChooseDirection(pSprite, pXSprite, Main.engine.getangle(dx, dy));
        if (pXTarget == null || pXTarget.health == 0) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.lotag - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
            return;
        }
        int dist = (int)Main.engine.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            short nAngle = Main.engine.getangle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.ang & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.yrepeat << 2;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.x, pTarget.y, pTarget.z, pTarget.sectnum, pSprite.x, pSprite.y, pSprite.z - eyeAboveZ, pSprite.sectnum)) {
                if (dist >= pDudeInfo.seeDist || Pragmas.klabs(losAngle) > pDudeInfo.periphery) return;
                Ai.aiSetTarget(pXSprite, pXSprite.target);
                int floorz = Main.engine.getflorzofslope(pSprite.sectnum, pSprite.x, pSprite.y);
                switch (pSprite.lotag) {
                    case 206: {
                        if (dist < 6144 && dist > 3072 && Pragmas.klabs(losAngle) < 85) {
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.lotag == Engine.sprite[Engine.pHitInfo.hitsprite].lotag || Engine.sprite[Engine.pHitInfo.hitsprite].lotag == 207)) return;
                            SOUND.sfxStart3DSound(pSprite, 1408, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFThrow);
                            return;
                        }
                        if (dist < 1024) {
                            if (Pragmas.klabs(losAngle) >= 85) return;
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.lotag == Engine.sprite[Engine.pHitInfo.hitsprite].lotag || Engine.sprite[Engine.pHitInfo.hitsprite].lotag == 207)) return;
                            SOUND.sfxStart3DSound(pSprite, 1406, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFSlash);
                            return;
                        }
                        int targetZ = pDudeInfo.eyeHeight * pTarget.yrepeat << 2;
                        if (targetZ - eyeAboveZ <= 8192 && floorz - Gameutils.extents_zBot <= 8192 || dist >= 5120 || dist <= 2560) {
                            if (targetZ - eyeAboveZ >= 8192 && floorz - Gameutils.extents_zBot >= 8192 || Pragmas.klabs(losAngle) >= 85) return;
                            Ai.aiPlaySound(pSprite, 1400, 1, -1);
                            return;
                        }
                        Ai.aiPlaySound(pSprite, 1400, 1, -1);
                        Ai.aiNewState(pSprite, pXSprite, gargoyleDown);
                        return;
                    }
                    case 207: {
                        if (dist < 6144 && dist > 3072 && Pragmas.klabs(losAngle) < 85) {
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.lotag == Engine.sprite[Engine.pHitInfo.hitsprite].lotag || Engine.sprite[Engine.pHitInfo.hitsprite].lotag == 206)) return;
                            SOUND.sfxStart3DSound(pSprite, 1457, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleSThrow);
                            return;
                        }
                        if (dist < 1024) {
                            if (Pragmas.klabs(losAngle) >= 85) return;
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.z, dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.lotag == Engine.sprite[Engine.pHitInfo.hitsprite].lotag || Engine.sprite[Engine.pHitInfo.hitsprite].lotag == 206)) return;
                            SOUND.sfxStart3DSound(pSprite, 1406, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFSlash);
                            return;
                        }
                        int targetZ = pDudeInfo.eyeHeight * pTarget.yrepeat << 2;
                        if (targetZ - eyeAboveZ <= 8192 && floorz - Gameutils.extents_zBot <= 8192 || dist >= 5120 || dist <= 2048) {
                            if (targetZ - eyeAboveZ >= 8192 && floorz - Gameutils.extents_zBot >= 8192 || Pragmas.klabs(losAngle) >= 85) return;
                            Ai.aiPlaySound(pSprite, 1450, 1, -1);
                            return;
                        }
                        Ai.aiPlaySound(pSprite, 1450, 1, -1);
                        Ai.aiNewState(pSprite, pXSprite, gargoyleDown);
                    }
                }
                return;
            }
            Ai.aiNewState(pSprite, pXSprite, gargoyleUp);
            return;
        }
        Ai.aiNewState(pSprite, pXSprite, gargoyleGoto);
        pXSprite.target = -1;
    }
}

