/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.Menus.MenuQav;
import ru.m210projects.Blood.Screens.MenuScreen;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pragmas;

public class BloodMenuHandler
extends MenuHandler {
    public BuildMenu[] mMenus = new BuildMenu[19];
    private Engine engine;
    private BuildGame app;
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int SOUNDSET = 3;
    public static final int DIFFICULTY = 4;
    public static final int CREDITS = 5;
    public static final int HELP = 6;
    public static final int LOADGAME = 7;
    public static final int SAVEGAME = 8;
    public static final int QUIT = 9;
    public static final int QUITTITLE = 10;
    public static final int NETWORKGAME = 11;
    public static final int MULTIPLAYER = 12;
    public static final int COLORCORR = 13;
    public static final int NEWADDON = 14;
    public static final int OPTIONS = 15;
    public static final int USERCONTENT = 16;
    public static final int CORRUPTLOAD = 17;
    private MenuQav Bdrip;

    public BloodMenuHandler(BuildGame app) {
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 2046;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 5, 57, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    public MenuQav addMenuBlood() {
        if (this.Bdrip == null) {
            this.Bdrip = new MenuQav(160, 100, 256){

                @Override
                public void draw(MenuHandler handler) {
                    int frames = Engine.xdim / 320;
                    this.pQAV.origin.x = 0.0f;
                    int i = 0;
                    while (i <= frames) {
                        super.draw(handler);
                        this.pQAV.origin.x += 319.0f;
                        ++i;
                    }
                }
            };
        }
        return this.Bdrip;
    }

    @Override
    public int getShade(MenuItem item) {
        int shade = 32;
        if (item != null && item.isFocused()) {
            shade = 32 - (Engine.totalclock & 0x3F);
        }
        return shade;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 10;
            }
            return item.pal;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, Engine.tilesizx[9216] - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        int size = Pragmas.mulscale(Engine.tilesizx[9216], zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }
}

