/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import java.io.File;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuNetwork;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PROFILE;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.POSTURE;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SPRITE;

public class BloodNetwork
extends BuildNet {
    public final int nNetVersion = 534;
    public final byte kPacketBroadcast = (byte)2;
    public final byte kPacketMessage = (byte)3;
    public final byte kPacketSound = (byte)4;
    public final byte kPacketContentRequest = (byte)6;
    public final byte kPacketChangeTeam = (byte)8;
    public final byte kPacketContentAnswer = (byte)9;
    public byte[] gContentFound = new byte[8];
    public PROFILE[] gProfile = new PROFILE[8];
    public PLOCATION[] predictFifo = new PLOCATION[256];
    public PLOCATION predict = new PLOCATION();
    public PLOCATION predictOld = new PLOCATION();
    public SPRITE predictSprite = new SPRITE();
    public Main app;

    public BloodNetwork(Main game) {
        super(game);
        this.app = game;
        int i = 0;
        while (i < 256) {
            this.predictFifo[i] = new PLOCATION();
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (i != Mmulti.myconnectindex) {
                this.gProfile[i] = new PROFILE("Player " + i, true, true);
            }
            ++i;
        }
        this.gProfile[Mmulti.myconnectindex] = new PROFILE(Main.cfg.pName, Main.cfg.gAutoAim, Main.cfg.gSlopeTilt);
        Arrays.fill(this.gContentFound, (byte)-1);
    }

    public String getPlayerName(int i) {
        return this.gProfile[i].name;
    }

    @Override
    public BuildNet.NetInput newInstance() {
        return new INPUT();
    }

    @Override
    public int GetPackets(byte[] p, int ptr, int len, int nPlayer) {
        switch (p[ptr++]) {
            case 3: {
                this.retransmit(nPlayer, this.packbuf, len);
                byte fromPlayer = p[ptr++];
                int mlen = LittleEndian.getInt(p, ptr);
                byte toPlayer = this.packbuf[6];
                if (p[6] == 47 && toPlayer != 0 && (toPlayer < 49 || toPlayer > 56 || toPlayer - 49 == Mmulti.myconnectindex)) break;
                String messageFrom = String.valueOf(this.gProfile[fromPlayer].name) + " : ";
                View.viewSetMessage(String.valueOf(messageFrom) + new String(p, 6, mlen), fromPlayer);
                SOUND.sndStartSample("DMRADIO.RAW", 128, -1);
                break;
            }
            case 4: {
                this.retransmit(nPlayer, this.packbuf, len);
                SOUND.sndStartSample((p[ptr++] & 0xFF) + 4400, 128, 1, false);
                break;
            }
            case 9: {
                this.gContentFound[nPlayer] = p[ptr];
                return 1;
            }
            case 6: {
                int pathlen = LittleEndian.getInt(p, ptr);
                if (pathlen >= p.length - (ptr += 4)) {
                    pathlen = p.length - ptr - 1;
                }
                String path = FileUtils.getCorrectPath(new String(p, ptr, pathlen));
                FileEntry fil = BuildGdx.compat.checkFile(path);
                BloodIniFile ini = LEVELS.levelGetEpisode(path);
                boolean found = false;
                if (fil != null || ini != null) {
                    MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
                    if (ini != null) {
                        found = true;
                        network.setEpisode(ini);
                    } else if (fil != null && fil.getExtension().equals("map")) {
                        found = true;
                        network.setMap(fil);
                    }
                } else {
                    Console.Println("Player" + nPlayer + " - " + this.gProfile[nPlayer].name + " tried to set user content. User content not found!", Console.OSDTEXT_RED);
                    Console.Println("Be sure that you have content to same path: " + File.separator + path, Console.OSDTEXT_RED);
                    Console.toggle();
                }
                this.packbuf[0] = 9;
                this.packbuf[1] = found ? (byte)1 : 0;
                Mmulti.sendpacket(nPlayer, this.packbuf, 2);
                return 1;
            }
            case 7: {
                return this.GetDisconnectPacket(p, ptr, len, nPlayer, new BuildNet.DisconnectCallback(){

                    @Override
                    public void invoke(int nDelete) {
                        View.viewSetMessage(String.valueOf(BloodNetwork.this.gProfile[nDelete].name) + " left the game with " + Globals.gPlayer[nDelete].fragCount + " frags.", -1);
                        if (BloodNetwork.this.game.isCurrentScreen(Main.gGameScreen) && Globals.gPlayer[nDelete].pSprite != null) {
                            SeqHandling.seqKill(3, Globals.gPlayer[nDelete].pSprite.extra);
                            Actor.actPostSprite(Globals.gPlayer[nDelete].nSprite, 1024);
                            if (nDelete == View.gViewIndex) {
                                View.gViewIndex = Mmulti.myconnectindex;
                            }
                        }
                    }
                });
            }
            case -5: {
                this.retransmit(nPlayer, this.packbuf, len);
                int num = p[ptr++] & 0xFF;
                this.gProfile[num].autoaim = p[ptr++] == 1;
                this.gProfile[num].slopetilt = p[ptr++] == 1;
                this.gProfile[num].skill = p[ptr++];
                this.gProfile[num].team = p[ptr++];
                this.gProfile[num].name = new String(p, ptr, 14).trim();
                ptr += 14;
                break;
            }
            case 8: {
                this.retransmit(nPlayer, this.packbuf, len);
                int nOther = p[ptr++] & 0xFF;
                this.gProfile[nOther].team = p[ptr++];
                String message = String.valueOf(this.gProfile[nOther].name) + " changed team to ";
                switch (this.gProfile[nOther].team) {
                    case 0: {
                        message = String.valueOf(message) + "default";
                        break;
                    }
                    case 1: {
                        message = String.valueOf(message) + "blue";
                        break;
                    }
                    case 2: {
                        message = String.valueOf(message) + "red";
                    }
                }
                View.viewSetMessage(message, -1);
                SOUND.sndStartSample("DMRADIO.RAW", 128, -1);
                break;
            }
            case -4: {
                this.retransmit(nPlayer, this.packbuf, len);
                ptr = 5;
                int nCheckVersion = LittleEndian.getInt(p, ptr);
                short nRFFVersion = LittleEndian.getUByte(p, ptr += 4);
                Globals.pNetInfo.set(p, ++ptr);
                if (nCheckVersion != 534 || VERSION.GAMEVER != nRFFVersion) {
                    this.game.GameMessage("These versions of Blood cannot play together.");
                    this.NetDisconnect(Mmulti.myconnectindex);
                    return -1;
                }
                if (!this.WaitForAllPlayers(0)) break;
                Main.gGameScreen.newgame(true, ((MenuNetwork)this.app.menu.mMenus[11]).getFile(), Globals.pNetInfo.nEpisode, Globals.pNetInfo.nLevel, Globals.pNetInfo.nDifficulty, Globals.pNetInfo.nDifficulty, Globals.pNetInfo.nDifficulty, false);
                break;
            }
            case -1: {
                this.game.gExit = true;
            }
        }
        return 0;
    }

    public void SendNetMessage(String message) {
        if (Mmulti.numplayers > 1) {
            this.packbuf[0] = 3;
            this.packbuf[1] = (byte)Mmulti.myconnectindex;
            int len = message.length();
            LittleEndian.putInt(this.packbuf, 2, message.length());
            if (len + 6 >= this.packbuf.length) {
                this.app.dassert("ptr + size < packbuf.length");
            }
            System.arraycopy(message.getBytes(), 0, this.packbuf, 6, len);
            this.sendtoall(this.packbuf, len + 6);
        }
    }

    public void ChangeTeam(int nPlayer, int team) {
        if (this.gProfile[nPlayer].team == team) {
            return;
        }
        this.packbuf[0] = 8;
        this.packbuf[1] = (byte)nPlayer;
        this.gProfile[nPlayer].team = team;
        this.packbuf[2] = (byte)this.gProfile[nPlayer].team;
        this.sendtoall(this.packbuf, 3);
    }

    public void InitProfile(int nPlayer) {
        if (Mmulti.numplayers > 1) {
            Arrays.fill(this.packbuf, 0, 19, (byte)0);
            int ptr = 0;
            this.packbuf[ptr++] = -5;
            this.packbuf[ptr++] = (byte)nPlayer;
            this.packbuf[ptr++] = (byte)(this.gProfile[nPlayer].autoaim ? 1 : 0);
            this.packbuf[ptr++] = (byte)(this.gProfile[nPlayer].slopetilt ? 1 : 0);
            this.packbuf[ptr++] = this.gProfile[nPlayer].skill;
            this.packbuf[ptr++] = (byte)this.gProfile[nPlayer].team;
            System.arraycopy(this.gProfile[nPlayer].name.getBytes(), 0, this.packbuf, ptr, Math.min(this.gProfile[nPlayer].name.length(), 14));
            this.sendtoall(this.packbuf, 20);
        }
    }

    public void TauntSound(int sndId) {
        if (Mmulti.numplayers > 1) {
            this.packbuf[0] = 4;
            this.packbuf[1] = (byte)sndId;
            this.sendtoall(this.packbuf, 2);
        }
        SOUND.sndStartSample(sndId + 4400, 128, 1, false);
    }

    public void TauntMessage(int msgId) {
        if (msgId >= 0 && msgId < 10) {
            this.SendNetMessage(Main.cfg.macros[msgId]);
        }
        View.viewSetMessage(Main.cfg.macros[msgId], Mmulti.myconnectindex);
    }

    @Override
    public void UpdatePrediction(BuildNet.NetInput input) {
        this.predictOld.copy(this.predict);
        SPRITE pSprite = Globals.gMe.pSprite;
        short cstat = pSprite.cstat;
        pSprite.cstat = 0;
        this.viewMovePrediction((INPUT)input);
        if (Actor.IsDudeSprite(pSprite)) {
            short nXSprite = pSprite.extra;
            if (nXSprite <= 0 || nXSprite >= 2048) {
                this.app.dassert("nXSprite > 0 && nXSprite < kMaxXSprites");
            }
            int airvel = 128;
            if (Engine.sector[this.predict.sectnum].extra > 0) {
                XSECTOR pXSector;
                short nXSector = Engine.sector[this.predict.sectnum].extra;
                if (nXSector <= 0 || nXSector >= 512) {
                    this.app.dassert("nXSector > 0 && nXSector < kMaxXSectors");
                }
                if (DB.xsector[nXSector].reference != this.predict.sectnum) {
                    this.app.dassert("xsector[nXSector].reference == nSector");
                }
                if ((pXSector = DB.xsector[nXSector]) != null) {
                    Gameutils.GetSpriteExtents(pSprite);
                    int zBot = Gameutils.extents_zBot;
                    if (Main.engine.getflorzofslope(this.predict.sectnum, this.predict.x, this.predict.y) <= zBot) {
                        int panVel = 0;
                        int panAngle = pXSector.panAngle;
                        if (pXSector.panAlways || pXSector.state != 0 || pXSector.busy != 0) {
                            panVel = (pXSector.panVel & 0xFF) << 9;
                            if (!pXSector.panAlways && pXSector.busy != 0) {
                                panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
                            }
                        }
                        if ((Engine.sector[this.predict.sectnum].floorstat & 0x40) != 0) {
                            panAngle = Gameutils.GetWallAngle(Engine.sector[this.predict.sectnum].wallptr) + panAngle + 512 & 0x7FF;
                        }
                        int pushX = Pragmas.mulscale(panVel, Trig.Cos(panAngle), 30);
                        int pushY = Pragmas.mulscale(panVel, Trig.Sin(panAngle), 30);
                        this.predict.xvel += (long)pushX;
                        this.predict.yvel += (long)pushY;
                    }
                    if (pXSector != null && pXSector.Underwater) {
                        airvel = 5376;
                    }
                }
            }
            this.viewAirDrag(airvel);
            if ((this.predict.flags & 4) != 0 || this.predict.xvel != 0L || this.predict.yvel != 0L || this.predict.zvel != 0L || Actor.floorVel[this.predict.sectnum] != 0L || Actor.ceilingVel[this.predict.sectnum] != 0L) {
                this.viewMoveDude();
            }
        }
        pSprite.cstat = cstat;
        this.predictFifo[this.gPredictTail & 0xFF].copy(this.predict);
        ++this.gPredictTail;
    }

    @Override
    public void CorrectPrediction() {
        if (Globals.pGameInfo.nGameType == 0) {
            return;
        }
        PLOCATION pFifo = this.predictFifo[this.gNetFifoTail - 1 & 0xFF];
        if (pFifo.ang == (float)Globals.gMe.pSprite.ang && pFifo.horiz == Globals.gMe.horiz && pFifo.x == Globals.gMe.pSprite.x && pFifo.y == Globals.gMe.pSprite.y && pFifo.z == Globals.gMe.pSprite.z) {
            return;
        }
        this.PredictReset();
        this.predictOld.copy(PLAYER.gPrevView[Mmulti.myconnectindex]);
        this.gPredictTail = this.gNetFifoTail;
        while (this.gPredictTail < this.gNetFifoHead[Mmulti.myconnectindex]) {
            this.UpdatePrediction(this.gFifoInput[this.gPredictTail & 0xFF][Mmulti.myconnectindex]);
        }
    }

    @Override
    public void CalcChecksum() {
        if ((Globals.gFrame & 8 * this.MovesPerPacket - 1) == 0) {
            this.CalcGameChecksum(300);
            int i = 0;
            while (i < 4) {
                LittleEndian.putInt(this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gCheckHead[Mmulti.myconnectindex] & 0xFF) + 4 * i, this.gChecksum[i]);
                ++i;
            }
            short s = Mmulti.myconnectindex;
            this.gCheckHead[s] = this.gCheckHead[s] + 1;
        }
    }

    public void PredictReset() {
        this.predict.ang = Globals.gMe.pSprite.ang;
        this.predict.look = Globals.gMe.look;
        this.predict.horiz = Globals.gMe.horiz;
        this.predict.slope = Globals.gMe.slope;
        this.predict.horizOff = Globals.gMe.horizOff;
        this.predict.fNoJump = Globals.gMe.pJump ? 1 : 0;
        this.predict.Run = Globals.gMe.Run;
        this.predict.underwater = Globals.gMe.Underwater;
        this.predict.jump = Globals.gMe.pInput.Jump;
        this.predict.x = Globals.gMe.pSprite.x;
        this.predict.y = Globals.gMe.pSprite.y;
        this.predict.z = Globals.gMe.pSprite.z;
        this.predict.sectnum = Globals.gMe.pSprite.sectnum;
        this.predict.flags = Globals.gMe.pSprite.hitag;
        this.predict.xvel = Actor.sprXVel[Globals.gMe.pSprite.xvel];
        this.predict.yvel = Actor.sprYVel[Globals.gMe.pSprite.xvel];
        this.predict.zvel = Actor.sprZVel[Globals.gMe.pSprite.xvel];
        this.predict.height = Globals.gMe.pXsprite.height;
        this.predict.moveState = Globals.gMe.moveState;
        this.predict.Turn_Around = Globals.gMe.TurnAround;
        this.predict.center = Globals.gMe.pInput.LookCenter;
        this.predict.moveHit = Actor.gSpriteHit[Globals.gMe.pSprite.extra].moveHit;
        this.predict.ceilHit = Actor.gSpriteHit[Globals.gMe.pSprite.extra].ceilHit;
        this.predict.floorHit = Actor.gSpriteHit[Globals.gMe.pSprite.extra].floorHit;
        this.predict.bobAmp = Globals.gMe.bobAmp;
        this.predict.bobPhase = Globals.gMe.bobPhase;
        this.predict.bobHeight = Globals.gMe.bobHeight;
        this.predict.bobWidth = Globals.gMe.bobWidth;
        this.predict.swayAmp = Globals.gMe.swayAmp;
        this.predict.swayPhase = Globals.gMe.swayPhase;
        this.predict.swayHeight = Globals.gMe.swayHeight;
        this.predict.swayWidth = Globals.gMe.swayWidth;
        this.predict.weapOffZ = Globals.gMe.weaponAboveZ - Globals.gMe.viewOffZ - 3072;
        this.predict.viewOffZ = Globals.gMe.viewOffZ;
        this.predict.viewOffdZ = Globals.gMe.viewOffdZ;
        this.predict.weaponAboveZ = Globals.gMe.weaponAboveZ;
        this.predict.weapOffdZ = Globals.gMe.weapOffdZ;
        this.predictOld.copy(this.predict);
    }

    private void viewMoveDude() {
        this.predictSprite.set(Globals.gMe.pSprite);
        this.predictSprite.x = this.predict.x;
        this.predictSprite.y = this.predict.y;
        this.predictSprite.z = this.predict.z;
        this.predictSprite.sectnum = this.predict.sectnum;
        PLAYER pPlayer = null;
        if (Gameutils.IsPlayerSprite(this.predictSprite)) {
            pPlayer = Globals.gPlayer[this.predictSprite.lotag - 231];
        }
        if (this.predictSprite.lotag < 200 || this.predictSprite.lotag >= 256) {
            this.app.dassert("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        Gameutils.GetSpriteExtents(this.predictSprite);
        int zTop = Gameutils.extents_zTop;
        int zBot = Gameutils.extents_zBot;
        int floorDist = (zBot - this.predict.z) / 4;
        int ceilDist = (this.predict.z - zTop) / 4;
        int clipDist = this.predictSprite.clipdist << 2;
        short nSector = this.predict.sectnum;
        if (nSector < 0 || nSector >= Globals.kMaxSectors) {
            this.app.dassert("nSector >= 0 && nSector < kMaxSectors");
        }
        if (this.predict.xvel != 0L || this.predict.yvel != 0L) {
            if (pPlayer != null && Globals.gNoClip) {
                this.predict.x = (int)((long)this.predict.x + (this.predict.xvel >> 12));
                this.predict.y = (int)((long)this.predict.y + (this.predict.yvel >> 12));
                if ((nSector = Main.engine.updatesector(this.predict.x, this.predict.y, nSector)) == -1) {
                    nSector = this.predict.sectnum;
                }
            } else {
                this.predict.moveHit = Gameutils.ClipMove(this.predict.x, this.predict.y, this.predict.z, nSector, this.predict.xvel >> 12, this.predict.yvel >> 12, clipDist, ceilDist, floorDist, 77825);
                this.predict.x = Gameutils.clipm_px;
                this.predict.y = Gameutils.clipm_py;
                this.predict.z = Gameutils.clipm_pz;
                nSector = (short)Gameutils.clipm_pnsectnum;
                if (nSector == -1) {
                    nSector = this.predict.sectnum;
                }
                if (Engine.sector[nSector].lotag >= 612 && Engine.sector[nSector].lotag <= 617) {
                    Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, nSector, clipDist, ceilDist, floorDist, 65537);
                    this.predict.x = Engine.pushmove_x;
                    this.predict.y = Engine.pushmove_y;
                    this.predict.z = Engine.pushmove_z;
                    if (Engine.pushmove_sectnum != -1) {
                        nSector = Engine.pushmove_sectnum;
                    }
                }
                if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                    this.app.dassert("nSector >= 0 && nSector < kMaxSectors");
                }
            }
            if ((this.predict.moveHit & 0xE000) == 32768) {
                int nWall = this.predict.moveHit & 0x1FFF;
                Actor.ReflectVector(this.predict.xvel, this.predict.yvel, nWall, 0);
                this.predict.xvel = Actor.refl_x;
                this.predict.yvel = Actor.refl_y;
            }
        }
        this.predictSprite.x = this.predict.x;
        this.predictSprite.y = this.predict.y;
        this.predictSprite.z = this.predict.z;
        if (this.predict.sectnum != nSector) {
            if (nSector < 0 || nSector >= Globals.kMaxSectors) {
                this.app.dassert("nSector >= 0 && nSector < kMaxSectors");
            }
            this.predictSprite.sectnum = this.predict.sectnum = nSector;
        }
        boolean underwater = false;
        boolean depth = false;
        if (Engine.sector[nSector].extra > 0) {
            if (DB.xsector[Engine.sector[nSector].extra].Underwater) {
                underwater = true;
            }
            if (DB.xsector[Engine.sector[nSector].extra].Depth != 0) {
                depth = true;
            }
        }
        int nUpper = Warp.gUpperLink[nSector];
        int nLower = Warp.gLowerLink[nSector];
        if (nUpper >= 0 && (Engine.sprite[nUpper].lotag == 9 || Engine.sprite[nUpper].lotag == 13)) {
            depth = true;
        }
        if (nLower >= 0 && (Engine.sprite[nLower].lotag == 10 || Engine.sprite[nLower].lotag == 14)) {
            depth = true;
        }
        if (pPlayer != null) {
            clipDist += 16;
        }
        if (this.predict.zvel != 0L) {
            this.predict.z = (int)((long)this.predict.z + (this.predict.zvel >> 8));
        }
        this.predictSprite.z = this.predict.z;
        Gameutils.GetZRange(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, clipDist, 77825);
        int ceilz = Gameutils.gz_ceilZ;
        int ceilhit = Gameutils.gz_ceilHit;
        int floorz = Gameutils.gz_floorZ;
        int floorhit = Gameutils.gz_floorHit;
        Gameutils.GetSpriteExtents(this.predictSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        if ((this.predict.flags & 2) != 0) {
            int G = 58254;
            if (!depth) {
                if (underwater || zBot >= floorz) {
                    G = 0;
                }
            } else if (underwater) {
                int ceilzofslope = Main.engine.getceilzofslope(nSector, this.predict.x, this.predict.y);
                if (ceilzofslope > zTop) {
                    if (zBot != zTop) {
                        G += -80099 * (zBot - ceilzofslope) / (zBot - zTop);
                    }
                } else {
                    G = 0;
                }
            } else {
                int florzofslope = Main.engine.getflorzofslope(nSector, this.predict.x, this.predict.y);
                if (florzofslope < zBot && zBot != zTop) {
                    G += -80099 * (zBot - florzofslope) / (zBot - zTop);
                }
            }
            if (G != 0) {
                this.predict.z += 2 * G >> 8;
                this.predict.zvel += (long)G;
            }
        }
        this.predictSprite.z = this.predict.z;
        Gameutils.GetSpriteExtents(this.predictSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        if (pPlayer != null && zBot >= floorz) {
            int ofloorz = floorz;
            int ofloorhit = floorhit;
            Gameutils.GetZRange(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, Globals.gMe.pSprite.clipdist << 2, 77825);
            ceilz = Gameutils.gz_ceilZ;
            ceilhit = Gameutils.gz_ceilHit;
            floorz = Gameutils.gz_floorZ;
            floorhit = Gameutils.gz_floorHit;
            if (zBot <= floorz && this.predict.z - ofloorz < floorDist) {
                floorz = ofloorz;
                floorhit = ofloorhit;
            }
        }
        if (floorz > zBot) {
            this.predict.floorHit = 0;
            if ((this.predict.flags & 2) != 0) {
                this.predict.flags = (short)(this.predict.flags | 4);
            }
        } else {
            this.predict.floorHit = floorhit;
            this.predict.z += floorz - zBot;
            int dZvel = (int)(this.predict.zvel - Actor.floorVel[this.predict.sectnum]);
            if (dZvel <= 0) {
                if (this.predict.zvel == 0L) {
                    this.predict.flags = (short)(this.predict.flags & 0xFFFFFFFB);
                }
            } else {
                Actor.GravityVector(this.predict.xvel, this.predict.yvel, dZvel, this.predict.sectnum, 0);
                this.predict.xvel = Actor.refl_x;
                this.predict.yvel = Actor.refl_y;
                this.predict.zvel = Actor.refl_z;
                if (Pragmas.klabs(dZvel) >= 65536) {
                    this.predict.flags = (short)(this.predict.flags | 4);
                } else {
                    this.predict.zvel = Actor.floorVel[this.predict.sectnum];
                    this.predict.flags = (short)(this.predict.flags & 0xFFFFFFFB);
                }
            }
        }
        if (ceilz < zTop) {
            this.predict.ceilHit = 0;
        } else {
            this.predict.ceilHit = ceilhit;
            if (ceilz - zTop > 0) {
                this.predict.z += ceilz - zTop;
            }
            if (this.predict.zvel <= 0L && (this.predict.flags & 4) != 0) {
                this.predict.zvel = -this.predict.zvel / 8L;
            }
        }
        this.predictSprite.z = this.predict.z;
        Gameutils.GetSpriteExtents(this.predictSprite);
        zTop = Gameutils.extents_zTop;
        zBot = Gameutils.extents_zBot;
        this.predict.height = floorz - zBot > 0 ? floorz - zBot >> 8 : 0;
        if (this.predict.xvel != 0L || this.predict.yvel != 0L) {
            if ((floorhit & 0xE000) == 49152) {
                int nUnderSprite = floorhit & 0x1FFF;
                if ((Engine.sprite[nUnderSprite].cstat & 0x30) == 0) {
                    this.predict.xvel += (long)Pragmas.mulscale(Globals.kFrameTicks, this.predict.x - Engine.sprite[nUnderSprite].x, 2);
                    this.predict.yvel += (long)Pragmas.mulscale(Globals.kFrameTicks, this.predict.y - Engine.sprite[nUnderSprite].y, 2);
                    return;
                }
            }
            nSector = this.predict.sectnum;
            if (!(Engine.sector[nSector].extra > 0 && DB.xsector[Engine.sector[nSector].extra].Underwater || this.predict.height >= 256)) {
                int kv = 10752;
                if (this.predict.height != 0) {
                    kv -= Pragmas.mulscale(this.predict.height, kv, 8);
                }
                this.predict.xvel -= (long)Pragmas.dmulscale(kv, this.predict.xvel, 32768L, 1L, 16);
                this.predict.yvel -= (long)Pragmas.dmulscale(kv, this.predict.yvel, 32768L, 1L, 16);
                if (Main.engine.qdist(this.predict.xvel, this.predict.yvel) < 4096L) {
                    this.predict.yvel = 0L;
                    this.predict.xvel = 0L;
                }
            }
        }
    }

    public boolean WaitForContentCheck(String filepath, int timeout) {
        int i;
        Arrays.fill(this.gContentFound, (byte)-1);
        if (Mmulti.numplayers < 2) {
            return true;
        }
        this.WaitForSend();
        this.packbuf[0] = 6;
        int len = Math.min(filepath.length(), 250);
        LittleEndian.putInt(this.packbuf, 1, len);
        System.arraycopy(filepath.getBytes(), 0, this.packbuf, 5, len);
        this.sendtoall(this.packbuf, len + 5);
        this.gContentFound[Mmulti.myconnectindex] = 1;
        long starttime = System.currentTimeMillis();
        block0: do {
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.Println("Connection timed out!", Console.OSDTEXT_YELLOW);
                return false;
            }
            this.GetPackets();
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.gContentFound[i] == -1) continue block0;
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block0;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gContentFound[i] != 1) {
                return false;
            }
            i = Mmulti.connectpoint2[i];
        }
        return true;
    }

    private void viewMovePrediction(INPUT pInput) {
        POSTURE cp = Globals.gPosture[Globals.gMe.nLifeMode][this.predict.moveState];
        SPRITE pSprite = Globals.gMe.pSprite;
        Gameutils.GetSpriteExtents(pSprite);
        int clipDist = pSprite.clipdist << 2;
        int floorDist = (Gameutils.extents_zBot - pSprite.z) / 4;
        int ceilDist = (pSprite.z - Gameutils.extents_zTop) / 4;
        if (!Globals.gNoClip) {
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, clipDist, ceilDist, floorDist, 65537);
            this.predict.x = Engine.pushmove_x;
            this.predict.y = Engine.pushmove_y;
            this.predict.z = Engine.pushmove_z;
            if (Engine.pushmove_sectnum != -1) {
                this.predict.sectnum = Engine.pushmove_sectnum;
            }
        }
        this.predict.Run = pInput.Run;
        if (!pInput.Jump) {
            this.predict.jump = false;
        }
        if (this.predict.moveState == 1) {
            if (pInput.Forward != 0) {
                this.predict.xvel += (long)Pragmas.mulscale(Trig.Cos((short)this.predict.ang), pInput.Forward * cp.frontAccel, 30);
                this.predict.yvel += (long)Pragmas.mulscale(Trig.Sin((short)this.predict.ang), pInput.Forward * cp.frontAccel, 30);
            }
            if (pInput.Strafe != 0) {
                this.predict.xvel += (long)Pragmas.mulscale(Trig.Sin((short)this.predict.ang), pInput.Strafe * cp.sideAccel, 30);
                this.predict.yvel -= (long)Pragmas.mulscale(Trig.Cos((short)this.predict.ang), pInput.Strafe * cp.sideAccel, 30);
            }
        } else if (this.predict.height < 256) {
            long vel;
            int zvel = 65536;
            if (this.predict.height != 0) {
                zvel -= (this.predict.height << 16) / 256;
            }
            if (pInput.Forward != 0) {
                vel = pInput.Forward > 0 ? (long)(pInput.Forward * cp.frontAccel) : (long)(pInput.Forward * cp.backAccel);
                if (this.predict.height != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                this.predict.xvel += (long)Pragmas.mulscale(Trig.Cos((short)this.predict.ang), vel, 30);
                this.predict.yvel += (long)Pragmas.mulscale(Trig.Sin((short)this.predict.ang), vel, 30);
            }
            if (pInput.Strafe != 0) {
                vel = pInput.Strafe * cp.sideAccel;
                if (this.predict.height != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                this.predict.xvel += (long)Pragmas.mulscale(Trig.Sin((short)this.predict.ang), vel, 30);
                this.predict.yvel -= (long)Pragmas.mulscale(Trig.Cos((short)this.predict.ang), vel, 30);
            }
        }
        if (pInput.Turn != 0.0f) {
            this.predict.ang = ru.m210projects.Build.Gameutils.BClampAngle(this.predict.ang + (float)Globals.kFrameTicks * pInput.Turn / 16.0f);
        }
        if (pInput.TurnAround && this.predict.Turn_Around == 0) {
            this.predict.Turn_Around = -1024;
        }
        if (this.predict.Turn_Around < 0) {
            int angSpeed = this.predict.moveState == 1 ? 64 : 128;
            this.predict.Turn_Around = Gameutils.ClipHigh(this.predict.Turn_Around + angSpeed, 0);
            this.predict.ang = ru.m210projects.Build.Gameutils.BClampAngle(this.predict.ang + (float)angSpeed);
        }
        if (!this.predict.jump) {
            this.predict.fNoJump = this.predict.jump ? 1 : 0;
        }
        switch (this.predict.moveState) {
            case 0: {
                if (!this.predict.jump && pInput.Jump && this.predict.height == 0) {
                    this.predict.zvel = PLAYER.inventoryCheck(Globals.gMe, 4) ? -1529173L : -764586L;
                    this.predict.fNoJump = 1;
                }
                if (!pInput.Crouch) break;
                this.predict.moveState = 2;
                break;
            }
            case 1: {
                if (pInput.Jump) {
                    this.predict.zvel -= 23301L;
                }
                if (!pInput.Crouch) break;
                this.predict.zvel += 23301L;
                break;
            }
            case 2: {
                if (pInput.Crouch) break;
                this.predict.moveState = 0;
            }
        }
        this.predict.look = ru.m210projects.Build.Gameutils.BClipRange(this.predict.look + pInput.mlook, -60.0f, 60.0f);
        if (pInput.LookCenter && !pInput.Lookup && !pInput.Lookdown) {
            if (this.predict.look < 0.0f) {
                this.predict.look = Gameutils.ClipHigh(this.predict.look + (float)Globals.kFrameTicks, 0);
            }
            if (this.predict.look > 0.0f) {
                this.predict.look = Gameutils.ClipLow(this.predict.look - (float)Globals.kFrameTicks, 0);
            }
            if (this.predict.look == 0.0f) {
                this.predict.center = false;
            }
        } else {
            if (pInput.Lookup) {
                this.predict.look = Gameutils.ClipHigh(this.predict.look + (float)Globals.kFrameTicks, 60);
            }
            if (pInput.Lookdown) {
                this.predict.look = Gameutils.ClipLow(this.predict.look - (float)Globals.kFrameTicks, -60);
            }
        }
        this.predict.horiz = this.predict.look > 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(this.predict.look * 8.0f) * 120.0 / 16384.0) : (this.predict.look < 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(this.predict.look * 8.0f) * 180.0 / 16384.0) : 0.0f);
        int floorhit = this.predict.floorHit & 0xE000;
        if (this.predict.height < 16 && (floorhit == 16384 || floorhit == 0) && (Engine.sector[this.predict.sectnum].floorstat & 2) != 0) {
            int dy;
            int oldslope = Main.engine.getflorzofslope(this.predict.sectnum, this.predict.x, this.predict.y);
            int dx = Pragmas.mulscale(64L, Trig.Cos((short)this.predict.ang), 30) + this.predict.x;
            short nSector = Main.engine.updatesector(dx, dy = Pragmas.mulscale(64L, Trig.Sin((short)this.predict.ang), 30) + this.predict.y, this.predict.sectnum);
            if (nSector == this.predict.sectnum) {
                int newslope = Main.engine.getflorzofslope(nSector, dx, dy);
                int slope = (oldslope - newslope >> 3) - this.predict.slope << 14;
                this.predict.slope += slope >> 16;
            }
        } else {
            int slope = this.predict.slope;
            int newslope = -slope << 14;
            this.predict.slope = newslope = slope + (newslope >> 16);
            if (newslope < 0) {
                newslope = -(slope + (-slope << 14 >> 16));
            }
            if (newslope < 4) {
                this.predict.slope = 0;
            }
        }
        this.predict.horizOff = -128.0f * this.predict.horiz;
        int moveDist = (int)(Main.engine.qdist(this.predict.xvel, this.predict.yvel) >> 16);
        this.predict.viewOffdZ += Pragmas.mulscale(28672L, this.predict.zvel - (long)this.predict.viewOffdZ, 16);
        int dZv = this.predict.z - cp.viewSpeed - this.predict.viewOffZ;
        this.predict.viewOffdZ = dZv > 0 ? (this.predict.viewOffdZ += Pragmas.mulscale(40960L, dZv << 8, 16)) : (this.predict.viewOffdZ += Pragmas.mulscale(6144L, dZv << 8, 16));
        this.predict.viewOffZ += this.predict.viewOffdZ >> 8;
        this.predict.weapOffdZ += Pragmas.mulscale(20480L, this.predict.zvel - (long)this.predict.weapOffdZ, 16);
        int dZw = this.predict.z - cp.weapSpeed - this.predict.weaponAboveZ;
        this.predict.weapOffdZ = dZw > 0 ? (this.predict.weapOffdZ += Pragmas.mulscale(32768L, dZw << 8, 16)) : (this.predict.weapOffdZ += Pragmas.mulscale(3072L, dZw << 8, 16));
        this.predict.weaponAboveZ += this.predict.weapOffdZ >> 8;
        this.predict.bobAmp = Gameutils.ClipLow(this.predict.bobAmp - Globals.kFrameTicks, 0);
        if (this.predict.moveState == 1) {
            this.predict.bobPhase = this.predict.bobPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            this.predict.swayPhase = this.predict.swayPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            this.predict.bobHeight = Pragmas.mulscale(cp.bobV * 10, Trig.Sin(this.predict.bobPhase * 2), 30);
            this.predict.bobWidth = Pragmas.mulscale(cp.bobH * this.predict.bobAmp, Trig.Sin(this.predict.bobPhase - 256), 30);
            this.predict.swayHeight = Pragmas.mulscale(cp.swayV * this.predict.bobAmp, Trig.Sin(this.predict.swayPhase * 2), 30);
            this.predict.swayWidth = Pragmas.mulscale(cp.swayH * this.predict.bobAmp, Trig.Sin(this.predict.swayPhase - 341), 30);
        } else if (this.predict.height < 256) {
            boolean Run = false;
            this.predict.bobPhase = this.predict.bobPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] & 0x7FF;
            this.predict.swayPhase = this.predict.swayPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] / 2 & 0x7FF;
            if (Run) {
                if (this.predict.bobAmp < 60) {
                    this.predict.bobAmp = Gameutils.ClipHigh(this.predict.bobAmp + moveDist, 60);
                }
            } else if (this.predict.bobAmp < 30) {
                this.predict.bobAmp = Gameutils.ClipHigh(this.predict.bobAmp + moveDist, 30);
            }
            this.predict.bobHeight = Pragmas.mulscale(cp.bobV * this.predict.bobAmp, Trig.Sin(this.predict.bobPhase * 2), 30);
            this.predict.bobWidth = Pragmas.mulscale(cp.bobH * this.predict.bobAmp, Trig.Sin(this.predict.bobPhase - 256), 30);
            this.predict.swayHeight = Pragmas.mulscale(cp.swayV * this.predict.bobAmp, Trig.Sin(this.predict.swayPhase * 2), 30);
            this.predict.swayWidth = Pragmas.mulscale(cp.swayH * this.predict.bobAmp, Trig.Sin(this.predict.swayPhase - 341), 30);
        }
        this.predict.underwater = false;
        if (this.predict.moveState == 1) {
            short type;
            this.predict.underwater = true;
            if (Warp.gLowerLink[this.predict.sectnum] > 0 && ((type = Engine.sprite[Warp.gLowerLink[this.predict.sectnum]].lotag) == 14 || type == 10) && Main.engine.getceilzofslope(this.predict.sectnum, this.predict.x, this.predict.y) > this.predict.viewOffZ) {
                this.predict.underwater = false;
            }
        }
    }

    private void viewAirDrag(int nDrag) {
        short nXSector;
        int windX = 0;
        int windY = 0;
        short nSector = this.predict.sectnum;
        if (nSector >= 0 && nSector < Globals.kMaxSectors && Engine.sector[nSector].extra > 0 && (nXSector = Engine.sector[nSector].extra) > 0 && nXSector < 512) {
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.windVel != 0 && (pXSector.windAlways || pXSector.busy != 0)) {
                int windVel = pXSector.windVel << 12;
                if (!pXSector.windAlways && pXSector.busy != 0) {
                    windVel = Pragmas.mulscale(pXSector.busy, windVel, 16);
                }
                windX = Pragmas.mulscale(Trig.Cos(pXSector.windAng), windVel, 30);
                windY = Pragmas.mulscale(Trig.Sin(pXSector.windAng), windVel, 30);
            }
        }
        this.predict.xvel += (long)Pragmas.mulscale(nDrag, (long)windX - this.predict.xvel, 16);
        this.predict.yvel += (long)Pragmas.mulscale(nDrag, (long)windY - this.predict.yvel, 16);
        this.predict.zvel -= (long)Pragmas.mulscale(nDrag, this.predict.zvel, 16);
    }

    private void CalcGameChecksum(int nVersion) {
        Arrays.fill(this.gChecksum, 0);
        this.gChecksum[0] = Gameutils.bRandom();
        if (Mmulti.numplayers > 1) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                this.gChecksum[1] = (int)((long)this.gChecksum[1] ^ this.Checksum(Globals.gPlayer[i].getBytes(nVersion), 865));
                this.gChecksum[2] = (int)((long)this.gChecksum[2] ^ this.Checksum(Globals.gPlayer[i].pSprite.getBytes(), 44));
                this.gChecksum[3] = (int)((long)this.gChecksum[3] ^ this.Checksum(Globals.gPlayer[i].pXsprite.getBytes(), 56));
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    @Override
    public void NetDisconnect(int nPlayer) {
        super.NetDisconnect(nPlayer);
        this.app.Disconnect();
    }

    @Override
    public void ComputerInput(int i) {
    }
}

