/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuDifficulty;
import ru.m210projects.Blood.Menus.MenuNetwork;
import ru.m210projects.Blood.Menus.MenuNewAddon;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Strhandler;

public class BLUserContent
extends BuildMenu {
    public boolean showmain;
    private Main app;
    private MenuFileBrowser list;

    public BLUserContent(final Main app) {
        this.app = app;
        MenuTitle title = new MenuTitle(app.pEngine, "User content", app.getFont(1), 160, 20, 2038);
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(3), app.getFont(1), app.getFont(3), 40, 40, width, 1, 10, 2046){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("rff", 7, 1);
                this.registerExtension("grp", 7, 1);
                this.registerExtension("zip", 7, 1);
                this.registerExtension("ini", 7, 1);
                this.registerExtension("dem", 10, -1);
            }

            @Override
            public void handleFile(FileEntry fil) {
                if (fil.getExtension().equals("ini")) {
                    BloodIniFile ini;
                    String name;
                    boolean main;
                    boolean bl = main = fil.getParent() == BuildGdx.compat.getDirectory(Compat.Path.Game);
                    if (BLUserContent.this.showmain) {
                        main = false;
                    }
                    if ((!main || main && !fil.getName().equalsIgnoreCase(Globals.MainINI.getName())) && (name = (ini = LEVELS.episodes.get(fil.getPath())) == null ? BLUserContent.this.buildEpisode(BuildGdx.cache.getBytes(fil.getPath(), 0), fil.getName(), fil, false) : fil.getName()) != null) {
                        this.addFile(fil, name);
                    }
                } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip") || fil.getExtension().equals("rff")) {
                    BLUserContent.this.buildPackage(this, fil);
                } else {
                    this.addFile(fil, fil.getName());
                }
            }

            @Override
            public void invoke(Object obj) {
                if (obj == null) {
                    return;
                }
                if (obj instanceof FileEntry) {
                    FileEntry fil = (FileEntry)obj;
                    if (fil.getExtension().equals("map")) {
                        BLUserContent.this.launchMap(fil);
                    } else if (fil.getExtension().equals("ini")) {
                        BLUserContent.this.launchEpisode(LEVELS.episodes.get(fil.getPath()));
                    } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip") || fil.getExtension().equals("rff")) {
                        BLUserContent.this.launchEpisode(LEVELS.episodes.get(this.getFileName()));
                    } else if (fil.getExtension().equals("dem")) {
                        Main.gDemoScreen.showDemo(fil.getPath(), null);
                        app.menu.mClose();
                    }
                }
            }

            @Override
            public void handleDirectory(DirectoryEntry dir) {
            }

            @Override
            public void drawHeader(int x1, int x2, int y) {
                this.topFont.drawText(x1 + 11, y + 5, this.dirs, 32768, -32, this.topPal, BuildFont.TextAlign.Left, 2, true);
                this.topFont.drawText(x2 + 10, y + 5, this.ffs, 32768, -32, this.topPal, BuildFont.TextAlign.Left, 2, true);
            }

            @Override
            public void drawPath(int x, int y) {
                this.brDrawText(this.pathFont, Strhandler.toCharArray(this.path), x, y, -32, this.pathPal, 0, this.x + this.width - 4);
            }
        };
        this.list.transparent = 33;
        this.list.topPal = 8;
        this.list.pathPal = 8;
        this.addItem(title, false);
        this.addItem(this.list, true);
        this.addItem(((BloodMenuHandler)app.pMenu).addMenuBlood(), false);
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (this.list.getDirectory() == BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            this.list.refreshList();
        }
    }

    private void launchEpisode(BloodIniFile ini) {
        if (ini == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setEpisode(ini);
            this.app.menu.mMenuBack();
            return;
        }
        MenuNewAddon next = (MenuNewAddon)this.app.menu.mMenus[14];
        next.setEpisode(ini);
        this.app.menu.mOpen(next, -1);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        MenuDifficulty next = (MenuDifficulty)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }

    private String buildPackage(MenuFileBrowser list, FileEntry file) {
        try {
            Group res = BuildGdx.cache.isGroup(file.getPath());
            if (res != null) {
                for (GroupResource files : res.getList()) {
                    if (!files.getExtension().equals("ini")) continue;
                    String ptr = String.valueOf(file.getPath()) + ":" + files.getFullName();
                    BloodIniFile ini = LEVELS.episodes.get(ptr);
                    if (ini == null) {
                        GroupResource gres = res.open(files.getFullName());
                        byte[] data = gres.getBytes();
                        ptr = this.buildEpisode(data, files.getFullName(), file, true);
                        if (ptr != null) {
                            list.addFile(file, ptr);
                        }
                        gres.close();
                        continue;
                    }
                    list.addFile(file, ptr);
                }
                res.dispose();
                res = null;
            }
        }
        catch (Exception e) {
            Console.Println("Can't load " + file.getPath(), Console.OSDTEXT_RED);
            e.printStackTrace();
        }
        return null;
    }

    private String buildEpisode(byte[] data, String name, FileEntry file, boolean isPackage) {
        if (data == null) {
            return null;
        }
        BloodIniFile ini = new BloodIniFile(data, name, file);
        boolean isEpisode = false;
        int i = 0;
        while (i < 6) {
            if (ini.set("Episode" + (i + 1))) {
                isEpisode = true;
            }
            ++i;
        }
        if (isEpisode) {
            ini.setPackage(isPackage);
            if (isPackage) {
                String ptr = String.valueOf(file.getPath()) + ":" + ini.getName();
                LEVELS.episodes.put(ptr, ini);
                return ptr;
            }
            LEVELS.episodes.put(file.getPath(), ini);
            return file.getName();
        }
        ini.close();
        return null;
    }
}

