/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.WAVLoader;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.BuildSmacker.SMKFile;

public class CutsceneScreen
extends MovieScreen {
    private Source smkSource;

    public CutsceneScreen(BuildGame game) {
        super(game, Engine.MAXTILES - 3);
        this.nFlags |= 4;
    }

    public boolean init(String path, String sndPath) {
        if (!Main.cfg.showCutscenes || this.isInited()) {
            return false;
        }
        if (!this.open(path)) {
            return false;
        }
        this.smkStartWAV(sndPath);
        return true;
    }

    @Override
    public void show() {
        super.show();
        if (this.smkSource != null) {
            this.smkSource.setGlobal(1);
            this.smkSource.play(1.0f);
        }
    }

    @Override
    public void hide() {
        Screen.curPalette = -1;
        Screen.scrSetPalette(0);
        Screen.scrReset();
        Screen.scrGLSetDac(0);
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            return new SMKMovieFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        SOUND.sndStopAllSounds();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        byte[] pic = this.mvfil.getFrame(num);
        if (((SMKMovieFile)this.mvfil).paletteChanged) {
            this.changepalette(this.mvfil.getPalette());
        }
        return pic;
    }

    @Override
    protected BuildFont GetFont() {
        return this.game.getFont(4);
    }

    @Override
    protected void DrawEscText(BuildFont font, int pal) {
        int shade = 32 + Pragmas.mulscale(32L, Trig.Sin(20 * Engine.totalclock & 0x7FF), 30);
        font.drawText(160, 5, Strings.cutskip, shade, pal, BuildFont.TextAlign.Center, 2, false);
    }

    private void smkStartWAV(String sampleName) {
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        if (Main.cfg.noSound || sampleName == null || sampleName.length() == 0) {
            return;
        }
        byte[] buf = BuildGdx.cache.getBytes(sampleName, 0);
        if (buf == null) {
            Console.Println("Could not load wav file: " + sampleName, Console.OSDTEXT_RED);
            return;
        }
        int sampleSize = buf.length;
        if (sampleSize <= 0) {
            return;
        }
        try {
            WAVLoader wav = new WAVLoader(buf);
            BuildGdx.audio.getSound().resetListener();
            this.smkSource = BuildGdx.audio.newSound(wav.data, wav.rate, wav.bits, wav.channels, 255);
        }
        catch (Exception e) {
            Console.Println(String.valueOf(e.getMessage()) + " in " + sampleName, Console.OSDTEXT_RED);
            return;
        }
    }

    @Override
    protected void close() {
        super.close();
        if (this.smkSource != null) {
            this.smkSource.dispose();
        }
        this.smkSource = null;
    }

    protected static class SMKMovieFile
    implements MovieScreen.MovieFile {
        protected SMKFile smkfil;
        protected boolean paletteChanged;

        public SMKMovieFile(String file) throws Exception {
            byte[] smkbuf = BuildGdx.cache.getBytes(file, 0);
            if (smkbuf == null) {
                throw new FileNotFoundException();
            }
            ByteBuffer bb = ByteBuffer.wrap(smkbuf);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.smkfil = new SMKFile(bb);
            this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask());
        }

        @Override
        public int getFrames() {
            return this.smkfil.getFrames();
        }

        @Override
        public float getRate() {
            return (float)this.smkfil.getRate() / 1000.0f;
        }

        @Override
        public byte[] getFrame(int num) {
            this.paletteChanged = this.smkfil.setFrame(num) != 0;
            return this.smkfil.getVideoBuffer().array();
        }

        @Override
        public byte[] getPalette() {
            return this.smkfil.getPalette();
        }

        @Override
        public short getWidth() {
            return (short)this.smkfil.getHeight();
        }

        @Override
        public short getHeight() {
            return (short)this.smkfil.getWidth();
        }

        public boolean paletteChanged(int frame) {
            return this.smkfil.setFrame(frame) != 0;
        }

        @Override
        public void close() {
        }

        @Override
        public void playAudio() {
        }
    }
}

