/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Cheats;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Settings.BuildConfig;

public class GameScreen
extends GameAdapter {
    public int gNameShowTime;
    private Main game;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            INPUT src = (INPUT)net.gFifoInput[net.gNetFifoTail & 0xFF][i];
            Globals.gPlayer[i].pInput.syncFlags = src.syncFlags;
            Globals.gPlayer[i].pInput.Forward = src.Forward;
            Globals.gPlayer[i].pInput.Turn = src.Turn;
            Globals.gPlayer[i].pInput.Strafe = src.Strafe;
            Globals.gPlayer[i].pInput.mlook = src.mlook;
            Globals.gPlayer[i].pInput.Run = src.Run;
            Globals.gPlayer[i].pInput.Jump = src.Jump;
            Globals.gPlayer[i].pInput.Crouch = src.Crouch;
            Globals.gPlayer[i].pInput.Shoot = src.Shoot;
            Globals.gPlayer[i].pInput.AltShoot = src.AltShoot;
            Globals.gPlayer[i].pInput.Lookup = src.Lookup;
            Globals.gPlayer[i].pInput.Lookdown = src.Lookdown;
            Globals.gPlayer[i].pInput.TurnAround = src.TurnAround;
            Globals.gPlayer[i].pInput.Use |= src.Use;
            Globals.gPlayer[i].pInput.InventoryLeft |= src.InventoryLeft;
            Globals.gPlayer[i].pInput.InventoryRight |= src.InventoryRight;
            Globals.gPlayer[i].pInput.InventoryUse |= src.InventoryUse;
            Globals.gPlayer[i].pInput.PrevWeapon |= src.PrevWeapon;
            Globals.gPlayer[i].pInput.NextWeapon |= src.NextWeapon;
            Globals.gPlayer[i].pInput.HolsterWeapon |= src.HolsterWeapon;
            Globals.gPlayer[i].pInput.LookCenter |= src.LookCenter;
            Globals.gPlayer[i].pInput.LookLeft = src.LookLeft;
            Globals.gPlayer[i].pInput.LookRight = src.LookRight;
            Globals.gPlayer[i].pInput.Pause |= src.Pause;
            Globals.gPlayer[i].pInput.Quit |= src.Quit;
            Globals.gPlayer[i].pInput.Restart |= src.Restart;
            Globals.gPlayer[i].pInput.CrouchMode = src.CrouchMode;
            Globals.gPlayer[i].pInput.LastWeapon = src.LastWeapon;
            Globals.gPlayer[i].pInput.UseBeastVision |= src.UseBeastVision;
            Globals.gPlayer[i].pInput.UseCrystalBall |= src.UseCrystalBall;
            Globals.gPlayer[i].pInput.UseJumpBoots |= src.UseJumpBoots;
            Globals.gPlayer[i].pInput.UseMedKit |= src.UseMedKit;
            if (src.newWeapon != 0) {
                Globals.gPlayer[i].pInput.newWeapon = src.newWeapon;
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        net.CalcChecksum();
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (Globals.gPlayer[i].pInput.Quit) {
                Globals.gPlayer[i].pInput.Quit = false;
                this.game.pNet.NetDisconnect(i);
                return;
            }
            if (Globals.gPlayer[i].pInput.Restart) {
                Globals.gPlayer[i].pInput.Restart = false;
                Main.gGameScreen.loadboard(Globals.pGameInfo.zLevelName, null);
                return;
            }
            if (Globals.gPlayer[i].pInput.Pause) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
                if (this.game.gPaused && Globals.pGameInfo.nGameType > 0 && Mmulti.numplayers > 1) {
                    View.viewSetMessage(String.valueOf(this.game.net.gProfile[i].name) + " paused the game", -1);
                }
                Globals.gPlayer[i].pInput.Pause = false;
            }
            i = Mmulti.connectpoint2[i];
        }
        if (this.game.gPaused || !this.game.isCurrentScreen(Main.gGameScreen) && !this.game.isCurrentScreen(Main.gDemoScreen)) {
            return;
        }
        if (this.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nGameType == 0 && (this.game.menu.gShowMenu || Console.IsShown())) {
            return;
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            View.viewBackupView(i);
            PLAYER.playerMove(Globals.gPlayer[i]);
            i = Mmulti.connectpoint2[i];
        }
        Trigger.trProcessBusy();
        EVENT.evProcess(Globals.gFrameClock);
        SeqHandling.seqProcess(Globals.kFrameTicks);
        SECTORFX.DoSectorPanning();
        Actor.actProcessSprites();
        Actor.actPostProcess();
        net.CorrectPrediction();
        SOUND.sndProcess();
        SOUND.ambProcess();
        SOUND.sfxUpdate3DSounds();
        ++Globals.gFrame;
        Globals.gFrameClock += Globals.kFrameTicks;
        if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
            this.game.pNet.ready2send = false;
            SeqHandling.seqKillAll();
            if (this.game.isCurrentScreen(Main.gDemoScreen)) {
                return;
            }
            if ((Globals.pGameInfo.uGameFlags & 2) != 0) {
                if (Globals.pGameInfo.nGameType == 0) {
                    Runnable rEndGame = new Runnable(){

                        @Override
                        public void run() {
                            GameScreen.this.game.resetState();
                            GameScreen.this.game.changeScreen(Main.gMenuScreen);
                            ((GameScreen)GameScreen.this).game.menu.mOpen(((GameScreen)GameScreen.this).game.menu.mMenus[5], -1);
                        }
                    };
                    if (this.checkCutsceneB()) {
                        this.game.changeScreen(Main.gCutsceneScreen.setCallback(rEndGame).escSkipping(true));
                    } else {
                        rEndGame.run();
                    }
                } else {
                    this.game.Disconnect();
                }
                Globals.pGameInfo.uGameFlags &= 0xFFFFFFFC;
            } else {
                this.game.changeScreen(Main.gStatisticScreen);
            }
        }
    }

    @Override
    public void DrawWorld(float smooth) {
        View.viewDrawScreen(View.gViewIndex, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        int x;
        PLAYER gView = Globals.gPlayer[View.gViewIndex];
        if (gView == null) {
            return;
        }
        if (View.gViewMode == 3 || View.gViewMode == 2) {
            short nSector = gView.pSprite.sectnum;
            if (View.gViewPos == 0) {
                if ((!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) && Main.cfg.gCrosshair) {
                    Main.engine.rotatesprite((int)((float)(View.viewCrossX - Engine.tilesizx[2319] * 320 / Engine.xdim) * 65536.0f), (int)((float)(View.viewCrossY + Engine.tilesizy[2319] * 240 / Engine.ydim) * 65536.0f), View.viewCrossZoom, 0, 2319, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
                byte nShade = 0;
                int nPLU = 0;
                if (nSector != -1) {
                    nShade = Engine.sector[nSector].floorshade;
                    if (Engine.sector[nSector].extra > 0 && DB.xsector[Engine.sector[nSector].extra].color) {
                        nPLU = Engine.sector[nSector].floorpal;
                    }
                }
                int nZoom = 65536;
                if (Globals.SplitScreen) {
                    nZoom = 32768;
                }
                Weapon.WeaponDraw(gView, nShade, View.viewWeaponX, View.viewWeaponY, nPLU, nZoom);
                if (gView.pXsprite.burnTime > 60) {
                    View.viewDrawBurn(gView.pXsprite.burnTime);
                }
            }
            if (PLAYER.inventoryCheck(gView, 1)) {
                Main.engine.rotatesprite(0, 0, 65536, 0, 2344, 0, 0, 282, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.rotatesprite(0x1400000, 0, 65536, 1024, 2344, 0, 0, 542, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.rotatesprite(0, 0xC80000, 65536, 0, 2344, 0, 0, 286, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.rotatesprite(0x1400000, 0xC80000, 65536, 1024, 2344, 0, 0, 538, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                if (Main.cfg.gDetail >= 4) {
                    Main.engine.rotatesprite(983040, 196608, 65536, 0, 2346, 32, 0, 283, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                    Main.engine.rotatesprite(0xD40000, 0x4D0000, 65536, 0, 2347, 32, 0, 539, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                }
            }
            if (PLAYER.powerupCheck(gView, 39) > 0) {
                Main.engine.rotatesprite(0, 0xC80000, 65536, 0, 2358, 0, 0, 286, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.rotatesprite(0x1400000, 0xC80000, 65536, 1024, 2358, 0, 0, 538, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
            }
            if (PLAYER.powerupCheck(gView, 21) > 0 && (Mmulti.numplayers > 1 || this.game.isCurrentScreen(Main.gGameScreen) && Globals.kFakeMultiplayer && Globals.nFakePlayers > 1)) {
                View.DoLensEffect();
                Main.engine.setaspect(65536, 54613);
                int crysX = 280;
                int crysY = 35;
                int nLensPLU = 0;
                if (nSector != -1 && Actor.IsUnderwaterSector(nSector)) {
                    nLensPLU = 10;
                }
                Main.engine.rotatesprite(crysX << 16, crysY << 16, 53248, Main.engine.getrender().getType() == Renderer.RenderType.Software ? 512 : -1024, 4077, 0, nLensPLU, 6, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.rotatesprite(crysX - 1 << 16, crysY - 1 << 16, 53248, 0, 1683, 0, 0, 35, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                Main.engine.setview(View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
            }
        }
        if (View.gViewMode == 4 || View.gViewMode == 2) {
            char[] mode;
            if (View.gViewMode == 4) {
                Main.engine.clearview(0);
            }
            View.updateviewmap();
            x = gView.pSprite.x;
            int y = gView.pSprite.y;
            float ang = gView.ang;
            if (Globals.gMapScrollMode) {
                x = View.scrollOX + Pragmas.mulscale(View.scrollX - View.scrollOX, View.smoothratio, 16);
                y = View.scrollOY + Pragmas.mulscale(View.scrollY - View.scrollOY, View.smoothratio, 16);
                ang = (float)View.scrollOAng + (ru.m210projects.Build.Gameutils.BClampAngle(View.scrollAng - View.scrollOAng + 1024) - 1024.0f) * (float)View.smoothratio / 65536.0f;
                mode = Strings.scrollmode;
            } else {
                x = PLAYER.gPrevView[View.gViewIndex].x + Pragmas.mulscale(x - PLAYER.gPrevView[View.gViewIndex].x, View.smoothratio, 16);
                y = PLAYER.gPrevView[View.gViewIndex].y + Pragmas.mulscale(y - PLAYER.gPrevView[View.gViewIndex].y, View.smoothratio, 16);
                ang = PLAYER.gPrevView[View.gViewIndex].ang + (ru.m210projects.Build.Gameutils.BClampAngle(ang - PLAYER.gPrevView[View.gViewIndex].ang + 1024.0f) - 1024.0f) * (float)View.smoothratio / 65536.0f;
                mode = Strings.followmode;
            }
            int oldSize = Main.cfg.gViewSize;
            View.viewResizeView(0);
            if (View.gViewMode == 4) {
                Main.engine.drawmapview(x, y, View.kMapZoom >> 1, (short)ang);
            }
            Main.engine.drawoverheadmap(x, y, View.kMapZoom >> 1, (short)ang);
            int tx = 315;
            int ty = 16;
            String mapname = Globals.boardfilename;
            if (Main.mUserFlag == Main.UserFlag.UserMap && LEVELS.gUserMapInfo.Title != null) {
                mapname = LEVELS.gUserMapInfo.Title;
            }
            String info = "E" + (Globals.pGameInfo.nEpisode + 1) + "M" + (Globals.pGameInfo.nLevel + 1) + ": " + mapname;
            this.game.getFont(3).drawText(tx, ty, Gameutils.toCharArray(info), 0, 0, BuildFont.TextAlign.Right, 514, false);
            this.game.getFont(3).drawText(tx, ty + 10, mode, 0, 0, BuildFont.TextAlign.Right, 514, false);
            View.viewResizeView(oldSize);
        }
        if (!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) {
            if (!Globals.SplitScreen) {
                View.viewDrawHUD(Globals.gPlayer[View.gViewIndex]);
            } else {
                View.viewDrawSplitHUD(Globals.gPlayer[View.gViewIndex]);
            }
        }
        if (Globals.gTextInput) {
            int nShade = 8;
            int x2 = Pragmas.mulscale(View.gViewX0 + 10, View.gViewX1Scaled, 16);
            int y = Pragmas.mulscale(View.gViewY0 + 10, View.gViewY1Scaled, 16);
            y += View.nextY + View.numQuotes * View.yOffset;
            if (Globals.pGameInfo.nGameType != 0 && Globals.pGameInfo.nGameType != 3) {
                int row = (Mmulti.numplayers - 1) / 4;
                y += (row + 1) * 9;
            }
            if (Globals.pGameInfo.nGameType == 3) {
                y += 22;
            }
            View.viewDrawInputText(0, Engine.getInput().getMessageBuffer(), Engine.getInput().getMessageLength() + 1, x2 + 1, y, 65536, nShade, 0, 0, 256, false);
        }
        View.viewDisplayMessage(0);
        if (View.gPlayerIndex != -1 && View.gPlayerIndex != View.gViewIndex) {
            int plu = Globals.gPlayer[View.gPlayerIndex].pSprite.pal;
            if (plu == 13) {
                plu = 4;
            }
            this.game.getFont(4).drawText(160, 120, Gameutils.toCharArray(this.game.net.gProfile[View.gPlayerIndex].name), 0, plu, BuildFont.TextAlign.Center, 2, false);
            if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gPlayer[View.gPlayerIndex].deathTime > 0 && Globals.gPlayer[View.gPlayerIndex].pXsprite.health <= 0) {
                PLAYER pPlayer = Globals.gPlayer[View.gPlayerIndex];
                int hitDist = (int)(Main.engine.qdist(gView.pSprite.x - pPlayer.pSprite.x, gView.pSprite.y - pPlayer.pSprite.y) >> 4);
                if (hitDist < 64) {
                    int shade = 32 - (Engine.totalclock & 0x3F);
                    this.game.getFont(4).drawText(160, 130, Gameutils.toCharArray("Press \"USE\" to revive player"), 0, shade, BuildFont.TextAlign.Center, 2, false);
                }
            }
        }
        if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gPlayer[View.gViewIndex].deathTime > 0 && Globals.gPlayer[View.gViewIndex].pXsprite.health <= 0) {
            int shade = 32 - (Engine.totalclock & 0x3F);
            this.game.getFont(4).drawText(160, 130, Gameutils.toCharArray("Wait for revive or press \"USE\" to respawn"), 0, shade, BuildFont.TextAlign.Center, 2, false);
        }
        if (this.game.gPaused) {
            this.game.getFont(1).drawText(160, 10, Strings.paused, 0, 0, BuildFont.TextAlign.Center, 2, false);
        }
        if (this.game.isCurrentScreen(Main.gGameScreen) && Globals.gFrameClock < this.gNameShowTime) {
            int transp = 0;
            if (Globals.gFrameClock > this.gNameShowTime - 20) {
                transp = 33;
            }
            if (Globals.gFrameClock > this.gNameShowTime - 10) {
                transp = 1;
            }
            if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu) {
                switch (Main.cfg.showMapInfo) {
                    case 1: {
                        if (Globals.boardfilename == null) break;
                        this.game.getFont(1).drawText(160, 60, Gameutils.toCharArray(Globals.boardfilename), -128, 0, BuildFont.TextAlign.Center, 2 | transp, true);
                        break;
                    }
                    case 2: {
                        if (Globals.boardfilename != null) {
                            this.game.getFont(3).drawText(160, 20, Gameutils.toCharArray(Globals.boardfilename), 0, 0, BuildFont.TextAlign.Center, 2 | transp, false);
                        }
                        if (LEVELS.currentEpisode == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel] == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Author == null) break;
                        this.game.getFont(3).drawText(160, 30, Gameutils.toCharArray("by " + LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Author), 0, 0, BuildFont.TextAlign.Center, 2 | transp, false);
                    }
                }
            }
        }
        if (this.game.net.bOutOfSync) {
            this.game.getFont(3).drawText(160, 20, Gameutils.toCharArray("Out of sync!"), 0, 0, BuildFont.TextAlign.Center, 2, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(3).drawText(160, 30, Gameutils.toCharArray("bseed checksum error"), 0, 0, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 1: {
                    this.game.getFont(3).drawText(160, 30, Gameutils.toCharArray("player struct checksum error"), 0, 0, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 2: {
                    this.game.getFont(3).drawText(160, 30, Gameutils.toCharArray("player sprite checksum error"), 0, 0, BuildFont.TextAlign.Center, 2, false);
                    break;
                }
                case 3: {
                    this.game.getFont(3).drawText(160, 30, Gameutils.toCharArray("player xsprite checksum error"), 0, 0, BuildFont.TextAlign.Center, 2, false);
                }
            }
        }
        if (gView.pSprite.statnum == 6 && gView.handDamage) {
            x = 160;
            int y = (gView.weaponAboveZ - gView.viewOffZ - 3072 >> 7) + 220;
            if (View.viewHandAnim.pQAV != null) {
                int oldFrameClock = Globals.gFrameClock;
                Globals.gFrameClock = Engine.totalclock;
                QAV pQAV = View.viewHandAnim.pQAV;
                pQAV.origin.x = x;
                pQAV.origin.y = y;
                int ticks = Engine.totalclock - View.viewHandAnim.clock;
                View.viewHandAnim.clock = Engine.totalclock;
                View.viewHandAnim.duration -= ticks;
                if (View.viewHandAnim.duration <= 0 || View.viewHandAnim.duration > pQAV.duration) {
                    View.viewHandAnim.duration = pQAV.duration;
                }
                int t = pQAV.duration - View.viewHandAnim.duration;
                pQAV.Play(t - ticks, t, -1, null);
                int oldwx1 = Engine.windowx1;
                int oldwy1 = Engine.windowy1;
                int oldwx2 = Engine.windowx2;
                int oldwy2 = Engine.windowy2;
                Engine.windowy1 = 0;
                Engine.windowx2 = Engine.xdim - 1;
                Engine.windowx1 = 0;
                Engine.windowy2 = Engine.ydim - 1;
                pQAV.Draw(t, 0, 10, 0, 65536);
                Engine.windowx1 = oldwx1;
                Engine.windowy1 = oldwy1;
                Engine.windowx2 = oldwx2;
                Engine.windowy2 = oldwy2;
                Globals.gFrameClock = oldFrameClock;
            }
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LOADSAVE.gQuickSaving) {
            if (this.captBuffer != null) {
                LOADSAVE.savegame("[quicksave_" + LOADSAVE.quickslot + "]", "quicksav" + LOADSAVE.quickslot + ".sav");
                LOADSAVE.quickslot ^= 1;
                LOADSAVE.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(320, 200);
            }
        }
        if (LOADSAVE.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LOADSAVE.savegame("[autosave]", "autosave.sav");
                LOADSAVE.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(320, 200);
            }
        }
        Globals.fire.process();
        View.viewPaletteHandler(Globals.gPlayer[View.gViewIndex]);
    }

    @Override
    public void KeyHandler() {
        BloodMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            menu.mOpen(menu.mMenus[1], -1);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Show_SaveMenu, true)) {
            if (Mmulti.numplayers > 1) {
                return;
            }
            if (Globals.gMe.pXsprite.health != 0) {
                Main.gGameScreen.capture(320, 200);
                menu.mOpen(menu.mMenus[8], -1);
            }
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Show_LoadMenu, true)) {
            if (Mmulti.numplayers > 1) {
                return;
            }
            menu.mOpen(menu.mMenus[7], -1);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Show_SoundSetup, true)) {
            menu.mOpen(menu.mMenus[3], -1);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[15], -1);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Quicksave, true)) {
            LOADSAVE.quicksave();
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Toggle_messages, true)) {
            boolean bl = Main.cfg.MessageState = !Main.cfg.MessageState;
            if (Main.cfg.MessageState) {
                View.viewSetMessage("Messages on", View.gViewIndex);
            }
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Quickload, true)) {
            LOADSAVE.quickload();
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[9], -1);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Gamma, true)) {
            this.openGamma(menu);
        }
        if (input.ctrlGetInputKey(Config.BloodKeys.Make_Screenshot, true)) {
            this.makeScreenshot();
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, false)) {
            if (View.gViewMode == 3) {
                if (input.ctrlGetInputKey(BuildConfig.GameKeys.Shrink_Screen, true)) {
                    View.viewResizeView(Main.cfg.gViewSize + 1);
                }
            } else {
                View.kMapZoom = Gameutils.ClipLow(View.kMapZoom - (View.kMapZoom >> 4), 16);
            }
        }
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, false)) {
            if (View.gViewMode == 3) {
                if (input.ctrlGetInputKey(BuildConfig.GameKeys.Enlarge_Screen, true)) {
                    View.viewResizeView(Main.cfg.gViewSize - 1);
                }
            } else {
                View.kMapZoom = Gameutils.ClipHigh(View.kMapZoom + (View.kMapZoom >> 4), 4096);
            }
        }
    }

    protected void makeScreenshot() {
        String filename;
        String name = "scrxxxx.png";
        if (Main.mUserFlag == Main.UserFlag.UserMap && LEVELS.gUserMapInfo != null) {
            name = "scr-" + this.game.getFilename(LEVELS.gUserMapInfo.MapName) + "-xxxx.png";
        }
        if (Main.mUserFlag != Main.UserFlag.UserMap && LEVELS.currentEpisode != null) {
            name = "scr-e" + (Globals.pGameInfo.nEpisode + 1) + "m" + (Globals.pGameInfo.nLevel + 1) + "[" + LEVELS.currentEpisode.filename + "]-xxxx.png";
        }
        if ((filename = this.pEngine.screencapture(name)) != null) {
            View.viewSetMessage(String.valueOf(filename) + " saved", View.gViewIndex);
        } else {
            View.viewSetMessage("Screenshot not saved. Access denied!", View.gViewIndex);
        }
    }

    protected void openGamma(BloodMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        SOUND.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(String map) {
        this.gNameShowTime = 500;
        return DB.prepareboard(this);
    }

    public void newgame(final boolean isMultiplayer, final Object item, final int episodeNum, final int nLevel, final int nGlobalDifficulty, final int nEnemyQuantity, final int nEnemyDamage, final boolean nPitchforkOnly) {
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(new Runnable(){

            @Override
            public void run() {
                if (!isMultiplayer) {
                    Globals.kFakeMultiplayer = false;
                    if (Mmulti.numplayers > 1) {
                        GameScreen.this.pNet.NetDisconnect(Mmulti.myconnectindex);
                    }
                    Globals.pGameInfo.copy(Globals.defGameInfo);
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Single;
                } else {
                    Globals.pGameInfo.nGameType = Globals.pNetInfo.nGameType;
                    Globals.pGameInfo.nEpisode = Globals.pNetInfo.nEpisode;
                    Globals.pGameInfo.nLevel = Globals.pNetInfo.nLevel;
                    Globals.pGameInfo.nDifficulty = Globals.pNetInfo.nDifficulty;
                    Globals.pGameInfo.nMonsterSettings = Globals.pNetInfo.nMonsterSettings;
                    Globals.pGameInfo.nWeaponSettings = Globals.pNetInfo.nWeaponSettings;
                    Globals.pGameInfo.nItemSettings = Globals.pNetInfo.nItemSettings;
                    Globals.pGameInfo.nFriendlyFire = Globals.pNetInfo.nFriendlyFire;
                    Globals.pGameInfo.nReviveMode = Globals.pNetInfo.nReviveMode;
                    Globals.pGameInfo.nEnemyQuantity = Globals.pNetInfo.nDifficulty;
                    Globals.pGameInfo.nEnemyDamage = Globals.pNetInfo.nDifficulty;
                    Globals.pGameInfo.nPitchforkOnly = false;
                    Globals.pGameInfo.nFragLimit = Globals.pNetInfo.nFragLimit;
                    ((GameScreen)GameScreen.this).game.nNetMode = BuildGame.NetMode.Multiplayer;
                }
                Main.UserFlag flag = Main.UserFlag.None;
                if (item instanceof BloodIniFile && !item.equals(Globals.MainINI)) {
                    flag = Main.UserFlag.Addon;
                    BloodIniFile ini = (BloodIniFile)item;
                    LEVELS.getEpisodeInfo(LEVELS.gUserEpisodeInfo, ini);
                    LEVELS.checkEpisodeResources(ini);
                    Console.Println("Start user episode: " + episodeNum);
                } else {
                    LEVELS.resetEpisodeResources();
                }
                if (item instanceof FileEntry) {
                    flag = Main.UserFlag.UserMap;
                }
                Main.mUserFlag = flag;
                if (flag == Main.UserFlag.UserMap) {
                    LEVELS.loadUserMapInfo(((FileEntry)item).getPath());
                    Console.Println("Start user map: " + LEVELS.gUserMapInfo.Title);
                } else {
                    LEVELS.loadMapInfo(episodeNum, nLevel);
                }
                Globals.pGameInfo.nDifficulty = nGlobalDifficulty;
                Globals.pGameInfo.nEnemyQuantity = nEnemyQuantity;
                Globals.pGameInfo.nEnemyDamage = nEnemyDamage;
                Globals.pGameInfo.nPitchforkOnly = nPitchforkOnly;
                Globals.pGameInfo.uGameFlags = 0;
                Globals.cheatsOn = false;
                PLAYER.playerGodMode(Globals.gMe, 0);
                Globals.gInfiniteAmmo = false;
                Globals.gFullMap = false;
                Cheats.cheatSubInventory(Globals.gMe);
                Globals.gNoClip = false;
                String title = GameScreen.this.getTitle();
                if (!GameScreen.this.checkCutsceneA(title)) {
                    GameScreen.this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(title);
                }
            }
        });
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.gPrecacheScreen.init(false, startboard);
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    public void nextmap() {
        LEVELS.loadMapInfo(Globals.pGameInfo.nEpisode, LEVELS.gNextMap);
        String title = this.getTitle();
        if (!this.checkCutsceneA(title)) {
            this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(title);
        }
        if (Globals.pGameInfo.nGameType == 0) {
            LOADSAVE.gAutosaveRequest = true;
        }
    }

    @Override
    public GameAdapter setTitle(String title) {
        Globals.boardfilename = title;
        return super.setTitle(title);
    }

    private boolean checkCutsceneA(final String loadTitle) {
        if (Globals.pGameInfo.nGameType != 0 || Globals.kFakeMultiplayer || Main.mUserFlag == Main.UserFlag.UserMap || !LEVELS.currentEpisode.hasCutsceneA(Globals.pGameInfo.nLevel) || this == Main.gDemoScreen) {
            return false;
        }
        if (Main.gCutsceneScreen.init(LEVELS.currentEpisode.CutSceneA, LEVELS.currentEpisode.CutWavA)) {
            Globals.pGameInfo.uGameFlags |= 4;
            Main.gCutsceneScreen.setCallback(new Runnable(){

                @Override
                public void run() {
                    Globals.pGameInfo.uGameFlags &= 0xFFFFFFFB;
                    GameScreen.this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(loadTitle);
                }
            }).escSkipping(true);
            this.game.changeScreen(Main.gCutsceneScreen);
            return true;
        }
        return false;
    }

    private boolean checkCutsceneB() {
        if (Globals.pGameInfo.nGameType != 0 || Globals.kFakeMultiplayer || Main.mUserFlag == Main.UserFlag.UserMap || !LEVELS.currentEpisode.hasCutsceneB(Globals.pGameInfo.nLevel) || this == Main.gDemoScreen) {
            return false;
        }
        return (Globals.pGameInfo.uGameFlags & 8) != 0 && Main.gCutsceneScreen.init(LEVELS.currentEpisode.CutSceneB, LEVELS.currentEpisode.CutWavB);
    }

    public String getTitle() {
        String title = null;
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            if (Main.mUserFlag == Main.UserFlag.None) {
                title = this.getEpisodeTitle();
            } else if (Main.mUserFlag == Main.UserFlag.Addon && (title = this.getUserEpisodeTitle()) == null) {
                this.game.GameMessage("No map in user episode or wrong map filename!");
                return null;
            }
        } else {
            title = this.getMapTitle();
        }
        return title;
    }

    public String getUserEpisodeTitle() {
        if (LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode] != null && LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel] != null) {
            return LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        return null;
    }

    public String getEpisodeTitle() {
        if (LEVELS.gEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel] != null) {
            return LEVELS.gEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        return null;
    }

    public String getMapTitle() {
        if (LEVELS.gUserMapInfo != null) {
            return LEVELS.gUserMapInfo.Title;
        }
        return null;
    }
}

