/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;

public class StatisticScreen
extends SkippableAdapter {
    protected float gTicks;
    protected float gShowTime;
    protected boolean maySkipped;
    protected Main app;

    public StatisticScreen(Main game, float gShowTime) {
        super(game);
        this.app = game;
        this.gShowTime = gShowTime;
    }

    @Override
    public void show() {
        this.gTicks = 0.0f;
        this.maySkipped = false;
        Screen.scrReset();
        Screen.scrSetPalette(0);
        SOUND.sndStopAllSounds();
        SOUND.sndStartSample(268, 128, -1, false);
    }

    @Override
    public void draw(float delta) {
        float f;
        this.engine.clearview(0);
        this.viewShowStatus(this.maySkipped);
        this.gTicks += delta;
        if (f >= this.gShowTime) {
            this.maySkipped = true;
        }
    }

    public void viewShowStatus(boolean maySkipped) {
        View.viewShowLoadingTile();
        this.engine.rotatesprite(0xA00000, 0x140000, 65536, 0, 2038, -128, 0, 78, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        if (Globals.pGameInfo.nGameType > 1) {
            this.game.getFont(1).drawText(160, 20 - this.game.getFont(1).getHeight() / 2, Strings.frags, -128, 0, BuildFont.TextAlign.Center, 2, false);
            this.game.getFont(3).drawText(85, 35, Gameutils.toCharArray("#"), -128, 0, BuildFont.TextAlign.Left, 2, false);
            this.game.getFont(3).drawText(110, 35, Gameutils.toCharArray("name"), -128, 0, BuildFont.TextAlign.Left, 2, false);
            this.game.getFont(3).drawText(225, 35, Gameutils.toCharArray("frags"), -128, 0, BuildFont.TextAlign.Left, 2, false);
            short i = Mmulti.connecthead;
            while (i >= 0) {
                View.viewDrawNumber(3, i, 85, 50 + i * 10, 65536, -128, 0, BuildFont.TextAlign.Left, 2, false);
                this.game.getFont(3).drawText(110, 50 + i * 10, Gameutils.toCharArray(this.app.net.gProfile[i].name), -128, 0, BuildFont.TextAlign.Left, 2, false);
                View.viewDrawNumber(3, Globals.gPlayer[i].fragCount, 225, 50 + i * 10, 65536, -128, 0, BuildFont.TextAlign.Left, 2, false);
                i = Mmulti.connectpoint2[i];
            }
        } else {
            this.game.getFont(1).drawText(160, 20 - this.game.getFont(1).getHeight() / 2, Strings.levelstats, -128, 0, BuildFont.TextAlign.Center, 2, false);
            if (Globals.cheatsOn) {
                this.game.getFont(3).drawText(160, 32, Gameutils.toCharArray(">>> YOU CHEATED! <<<"), -128, 0, BuildFont.TextAlign.Center, 2, true);
            }
            View.viewFragStat();
            View.viewSecretStat();
        }
        this.game.getFont(3).drawText(20, 191, this.game.sversion, 32, 0, BuildFont.TextAlign.Center, 2, false);
        if (maySkipped && (Engine.totalclock & 0x20) != 0) {
            this.game.getFont(3).drawText(160, 134, Strings.keycontinue, -128, 0, BuildFont.TextAlign.Center, 2, true);
        }
    }

    @Override
    public void skip() {
        if (this.maySkipped) {
            Main.gGameScreen.nextmap();
        }
        super.skip();
    }
}

