/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;

public class Trig {
    public static int[] costable = new int[2048];
    static Vector2 rotated = new Vector2(0.0f, 0.0f);
    static int[] octanTable;

    static {
        int[] nArray = new int[8];
        nArray[0] = 5;
        nArray[1] = 6;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 4;
        nArray[5] = 7;
        nArray[6] = 3;
        octanTable = nArray;
    }

    public static void trigInit() {
        Resource buf = BuildGdx.cache.open("cosine.dat", 0);
        if (buf != null) {
            int i = 0;
            while (i < 512) {
                Trig.costable[i] = buf.readInt();
                ++i;
            }
            i = 513;
            while (i <= 1024) {
                Trig.costable[i] = -costable[1024 - i];
                ++i;
            }
            i = 1025;
            while (i < 2048) {
                Trig.costable[i] = costable[2048 - i];
                ++i;
            }
            buf.close();
        } else {
            System.err.println("cosine file not found");
        }
    }

    public static int Cos(int angle) {
        return costable[angle & 0x7FF];
    }

    public static int Sin(int angle) {
        return costable[angle - 512 & 0x7FF];
    }

    public static Vector2 RotateVector(long x, long y, int nAngle) {
        Trig.rotated.x = Pragmas.dmulscaler(Trig.Cos(nAngle), x, -Trig.Sin(nAngle), y, 30);
        Trig.rotated.y = Pragmas.dmulscaler(Trig.Sin(nAngle), x, Trig.Cos(nAngle), y, 30);
        return rotated;
    }

    public static int GetOctant(int x, int y) {
        long dx = Pragmas.klabs(x) - Pragmas.klabs(y);
        return octanTable[7 - 2 * (y < 0 ? 1 : 0) - (x < 0 ? 1 : 0) - 4 * (dx > 2L * dx ? 1 : 0)];
    }
}

