/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.PICANM;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;

public class BloodDef
extends DefScript {
    public byte[] surfType = new byte[Globals.kMaxTiles];
    private final DefineIdToken rffid = new DefineIdToken();
    private final NBloodDefineIdToken nbrffid = new NBloodDefineIdToken();
    private final DefScript.TileFromTextureToken tft = new BloodTileFromTextureToken();
    private UserGroup usergroup;
    private final Map<String, Integer> fileids = new HashMap<String, Integer>();

    public BloodDef(BuildEngine engine, boolean disposable) {
        super(engine, disposable);
        this.addToken("definefileid", this.rffid);
        this.addToken("rffdefineid", this.nbrffid);
        this.addToken("tilefromtexture", this.tft);
        this.surfaceInit("SURFACE.DAT");
    }

    public BloodDef(BloodDef src, FileEntry addon) {
        super(src, addon);
        this.addToken("definefileid", this.rffid);
        this.addToken("rffdefineid", this.nbrffid);
        this.addToken("tilefromtexture", this.tft);
        System.arraycopy(src.surfType, 0, this.surfType, 0, src.surfType.length);
    }

    public void surfaceInit(String name) {
        Resource data = BuildGdx.cache.open(name, 0);
        if (data == null) {
            return;
        }
        int pos = 0;
        while (data.hasRemaining()) {
            data.read(this.surfType, pos, Math.min(this.surfType.length, data.remaining()));
            pos += this.surfType.length;
        }
        data.close();
    }

    @Override
    public void apply() {
        Resource res;
        List defs;
        if (this.addonsIncludes != null && this.currentAddon != null && (defs = (List)this.addonsIncludes.get(this.currentAddon.getName())) != null) {
            int i = 0;
            while (i < defs.size() / 2) {
                String fn = (String)defs.get(2 * i + 1);
                res = BuildGdx.cache.open(fn, 0);
                if (res == null) {
                    Console.Println("Warning: Failed including " + (String)fn + " as module", Console.OSDTEXT_RED);
                } else {
                    Scriptfile included = new Scriptfile(fn, res.getBytes());
                    included.path = (String)defs.get(2 * i);
                    this.defsparser(included);
                    res.close();
                }
                ++i;
            }
        }
        if (this.fileids.size() > 0) {
            if (this.disposable) {
                for (GroupResource res2 : BuildGdx.cache.getDynamicResources()) {
                    Integer fileid = null;
                    fileid = this.fileids.get(res2.getFullName());
                    if (fileid == null) continue;
                    res2.setIdentification(fileid);
                }
            } else {
                for (String file : this.fileids.keySet()) {
                    res = (GroupResource)BuildGdx.cache.open(file, -1);
                    if (res == null) continue;
                    ((GroupResource)res).setIdentification(this.fileids.get(file));
                }
            }
        }
        int i = 0;
        while (i < Engine.MAXTILES) {
            block17: {
                DefScript.DefTile tile;
                block18: {
                    long crc32;
                    if (this.tiles[i] == null) break block17;
                    tile = this.tiles[i];
                    if (tile.crc32 == 0L) break block18;
                    byte[] data = Engine.waloff[i];
                    if (data == null) {
                        data = this.engine.loadtile(i);
                    }
                    long l = crc32 = data != null ? CRC32.getChecksum(data) : -1L;
                    if (crc32 == tile.crc32) break block18;
                    boolean found = false;
                    while (tile.next != null) {
                        tile = tile.next;
                        if (tile.crc32 != 0L && crc32 != tile.crc32) continue;
                        found = true;
                        break;
                    }
                    if (!found) break block17;
                }
                if (tile.waloff != null) {
                    this.engine.invalidatetile(i, -1, -1);
                    Engine.waloff[i] = new byte[tile.waloff.length];
                    System.arraycopy(tile.waloff, 0, Engine.waloff[i], 0, tile.waloff.length);
                    Engine.tilesizx[i] = tile.sizx;
                    Engine.tilesizy[i] = tile.sizy;
                    int n = i;
                    Engine.picanm[n] = Engine.picanm[n] & 0x8F0000FF;
                    int n2 = i;
                    Engine.picanm[n2] = Engine.picanm[n2] | (tile.xoffset & 0xFF) << 8;
                    int n3 = i;
                    Engine.picanm[n3] = Engine.picanm[n3] | (tile.yoffset & 0xFF) << 16;
                    int n4 = i;
                    Engine.picanm[n4] = Engine.picanm[n4] | (tile.optional & 7) << 28;
                    Globals.gPicAnm[i] = new PICANM(Engine.picanm[i]);
                    this.engine.setpicsiz(i);
                    this.texInfo.addTexture(i, 0, tile.hrp, (float)(255 - (tile.alphacut & 0xFF)) * 0.003921569f, 1.0f, 1.0f, 1.0f, 1.0f, 0);
                }
            }
            ++i;
        }
    }

    public byte GetSurfType(int nHit) {
        int nHitType = nHit & 0xE000;
        int nHitIndex = nHit & 0x1FFF;
        switch (nHitType) {
            case 16384: {
                return this.surfType[Engine.sector[nHitIndex].floorpicnum];
            }
            case 24576: {
                return this.surfType[Engine.sector[nHitIndex].ceilingpicnum];
            }
            case 32768: {
                return this.surfType[Engine.wall[nHitIndex].picnum];
            }
            case 49152: {
                return this.surfType[Engine.sprite[nHitIndex].picnum];
            }
        }
        return 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposable) {
            this.usergroup = null;
        }
    }

    static /* synthetic */ Object access$5(BloodDef bloodDef, Scriptfile scriptfile, Map map) {
        return bloodDef.gettoken(scriptfile, map);
    }

    static /* synthetic */ int access$6(BloodDef bloodDef, Scriptfile scriptfile, int n) {
        return bloodDef.getPtr(scriptfile, n);
    }

    private class BloodTileFromTextureToken
    extends DefScript.TileFromTextureToken {
        protected final Map<String, TileTextureTokens> tilefromtexturetokens = new HashMap<String, TileTextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("file", TileTextureTokens.FILE);
                this.put("name", TileTextureTokens.FILE);
                this.put("alphacut", TileTextureTokens.ALPHACUT);
                this.put("xoffset", TileTextureTokens.XOFFSET);
                this.put("xoff", TileTextureTokens.XOFFSET);
                this.put("yoffset", TileTextureTokens.YOFFSET);
                this.put("yoff", TileTextureTokens.YOFFSET);
                this.put("texture", TileTextureTokens.TEXTURE);
                this.put("ifcrc", TileTextureTokens.CRC);
                this.put("extra", TileTextureTokens.EXTRA);
                this.put("surface", TileTextureTokens.SURF);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens;

        private BloodTileFromTextureToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            ttexturetokptr = script.ltextptr;
            fn = null;
            tile = -1;
            talphacut = 255;
            xoffset = null;
            yoffset = null;
            tilecrc = 0L;
            istexture = false;
            extra = null;
            surf = null;
            tile = script.getsymbol();
            if (tile == null) {
                return DefScript.BaseToken.Error;
            }
            ttextureend = script.getbraces();
            if (ttextureend != -1) ** GOTO lbl67
            return DefScript.BaseToken.Error;
lbl-1000:
            // 1 sources

            {
                tk = BloodDef.access$5(BloodDef.this, script, this.tilefromtexturetokens);
                if (tk instanceof DefScript.BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(BloodDef.access$6(BloodDef.this, script, line), BloodDef.access$6(BloodDef.this, script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch (BloodTileFromTextureToken.$SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens()[((TileTextureTokens)tk).ordinal()]) {
                    case 7: {
                        extra = script.getsymbol();
                        break;
                    }
                    case 1: {
                        fn = BloodDef.access$0(BloodDef.this, script);
                        break;
                    }
                    case 2: {
                        value = script.getsymbol();
                        if (value != null) {
                            talphacut = value;
                        }
                        talphacut = Gameutils.BClipRange(talphacut, 0, 255);
                        break;
                    }
                    case 3: {
                        xoffs = script.getstring();
                        if (xoffs.toUpperCase().equals("ART")) {
                            xoffset = (byte)((Engine.picanm[tile] & 65280) >> 8);
                            break;
                        }
                        try {
                            xoffset = Byte.parseByte(xoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Xoffset value out of range. Value: \"" + xoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block14;
                    }
                    case 4: {
                        yoffs = script.getstring();
                        if (yoffs.toUpperCase().equals("ART")) {
                            yoffset = (byte)((Engine.picanm[tile] & 0xFF0000) >> 16);
                            break;
                        }
                        try {
                            yoffset = Byte.parseByte(yoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Yoffset value out of range. Value: \"" + yoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block14;
                    }
                    case 5: {
                        istexture = true;
                        break;
                    }
                    case 8: {
                        value = script.getsymbol();
                        if (value == null) break;
                        surf = Gameutils.BClipRange(value, 0, 255);
                        break;
                    }
                    case 6: {
                        tilecrc = (long)script.getsymbol().intValue() & 0xFFFFFFFFL;
                    }
                }
lbl67:
                // 16 sources

                ** while (script.textptr < ttextureend)
            }
lbl68:
            // 1 sources

            dt = this.addTile(script, fn, tile, xoffset, yoffset, tilecrc, talphacut, istexture, ttexturetokptr);
            if (dt != null) {
                if (extra != null) {
                    dt.optional = extra;
                }
                if (surf != null) {
                    s = (byte)surf.intValue();
                    if (s >= Tile.kSurfMax) {
                        Console.Println("Warning! surfaceType out of range: " + s + " resetting...", Console.OSDTEXT_RED);
                        s = 0;
                    }
                    BloodDef.this.surfType[tile.intValue()] = s;
                }
                return DefScript.BaseToken.Ok;
            }
            return DefScript.BaseToken.Error;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens;
            }
            int[] nArray = new int[TileTextureTokens.values().length];
            try {
                nArray[TileTextureTokens.ALPHACUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.CRC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.EXTRA.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.SURF.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.TEXTURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.XOFFSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.YOFFSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Blood$Types$BloodDef$TileTextureTokens = nArray;
            return nArray;
        }
    }

    public class DefineIdToken
    implements DefScript.Token {
        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            Integer fileId;
            String name = null;
            name = BloodDef.this.getFile(script);
            if (name == null) {
                return DefScript.BaseToken.Error;
            }
            if (!BuildGdx.cache.contains(name, -1)) {
                byte[] data = BuildGdx.cache.getBytes(name, 0);
                if (data == null) {
                    Console.Println("DefineId error: file " + name + " not found!", Console.OSDTEXT_RED);
                    return DefScript.BaseToken.Error;
                }
                if (BloodDef.this.usergroup == null) {
                    BloodDef.this.usergroup = BuildGdx.cache.add("UserDef", BloodDef.this.disposable);
                }
                BloodDef.this.usergroup.add(name, data, -1);
            }
            if ((fileId = script.getsymbol()) == null) {
                return DefScript.BaseToken.Error;
            }
            BloodDef.this.fileids.put(name, fileId);
            return DefScript.BaseToken.Ok;
        }
    }

    public class NBloodDefineIdToken
    implements DefScript.Token {
        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            Integer fileId;
            String name = null;
            String ext = null;
            name = BloodDef.this.getFile(script);
            if (name == null) {
                return DefScript.BaseToken.Error;
            }
            ext = script.getstring();
            if (ext == null) {
                return DefScript.BaseToken.Error;
            }
            String filename = String.valueOf(name) + "." + ext;
            if (!BuildGdx.cache.contains(filename, -1)) {
                byte[] data = BuildGdx.cache.getBytes(filename, 0);
                if (data == null) {
                    Console.Println("DefineId error: file " + filename + " not found!", Console.OSDTEXT_RED);
                    return DefScript.BaseToken.Error;
                }
                if (BloodDef.this.usergroup == null) {
                    BloodDef.this.usergroup = BuildGdx.cache.add("UserDef", BloodDef.this.disposable);
                }
                BloodDef.this.usergroup.add(filename, data, -1);
            }
            if ((fileId = script.getsymbol()) == null) {
                return DefScript.BaseToken.Error;
            }
            script.getstring();
            BloodDef.this.fileids.put(filename, fileId);
            return DefScript.BaseToken.Ok;
        }
    }

    public static enum TileTextureTokens {
        FILE,
        ALPHACUT,
        XOFFSET,
        YOFFSET,
        TEXTURE,
        CRC,
        EXTRA,
        SURF;

    }
}

