/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Hud;

import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;

public abstract class HudRenderer {
    protected static final char[] number_buffer = new char[256];
    public static final int[] viewInventoryTile = new int[]{2569, 2564, 2566, 2568, 2560, 2563, 2567};
    public final int kBigRed = 2190;
    public final int kBigBlue = 2240;
    public final int kLittleWhite = 2230;
    public final int kLittleRed = 2250;
    public final int kDrawNormal = 0;
    public final int kDrawTranslucent = 1;
    public final int kDrawScale = 2;
    public final int kDrawYFlip = 4;
    public final int kDrawUnclipped = 8;
    public final int kDrawStatus = 10;
    public final int kDrawCorner = 16;
    public final int kDrawTranslucentR = 32;
    public final int kDrawNonMasked = 64;
    public final int kDrawMultiPage = 128;
    public final int kDrawXFlip = 2048;
    private final int[] avaibleInventory = new int[6];

    public abstract void draw(PLAYER var1, int var2, int var3);

    protected int getPalette(PLAYER gView) {
        int pal = 0;
        if (Globals.pGameInfo.nGameType == 3) {
            pal = (gView.teamID & 1) != 0 ? 7 : 10;
        }
        return pal;
    }

    public void DrawStatNumber(int slen, int n, int nTile, int x, int y, int nShade, int nPLU, int nFlags) {
        Strhandler.Bsprintf(number_buffer, slen, n, 1);
        int i = 0;
        while (i < slen) {
            if (number_buffer[i] != ' ') {
                this.DrawStatMaskedSprite(nTile + number_buffer[i] - 48, x, y, nShade, nPLU, nFlags);
            }
            x += Engine.tilesizx[nTile] + 1;
            ++i;
        }
    }

    public void DrawStatNumber(int slen, int n, int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Strhandler.Bsprintf(number_buffer, slen, n, 1);
        int i = 0;
        while (i < slen) {
            if (number_buffer[i] != ' ') {
                this.DrawStatSprite(nTile + number_buffer[i] - 48, x, y, nShade, nPLU, nFlags, nScale);
            }
            x += Pragmas.mulscale(Engine.tilesizx[nTile] + 1, nScale, 16);
            ++i;
        }
    }

    public void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlag, int nScale) {
        Main.engine.rotatesprite(x << 16, y << 16, nScale, 0, nTile, nShade, nPLU, nFlag | 0xA, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags) {
        int nAngle = 0;
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        Main.engine.rotatesprite(x << 16, y << 16, 65536, nAngle, (short)nTile, nShade, nPLU, nFlags | 0xA, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    public void showInventoryItems(PLAYER pPlayer, int sx, int sy, int fx, int fy, int nFlags) {
        if (pPlayer.choosedInven >= 0) {
            this.DrawStatMaskedSprite(viewInventoryTile[pPlayer.choosedInven], sx, sy, 0, 0, nFlags);
            this.DrawStatNumber(3, pPlayer.Inventory[pPlayer.choosedInven].amount, 2250, fx, fy, 4, 0, nFlags);
        }
    }

    public void viewShowInventory(PLAYER gView, int x, int y, int nFlags) {
        int i = 0;
        while (i < 6) {
            this.avaibleInventory[i] = 0;
            ++i;
        }
        int shade = 24;
        if (gView.showInventory != 0) {
            int wx = 0;
            int invcount = 0;
            int i2 = 0;
            while (i2 < 6) {
                if (gView.Inventory[i2].amount != 0) {
                    this.avaibleInventory[invcount++] = i2;
                    wx += Engine.tilesizx[viewInventoryTile[i2]] + 1;
                }
                ++i2;
            }
            x -= wx / 2;
            i2 = 0;
            while (i2 < invcount) {
                int xoffset = 1;
                int yoffset = 8;
                this.DrawStatMaskedSprite(2568, x + xoffset, y - yoffset, 0, 0, nFlags);
                yoffset = 6;
                this.DrawStatMaskedSprite(2568, x + xoffset, y - yoffset, 0, 0, nFlags);
                yoffset = 1;
                this.DrawStatMaskedSprite(viewInventoryTile[this.avaibleInventory[i2]], x + xoffset, y + yoffset, 0, 0, nFlags);
                if (this.avaibleInventory[i2] == gView.choosedInven) {
                    this.DrawStatMaskedSprite(2559, x + xoffset, y + yoffset, 0, 0, nFlags);
                }
                if (gView.Inventory[this.avaibleInventory[i2]].activated) {
                    shade = 4;
                }
                yoffset = 13;
                xoffset = 4;
                this.DrawStatNumber(3, gView.Inventory[this.avaibleInventory[i2]].amount, 2250, x - xoffset, y - yoffset, shade, 0, nFlags);
                xoffset = Engine.tilesizx[viewInventoryTile[this.avaibleInventory[i2]]] + 1;
                x += xoffset;
                ++i2;
            }
        }
    }

    public void TileHGauge(int nTile, int x, int y, int n, int total, int nFlags) {
        int nGauge = n * Engine.tilesizx[nTile] / total;
        Gameutils.ConvertType type = Gameutils.ConvertType.Normal;
        if ((nFlags & 0x100) != 0) {
            type = Gameutils.ConvertType.AlignLeft;
        }
        if ((nFlags & 0x200) != 0) {
            type = Gameutils.ConvertType.AlignRight;
        }
        if ((nFlags & 0x400) != 0) {
            type = Gameutils.ConvertType.Stretch;
        }
        Main.engine.rotatesprite(x << 16, y << 16, 65536, 0, nTile, 0, 0, 0x1A | nFlags, 0, 0, Gameutils.coordsConvertXScaled(x + nGauge, type), Engine.ydim - 1);
    }

    protected void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Globals.pGameInfo.nGameType >= 2 || Main.cfg.gShowStat == 2 && View.gViewMode != 4) {
            return;
        }
        zoom = Pragmas.scale(Engine.ydim, zoom, 240L);
        float viewzoom = (float)zoom / 65536.0f;
        Strhandler.Bitoa(LEVELS.kills, number_buffer);
        int alignx = Main.game.getFont(3).getWidth(number_buffer);
        int yoffset = (int)((float)(2 * (Main.game.getFont(3).getHeight() - 1)) * viewzoom);
        int statx = x;
        int staty = y -= yoffset;
        Main.game.getFont(3).drawText(statx, staty, Strings.killsstat2, zoom, 32, 7, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        Main.game.getFont(3).drawChar(statx, staty, '/', zoom, 32, 0, 256, false);
        Strhandler.Bitoa(LEVELS.totalKills, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = x;
        staty = y + (int)(8.0f * viewzoom);
        Strhandler.Bitoa(LEVELS.foundSecret, number_buffer);
        alignx = Main.game.getFont(3).getWidth(number_buffer);
        Main.game.getFont(3).drawText(statx, staty, Strings.secretsstat, zoom, 32, 7, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
        statx = (int)((float)statx + (float)(alignx + 2) * viewzoom);
        Main.game.getFont(3).drawChar(statx, staty, '/', zoom, 32, 0, 256, false);
        Strhandler.Bitoa(LEVELS.totalSecrets, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawText(statx, staty, number_buffer, zoom, 32, 0, BuildFont.TextAlign.Left, 256, false);
    }

    protected void viewDrawStats(int yoffs) {
        if (View.gViewMode != 4) {
            this.viewDrawStats(5, 160 + yoffs, Main.cfg.gStatSize);
        } else {
            this.viewDrawStats(Pragmas.mulscale(5L, Main.cfg.gStatSize, 16), Pragmas.mulscale(20L, Main.cfg.gStatSize, 16), Main.cfg.gStatSize);
        }
    }
}

