/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Hud;

import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Types.Hud.HudRenderer;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;

public abstract class HudScaledRenderer
extends HudRenderer {
    protected int nScale = 65536;

    public void setScale(int nScale) {
        this.nScale = Pragmas.scale(Engine.ydim, nScale, 240L);
    }

    @Override
    public abstract void draw(PLAYER var1, int var2, int var3);

    protected float convertX(int x, int scale, Gameutils.ConvertType type) {
        if (type == Gameutils.ConvertType.AlignLeft) {
            return (float)(x * scale) / 65536.0f;
        }
        if (type == Gameutils.ConvertType.AlignRight) {
            return (float)Engine.xdim - (float)((320 - x) * scale) / 65536.0f;
        }
        if (type == Gameutils.ConvertType.Normal) {
            return (float)(Engine.xdim / 2) - (float)((160 - x) * scale) / 65536.0f;
        }
        return x;
    }

    protected float convertY(int y, int nScale) {
        return (float)Engine.ydim - (float)((200 - y) * nScale) / 65536.0f;
    }

    protected Gameutils.ConvertType getType(int nFlags) {
        Gameutils.ConvertType type = Gameutils.ConvertType.Normal;
        if ((nFlags & 0x100) != 0) {
            type = Gameutils.ConvertType.AlignLeft;
        }
        if ((nFlags & 0x200) != 0) {
            type = Gameutils.ConvertType.AlignRight;
        }
        if ((nFlags & 0x400) != 0) {
            type = Gameutils.ConvertType.Stretch;
        }
        return type;
    }

    @Override
    public void showInventoryItems(PLAYER pPlayer, int sx, int sy, int fx, int fy, int nFlags) {
        if (pPlayer.choosedInven >= 0) {
            this.DrawStatSprite(viewInventoryTile[pPlayer.choosedInven], sx, sy, 0, 0, nFlags, this.nScale);
            this.DrawStatNumber(3, pPlayer.Inventory[pPlayer.choosedInven].amount, 2250, fx, fy, 4, 0, nFlags, this.nScale);
        }
    }

    @Override
    public void DrawStatNumber(int slen, int n, int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Strhandler.Bsprintf(number_buffer, slen, n, 1);
        Gameutils.ConvertType type = this.getType(nFlags);
        y = (int)(this.convertY(y, nScale) * 65536.0f);
        int i = 0;
        while (i < slen) {
            if (number_buffer[i] != ' ') {
                Main.engine.rotatesprite((int)(this.convertX(x, nScale, type) * 65536.0f), y, nScale, 0, nTile + number_buffer[i] - 48, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            x += Engine.tilesizx[nTile] + 1;
            ++i;
        }
    }

    @Override
    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags) {
        int nAngle = 0;
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        Main.engine.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, nAngle, (short)nTile, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Main.engine.rotatesprite((int)(this.convertX(x, nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, nScale) * 65536.0f), nScale, 0, nTile, nShade, nPLU, nFlags | 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void TileHGauge(int nTile, int x, int y, int n, int total, int nFlags) {
        int nGauge = n * Engine.tilesizx[nTile] / total;
        Main.engine.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, 0, nTile, 0, 0, 0x18 | nFlags, 0, 0, (int)this.convertX(x + nGauge + 1, this.nScale, this.getType(nFlags)), Engine.ydim - 1);
    }

    @Override
    protected void viewDrawStats(int yoffs) {
        if (View.gViewMode != 4) {
            this.viewDrawStats((int)this.convertX(5, this.nScale, Gameutils.ConvertType.AlignLeft), (int)this.convertY(160 + yoffs, this.nScale), Main.cfg.gStatSize);
        } else {
            this.viewDrawStats(Pragmas.mulscale(5L, Main.cfg.gStatSize, 16), Pragmas.mulscale(20L, Main.cfg.gStatSize, 16), Main.cfg.gStatSize);
        }
    }
}

