/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import com.badlogic.gdx.files.FileHandle;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Script.DefScript;

public class Gameutils {
    public static void fill(byte[] array, int value) {
        int len = array.length;
        if (len > 0) {
            array[0] = (byte)value;
        }
        int i = 1;
        while (i < len) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
            i += i;
        }
    }

    public static void fill(byte[] array, int start, int end, int value) {
        if (array.length > 0) {
            array[start] = (byte)value;
        }
        int len = end - start;
        int i = 1;
        while (i < len) {
            System.arraycopy(array, start, array, start + i, len - i < i ? len - i : i);
            i += i;
        }
    }

    public static float BClampAngle(float angle) {
        return angle < 0.0f ? angle % 2048.0f + 2048.0f : angle % 2048.0f;
    }

    public static float BClipRange(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int BClipRange(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static short BClipLow(short value, short min) {
        return value < min ? min : value;
    }

    public static short BClipHigh(short value, short max) {
        return value > max ? max : value;
    }

    public static int BClipLow(int value, int min) {
        return value < min ? min : value;
    }

    public static int BClipHigh(int value, int max) {
        return value > max ? max : value;
    }

    public static float BClipLow(float value, int min) {
        return value < (float)min ? (float)min : value;
    }

    public static float BClipHigh(float value, int max) {
        return value > (float)max ? (float)max : value;
    }

    public static double BSinAngle(double daang) {
        double rad_ang = daang * Math.PI * 9.765625E-4;
        return Math.sin(rad_ang) * 16384.0;
    }

    public static double BCosAngle(double daang) {
        double rad_ang = daang * Math.PI * 9.765625E-4;
        return Math.cos(rad_ang) * 16384.0;
    }

    public static boolean isValidSector(int i) {
        return i >= 0 && i < Engine.MAXSECTORS && Engine.sector[i] != null;
    }

    public static boolean isValidStat(int i) {
        return i >= 0 && i <= 1024;
    }

    public static boolean isValidSprite(int i) {
        return i >= 0 && i < Engine.MAXSPRITES && Engine.sprite[i] != null;
    }

    public static boolean isValidWall(int i) {
        return i >= 0 && i < Engine.MAXWALLS && Engine.wall[i] != null;
    }

    public static boolean isCorruptWall(int i) {
        return !Gameutils.isValidWall(i) || !Gameutils.isValidWall(Engine.wall[i].point2);
    }

    public static boolean isValidTile(int tile) {
        return tile >= 0 && tile < Engine.MAXTILES;
    }

    public static int coordsConvertXScaled(int coord, ConvertType type) {
        int oxdim = Engine.xdim;
        int xdim = 4 * Engine.ydim / 3;
        if (4 * oxdim / 5 == Engine.ydim) {
            xdim = 5 * Engine.ydim / 4;
        }
        int offset = oxdim - xdim;
        int buildim = 320;
        if (type == ConvertType.Stretch) {
            buildim = buildim * xdim / oxdim;
        }
        int normxofs = coord - (buildim << 15);
        int wx = (xdim << 15) + Pragmas.scale(normxofs, xdim, buildim);
        if (type == ConvertType.Stretch) {
            return wx;
        }
        wx += (oxdim - xdim) / 2;
        if (type == ConvertType.AlignLeft) {
            return wx - offset / 2 - 1;
        }
        if (type == ConvertType.AlignRight) {
            return wx + offset / 2 - 1;
        }
        return wx - 1;
    }

    public static int coordsConvertYScaled(int coord) {
        int oydim = Engine.ydim;
        int ydim = 3 * Engine.xdim / 4;
        int buildim = 200 * ydim / oydim;
        int normxofs = coord - (buildim << 15);
        int wy = (ydim << 15) + Pragmas.scale(normxofs, ydim, buildim);
        return wy;
    }

    public static void loadGdxDef(DefScript baseDef, String appdef, String resname) {
        DataResource res;
        Group group;
        GroupResource def;
        byte[] data = null;
        String filename = "";
        try {
            FileHandle fil = BuildGdx.files.internal(resname);
            if (fil != null && fil.exists()) {
                filename = fil.name();
                data = fil.readBytes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (data != null && (def = (group = BuildGdx.cache.add((Resource)(res = new DataResource(null, filename, -1, data)), filename)).open(appdef)) != null) {
            baseDef.loadScript(filename, def.getBytes());
            def.close();
        }
    }

    public static enum ConvertType {
        Normal,
        AlignLeft,
        AlignRight,
        Stretch;

    }
}

