/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader;

import com.badlogic.gdx.graphics.Pixmap;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Loader.MDAnimation;
import ru.m210projects.Build.Loader.MDSkinmap;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.TextureHandle.TextureUtils;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.ModelInfo;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Types.SPRITE;

public abstract class MDModel
extends Model {
    public MDSkinmap skinmap;
    public int numskins;
    public int skinloaded;
    public int numframes;
    public int cframe;
    public int nframe;
    public int fpssc;
    public boolean usesalpha;
    public float oldtime;
    public float curtime;
    public float interpol;
    public MDAnimation animations;

    public abstract int getFrameIndex(String var1);

    public void updateanimation(DefScript defs, SPRITE tspr) {
        if (this.numframes < 2) {
            this.interpol = 0.0f;
            return;
        }
        short tile = tspr.picnum;
        this.cframe = this.nframe = defs.mdInfo.getParams((int)tspr.picnum).framenum;
        boolean smoothdurationp = GLSettings.animSmoothing.get() != false && defs.mdInfo.getParams((int)tile).smoothduration != 0.0f;
        ModelInfo.Spritesmooth smooth = tspr.owner < Engine.MAXSPRITES + 256 ? defs.mdInfo.getSmoothParams(tspr.owner) : null;
        Spriteext sprext = tspr.owner < Engine.MAXSPRITES + 256 ? Engine.spriteext[tspr.owner] : null;
        MDAnimation anim = this.animations;
        while (anim != null && anim.startframe != this.cframe) {
            anim = anim.next;
        }
        if (anim == null) {
            if (!smoothdurationp || smooth.mdoldframe == this.cframe && smooth.mdcurframe == this.cframe) {
                this.interpol = 0.0f;
                return;
            }
            if (smooth.mdoldframe != this.cframe) {
                if (smooth.mdsmooth == 0) {
                    sprext.mdanimtims = MDAnimation.mdtims;
                    this.interpol = 0.0f;
                    smooth.mdsmooth = 1;
                    smooth.mdcurframe = (short)this.cframe;
                }
                if (smooth.mdcurframe != this.cframe) {
                    sprext.mdanimtims = MDAnimation.mdtims;
                    this.interpol = 0.0f;
                    smooth.mdsmooth = 1;
                    smooth.mdoldframe = smooth.mdcurframe;
                    smooth.mdcurframe = (short)this.cframe;
                }
            } else {
                sprext.mdanimtims = MDAnimation.mdtims;
                this.interpol = 0.0f;
                smooth.mdsmooth = 1;
                smooth.mdoldframe = smooth.mdcurframe;
                smooth.mdcurframe = (short)this.cframe;
            }
        } else if (sprext.mdanimcur != anim.startframe) {
            sprext.mdanimcur = (short)anim.startframe;
            sprext.mdanimtims = MDAnimation.mdtims;
            this.interpol = 0.0f;
            if (!smoothdurationp) {
                this.cframe = this.nframe = anim.startframe;
                return;
            }
            this.nframe = anim.startframe;
            this.cframe = smooth.mdoldframe;
            smooth.mdsmooth = 1;
            return;
        }
        int fps = smooth.mdsmooth != 0 ? Math.round(1.0f / defs.mdInfo.getParams((int)tile).smoothduration * 66.0f) : anim.fpssc;
        int i = (int)((MDAnimation.mdtims - sprext.mdanimtims) * (long)(fps * Engine.timerticspersec / 120));
        int j = 65536;
        if (smooth.mdsmooth == 0) {
            j = anim.endframe + 1 - anim.startframe << 16;
        }
        if (i < 0) {
            i = 0;
            sprext.mdanimtims = MDAnimation.mdtims;
        }
        if (anim != null && i >= j + j && fps != 0 && MDAnimation.mdpause == 0) {
            sprext.mdanimtims += (long)(j / (fps * Engine.timerticspersec / 120));
        }
        int k = i;
        if (anim != null && (anim.flags & 1) != 0) {
            if (i > j - 65536) {
                i = j - 65536;
            }
        } else if (i >= j && (i -= j) >= j) {
            i %= j;
        }
        if (GLSettings.animSmoothing.get().booleanValue() && smooth.mdsmooth != 0) {
            this.nframe = anim != null ? anim.startframe : (int)smooth.mdcurframe;
            this.cframe = smooth.mdoldframe;
            if (k > 65535) {
                sprext.mdanimtims = MDAnimation.mdtims;
                this.interpol = 0.0f;
                smooth.mdsmooth = 0;
                this.cframe = this.nframe;
                smooth.mdoldframe = (short)this.cframe;
                return;
            }
        } else {
            this.cframe = (i >> 16) + anim.startframe;
            this.nframe = this.cframe + 1;
            if (this.nframe > anim.endframe) {
                this.nframe = anim.startframe;
            }
            smooth.mdoldframe = (short)this.cframe;
        }
        this.interpol = Gameutils.BClipRange((float)(i & 0xFFFF) / 65536.0f, 0.0f, 1.0f);
        if (this.cframe < 0 || this.cframe >= this.numframes || this.nframe < 0 || this.nframe >= this.numframes) {
            if (this.cframe < 0) {
                this.cframe = 0;
            }
            if (this.cframe >= this.numframes) {
                this.cframe = this.numframes - 1;
            }
            if (this.nframe < 0) {
                this.nframe = 0;
            }
            if (this.nframe >= this.numframes) {
                this.nframe = this.numframes - 1;
            }
        }
    }

    public MDSkinmap getSkin(int palnum, int skinnum, int surfnum) {
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            if (sk.palette == palnum && skinnum == sk.skinnum && surfnum == sk.surfnum) {
                return sk;
            }
            sk = sk.next;
        }
        return null;
    }

    private void addSkin(MDSkinmap sk) {
        sk.next = this.skinmap;
        this.skinmap = sk;
    }

    public int setSkin(String skinfn, int palnum, int skinnum, int surfnum, double param, double specpower, double specfactor) {
        MDSkinmap sk;
        if (skinfn == null) {
            return -2;
        }
        if (palnum >= 256) {
            return -3;
        }
        if (this.mdnum == 2) {
            surfnum = 0;
        }
        if ((sk = this.getSkin(palnum, skinnum, surfnum)) == null) {
            sk = new MDSkinmap();
            this.addSkin(sk);
        }
        sk.palette = palnum;
        sk.skinnum = skinnum;
        sk.surfnum = surfnum;
        sk.param = (float)param;
        sk.specpower = (float)specpower;
        sk.specfactor = (float)specfactor;
        sk.fn = skinfn;
        return 0;
    }

    public int setAnimation(String framestart, String frameend, int fpssc, int flags) {
        MDAnimation ma = new MDAnimation();
        int i = 0;
        i = this.getFrameIndex(framestart);
        if (i == this.numframes) {
            return -2;
        }
        ma.startframe = i;
        i = this.getFrameIndex(frameend);
        if (i == this.numframes) {
            return -3;
        }
        ma.endframe = i;
        ma.fpssc = fpssc;
        ma.flags = flags;
        ma.next = this.animations;
        this.animations = ma;
        return 0;
    }

    public BTexture loadskin(DefScript defs, int number, int pal, int surf) {
        int i;
        String skinfile = null;
        BTexture texidx = null;
        BTexture[] texptr = null;
        int idptr = -1;
        MDSkinmap skzero = null;
        if (this.mdnum == 2) {
            surf = 0;
        }
        if (pal >= 256 || defs == null) {
            return null;
        }
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            i = -1;
            if (sk.palette == pal && sk.skinnum == number && sk.surfnum == surf) {
                skinfile = sk.fn;
                idptr = defs.texInfo.getPaletteEffect(pal);
                texptr = sk.texid;
                if (texptr == null) break;
                texidx = texptr[idptr];
                break;
            }
            if (sk.palette == 0 && sk.skinnum == number && sk.surfnum == surf && i < 5) {
                i = 5;
                skzero = sk;
            } else if (sk.palette == pal && sk.skinnum == 0 && sk.surfnum == surf && i < 4) {
                i = 4;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == 0 && sk.surfnum == surf && i < 3) {
                i = 3;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == number && i < 2) {
                i = 2;
                skzero = sk;
            } else if (sk.palette == pal && sk.skinnum == 0 && i < 1) {
                i = 1;
                skzero = sk;
            } else if (sk.palette == 0 && sk.skinnum == 0 && i < 0) {
                i = 0;
                skzero = sk;
            }
            sk = sk.next;
        }
        if (sk == null) {
            if (pal >= 252) {
                return null;
            }
            if (skzero != null) {
                skinfile = skzero.fn;
                idptr = defs.texInfo.getPaletteEffect(pal);
                texptr = skzero.texid;
                if (texptr != null) {
                    texidx = texptr[idptr];
                }
            } else {
                Console.Println("Couldn't load skin", Console.OSDTEXT_YELLOW);
                defs.mdInfo.removeModelInfo(this);
                return null;
            }
        }
        if (skinfile == null) {
            return null;
        }
        if (texidx != null) {
            return texidx;
        }
        if (pal >= 252) {
            i = Engine.MAXTILES - 1;
            while (i >= 0) {
                Model m = defs.mdInfo.getModel(i);
                if (m != null && m.mdnum >= 2) {
                    MDModel mi = (MDModel)m;
                    skzero = mi.skinmap;
                    while (skzero != null) {
                        if (skzero.fn.equalsIgnoreCase(sk.fn) && skzero.texid[defs.texInfo.getPaletteEffect(pal)] != null) {
                            int f = defs.texInfo.getPaletteEffect(pal);
                            sk.texid[f] = skzero.texid[f];
                            return sk.texid[f];
                        }
                        skzero = skzero.next;
                    }
                }
                --i;
            }
        }
        texidx = null;
        Resource res = BuildGdx.cache.open(skinfile, 0);
        if (res == null) {
            Console.Println("Skin " + skinfile + " not found.", Console.OSDTEXT_YELLOW);
            defs.mdInfo.removeModelInfo(this);
            skinfile = null;
            return null;
        }
        long startticks = System.currentTimeMillis();
        try {
            try {
                byte[] data = res.getBytes();
                Pixmap pix = new Pixmap(data, 0, data.length);
                texidx = new BTexture(pix, true);
                this.usesalpha = true;
            }
            catch (Exception e) {
                Console.Println("Couldn't load file: " + skinfile, Console.OSDTEXT_YELLOW);
                defs.mdInfo.removeModelInfo(this);
                skinfile = null;
                res.close();
                return null;
            }
        }
        finally {
            res.close();
        }
        TextureUtils.setupBoundTexture(GLSettings.textureFilter.get(), GLSettings.textureAnisotropy.get());
        TextureUtils.setupBoundTextureWrap(10497);
        long etime = System.currentTimeMillis() - startticks;
        System.out.println("Load skin: p" + pal + "-e" + defs.texInfo.getPaletteEffect(pal) + " \"" + skinfile + "\"... " + etime + " ms");
        texptr[idptr] = texidx;
        return texidx;
    }

    @Override
    public void setSkinParams(GLFilter filter, int anisotropy) {
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            BTexture[] bTextureArray = sk.texid;
            int n = sk.texid.length;
            int n2 = 0;
            while (n2 < n) {
                BTexture tex = bTextureArray[n2];
                if (tex != null) {
                    TextureUtils.bindTexture(tex);
                    TextureUtils.setupBoundTexture(filter, anisotropy);
                }
                ++n2;
            }
            sk = sk.next;
        }
    }

    @Override
    public void clearSkins() {
        MDSkinmap sk = this.skinmap;
        while (sk != null) {
            int j = 0;
            while (j < sk.texid.length) {
                BTexture tex = sk.texid[j];
                if (tex != null) {
                    tex.dispose();
                    sk.texid[j] = null;
                }
                ++j;
            }
            sk = sk.next;
        }
    }
}

