/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.Voxels;

import java.nio.FloatBuffer;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Loader.Model;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.TextureHandle.ImageUtils;
import ru.m210projects.Build.Render.TextureHandle.TextureUtils;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Settings.GLSettings;

public class VOXModel
extends Model {
    public BTexture[] texid;
    public voxrect_t[] quad;
    public int qcnt;
    public int[] qfacind = new int[7];
    public int mytexx;
    public int mytexy;
    public byte[] mytex;
    public int xsiz;
    public int ysiz;
    public int zsiz;
    public float xpiv;
    public float ypiv;
    public float zpiv;
    public int is8bit;
    public FloatBuffer uv;

    public void initQuads() {
        int vx = 0;
        while (vx < this.qcnt) {
            this.quad[vx] = new voxrect_t();
            ++vx;
        }
    }

    public BTexture loadskin(int dapal, boolean bit8texture) {
        if (Engine.palookup[dapal] == null || bit8texture) {
            dapal = 0;
        }
        if (this.texid[dapal] != null) {
            return this.texid[dapal];
        }
        TextureBuffer buffer = ImageUtils.getTmpBuffer();
        int y = 0;
        while (y < this.mytexy) {
            int wpptr = y * this.mytexx;
            int x = 0;
            while (x < this.mytexx) {
                int wp = wpptr << 2;
                if (bit8texture) {
                    buffer.put(wp, this.mytex[wpptr]);
                } else {
                    int dacol = this.mytex[wpptr] & 0xFF;
                    if (Engine.UseBloodPal && dapal == 1) {
                        int shade = Math.min(Math.max(Engine.globalshade, 0), Engine.numshades - 1);
                        dacol = Engine.palookup[dapal][dacol + (shade << 8)] & 0xFF;
                    } else {
                        dacol = Engine.palookup[dapal][dacol] & 0xFF;
                    }
                    buffer.putInt(wp, Engine.curpalette.getRGB(dacol) + -16777216);
                }
                ++x;
                ++wpptr;
            }
            ++y;
        }
        BTexture rtexid = new BTexture(this.mytexx, this.mytexy);
        TextureUtils.bindTexture(rtexid);
        TextureUtils.uploadBoundTexture(true, this.mytexx, this.mytexy, 6408, 6408, buffer.getBuffer());
        TextureUtils.setupBoundTexture(GLSettings.glfiltermodes[0], 0);
        this.texid[dapal] = rtexid;
        return rtexid;
    }

    @Override
    public void setSkinParams(GLFilter filter, int anisotropy) {
    }

    @Override
    public void clearSkins() {
        int i = 0;
        while (i < this.texid.length) {
            BTexture tex = this.texid[i];
            if (tex != null) {
                tex.dispose();
                this.texid[i] = null;
            }
            ++i;
        }
    }

    public class vert_t {
        public int x;
        public int y;
        public int z;
        public int u;
        public int v;
    }

    public class voxrect_t {
        public vert_t[] v = new vert_t[4];

        public voxrect_t() {
            int i = 0;
            while (i < 4) {
                this.v[i] = new vert_t();
                ++i;
            }
        }
    }
}

