/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuMouse
extends BuildMenu {
    public BuildMenu advancedMenu;
    public MenuSwitch mEnable;
    public MenuSwitch mMenuEnab;
    public MenuSlider mSens;
    public MenuSlider mTurn;
    public MenuSlider mLook;
    public MenuSlider mMove;
    public MenuSlider mStrafe;
    public MenuSwitch mAiming;
    public MenuSwitch mInvert;
    public MenuButton mAdvance;
    public MenuConteiner mAxisUp;
    public MenuConteiner mAxisDown;
    public MenuConteiner mAxisLeft;
    public MenuConteiner mAxisRight;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public MenuMouse(BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, BuildFont style, int buttonPal) {
        this.addItem(this.getTitle(app, "Mouse setup"), false);
        final BuildConfig cfg = app.pCfg;
        this.advancedMenu = this.buildAdvancedAxisMenu(app, posx, posy, width, menuHeight, style);
        this.mEnable = new MenuSwitch("Mouse in game", style, posx, posy += menuHeight, width, cfg.useMouse, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.useMouse = sw.value;
            }
        }, "Yes", "No");
        this.mEnable.pal = buttonPal;
        this.mMenuEnab = new MenuSwitch("Mouse in menu", style, posx, posy += menuHeight, width, cfg.menuMouse, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.menuMouse = sw.value;
            }
        }, "Yes", "No");
        this.mMenuEnab.pal = buttonPal;
        posy += separatorHeight;
        this.mSens = new MenuSlider(app.pSlider, "Mouse Sensitivity", style, posx, posy += menuHeight, width, cfg.gSensitivity, 4096, 163840, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gSensitivity = slider.value;
            }
        }, true);
        this.mSens.digitalMax = 65536.0f;
        this.mSens.pal = buttonPal;
        this.mTurn = new MenuSlider(app.pSlider, "Turning speed", style, posx, posy += menuHeight, width, cfg.gMouseTurnSpeed, 0, 163840, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gMouseTurnSpeed = slider.value;
            }
        }, true);
        this.mTurn.digitalMax = 65536.0f;
        this.mTurn.pal = buttonPal;
        this.mLook = new MenuSlider(app.pSlider, "Aiming up/down speed", style, posx, posy += menuHeight, width, cfg.gMouseLookSpeed, 0, 163840, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gMouseLookSpeed = slider.value;
            }
        }, true);
        this.mLook.digitalMax = 65536.0f;
        this.mLook.pal = buttonPal;
        this.mMove = new MenuSlider(app.pSlider, "Forward/Backward speed", style, posx, posy += menuHeight, width, cfg.gMouseMoveSpeed, 0, 163840, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gMouseMoveSpeed = slider.value;
            }
        }, true);
        this.mMove.digitalMax = 65536.0f;
        this.mMove.pal = buttonPal;
        this.mStrafe = new MenuSlider(app.pSlider, "Strafing speed", style, posx, posy += menuHeight, width, cfg.gMouseStrafeSpeed, 0, 163840, 4096, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.gMouseStrafeSpeed = slider.value;
            }
        }, true);
        this.mStrafe.digitalMax = 65536.0f;
        this.mStrafe.pal = buttonPal;
        posy += separatorHeight;
        this.mAiming = new MenuSwitch("Mouse aiming", style, posx, posy += menuHeight, width, cfg.gMouseAim, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.gMouseAim = sw.value;
            }
        }, null, null);
        this.mAiming.pal = buttonPal;
        this.mInvert = new MenuSwitch("Invert mouse aim", style, posx, posy += menuHeight, width, cfg.gInvertmouse, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.gInvertmouse = sw.value;
            }
        }, null, null);
        this.mInvert.pal = buttonPal;
        posy += separatorHeight;
        this.mAdvance = new MenuButton("Digital axis setup", style, posx, posy += menuHeight, width, 1, buttonPal, this.advancedMenu, -1, null, 0);
        this.addItem(this.mEnable, true);
        this.addItem(this.mMenuEnab, false);
        this.addItem(this.mSens, false);
        this.addItem(this.mTurn, false);
        this.addItem(this.mLook, false);
        this.addItem(this.mMove, false);
        this.addItem(this.mStrafe, false);
        this.addItem(this.mAiming, false);
        this.addItem(this.mInvert, false);
        this.addItem(this.mAdvance, false);
    }

    protected BuildMenu buildAdvancedAxisMenu(BuildGame app, int posx, int posy, int width, int menuHeight, BuildFont style) {
        BuildMenu advancedMenu = new BuildMenu();
        advancedMenu.addItem(this.getTitle(app, "Digital axis"), false);
        final BuildConfig cfg = app.pCfg;
        char[][] keymaplist = new char[cfg.keymap.length + 1][];
        keymaplist[0] = "None".toCharArray();
        int i = 1;
        while (i < keymaplist.length) {
            keymaplist[i] = cfg.keymap[i - 1].getName().toCharArray();
            ++i;
        }
        this.mAxisUp = new MenuConteiner("Digital up", style, posx, posy += 10, width, null, 0, null){

            @Override
            public void open() {
                this.num = cfg.mouseaxis[2] + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return MenuMouse.this.mAdvancedCallback(handler, cfg, this, opt, 2);
            }
        };
        this.mAxisDown = new MenuConteiner("Digital down", style, posx, posy += 10, width, null, 0, null){

            @Override
            public void open() {
                this.num = cfg.mouseaxis[3] + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return MenuMouse.this.mAdvancedCallback(handler, cfg, this, opt, 3);
            }
        };
        this.mAxisLeft = new MenuConteiner("Digital left", style, posx, posy += 10, width, null, 0, null){

            @Override
            public void open() {
                this.num = cfg.mouseaxis[0] + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return MenuMouse.this.mAdvancedCallback(handler, cfg, this, opt, 0);
            }
        };
        this.mAxisRight = new MenuConteiner("Digital right", style, posx, posy += 10, width, null, 0, null){

            @Override
            public void open() {
                this.num = cfg.mouseaxis[1] + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return MenuMouse.this.mAdvancedCallback(handler, cfg, this, opt, 1);
            }
        };
        this.mAxisRight.list = keymaplist;
        this.mAxisLeft.list = keymaplist;
        this.mAxisDown.list = keymaplist;
        this.mAxisUp.list = keymaplist;
        advancedMenu.addItem(this.mAxisUp, true);
        advancedMenu.addItem(this.mAxisDown, false);
        advancedMenu.addItem(this.mAxisLeft, false);
        advancedMenu.addItem(this.mAxisRight, false);
        return advancedMenu;
    }

    private boolean mAdvancedCallback(MenuHandler handler, BuildConfig cfg, MenuConteiner item, MenuHandler.MenuOpt opt, int nAxis) {
        switch (opt) {
            case LEFT: 
            case MWDW: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num > 0 ? --item.num : 0;
                cfg.mouseaxis[nAxis] = item.num - 1;
                return false;
            }
            case RIGHT: 
            case MWUP: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num < item.list.length - 1 ? ++item.num : item.list.length - 1;
                cfg.mouseaxis[nAxis] = item.num - 1;
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num < item.list.length - 1 ? ++item.num : 0;
                cfg.mouseaxis[nAxis] = item.num - 1;
                return false;
            }
        }
        return item.m_pMenu.mNavigation(opt);
    }
}

