/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.ArrayList;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.VideoMode;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;

public abstract class MenuVideoMode
extends BuildMenu {
    protected MenuConteiner mResolution;
    protected MenuConteiner mRenderer;
    protected MenuButton mRenderSettings;
    protected MenuSwitch mFullscreen;
    protected MenuButton mApplyChanges;
    protected MenuResolutionList mSlot;
    protected MenuScroller slider;
    protected VideoMode choosedMode;
    protected VideoMode currentMode;
    protected boolean isFullscreen;
    protected Renderer.RenderType currentRender;
    protected Renderer.RenderType choosedRender;
    protected final BuildMenu mResList;
    protected final BuildMenu mRenSettingsMenu;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract void setMode(BuildConfig var1);

    public BuildMenu getResolutionListMenu(final MenuVideoMode parent, final BuildGame app, int posx, int posy, int width, int nListItems, BuildFont style, int nListBackground) {
        BuildMenu menu = new BuildMenu();
        menu.addItem(parent.getTitle(app, "Resolution"), false);
        ArrayList<char[]> list = new ArrayList<char[]>();
        if (VideoMode.strvmodes != null) {
            int i = 0;
            while (i < VideoMode.strvmodes.length) {
                list.add(VideoMode.strvmodes[i].toCharArray());
                ++i;
            }
        }
        MenuProc callback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                final MenuList item = (MenuList)pItem;
                if (item.l_nFocus == -1) {
                    return;
                }
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        (this).MenuVideoMode.this.currentMode = (this).MenuVideoMode.this.choosedMode = VideoMode.validmodes.get(item.l_nFocus);
                        MenuVideoMode.this.setMode(app.pCfg);
                        parent.mLoadRes(app.pMenu, MenuHandler.MenuOpt.Open);
                        app.pMenu.mMenuBack();
                    }
                });
            }
        };
        this.mSlot = new MenuResolutionList(app.pEngine, list, style, posx, posy, width, 1, null, callback, nListItems, nListBackground);
        this.slider = new MenuScroller(app.pSlider, this.mSlot, width + posx - app.pSlider.getScrollerWidth());
        menu.addItem(this.mSlot, true);
        menu.addItem(this.slider, false);
        return menu;
    }

    public abstract MenuRendererSettings getRenSettingsMenu(BuildGame var1, int var2, int var3, int var4, int var5, BuildFont var6);

    public MenuVideoMode(final BuildGame app, int posx, int posy, int width, int itemHeight, BuildFont style, int nListItems, int nListWidth, int nBackground) {
        this.addItem(this.getTitle(app, "Video mode"), false);
        final BuildConfig cfg = app.pCfg;
        MenuProc callback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        cfg.fullscreen = (this).MenuVideoMode.this.isFullscreen ? 1 : 0;
                        (this).MenuVideoMode.this.currentMode = (this).MenuVideoMode.this.choosedMode;
                        if ((this).MenuVideoMode.this.currentRender != (this).MenuVideoMode.this.choosedRender) {
                            app.pEngine.getrender().uninit();
                            app.pEngine.setrendermode(app.getFactory().renderer((this).MenuVideoMode.this.choosedRender));
                            app.updateColorCorrection();
                            Console.Println("The render has been changed to " + (this).MenuVideoMode.this.choosedRender.getName());
                            cfg.renderType = app.pEngine.getrender().getType();
                            (this).MenuVideoMode.this.currentRender = (this).MenuVideoMode.this.choosedRender;
                        }
                        MenuVideoMode.this.setMode(cfg);
                    }
                });
                app.pInput.ctrlResetInput();
            }
        };
        this.mResList = this.getResolutionListMenu(this, app, posx + (width - nListWidth) / 2, posy + 2 * style.getHeight(), nListWidth, nListItems, style, nBackground);
        this.mRenSettingsMenu = this.getRenSettingsMenu(app, posx, posy, width, itemHeight, style);
        this.mResolution = new MenuConteiner("Resolution", style, posx, posy += itemHeight, width, VideoMode.strvmodes, 0, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuConteiner item = (MenuConteiner)pItem;
                MenuVideoMode.this.choosedMode = VideoMode.validmodes.get(item.num);
            }
        }){

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case LEFT: 
                    case MWDW: {
                        if (this.list == null) {
                            return false;
                        }
                        this.num = this.num > 0 ? --this.num : 0;
                        if (this.callback != null) {
                            this.callback.run(handler, this);
                        }
                        return false;
                    }
                    case RIGHT: 
                    case MWUP: {
                        if (this.list == null) {
                            return false;
                        }
                        this.num = this.num < this.list.length - 1 ? ++this.num : this.list.length - 1;
                        if (this.callback != null) {
                            this.callback.run(handler, this);
                        }
                        return false;
                    }
                    case ENTER: 
                    case LMB: {
                        handler.mOpen(MenuVideoMode.this.mResList, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                this.num = -1;
                int m = 0;
                while (m < VideoMode.validmodes.size()) {
                    if (VideoMode.validmodes.get((int)m).xdim == Engine.xdim && VideoMode.validmodes.get((int)m).ydim == Engine.ydim) {
                        this.num = m;
                        break;
                    }
                    ++m;
                }
                if (this.num != -1) {
                    MenuVideoMode.this.choosedMode = MenuVideoMode.this.currentMode = VideoMode.validmodes.get(this.num);
                } else {
                    MenuVideoMode.this.currentMode = new VideoMode(BuildGdx.graphics.getDisplayMode());
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                int px = this.x;
                int py = this.y;
                char[] key = null;
                key = this.num != -1 && this.list != null ? this.list[this.num] : Strhandler.toCharArray(String.valueOf(cfg.ScreenWidth) + " x " + cfg.ScreenHeight + " *");
                int pal = handler.getPal(this.font, this);
                int shade = handler.getShade(this);
                this.font.drawText(px, py, this.text, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
                if (key == null) {
                    return;
                }
                this.listFont.drawText(this.x + this.width - 1 - this.listFont.getWidth(key), py, key, shade, handler.getPal(this.listFont, this), BuildFont.TextAlign.Left, 2, this.listShadow);
                handler.mPostDraw(this);
            }
        };
        MenuProc renderCallback = new MenuProc(){

            @Override
            public void run(MenuHandler handler, final MenuItem pItem) {
                BuildGdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        MenuConteiner item = (MenuConteiner)pItem;
                        switch (item.num) {
                            case 0: {
                                (this).MenuVideoMode.this.choosedRender = Renderer.RenderType.Software;
                                break;
                            }
                            case 1: {
                                (this).MenuVideoMode.this.choosedRender = Renderer.RenderType.Polymost;
                            }
                        }
                    }
                });
            }
        };
        String[] renderers = new String[]{Renderer.RenderType.Software.getName(), Renderer.RenderType.Polymost.getName()};
        this.mRenderer = new MenuConteiner("Renderer", style, posx, posy += itemHeight, width, renderers, 0, renderCallback){

            @Override
            public void open() {
                MenuVideoMode.this.choosedRender = MenuVideoMode.this.currentRender = app.pEngine.getrender().getType();
                switch (MenuVideoMode.this.currentRender) {
                    case Software: {
                        this.num = 0;
                        break;
                    }
                    case Polymost: {
                        this.num = 1;
                    }
                }
            }
        };
        this.mFullscreen = new MenuSwitch("Fullscreen", style, posx, posy += itemHeight, width, cfg.fullscreen == 1, new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuVideoMode.this.isFullscreen = sw.value;
            }
        }, null, null){

            @Override
            public void open() {
                MenuVideoMode.this.isFullscreen = cfg.fullscreen == 1;
                this.value = MenuVideoMode.this.isFullscreen;
            }
        };
        this.mRenderSettings = new MenuButton("Renderer settings", style, posx, posy += itemHeight, width, 0, 0, this.mRenSettingsMenu, -1, null, 0);
        this.mApplyChanges = new MenuButton("Apply changes", style, 0, posy += 2 * itemHeight, 320, 1, 0, null, -1, callback, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuVideoMode.this.choosedMode != null && (MenuVideoMode.this.choosedMode != MenuVideoMode.this.currentMode || MenuVideoMode.this.isFullscreen != (cfg.fullscreen == 1) || MenuVideoMode.this.currentRender != MenuVideoMode.this.choosedRender));
                super.draw(handler);
            }

            @Override
            public void mCheckEnableItem(boolean nEnable) {
                this.flags = nEnable ? 7 : 3;
            }
        };
        posy += itemHeight;
        this.addItem(this.mResolution, true);
        this.addItem(this.mRenderer, false);
        this.addItem(this.mFullscreen, false);
        this.addItem(this.mRenderSettings, false);
        this.addItem(this.mApplyChanges, false);
    }
}

