/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Strhandler;

public class MenuSlider
extends MenuItem {
    public int min;
    public int max;
    public int step;
    public int value;
    public boolean digital;
    public float digitalMax;
    public char[] dbuff;
    public MenuProc callback;
    public BuildFont sliderNumbers;
    private int touchX;
    private boolean isTouched;
    private static MenuSlider touchedObj;
    private SliderDrawable slider;

    public MenuSlider(SliderDrawable slider, Object text, BuildFont textStyle, int x, int y, int width, int value, int min, int max, int step, MenuProc callback, boolean digital) {
        super(text, textStyle);
        this.slider = slider;
        this.flags = 7;
        this.x = x;
        this.y = y;
        this.width = width;
        this.min = min;
        this.max = max;
        this.step = step;
        this.value = Gameutils.BClipRange(value, min, max);
        this.digital = digital;
        this.digitalMax = 0.0f;
        this.callback = callback;
        this.sliderNumbers = this.font;
        this.dbuff = new char[10];
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade = handler.getShade(this);
        if (this.text != null) {
            this.font.drawText(this.x, this.y, this.text, shade, handler.getPal(this.font, this), BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        this.slider.drawSliderBackground(this.x + this.width - this.slider.getSliderRange(), this.y, shade, handler.getPal(null, this));
        if (this.digital) {
            Arrays.fill(this.dbuff, '\u0000');
            if (this.digitalMax == 0.0f) {
                Strhandler.Bitoa(this.value, this.dbuff);
            } else {
                String val = Float.toString((float)this.value / this.digitalMax);
                int index = val.indexOf(46);
                Strhandler.buildString(this.dbuff, 0, val);
                Arrays.fill(this.dbuff, index + 4, this.dbuff.length, '\u0000');
            }
            this.sliderNumbers.drawText(this.x + this.width - this.slider.getSliderRange() - this.sliderNumbers.getWidth(this.dbuff) - 5, this.y + (this.font.getHeight() - this.sliderNumbers.getHeight()) / 2, this.dbuff, shade, handler.getPal(this.sliderNumbers, this), BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        int xRange = this.slider.getSliderRange() - this.slider.getSliderWidth();
        int nRange = this.max - this.min;
        int dx = xRange * (this.value - this.min) / nRange - this.slider.getSliderRange();
        this.slider.drawSlider(this.x + this.width + dx, this.y, shade, handler.getPal(null, this));
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case UP: {
                this.m_pMenu.mNavUp();
                break;
            }
            case DW: {
                this.m_pMenu.mNavDown();
                break;
            }
            case LEFT: 
            case MWDW: {
                int val;
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.value <= 0) {
                    int dv = (this.value - this.step) % -this.step;
                    val = this.value - this.step - dv;
                    if (dv < 0) {
                        val += this.step;
                    }
                } else {
                    int dv = (this.value - 1) % this.step;
                    val = this.value - 1 - dv;
                    if (dv < 0) {
                        val -= this.step;
                    }
                }
                this.value = Gameutils.BClipRange(val, this.min, this.max);
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            case RIGHT: 
            case MWUP: {
                int val;
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.value < 0) {
                    int dv = (this.value - 1) % -this.step;
                    val = this.value - 1 - dv;
                    if (dv < 0) {
                        val += this.step;
                    }
                } else {
                    int dv = (this.value + this.step) % this.step;
                    val = this.value + this.step - dv;
                    if (dv < 0) {
                        val -= this.step;
                    }
                }
                this.value = Gameutils.BClipRange(val, this.min, this.max);
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            case ENTER: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (touchedObj != this) break;
                int startx = this.x + this.width - this.slider.getSliderRange() + this.slider.getSliderWidth() / 2;
                float dr = (float)(this.touchX - startx) / (float)(this.slider.getSliderRange() - this.slider.getSliderWidth() - 1);
                this.value = Gameutils.BClipRange((int)(dr * (float)(this.max - this.min) + (float)this.min), this.min, this.max);
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            default: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        int cx;
        this.touchX = mx;
        this.isTouched = false;
        if (!BuildGdx.input.isTouched()) {
            touchedObj = null;
        }
        if (this.text != null && mx > this.x && mx < this.x + this.font.getWidth(this.text) && my > this.y && my < this.y + this.font.getHeight()) {
            return true;
        }
        if (touchedObj == null && mx > (cx = this.x + this.width - this.slider.getSliderRange()) && mx < cx + this.slider.getSliderRange() && my > this.y && my < this.y + this.font.getHeight()) {
            this.isTouched = true;
            if (BuildGdx.input.isTouched()) {
                touchedObj = this;
            }
        }
        return this.isTouched;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

