/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.InputCallback;
import ru.m210projects.Build.Input.KeyInput;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Strhandler;

public class MenuTextField
extends MenuItem {
    public static final int LETTERS = 1;
    public static final int NUMBERS = 2;
    public static final int SYMBOLS = 4;
    public static final int POINT = 8;
    public char[] typingBuf = new char[16];
    public char[] otypingBuf = new char[16];
    public boolean typing;
    public String typed;
    public int inputlen;
    public int oinputlen;
    private InputCallback inputCallback;
    private MenuProc confirmCallback;

    public MenuTextField(Object text, String input, BuildFont font, int x, int y, int width, final int charFlag, MenuProc confirmCallback) {
        super(text, font);
        this.flags = 7;
        this.m_pMenu = null;
        this.x = x;
        this.y = y;
        this.width = width;
        this.typing = false;
        this.inputCallback = new InputCallback(){

            @Override
            public int run(int ch) {
                if (ch == 131) {
                    return -1;
                }
                if (ch == 67) {
                    if (MenuTextField.this.inputlen == 0) {
                        return 0;
                    }
                    --MenuTextField.this.inputlen;
                    MenuTextField.this.typingBuf[MenuTextField.this.inputlen] = '\u0000';
                }
                if (ch == 66) {
                    return 1;
                }
                if (BuildGdx.input.isKeyPressed(129) && ch == 50) {
                    if (BuildGdx.app.getClipboard() != null) {
                        String content = BuildGdx.app.getClipboard().getContents();
                        int i = 0;
                        while (i < content.length()) {
                            MenuTextField.this.type(content.charAt(i), charFlag);
                            ++i;
                        }
                    }
                    return 0;
                }
                if (ch == 240) {
                    ch = 56;
                }
                if (ch >= 144 && ch <= 153) {
                    ch = ch - 144 + 7;
                }
                MenuTextField.this.type(MenuTextField.this.getChar(ch), charFlag);
                return 0;
            }
        };
        this.typed = input;
        this.inputlen = input.length();
        System.arraycopy(input.toCharArray(), 0, this.typingBuf, 0, this.inputlen);
        this.confirmCallback = confirmCallback;
    }

    private void type(char ch, int charFlag) {
        boolean canType;
        if (this.inputlen < 15 && ch != '\u0000' && (canType = Strhandler.isalpha(ch) && (charFlag & 1) != 0 || Strhandler.isdigit(ch) && (charFlag & 2) != 0 || !Strhandler.isdigit(ch) && !Strhandler.isalpha(ch) && ((charFlag & 4) != 0 || (charFlag & 8) != 0 && ch == '.'))) {
            this.typingBuf[this.inputlen++] = ch;
        }
    }

    private char getChar(int ch) {
        if (ch < 128) {
            return KeyInput.gdxscantoasc[ch];
        }
        return '\u0000';
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.text != null) {
            int pal = handler.getPal(this.font, this);
            int shade = handler.getShade(this);
            if (!this.m_pMenu.mGetFocusedItem(this)) {
                this.typing = false;
            }
            this.font.drawText(this.x, this.y, this.text, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
            int px = this.x + this.width - 1;
            if (this.typing) {
                shade = -128;
                px -= 4;
            }
            this.font.drawText(px - this.font.getWidth(this.typingBuf), this.y, this.typingBuf, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
            if (this.typing && (Engine.totalclock & 0x20) != 0) {
                this.font.drawChar(px, this.y, '_', shade, pal, 2, false);
            }
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.typing) {
            if (opt != MenuHandler.MenuOpt.ESC) {
                if (Engine.getInput().putMessage(this.inputCallback, true) == 1) {
                    this.typed = new String(this.typingBuf, 0, this.inputlen);
                    this.typing = false;
                    if (this.typed.isEmpty()) {
                        System.arraycopy(this.otypingBuf, 0, this.typingBuf, 0, 16);
                        this.inputlen = this.oinputlen;
                        return false;
                    }
                    if (this.confirmCallback != null) {
                        this.confirmCallback.run(handler, this);
                    }
                }
            } else {
                System.arraycopy(this.otypingBuf, 0, this.typingBuf, 0, 16);
                this.inputlen = this.oinputlen;
                this.typing = false;
            }
        } else {
            switch (opt) {
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    Engine.getInput().initMessageInput(null);
                    System.arraycopy(this.typingBuf, 0, this.otypingBuf, 0, 16);
                    this.oinputlen = this.inputlen;
                    this.typing = true;
                    break;
                }
                case ESC: 
                case RMB: {
                    return true;
                }
                case UP: {
                    this.m_pMenu.mNavUp();
                    return false;
                }
                case DW: {
                    this.m_pMenu.mNavDown();
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.text != null) {
            if (mx > this.x && mx < this.x + this.font.getWidth(this.text) && my > this.y && my < this.y + this.font.getHeight()) {
                return true;
            }
            if (mx > this.x + this.width - this.font.getWidth(this.typingBuf) && mx < this.x + this.width - 1 && my > this.y && my < this.y + this.font.getHeight()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

