/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;

public abstract class MovieScreen
extends SkippableAdapter {
    protected final int TILE_MOVIE;
    protected Runnable callback;
    protected int gCutsClock;
    protected long LastMS;
    protected MovieFile mvfil;
    protected int frame;
    protected long mvtime;
    protected byte[] opalookup;
    protected int nFlags = 74;
    protected int nScale = 65536;
    protected int nPosX = 160;
    protected int nPosY = 100;

    public MovieScreen(BuildGame game, int nTile) {
        super(game);
        this.TILE_MOVIE = nTile;
        this.opalookup = new byte[Engine.palookup[0].length];
        System.arraycopy(Engine.palookup[0], 0, this.opalookup, 0, this.opalookup.length);
    }

    protected abstract MovieFile GetFile(String var1);

    protected abstract void StopAllSounds();

    protected abstract byte[] DoDrawFrame(int var1);

    protected abstract BuildFont GetFont();

    protected abstract void DrawEscText(BuildFont var1, int var2);

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.StopAllSounds();
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
        this.mvfil.playAudio();
    }

    @Override
    public void hide() {
        this.engine.setbrightness(BuildSettings.paletteGamma.get(), Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    public MovieScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    protected boolean open(String fn) {
        if (this.mvfil != null) {
            return false;
        }
        this.mvfil = this.GetFile(fn);
        if (this.mvfil == null) {
            return false;
        }
        Engine.tilesizx[this.TILE_MOVIE] = this.mvfil.getWidth();
        Engine.tilesizy[this.TILE_MOVIE] = this.mvfil.getHeight();
        Engine.waloff[this.TILE_MOVIE] = null;
        float kt = (float)Engine.tilesizy[this.TILE_MOVIE] / (float)Engine.tilesizx[this.TILE_MOVIE];
        float kv = (float)Engine.xdim / (float)Engine.ydim;
        float scale = 1.0f;
        if (kv >= kt) {
            scale = (float)Engine.ydim / (float)Engine.tilesizx[this.TILE_MOVIE];
            scale /= (float)Engine.ydim / 200.0f;
        } else {
            scale = (float)Engine.xdim / (float)Engine.tilesizy[this.TILE_MOVIE];
            scale /= (float)(4 * Engine.ydim) / 960.0f;
        }
        this.nScale = (int)(scale * 65536.0f);
        int i = 0;
        while (i < 256) {
            Engine.palookup[0][i] = (byte)i;
            ++i;
        }
        this.changepalette(this.mvfil.getPalette());
        this.frame = 0;
        this.mvtime = 0L;
        this.LastMS = -1L;
        return true;
    }

    public boolean isInited() {
        return this.mvfil != null;
    }

    protected void changepalette(byte[] pal) {
        if (pal == null) {
            return;
        }
        this.engine.changepalette(pal);
        int white = -1;
        int k = 0;
        int i = 0;
        while (i < 256) {
            int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j > k) {
                k = j;
                white = i;
            }
            i += 3;
        }
        if (white == -1) {
            return;
        }
        int palnum = 251;
        byte[] remapbuf = new byte[768];
        int i2 = 0;
        while (i2 < 768) {
            remapbuf[i2] = (byte)white;
            ++i2;
        }
        this.engine.makepalookup(palnum, remapbuf, 0, 1, 0, 1);
        i2 = 0;
        while (i2 < 256) {
            int tile = this.GetFont().getTile(i2);
            if (tile >= 0) {
                this.engine.invalidatetile(tile, palnum, -1);
            }
            ++i2;
        }
    }

    protected boolean play() {
        if (this.mvfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.mvtime += dt;
            float tick = this.mvfil.getRate();
            if ((float)this.mvtime >= tick) {
                if (this.frame < this.mvfil.getFrames()) {
                    Engine.waloff[this.TILE_MOVIE] = this.DoDrawFrame(this.frame);
                    this.engine.invalidatetile(this.TILE_MOVIE, 0, -1);
                    ++this.frame;
                } else {
                    return false;
                }
                this.mvtime = (long)((float)this.mvtime - tick);
            }
            this.LastMS = ms;
            if (Engine.tilesizx[this.TILE_MOVIE] <= 0) {
                return false;
            }
            if (Engine.waloff[this.TILE_MOVIE] != null) {
                this.engine.rotatesprite(this.nPosX << 16, this.nPosY << 16, this.nScale, 512, this.TILE_MOVIE, 0, 0, this.nFlags, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void skip() {
        this.close();
        super.skip();
    }

    protected void callback() {
        this.close();
        if (this.callback != null) {
            BuildGdx.app.postRunnable(this.callback);
            this.callback = null;
        }
    }

    @Override
    public void draw(float delta) {
        if (!this.play() && this.skipCallback != null) {
            this.callback();
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.DrawEscText(this.GetFont(), 251);
        }
    }

    protected void close() {
        if (this.mvfil != null) {
            System.arraycopy(this.opalookup, 0, Engine.palookup[0], 0, this.opalookup.length);
            this.mvfil.close();
        }
        this.mvfil = null;
        this.LastMS = -1L;
        this.frame = 0;
    }

    public static interface MovieFile {
        public int getFrames();

        public float getRate();

        public byte[] getFrame(int var1);

        public byte[] getPalette();

        public short getWidth();

        public short getHeight();

        public void close();

        public void playAudio();
    }
}

