/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class Interpolation {
    protected boolean requestUpdating;
    protected final int MAXINTERPOLATIONS = 4096;
    protected ILoc[] gOldSpriteLoc = new ILoc[Engine.MAXSPRITES];
    protected int InterpolationCount = 0;
    protected IData[] gInterpolationData = new IData[4096];
    protected int[] gWallLoc = new int[Engine.MAXWALLS >> 3];
    protected int[] gFloorHeinumLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gFloorLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gCeilLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gCeilHeinumLoc = new int[Engine.MAXSECTORS >> 3];
    protected int[] gSpriteLoc = new int[Engine.MAXSPRITES >> 3];

    public Interpolation() {
        int i = 0;
        while (i < 4096) {
            this.gInterpolationData[i] = new IData();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            this.gOldSpriteLoc[i] = new ILoc();
            ++i;
        }
    }

    protected void setinterpolation(Object obj, InterpolationType type) {
        if (this.InterpolationCount == 4096) {
            Console.Println("Too many interpolations", Console.OSDTEXT_RED);
            return;
        }
        IData data = this.gInterpolationData[this.InterpolationCount++];
        data.ptr = obj;
        data.type = type;
        switch (type) {
            case WallX: {
                data.oldpos = ((WALL)obj).x;
                break;
            }
            case WallY: {
                data.oldpos = ((WALL)obj).y;
                break;
            }
            case FloorZ: {
                data.oldpos = ((SECTOR)obj).floorz;
                break;
            }
            case CeilZ: {
                data.oldpos = ((SECTOR)obj).ceilingz;
                break;
            }
            case FloorH: {
                data.oldpos = ((SECTOR)obj).floorheinum;
                break;
            }
            case CeilH: {
                data.oldpos = ((SECTOR)obj).ceilingheinum;
            }
        }
    }

    protected void stopinterpolation(Object obj, InterpolationType type) {
        int i = this.InterpolationCount - 1;
        while (i >= 0) {
            IData data = this.gInterpolationData[i];
            if (obj == data.ptr && data.type == type) {
                --this.InterpolationCount;
                this.gInterpolationData[i] = this.gInterpolationData[this.InterpolationCount];
            }
            --i;
        }
    }

    public boolean clearinterpolations() {
        if (!this.requestUpdating) {
            return false;
        }
        this.InterpolationCount = 0;
        Arrays.fill(this.gWallLoc, 0);
        Arrays.fill(this.gFloorHeinumLoc, 0);
        Arrays.fill(this.gCeilHeinumLoc, 0);
        Arrays.fill(this.gFloorLoc, 0);
        Arrays.fill(this.gCeilLoc, 0);
        Arrays.fill(this.gSpriteLoc, 0);
        this.requestUpdating = false;
        return true;
    }

    public void requestUpdating() {
        this.requestUpdating = true;
    }

    public void dospriteinterp(SPRITE tsp, int smoothratio) {
        ILoc oldLoc = this.getsprinterpolate(tsp.owner);
        if (oldLoc != null) {
            int x = oldLoc.x;
            int y = oldLoc.y;
            int z = oldLoc.z;
            short nAngle = oldLoc.ang;
            nAngle = (short)(nAngle + Pragmas.mulscale((tsp.ang - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
            tsp.x = x += Pragmas.mulscale(tsp.x - oldLoc.x, smoothratio, 16);
            tsp.y = y += Pragmas.mulscale(tsp.y - oldLoc.y, smoothratio, 16);
            tsp.z = z += Pragmas.mulscale(tsp.z - oldLoc.z, smoothratio, 16);
            tsp.ang = nAngle;
        }
    }

    public int getValue(IData obj) {
        switch (obj.type) {
            case WallX: {
                return ((WALL)obj.ptr).x;
            }
            case WallY: {
                return ((WALL)obj.ptr).y;
            }
            case FloorZ: {
                return ((SECTOR)obj.ptr).floorz;
            }
            case CeilZ: {
                return ((SECTOR)obj.ptr).ceilingz;
            }
            case FloorH: {
                return ((SECTOR)obj.ptr).floorheinum;
            }
            case CeilH: {
                return ((SECTOR)obj.ptr).ceilingheinum;
            }
        }
        return 0;
    }

    public void dointerpolations(float smoothratio) {
        int i = 0;
        while (i < this.InterpolationCount) {
            IData gInt = this.gInterpolationData[i];
            Object obj = gInt.ptr;
            int value = gInt.bakpos = this.getValue(gInt);
            value = (int)((float)gInt.oldpos + (float)(value - gInt.oldpos) * smoothratio / 65536.0f);
            switch (gInt.type) {
                case WallX: {
                    ((WALL)obj).x = value;
                    break;
                }
                case WallY: {
                    ((WALL)obj).y = value;
                    break;
                }
                case FloorZ: {
                    ((SECTOR)obj).floorz = value;
                    break;
                }
                case CeilZ: {
                    ((SECTOR)obj).ceilingz = value;
                    break;
                }
                case FloorH: {
                    ((SECTOR)obj).floorheinum = (short)value;
                    break;
                }
                case CeilH: {
                    ((SECTOR)obj).ceilingheinum = (short)value;
                }
            }
            ++i;
        }
    }

    public void restoreinterpolations() {
        int i = 0;
        while (i < this.InterpolationCount) {
            IData gInt = this.gInterpolationData[i];
            Object obj = gInt.ptr;
            switch (gInt.type) {
                case WallX: {
                    ((WALL)obj).x = gInt.bakpos;
                    break;
                }
                case WallY: {
                    ((WALL)obj).y = gInt.bakpos;
                    break;
                }
                case FloorZ: {
                    ((SECTOR)obj).floorz = gInt.bakpos;
                    break;
                }
                case CeilZ: {
                    ((SECTOR)obj).ceilingz = gInt.bakpos;
                    break;
                }
                case FloorH: {
                    ((SECTOR)obj).floorheinum = (short)gInt.bakpos;
                    break;
                }
                case CeilH: {
                    ((SECTOR)obj).ceilingheinum = (short)gInt.bakpos;
                }
            }
            ++i;
        }
    }

    public boolean setsprinterpolate(int nSprite, SPRITE pSprite) {
        if ((this.gSpriteLoc[nSprite >> 3] & Engine.pow2char[nSprite & 7]) == 0) {
            ILoc pLocation = this.gOldSpriteLoc[nSprite];
            pLocation.x = pSprite.x;
            pLocation.y = pSprite.y;
            pLocation.z = pSprite.z;
            pLocation.ang = pSprite.ang;
            int n = nSprite >> 3;
            this.gSpriteLoc[n] = this.gSpriteLoc[n] | Engine.pow2char[nSprite & 7];
            return true;
        }
        return false;
    }

    public void clearspriteinterpolate(int nSprite) {
        int n = nSprite >> 3;
        this.gSpriteLoc[n] = this.gSpriteLoc[n] & ~Engine.pow2char[nSprite & 7];
    }

    public ILoc getsprinterpolate(int nSprite) {
        if ((this.gSpriteLoc[nSprite >> 3] & Engine.pow2char[nSprite & 7]) != 0) {
            return this.gOldSpriteLoc[nSprite];
        }
        return null;
    }

    public void setwallinterpolate(int nWall, WALL pWall) {
        if ((this.gWallLoc[nWall >> 3] & Engine.pow2char[nWall & 7]) == 0) {
            this.setinterpolation(pWall, InterpolationType.WallX);
            this.setinterpolation(pWall, InterpolationType.WallY);
            int n = nWall >> 3;
            this.gWallLoc[n] = this.gWallLoc[n] | Engine.pow2char[nWall & 7];
        }
    }

    public void clearwallinterpolate(int nWall, WALL pWall) {
        if ((this.gWallLoc[nWall >> 3] & Engine.pow2char[nWall & 7]) != 0) {
            this.stopinterpolation(pWall, InterpolationType.WallX);
            this.stopinterpolation(pWall, InterpolationType.WallY);
            int n = nWall >> 3;
            this.gWallLoc[n] = this.gWallLoc[n] & ~Engine.pow2char[nWall & 7];
        }
    }

    public void setfheinuminterpolate(int nSector, SECTOR pSector) {
        if ((this.gFloorHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.FloorH);
            int n = nSector >> 3;
            this.gFloorHeinumLoc[n] = this.gFloorHeinumLoc[n] | Engine.pow2char[nSector & 7];
        }
    }

    public void clearfheinuminterpolate(int nSector, SECTOR pSector) {
        if ((this.gFloorHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.FloorH);
            int n = nSector >> 3;
            this.gFloorHeinumLoc[n] = this.gFloorHeinumLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public void setcheinuminterpolate(int nSector, SECTOR pSector) {
        if ((this.gCeilHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.CeilH);
            int n = nSector >> 3;
            this.gCeilHeinumLoc[n] = this.gCeilHeinumLoc[n] | Engine.pow2char[nSector & 7];
        }
    }

    public void clearcheinuminterpolate(int nSector, SECTOR pSector) {
        if ((this.gCeilHeinumLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.CeilH);
            int n = nSector >> 3;
            this.gCeilHeinumLoc[n] = this.gCeilHeinumLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public boolean setfloorinterpolate(int nSector, SECTOR pSector) {
        if ((this.gFloorLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.FloorZ);
            int n = nSector >> 3;
            this.gFloorLoc[n] = this.gFloorLoc[n] | Engine.pow2char[nSector & 7];
            return true;
        }
        return false;
    }

    public void clearfloorinterpolate(int nSector, SECTOR pSector) {
        if ((this.gFloorLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.FloorZ);
            int n = nSector >> 3;
            this.gFloorLoc[n] = this.gFloorLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public boolean setceilinterpolate(int nSector, SECTOR pSector) {
        if ((this.gCeilLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) == 0) {
            this.setinterpolation(pSector, InterpolationType.CeilZ);
            int n = nSector >> 3;
            this.gCeilLoc[n] = this.gCeilLoc[n] | Engine.pow2char[nSector & 7];
            return true;
        }
        return false;
    }

    public void clearceilinterpolate(int nSector, SECTOR pSector) {
        if ((this.gCeilLoc[nSector >> 3] & Engine.pow2char[nSector & 7]) != 0) {
            this.stopinterpolation(pSector, InterpolationType.CeilZ);
            int n = nSector >> 3;
            this.gCeilLoc[n] = this.gCeilLoc[n] & ~Engine.pow2char[nSector & 7];
        }
    }

    public class IData {
        public Object ptr;
        public InterpolationType type;
        public int oldpos;
        public int bakpos;
    }

    public class ILoc {
        public int x;
        public int y;
        public int z;
        public short ang;
    }

    public static enum InterpolationType {
        WallX,
        WallY,
        FloorZ,
        CeilZ,
        FloorH,
        CeilH;

    }
}

