/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GdxRender.GdxBatch;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.TextureHandle.Pthtyp;
import ru.m210projects.Build.Render.TextureHandle.TextureCache;
import ru.m210projects.Build.Render.TextureHandle.TextureUtils;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.TileFont;

public class GdxOrphoRen
extends OrphoRenderer {
    protected final TextureCache textureCache;
    protected final Engine engine;
    protected final GdxBatch batch;
    protected final ShapeRenderer shape;
    protected BTexture textAtlas;

    public GdxOrphoRen(Engine engine, TextureCache textureCache) {
        this.engine = engine;
        this.textureCache = textureCache;
        this.batch = new GdxBatch();
        this.shape = new ShapeRenderer();
    }

    @Override
    public void init() {
        if (this.textAtlas == null) {
            int j;
            int i;
            int tptr;
            ByteBuffer ub = BufferUtils.newByteBuffer(32768);
            int h = 0;
            while (h < 256) {
                tptr = h % 32 * 8 + h / 32 * 256 * 8;
                i = 0;
                while (i < 8) {
                    j = 0;
                    while (j < 8) {
                        if ((Engine.textfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0) {
                            ub.put(tptr + j, (byte)-1);
                        }
                        ++j;
                    }
                    tptr += 256;
                    ++i;
                }
                ++h;
            }
            h = 0;
            while (h < 256) {
                tptr = 16384 + h % 32 * 8 + h / 32 * 256 * 8;
                i = 1;
                while (i < 7) {
                    j = 2;
                    while (j < 6) {
                        if ((Engine.smalltextfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0) {
                            ub.put(tptr + j - 2, (byte)-1);
                        }
                        ++j;
                    }
                    tptr += 256;
                    ++i;
                }
                ++h;
            }
            this.textAtlas = new BTexture(256, 128);
            this.textAtlas.bind();
            int internalformat = 32841;
            int format = 6409;
            BuildGdx.gl.glTexImage2D(3553, 0, internalformat, this.textAtlas.getWidth(), this.textAtlas.getHeight(), 0, format, 5121, ub);
            TextureUtils.setupBoundTexture(GLSettings.glfiltermodes[0], 0);
        }
    }

    @Override
    public void uninit() {
        if (this.textAtlas != null) {
            this.textAtlas.dispose();
        }
        this.textAtlas = null;
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        BuildGdx.gl.glDisable(3008);
        BuildGdx.gl.glDepthMask(false);
        BuildGdx.gl.glEnable(3042);
        int xsiz = fontsize != 0 ? 4 : 8;
        int ysiz = fontsize != 0 ? 6 : 8;
        xpos <<= 16;
        ypos <<= 16;
        this.bindBatch();
        if (backcol >= 0) {
            this.batch.setColor((float)Engine.curpalette.getRed(backcol) / 255.0f, (float)Engine.curpalette.getGreen(backcol) / 255.0f, (float)Engine.curpalette.getBlue(backcol) / 255.0f, 1.0f);
            this.batch.draw(this.textAtlas, xpos, ypos, Strhandler.Bstrlen(text) * xsiz, 8, 0, 0, 64.0f, 0.0f, 1.0f, 1.0f, 0, (int)(scale * 65536.0f), 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        int oxpos = xpos;
        int c = 0;
        int line = 0;
        this.batch.setColor((float)Engine.curpalette.getRed(col) / 255.0f, (float)Engine.curpalette.getGreen(col) / 255.0f, (float)Engine.curpalette.getBlue(col) / 255.0f, 1.0f);
        while (c < text.length && text[c] != '\u0000') {
            if (text[c] == '\n') {
                text[c] = '\u0000';
                ++line;
                xpos = oxpos - (int)(scale * (float)(8 >> fontsize));
            }
            if (text[c] == '\r') {
                text[c] = '\u0000';
            }
            int yoffs = (int)(scale * (float)line * (float)(8 >> fontsize));
            this.batch.draw(this.textAtlas, xpos, ypos, xsiz, ysiz, 0, -yoffs, text[c] % 32 * 8, text[c] / 32 * 8 + fontsize * 64, xsiz, ysiz, 0, (int)(scale * 65536.0f), 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            xpos = (int)((float)xpos + scale * (float)(xsiz << 16));
            ++c;
        }
        BuildGdx.gl.glDepthMask(true);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        col = Engine.palookup[0][col] & 0xFF;
        this.shape.begin(ShapeRenderer.ShapeType.Line);
        this.shape.setColor(Engine.curpalette.getRed(col), Engine.curpalette.getGreen(col), Engine.curpalette.getBlue(col), 255.0f);
        this.shape.line((float)x1 / 4096.0f, (float)Engine.ydim - (float)y1 / 4096.0f, (float)x2 / 4096.0f, (float)Engine.ydim - (float)y2 / 4096.0f);
        this.shape.end();
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        Pthtyp pth;
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        if ((Engine.picanm[picnum] & 0xC0) != 0) {
            picnum += this.engine.animateoffs((short)picnum, -16384);
        }
        if (Engine.tilesizx[picnum] <= 0 || Engine.tilesizy[picnum] <= 0) {
            return;
        }
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        short xsiz = Engine.tilesizx[picnum];
        short ysiz = Engine.tilesizy[picnum];
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = (byte)(Engine.picanm[picnum] >> 8 & 0xFF) + (xsiz >> 1);
            yoff = (byte)(Engine.picanm[picnum] >> 16 & 0xFF) + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if (picnum >= Engine.MAXTILES) {
            picnum = 0;
        }
        if (Engine.palookup[dapalnum & 0xFF] == null) {
            dapalnum = 0;
        }
        this.engine.setgotpic(picnum);
        if (Engine.waloff[picnum] == null) {
            this.engine.loadtile(picnum);
        }
        if ((pth = this.textureCache.cache(picnum, dapalnum, (short)0, this.textureCache.clampingMode(method), this.textureCache.alphaMode(method))) == null) {
            return;
        }
        if ((method & 3) == 0) {
            this.batch.disableBlending();
        } else {
            this.batch.enableBlending();
        }
        float shade = (float)(Engine.numshades - Math.min(Math.max(dashade, 0), Engine.numshades)) / (float)Engine.numshades;
        float alpha = 1.0f;
        switch (method & 3) {
            case 2: {
                alpha = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                alpha = Engine.TRANSLUSCENT2;
            }
        }
        this.bindBatch();
        this.batch.setColor(shade, shade, shade, alpha);
        this.batch.draw(pth.glpic, sx, sy, xsiz, ysiz, xoff, yoff, a, z, dastat, cx1, cy1, cx2, cy2);
    }

    private void bindBatch() {
        if (!this.batch.isDrawing()) {
            this.batch.begin();
        }
    }

    @Override
    public void nextpage() {
        if (this.batch.isDrawing()) {
            this.batch.end();
        }
    }
}

