/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Polygon;
import ru.m210projects.Build.Render.Polymost;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.Pthtyp;
import ru.m210projects.Build.Render.TextureHandle.TextureCache;
import ru.m210projects.Build.Render.TextureHandle.TextureUtils;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Palette;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public class Polymost2D
extends OrphoRenderer {
    private Polymost parent;
    private GL10 gl;
    private Engine engine;
    private IntBuffer polymosttext;
    private final TextureCache textureCache;
    private final FloatBuffer vertices = BufferUtils.newFloatBuffer(8);
    private final FloatBuffer textures = BufferUtils.newFloatBuffer(8);
    protected int globalx1;
    protected int globaly1;
    protected int globalx2;
    protected int globaly2;
    private int guniqhudid;
    protected int[] xb1 = new int[Polymost.MAXWALLSB];
    protected int[] xb2 = new int[Polymost.MAXWALLSB];
    protected float[] rx1 = new float[Polymost.MAXWALLSB];
    protected float[] ry1 = new float[Polymost.MAXWALLSB];
    private int allocpoints = 0;
    private int[] slist;
    private int[] npoint2;
    private raster[] rst;
    private final float[] trapextx = new float[2];
    private SPRITE hudsprite;
    private final int RS_CENTERORIGIN = 0x40000000;
    protected int asm1;
    protected int asm2;
    private double guo;
    private double gux;
    private double guy;
    private double gvo;
    private double gvx;
    private double gvy;
    private short globalpicnum;
    private int globalorientation;
    private final Polygon[] drawpoly = new Polygon[4];
    private final Color polyColor = new Color();

    public Polymost2D(Polymost parent) {
        this.parent = parent;
        this.gl = parent.gl;
        this.engine = parent.engine;
        this.textureCache = parent.textureCache;
        int i = 0;
        while (i < 4) {
            this.drawpoly[i] = new Polygon();
            ++i;
        }
        this.vertices.put(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        this.textures.put(new float[]{0.0f, 0.0f, 0.9999f, 0.0f, 0.9999f, 0.9999f, 0.0f, 0.9999f});
        this.vertices.rewind();
        this.textures.rewind();
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        int baky1;
        int bakx1;
        int y;
        int x;
        int oy;
        int ox;
        int j;
        int i;
        int npoints;
        SECTOR sec = null;
        Engine.beforedrawrooms = 0;
        Arrays.fill(Engine.gotsector, (byte)0);
        int cx1 = Engine.windowx1 << 12;
        int cy1 = Engine.windowy1 << 12;
        int cx2 = (Engine.windowx2 + 1 << 12) - 1;
        int cy2 = (Engine.windowy2 + 1 << 12) - 1;
        int bakgxvect = Pragmas.divscale(Engine.sintable[1536 - ang & 0x7FF], zoome <<= 8, 28);
        int bakgyvect = Pragmas.divscale(Engine.sintable[2048 - ang & 0x7FF], zoome, 28);
        int xvect = Pragmas.mulscale(Engine.sintable[2048 - ang & 0x7FF], zoome, 8);
        int yvect = Pragmas.mulscale(Engine.sintable[1536 - ang & 0x7FF], zoome, 8);
        int xvect2 = Pragmas.mulscale(xvect, Engine.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, Engine.yxaspect, 16);
        int sortnum = 0;
        int s = 0;
        while (s < Engine.numsectors) {
            block40: {
                block42: {
                    int startwall;
                    block41: {
                        sec = Engine.sector[s];
                        if (!this.fullmap && (Engine.show2dsector[s >> 3] & Engine.pow2char[s & 7]) == 0) break block40;
                        npoints = 0;
                        i = 0;
                        j = startwall = sec.wallptr;
                        if (startwall < 0) break block40;
                        int w = sec.wallnum;
                        while (w > 0) {
                            WALL wal = Engine.wall[j];
                            if (wal != null) {
                                ox = wal.x - dax;
                                oy = wal.y - day;
                                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                                this.rx1[npoints] = x;
                                this.ry1[npoints] = y;
                                this.xb1[npoints] = wal.point2 - startwall;
                                if (this.xb1[npoints] < 0) {
                                    this.xb1[npoints] = 0;
                                }
                                ++npoints;
                            }
                            --w;
                            ++j;
                        }
                        if ((i & 0xF0) != 240) break block40;
                        bakx1 = (int)this.rx1[0];
                        baky1 = Pragmas.mulscale((int)this.ry1[0] - (Engine.ydim << 11), Engine.xyaspect, 16) + (Engine.ydim << 11);
                        if (this.showflspr) {
                            i = Engine.headspritesect[s];
                            while (i >= 0) {
                                if ((Engine.sprite[i].cstat & 0x30) == 32 && sortnum < 1024 && (Engine.sprite[i].cstat & 0x48) != 72) {
                                    if (Engine.tsprite[sortnum] == null) {
                                        Engine.tsprite[sortnum] = new SPRITE();
                                    }
                                    Engine.tsprite[sortnum].set(Engine.sprite[i]);
                                    Engine.tsprite[sortnum++].owner = (short)i;
                                }
                                i = Engine.nextspritesect[i];
                            }
                        }
                        if (this.showspr) {
                            i = Engine.headspritesect[s];
                            while (i >= 0) {
                                if ((Engine.show2dsprite[i >> 3] & Engine.pow2char[i & 7]) != 0 && sortnum < 1024) {
                                    if (Engine.tsprite[sortnum] == null) {
                                        Engine.tsprite[sortnum] = new SPRITE();
                                    }
                                    Engine.tsprite[sortnum].set(Engine.sprite[i]);
                                    Engine.tsprite[sortnum++].owner = (short)i;
                                }
                                i = Engine.nextspritesect[i];
                            }
                        }
                        int n = s >> 3;
                        Engine.gotsector[n] = (byte)(Engine.gotsector[n] | Engine.pow2char[s & 7]);
                        this.globalorientation = sec.floorstat;
                        if ((this.globalorientation & 1) != 0) break block40;
                        Engine.globalpal = sec.floorpal;
                        this.globalpicnum = sec.floorpicnum;
                        if (this.globalpicnum >= Engine.MAXTILES) {
                            this.globalpicnum = 0;
                        }
                        this.engine.setgotpic(this.globalpicnum);
                        if (Engine.tilesizx[this.globalpicnum] <= 0 || Engine.tilesizy[this.globalpicnum] <= 0) break block40;
                        if ((Engine.picanm[this.globalpicnum] & 0xC0) != 0) {
                            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, s));
                        }
                        if (Engine.waloff[this.globalpicnum] == null) {
                            this.engine.loadtile(this.globalpicnum);
                        }
                        Engine.globalshade = Math.max(Math.min(sec.floorshade, Engine.numshades - 1), 0);
                        if ((this.globalorientation & 0x40) != 0) break block41;
                        Engine.globalposx = dax;
                        this.globalx1 = bakgxvect;
                        this.globaly1 = bakgyvect;
                        Engine.globalposy = day;
                        this.globalx2 = bakgxvect;
                        this.globaly2 = bakgyvect;
                        break block42;
                    }
                    ox = Engine.wall[Engine.wall[startwall].point2].x - Engine.wall[startwall].x;
                    oy = Engine.wall[Engine.wall[startwall].point2].y - Engine.wall[startwall].y;
                    i = this.engine.ksqrt(ox * ox + oy * oy);
                    if (i == 0) break block40;
                    i = 0x100000 / i;
                    this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                    this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                    ox = (bakx1 >> 4) - (Engine.xdim << 7);
                    oy = (baky1 >> 4) - (Engine.ydim << 7);
                    Engine.globalposx = Pragmas.dmulscale(-oy, this.globalx1, -ox, this.globaly1, 28);
                    Engine.globalposy = Pragmas.dmulscale(-ox, this.globalx1, oy, this.globaly1, 28);
                    this.globalx2 = -this.globalx1;
                    this.globaly2 = -this.globaly1;
                    short daslope = Engine.sector[s].floorheinum;
                    i = this.engine.ksqrt(daslope * daslope + 0x1000000);
                    Engine.globalposy = Pragmas.mulscale(Engine.globalposy, i, 12);
                    this.globalx2 = Pragmas.mulscale(this.globalx2, i, 12);
                    this.globaly2 = Pragmas.mulscale(this.globaly2, i, 12);
                }
                int globalxshift = 8 - (Engine.picsiz[this.globalpicnum] & 0xF);
                int globalyshift = 8 - (Engine.picsiz[this.globalpicnum] >> 4);
                if ((this.globalorientation & 8) != 0) {
                    ++globalxshift;
                    ++globalyshift;
                }
                if ((this.globalorientation & 4) > 0) {
                    i = Engine.globalposx;
                    Engine.globalposx = -Engine.globalposy;
                    Engine.globalposy = -i;
                    i = this.globalx2;
                    this.globalx2 = this.globaly1;
                    this.globaly1 = i;
                    i = this.globalx1;
                    this.globalx1 = -this.globaly2;
                    this.globaly2 = -i;
                }
                if ((this.globalorientation & 0x10) > 0) {
                    this.globalx1 = -this.globalx1;
                    this.globaly1 = -this.globaly1;
                    Engine.globalposx = -Engine.globalposx;
                }
                if ((this.globalorientation & 0x20) > 0) {
                    this.globalx2 = -this.globalx2;
                    this.globaly2 = -this.globaly2;
                    Engine.globalposy = -Engine.globalposy;
                }
                this.asm1 = this.globaly1 << globalxshift;
                this.asm2 = this.globalx2 << globalyshift;
                this.globalx1 <<= globalxshift;
                this.globaly2 <<= globalyshift;
                Engine.globalposx = (Engine.globalposx << 20 + globalxshift) + (sec.floorxpanning << 24);
                Engine.globalposy = (Engine.globalposy << 20 + globalyshift) - (sec.floorypanning << 24);
                this.fillpolygon(npoints);
            }
            ++s;
        }
        if (this.showspr) {
            int gap = 1;
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                i = 0;
                while (i < sortnum - gap) {
                    j = i;
                    while (j >= 0) {
                        if (Engine.sprite[Engine.tsprite[j].owner].z <= Engine.sprite[Engine.tsprite[j + gap].owner].z) break;
                        short tmp = Engine.tsprite[j].owner;
                        Engine.tsprite[j].owner = Engine.tsprite[j + gap].owner;
                        Engine.tsprite[j + gap].owner = tmp;
                        j -= gap;
                    }
                    ++i;
                }
                gap >>= 1;
            }
            s = sortnum - 1;
            while (s >= 0) {
                SPRITE spr = Engine.sprite[Engine.tsprite[s].owner];
                if ((spr.cstat & 0x8000) == 0) {
                    npoints = 0;
                    short tilenum = spr.picnum;
                    int xoff = (byte)(Engine.picanm[tilenum] >> 8 & 0xFF) + spr.xoffset;
                    int yoff = (byte)(Engine.picanm[tilenum] >> 16 & 0xFF) + spr.yoffset;
                    if ((spr.cstat & 4) > 0) {
                        xoff = -xoff;
                    }
                    if ((spr.cstat & 8) > 0) {
                        yoff = -yoff;
                    }
                    int k = spr.ang & 0x7FF;
                    short cosang = Engine.sintable[k + 512 & 0x7FF];
                    short sinang = Engine.sintable[k];
                    short xspan = Engine.tilesizx[tilenum];
                    short xrepeat = spr.xrepeat;
                    short yspan = Engine.tilesizy[tilenum];
                    short yrepeat = spr.yrepeat;
                    ox = ((xspan >> 1) + xoff) * xrepeat;
                    oy = ((yspan >> 1) + yoff) * yrepeat;
                    int x1 = spr.x + Pragmas.mulscale(sinang, ox, 16) + Pragmas.mulscale(cosang, oy, 16);
                    int y1 = spr.y + Pragmas.mulscale(sinang, oy, 16) - Pragmas.mulscale(cosang, ox, 16);
                    int l = xspan * xrepeat;
                    int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                    int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                    l = yspan * yrepeat;
                    k = -Pragmas.mulscale(cosang, l, 16);
                    int x3 = x2 + k;
                    int x4 = x1 + k;
                    k = -Pragmas.mulscale(sinang, l, 16);
                    int y3 = y2 + k;
                    int y4 = y1 + k;
                    this.xb1[0] = 1;
                    this.xb1[1] = 2;
                    this.xb1[2] = 3;
                    this.xb1[3] = 0;
                    npoints = 4;
                    i = 0;
                    ox = x1 - dax;
                    oy = y1 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[0] = x;
                    this.ry1[0] = y;
                    ox = x2 - dax;
                    oy = y2 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[1] = x;
                    this.ry1[1] = y;
                    ox = x3 - dax;
                    oy = y3 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[2] = x;
                    this.ry1[2] = y;
                    x = (int)(this.rx1[0] + this.rx1[2] - this.rx1[1]);
                    y = (int)(this.ry1[0] + this.ry1[2] - this.ry1[1]);
                    this.rx1[3] = x;
                    this.ry1[3] = y;
                    if (((i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y)) & 0xF0) == 240) {
                        bakx1 = (int)this.rx1[0];
                        baky1 = Pragmas.mulscale((int)this.ry1[0] - (Engine.ydim << 11), Engine.xyaspect, 16) + (Engine.ydim << 11);
                        this.globalpicnum = spr.picnum;
                        Engine.globalpal = spr.pal;
                        if (this.globalpicnum >= Engine.MAXTILES) {
                            this.globalpicnum = 0;
                        }
                        this.engine.setgotpic(this.globalpicnum);
                        if (Engine.tilesizx[this.globalpicnum] > 0 && Engine.tilesizy[this.globalpicnum] > 0) {
                            if ((Engine.picanm[this.globalpicnum] & 0xC0) != 0) {
                                this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, s));
                            }
                            if (Engine.waloff[this.globalpicnum] == null) {
                                this.engine.loadtile(this.globalpicnum);
                            }
                            Engine.globalshade = (Engine.sector[spr.sectnum].ceilingstat & 1) > 0 ? (int)Engine.sector[spr.sectnum].ceilingshade : (int)Engine.sector[spr.sectnum].floorshade;
                            Engine.globalshade = Math.max(Math.min(Engine.globalshade + spr.shade + 6, Engine.numshades - 1), 0);
                            ox = x2 - x1;
                            oy = y2 - y1;
                            i = ox * ox + oy * oy;
                            if (i != 0) {
                                i = 0x40000000 / i;
                                this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                                this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                                ox = y1 - y4;
                                oy = x4 - x1;
                                i = ox * ox + oy * oy;
                                if (i != 0) {
                                    i = 0x40000000 / i;
                                    this.globalx2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                                    this.globaly2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                                    ox = Engine.picsiz[this.globalpicnum];
                                    oy = ox >> 4 & 0xF;
                                    if (Engine.pow2long[ox &= 0xF] != xspan) {
                                        this.globalx1 = Pragmas.mulscale(this.globalx1, xspan, ++ox);
                                        this.globaly1 = Pragmas.mulscale(this.globaly1, xspan, ox);
                                    }
                                    bakx1 = (bakx1 >> 4) - (Engine.xdim << 7);
                                    baky1 = (baky1 >> 4) - (Engine.ydim << 7);
                                    Engine.globalposx = Pragmas.dmulscale(-baky1, this.globalx1, -bakx1, this.globaly1, 28);
                                    Engine.globalposy = Pragmas.dmulscale(bakx1, this.globalx2, -baky1, this.globaly2, 28);
                                    if ((spr.cstat & 4) > 0) {
                                        this.globalx1 = -this.globalx1;
                                        this.globaly1 = -this.globaly1;
                                        Engine.globalposx = -Engine.globalposx;
                                    }
                                    this.asm1 = this.globaly1 << 2;
                                    this.globalx1 <<= 2;
                                    Engine.globalposx <<= 22;
                                    this.asm2 = this.globalx2 << 2;
                                    this.globaly2 <<= 2;
                                    Engine.globalposy <<= 22;
                                    this.globalorientation = (spr.cstat & 2) << 7 | (spr.cstat & 0x200) >> 2;
                                    this.fillpolygon(npoints);
                                }
                            }
                        }
                    }
                }
                --s;
            }
        }
    }

    protected void setpolymost2dview() {
        if (this.parent.gloy1 != -1.0f || this.parent.gloy1 != (float)Engine.windowy1) {
            this.gl.glViewport(0, 0, Engine.xdim, Engine.ydim);
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glOrthof(0.0f, Engine.xdim, Engine.ydim, 0.0f, -1.0f, 1.0f);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
        }
        this.parent.gloy1 = -1.0f;
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glDisable(3042);
    }

    protected void fillpolygon(int npoints) {
        int z = 0;
        while (z < npoints) {
            if (this.xb1[z] >= npoints) {
                this.xb1[z] = 0;
            }
            ++z;
        }
        if (Engine.palookup[Engine.globalpal] == null) {
            Engine.globalpal = 0;
        }
        this.globalx1 = Pragmas.mulscale(this.globalx1, Engine.xyaspect, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, Engine.xyaspect, 16);
        this.gux = (double)this.asm1 / 4.294967296E9;
        this.gvx = (double)this.asm2 / 4.294967296E9;
        this.guy = (double)this.globalx1 / 4.294967296E9;
        this.gvy = (double)(-this.globaly2) / 4.294967296E9;
        this.guo = ((double)Engine.xdim * this.gux + (double)Engine.ydim * this.guy) * -0.5 + (double)Engine.globalposx / 4.294967296E9;
        this.gvo = ((double)Engine.xdim * this.gvx + (double)Engine.ydim * this.gvy) * -0.5 - (double)Engine.globalposy / 4.294967296E9;
        int i = npoints - 1;
        while (i >= 0) {
            int n = i;
            this.rx1[n] = this.rx1[n] / 4096.0f;
            int n2 = i--;
            this.ry1[n2] = this.ry1[n2] / 4096.0f;
        }
        this.gl.glDisable(2912);
        this.setpolymost2dview();
        this.gl.glEnable(3008);
        this.gl.glEnable(3553);
        Pthtyp pth = this.textureCache.cache(this.globalpicnum, Engine.globalpal, (short)0, false, true);
        TextureUtils.bindTexture(pth.glpic);
        float f = this.parent.getshadefactor(Engine.globalshade);
        float a = 0.0f;
        switch (this.globalorientation >> 7 & 3) {
            case 0: 
            case 1: {
                a = 1.0f;
                this.gl.glDisable(3042);
                break;
            }
            case 2: {
                a = Engine.TRANSLUSCENT1;
                this.gl.glEnable(3042);
                break;
            }
            case 3: {
                a = Engine.TRANSLUSCENT2;
                this.gl.glEnable(3042);
            }
        }
        this.gl.glColor4f(f, f, f, a);
        this.tessectrap(this.rx1, this.ry1, this.xb1, npoints);
    }

    private void drawtrap(float x0, float x1, float y0, float x2, float x3, float y1) {
        if (y0 == y1) {
            return;
        }
        this.drawpoly[0].px = x0;
        this.drawpoly[0].py = y0;
        this.drawpoly[2].py = y1;
        int n = 3;
        if (x0 == x1) {
            this.drawpoly[1].px = x3;
            this.drawpoly[1].py = y1;
            this.drawpoly[2].px = x2;
        } else if (x2 == x3) {
            this.drawpoly[1].px = x1;
            this.drawpoly[1].py = y0;
            this.drawpoly[2].px = x3;
        } else {
            this.drawpoly[1].px = x1;
            this.drawpoly[1].py = y0;
            this.drawpoly[2].px = x3;
            this.drawpoly[3].px = x2;
            this.drawpoly[3].py = y1;
            n = 4;
        }
        this.gl.glBegin(6);
        int i = 0;
        while (i < n) {
            this.drawpoly[i].px = Math.min(Math.max(this.drawpoly[i].px, (double)this.trapextx[0]), (double)this.trapextx[1]);
            this.gl.glTexCoord2d(this.drawpoly[i].px * this.gux + this.drawpoly[i].py * this.guy + this.guo, this.drawpoly[i].px * this.gvx + this.drawpoly[i].py * this.gvy + this.gvo);
            this.gl.glVertex2d(this.drawpoly[i].px, this.drawpoly[i].py);
            ++i;
        }
        this.gl.glEnd();
    }

    private void tessectrap(float[] px, float[] py, int[] point2, int numpoints) {
        float m1;
        float m0;
        int k;
        int j;
        int i;
        if (numpoints + 16 > this.allocpoints) {
            this.allocpoints = numpoints + 16;
            this.rst = new raster[this.allocpoints];
            i = 0;
            while (i < this.allocpoints) {
                this.rst[i] = new raster();
                ++i;
            }
            this.slist = new int[this.allocpoints];
            this.npoint2 = new int[this.allocpoints];
        }
        i = 0;
        while (i < numpoints) {
            this.npoint2[i] = point2[i];
            ++i;
        }
        int npoints = numpoints;
        int z = 0;
        i = 0;
        while (i < numpoints) {
            j = this.npoint2[i];
            if (point2[i] < i && i < numpoints - 1) {
                z = 3;
            }
            if (j >= 0 && (k = this.npoint2[j]) >= 0) {
                m0 = (px[j] - px[i]) * (py[k] - py[j]);
                m1 = (py[j] - py[i]) * (px[k] - px[j]);
                if (m0 < m1) {
                    z |= 1;
                } else if (m0 > m1) {
                    z |= 2;
                } else {
                    this.npoint2[i] = k;
                    this.npoint2[j] = -1;
                    --npoints;
                    --i;
                }
            }
            ++i;
        }
        if (z == 0) {
            return;
        }
        this.trapextx[0] = this.trapextx[1] = px[0];
        j = 0;
        i = 0;
        while (i < numpoints) {
            if (this.npoint2[i] >= 0) {
                if (px[i] < this.trapextx[0]) {
                    this.trapextx[0] = px[i];
                }
                if (px[i] > this.trapextx[1]) {
                    this.trapextx[1] = px[i];
                }
                this.slist[j++] = i;
            }
            ++i;
        }
        if (z != 3) {
            this.gl.glBegin(6);
            i = 0;
            while (i < npoints) {
                j = this.slist[i];
                this.gl.glTexCoord2f((float)((double)px[j] * this.gux + (double)py[j] * this.guy + this.guo), (float)((double)px[j] * this.gvx + (double)py[j] * this.gvy + this.gvo));
                this.gl.glVertex2d(px[j], py[j]);
                ++i;
            }
            this.gl.glEnd();
            return;
        }
        int gap = npoints >> 1;
        while (gap != 0) {
            i = 0;
            while (i < npoints - gap) {
                j = i;
                while (j >= 0) {
                    if (py[this.npoint2[this.slist[j]]] <= py[this.npoint2[this.slist[j + gap]]]) break;
                    k = this.slist[j];
                    this.slist[j] = this.slist[j + gap];
                    this.slist[j + gap] = k;
                    j -= gap;
                }
                ++i;
            }
            gap >>= 1;
        }
        int numrst = 0;
        z = 0;
        while (z < npoints) {
            int i0 = this.slist[z];
            int i1 = this.npoint2[i0];
            if (py[i0] != py[i1] && this.npoint2[i1] != -1) {
                float x1;
                float x0;
                int i2 = i1;
                int i3 = this.npoint2[i1];
                if (py[i1] == py[i3]) {
                    i2 = i3;
                    i3 = this.npoint2[i3];
                }
                if (py[i1] < py[i0] && py[i2] < py[i3]) {
                    i = numrst;
                    while (i > 0) {
                        if (this.rst[i - 1].xi * (py[i1] - this.rst[i - 1].y) + this.rst[i - 1].x < px[i1]) break;
                        this.rst[i + 1].set(this.rst[i - 1]);
                        --i;
                    }
                    numrst += 2;
                    if ((i & 1) != 0) {
                        j = i - 1;
                        x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
                        x1 = (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
                        this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
                        this.rst[j].x = x0;
                        this.rst[j].y = py[i1];
                        this.rst[j + 3].x = x1;
                        this.rst[j + 3].y = py[i1];
                    }
                    m0 = (px[i0] - px[i1]) / (py[i0] - py[i1]);
                    m1 = (px[i3] - px[i2]) / (py[i3] - py[i2]);
                    j = (px[i1] > px[i2] || i1 == i2 && m0 >= m1 ? 1 : 0) + i;
                    if (j >= 0) {
                        k = (i << 1) + 1 - j;
                        this.rst[j].i = i0;
                        this.rst[j].xi = m0;
                        this.rst[j].x = px[i1];
                        this.rst[j].y = py[i1];
                        this.rst[k].i = i3;
                        this.rst[k].xi = m1;
                        this.rst[k].x = px[i2];
                        this.rst[k].y = py[i2];
                    }
                } else {
                    if (i1 == i2) {
                        i = 0;
                        while (i < numrst) {
                            if (this.rst[i].i != i1) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        i = 0;
                        while (i < numrst) {
                            if (this.rst[i].i != i1 && this.rst[i].i != i2) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    j = i & 0xFFFFFFFE;
                    if (py[i1] > py[i0] && py[i2] > py[i3]) {
                        while (j <= i + 1) {
                            x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
                            x1 = i == j && i1 == i2 ? x0 : (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
                            this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
                            this.rst[j].x = x0;
                            this.rst[j].y = py[i1];
                            this.rst[j + 1].x = x1;
                            this.rst[j + 1].y = py[i1];
                            j += 2;
                        }
                        numrst -= 2;
                        while (i < numrst) {
                            this.rst[i].set(this.rst[i + 2]);
                            ++i;
                        }
                    } else {
                        x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
                        x1 = (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
                        this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
                        this.rst[j].x = x0;
                        this.rst[j].y = py[i1];
                        this.rst[j + 1].x = x1;
                        this.rst[j + 1].y = py[i1];
                        if (py[i0] < py[i3]) {
                            this.rst[i].x = px[i2];
                            this.rst[i].y = py[i2];
                            this.rst[i].i = i3;
                        } else {
                            this.rst[i].x = px[i1];
                            this.rst[i].y = py[i1];
                            this.rst[i].i = i0;
                        }
                        this.rst[i].xi = (px[this.rst[i].i] - this.rst[i].x) / (py[this.rst[i].i] - py[i1]);
                    }
                }
            }
            ++z;
        }
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        Pthtyp pth;
        if (font.type == TileFont.FontType.Tilemap) {
            int nTile;
            if (Engine.palookup[col] == null) {
                col = 0;
            }
            if (Engine.waloff[nTile = ((Integer)font.ptr).intValue()] == null && this.engine.loadtile(nTile) == null) {
                return;
            }
        }
        if ((pth = font.getGL(this.textureCache, col)) == null) {
            return;
        }
        int opal = Engine.globalpal;
        Engine.globalpal = col;
        TextureUtils.bindTexture(pth.glpic);
        this.setpolymost2dview();
        this.gl.glDisable(2912);
        this.gl.glDisable(3008);
        this.gl.glDepthMask(0);
        this.gl.glEnable(3553);
        this.gl.glEnable(3042);
        float alpha = 1.0f;
        float f = this.parent.getshadefactor(shade);
        if (bit == Renderer.Transparent.Bit1) {
            alpha = Engine.TRANSLUSCENT1;
        }
        if (bit == Renderer.Transparent.Bit2) {
            alpha = Engine.TRANSLUSCENT2;
        }
        if (font.type == TileFont.FontType.Tilemap) {
            this.gl.glColor4f(f, f, f, alpha);
        } else {
            this.gl.glColor4ub(Engine.curpalette.getRed(col), Engine.curpalette.getGreen(col), Engine.curpalette.getBlue(col), (int)(alpha * 255.0f));
        }
        int c = 0;
        int line = 0;
        float txc = (float)font.charsizx / (float)font.sizx;
        float tyc = (float)font.charsizy / (float)font.sizy;
        this.gl.glBegin(5);
        int oxpos = xpos;
        while (c < text.length && text[c] != '\u0000') {
            if (text[c] == '\n') {
                text[c] = '\u0000';
                ++line;
                xpos = oxpos - (int)(scale * (float)font.charsizx);
            }
            if (text[c] == '\r') {
                text[c] = '\u0000';
            }
            float tx = (float)(text[c] % font.cols) / (float)font.cols;
            float ty = (float)(text[c] / font.cols) / (float)font.rows;
            int yoffs = (int)(scale * (float)line * (float)font.charsizy);
            int x = xpos + (int)(scale * (float)font.charsizx);
            int y = ypos + (int)(scale * (float)font.charsizy);
            this.gl.glTexCoord2f(tx, ty);
            this.gl.glVertex2i(xpos, ypos + yoffs);
            this.gl.glTexCoord2f(tx, ty + tyc);
            this.gl.glVertex2i(xpos, y + yoffs);
            this.gl.glTexCoord2f(tx + txc, ty);
            this.gl.glVertex2i(x, ypos + yoffs);
            this.gl.glTexCoord2f(tx + txc, ty + tyc);
            this.gl.glVertex2i(x, y + yoffs);
            xpos = (int)((float)xpos + scale * (float)font.charsizx);
            ++c;
        }
        this.gl.glEnd();
        this.gl.glDepthMask(1);
        Engine.globalpal = opal;
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        int oxpos = xpos;
        this.gl.glBindTexture(3553, this.polymosttext);
        this.setpolymost2dview();
        this.gl.glDisable(2912);
        this.gl.glDisable(3008);
        this.gl.glDepthMask(0);
        if (backcol >= 0) {
            this.gl.glColor4ub(Engine.curpalette.getRed(backcol), Engine.curpalette.getGreen(backcol), Engine.curpalette.getBlue(backcol), 255);
            int c = Strhandler.Bstrlen(text);
            this.gl.glBegin(6);
            this.gl.glVertex2i(xpos, ypos);
            this.gl.glVertex2i(xpos, ypos + (fontsize != 0 ? 6 : 8));
            int x = xpos + (c << 3 - fontsize);
            int y = ypos + (fontsize != 0 ? 6 : 8);
            this.gl.glVertex2i(x, y);
            this.gl.glVertex2i(xpos + (c << 3 - fontsize), ypos);
            this.gl.glEnd();
        }
        this.gl.glEnable(3553);
        this.gl.glEnable(3042);
        this.gl.glColor4ub(Engine.curpalette.getRed(col), Engine.curpalette.getGreen(col), Engine.curpalette.getBlue(col), 255);
        float txc = fontsize != 0 ? 0.015625f : 0.03125f;
        float tyc = fontsize != 0 ? 0.046875f : 0.0625f;
        this.gl.glBegin(5);
        int c = 0;
        int line = 0;
        while (c < text.length && text[c] != '\u0000') {
            if (text[c] == '\n') {
                text[c] = '\u0000';
                ++line;
                xpos = oxpos - (int)(scale * (float)(8 >> fontsize));
            }
            if (text[c] == '\r') {
                text[c] = '\u0000';
            }
            float tx = (float)(text[c] % 32) / 32.0f;
            float ty = (float)(text[c] / 32 + fontsize * 8) / 16.0f;
            int yoffs = (int)(scale * (float)line * (float)(fontsize != 0 ? 6 : 8));
            int x = xpos + (int)(scale * (float)(8 >> fontsize));
            int y = ypos + (int)(scale * (float)(fontsize != 0 ? 6 : 8));
            this.gl.glTexCoord2f(tx, ty);
            this.gl.glVertex2i(xpos, ypos + yoffs);
            this.gl.glTexCoord2f(tx, ty + tyc);
            this.gl.glVertex2i(xpos, y + yoffs);
            this.gl.glTexCoord2f(tx + txc, ty);
            this.gl.glVertex2i(x, ypos + yoffs);
            this.gl.glTexCoord2f(tx + txc, ty + tyc);
            this.gl.glVertex2i(x, y + yoffs);
            xpos = (int)((float)xpos + scale * (float)(8 >> fontsize));
            ++c;
        }
        this.gl.glEnd();
        this.gl.glDepthMask(1);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        this.gl.glDisable(2912);
        this.setpolymost2dview();
        col = Engine.palookup[0][col] & 0xFF;
        this.gl.glBegin(1);
        this.gl.glColor4ub(Engine.curpalette.getRed(col), Engine.curpalette.getGreen(col), Engine.curpalette.getBlue(col), 255);
        this.gl.glVertex2f((float)x1 / 4096.0f, (float)y1 / 4096.0f);
        this.gl.glVertex2f((float)x2 / 4096.0f, (float)y2 / 4096.0f);
        this.gl.glEnd();
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        if ((Engine.picanm[picnum] & 0xC0) != 0) {
            picnum += this.engine.animateoffs((short)picnum, -16384);
        }
        if (Engine.tilesizx[picnum] <= 0 || Engine.tilesizy[picnum] <= 0) {
            return;
        }
        if ((dastat & 0x80) == 0 || Engine.beforedrawrooms != 0) {
            this.dorotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, this.guniqhudid);
        }
    }

    protected void dorotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int ourxyaspect = Engine.xyaspect;
        if (GLSettings.useModels.get().booleanValue() && this.parent.defs != null && this.parent.defs.mdInfo.getHudInfo(picnum, dastat) != null && this.parent.defs.mdInfo.getHudInfo((int)picnum, (int)dastat).angadd != 0) {
            Tile2model entry;
            Tile2model tile2model = entry = this.parent.defs != null ? this.parent.defs.mdInfo.getParams(picnum) : null;
            if (entry != null && entry.model != null && entry.framenum >= 0) {
                this.dorotatesprite3d(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, uniqid);
                return;
            }
        }
        short ogpicnum = this.globalpicnum;
        this.globalpicnum = (short)picnum;
        int ogshade = Engine.globalshade;
        Engine.globalshade = dashade;
        int ogpal = Engine.globalpal;
        Engine.globalpal = dapalnum & 0xFF;
        if ((dastat & 0xA) == 2) {
            this.gl.glViewport(Engine.windowx1, Engine.ydim - (Engine.windowy2 + 1), Engine.windowx2 - Engine.windowx1 + 1, Engine.windowy2 - Engine.windowy1 + 1);
        } else {
            this.gl.glViewport(0, 0, Engine.xdim, Engine.ydim);
            this.parent.glox1 = -1.0f;
        }
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glOrthof(0.0f, Engine.xdim - 1, Engine.ydim - 1, 0.0f, -1.0f, 1.0f);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glDisable(3008);
        this.gl.glEnable(3553);
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        short xsiz = Engine.tilesizx[this.globalpicnum];
        short ysiz = Engine.tilesizy[this.globalpicnum];
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = (byte)(Engine.picanm[this.globalpicnum] >> 8 & 0xFF) + (xsiz >> 1);
            yoff = (byte)(Engine.picanm[this.globalpicnum] >> 16 & 0xFF) + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * Engine.xdim) {
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = Engine.xdim;
            int ouryxaspect = Engine.yxaspect;
            ourxyaspect = Engine.xyaspect;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * xdim) {
                xdim = 4 * Engine.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = cx1 + cx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(Engine.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = Engine.xdimenscale;
                sy = (cy1 + cy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                if ((dastat & 0x40000000) != 0) {
                    sx += oxdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (Engine.ydim << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        this.gl.glEnable(12288);
        this.gl.glClipPlanef(12288, 1.0f, 0.0f, 0.0f, -cx1);
        this.gl.glEnable(12289);
        this.gl.glClipPlanef(12289, -1.0f, 0.0f, 0.0f, cx2);
        this.gl.glEnable(12290);
        this.gl.glClipPlanef(12290, 0.0f, 1.0f, 0.0f, -cy1);
        this.gl.glEnable(12291);
        this.gl.glClipPlanef(12291, 0.0f, -1.0f, 0.0f, cy2);
        float aspectFix = (dastat & 2) != 0 || (dastat & 8) == 0 ? (float)ourxyaspect / 65536.0f : 1.0f;
        float scale = (float)z / 65536.0f;
        float cx = (float)sx / 65536.0f;
        float cy = (float)sy / 65536.0f;
        this.gl.glTranslatef(cx, cy, 0.0f);
        this.gl.glScalef(1.0f, 1.0f / aspectFix, 0.0f);
        this.gl.glRotatef(360.0f * (float)a / 2048.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glScalef(scale * aspectFix, scale * aspectFix, 0.0f);
        this.gl.glTranslatef(-xoff, -yoff, 0.0f);
        this.gl.glScalef(xsiz, ysiz, 0.0f);
        this.gl.glDisable(2912);
        this.drawrotate(method, dastat);
        this.gl.glDisable(12288);
        this.gl.glDisable(12289);
        this.gl.glDisable(12290);
        this.gl.glDisable(12291);
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.globalpicnum = ogpicnum;
        Engine.globalshade = ogshade;
        Engine.globalpal = ogpal & 0xFF;
    }

    protected void drawrotate(int method, int dastat) {
        Pthtyp pth;
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        if (Engine.palookup[Engine.globalpal] == null) {
            Engine.globalpal = 0;
        }
        this.engine.setgotpic(this.globalpicnum);
        short tsizx = Engine.tilesizx[this.globalpicnum];
        short tsizy = Engine.tilesizy[this.globalpicnum];
        if (Engine.waloff[this.globalpicnum] == null) {
            this.engine.loadtile(this.globalpicnum);
            if (Engine.waloff[this.globalpicnum] == null) {
                tsizy = 1;
                tsizx = 1;
                method = 1;
            }
        }
        if ((pth = this.textureCache.cache(this.globalpicnum, Engine.globalpal, (short)0, this.textureCache.clampingMode(method), this.textureCache.alphaMode(method))) == null) {
            return;
        }
        pth.isHighTile();
        TextureUtils.bindTexture(pth.glpic);
        float hackscx = 1.0f;
        float hackscy = 1.0f;
        if (pth != null && pth.isHighTile()) {
            tsizx = pth.sizx;
            tsizy = pth.sizy;
        }
        float ox2 = hackscx / (float)TextureUtils.calcSize(tsizx);
        float oy2 = hackscy / (float)TextureUtils.calcSize(tsizy);
        this.gl.glMatrixMode(5890);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glScalef(tsizx, tsizy, 1.0f);
        this.gl.glScalef(ox2, oy2, 1.0f);
        if (pth != null && pth.hicr != null && (pth.hicr.xscale != 1.0f || pth.hicr.yscale != 1.0f)) {
            this.gl.glScalef(pth.hicr.xscale, pth.hicr.yscale, 1.0f);
        }
        if ((dastat & 4) != 0) {
            this.gl.glScalef(1.0f, -1.0f, 1.0f);
            this.gl.glTranslatef(0.0f, -1.0f, 0.0f);
        }
        if ((method & 3) == 0) {
            this.gl.glDisable(3042);
            this.gl.glDisable(3008);
        } else {
            this.gl.glEnable(3042);
            this.gl.glEnable(3008);
        }
        this.polyColor.g = this.polyColor.b = this.parent.getshadefactor(Engine.globalshade);
        this.polyColor.r = this.polyColor.b;
        switch (method & 3) {
            default: {
                this.polyColor.a = 1.0f;
                break;
            }
            case 2: {
                this.polyColor.a = Engine.TRANSLUSCENT1;
                break;
            }
            case 3: {
                this.polyColor.a = Engine.TRANSLUSCENT2;
            }
        }
        if (this.parent.defs != null && pth != null && pth.isHighTile()) {
            if (pth.hicr.palnum != Engine.globalpal) {
                Palette p = this.parent.defs.texInfo.getTints(Engine.globalpal);
                this.polyColor.r *= (float)p.r / 255.0f;
                this.polyColor.g *= (float)p.g / 255.0f;
                this.polyColor.b *= (float)p.b / 255.0f;
            }
            Palette pdetail = this.parent.defs.texInfo.getTints(255);
            if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                this.polyColor.r *= (float)pdetail.r / 255.0f;
                this.polyColor.g *= (float)pdetail.g / 255.0f;
                this.polyColor.b *= (float)pdetail.b / 255.0f;
            }
        }
        this.gl.glColor4f(this.polyColor.r, this.polyColor.g, this.polyColor.b, this.polyColor.a);
        this.gl.glEnableClientState(32888);
        this.gl.glEnableClientState(32884);
        this.gl.glTexCoordPointer(2, 5126, 0, this.textures);
        this.gl.glVertexPointer(2, 5126, 0, this.vertices);
        this.gl.glDrawArrays(6, 0, 4);
        this.gl.glDisableClientState(32888);
        this.gl.glDisableClientState(32884);
        this.gl.glMatrixMode(5890);
        this.gl.glPopMatrix();
    }

    private void dorotatesprite3d(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int xoff = 0;
        int yoff = 0;
        if (this.hudsprite == null) {
            this.hudsprite = new SPRITE();
        }
        this.hudsprite.reset((byte)0);
        Hudtyp hudInfo = null;
        if (this.parent.defs == null || (hudInfo = this.parent.defs.mdInfo.getHudInfo(picnum, dastat)) != null && (hudInfo.flags & 1) != 0) {
            return;
        }
        float ogchang = this.parent.gchang;
        this.parent.gchang = 1.0f;
        float ogshang = this.parent.gshang;
        this.parent.gshang = 0.0f;
        float d = (float)z / 1.0737418E9f;
        float ogctang = this.parent.gctang;
        this.parent.gctang = (float)Engine.sintable[a + 512 & 0x7FF] * d;
        float ogstang = this.parent.gstang;
        this.parent.gstang = (float)Engine.sintable[a & 0x7FF] * d;
        int ogshade = Engine.globalshade;
        Engine.globalshade = dashade;
        int ogpal = Engine.globalpal;
        Engine.globalpal = dapalnum;
        double ogxyaspect = this.parent.gxyaspect;
        this.parent.gxyaspect = 1.0;
        int oldviewingrange = Engine.viewingrange;
        Engine.viewingrange = 65536;
        float x1 = hudInfo.xadd;
        float y1 = hudInfo.yadd;
        float z1 = hudInfo.zadd;
        if ((hudInfo.flags & 2) == 0) {
            float fx = (float)sx * 1.5258789E-5f;
            float fy = (float)sy * 1.5258789E-5f;
            if ((dastat & 0x10) != 0) {
                float sinang;
                float cosang;
                short xsiz = Engine.tilesizx[picnum];
                short ysiz = Engine.tilesizy[picnum];
                xoff = (byte)(Engine.picanm[picnum] >> 8 & 0xFF) + (xsiz >> 1);
                yoff = (byte)(Engine.picanm[picnum] >> 16 & 0xFF) + (ysiz >> 1);
                d = (float)z / 1.0737418E9f;
                float cosang2 = cosang = (float)Engine.sintable[a + 512 & 0x7FF] * d;
                float sinang2 = sinang = (float)Engine.sintable[a & 0x7FF] * d;
                if ((dastat & 2) != 0 || (dastat & 8) == 0) {
                    d = (float)Engine.xyaspect / 65536.0f;
                    cosang2 *= d;
                    sinang2 *= d;
                }
                fx = (float)((double)fx + (-((double)xoff) * (double)cosang2 + (double)yoff * (double)sinang2));
                fy = (float)((double)fy + (-((double)xoff) * (double)sinang - (double)yoff * (double)cosang));
            }
            if ((dastat & 2) == 0) {
                x1 = (float)((double)x1 + ((double)fx / (double)(Engine.xdim << 15) - 1.0));
                y1 = (float)((double)y1 + ((double)fy / (double)(Engine.ydim << 15) - 1.0));
            } else {
                x1 = (float)((double)x1 + ((double)fx / 160.0 - 1.0));
                y1 = (float)((double)y1 + ((double)fy / 100.0 - 1.0));
            }
        }
        this.hudsprite.ang = (short)((float)hudInfo.angadd + Engine.globalang);
        if ((dastat & 4) != 0) {
            x1 = -x1;
            y1 = -y1;
        }
        this.hudsprite.yrepeat = (short)32;
        this.hudsprite.xrepeat = (short)32;
        this.hudsprite.x = (int)(((double)this.parent.gcosang * (double)z1 - (double)this.parent.gsinang * (double)x1) * 16384.0 + (double)Engine.globalposx);
        this.hudsprite.y = (int)(((double)this.parent.gsinang * (double)z1 + (double)this.parent.gcosang * (double)x1) * 16384.0 + (double)Engine.globalposy);
        this.hudsprite.z = (int)((double)Engine.globalposz + (double)y1 * 16384.0 * 0.8);
        this.hudsprite.picnum = (short)picnum;
        this.hudsprite.shade = (byte)dashade;
        this.hudsprite.pal = (short)dapalnum;
        this.hudsprite.owner = (short)(uniqid + Engine.MAXSPRITES);
        this.hudsprite.cstat = (short)((dastat & 1) + ((dastat & 0x20) << 4) + ((dastat & 4) << 1));
        if ((dastat & 0xA) == 2) {
            this.gl.glViewport(Engine.windowx1, Engine.ydim - (Engine.windowy2 + 1), Engine.windowx2 - Engine.windowx1 + 1, Engine.windowy2 - Engine.windowy1 + 1);
        } else {
            this.gl.glViewport(0, 0, Engine.xdim, Engine.ydim);
            this.parent.glox1 = -1.0f;
        }
        this.gl.glMatrixMode(5889);
        if ((dastat & 0xA) == 2) {
            float ratioratio = (float)Engine.xdim / (float)Engine.ydim;
            this.parent.matrix[0][0] = (float)Engine.ydimen * (ratioratio >= 1.6f ? 1.2f : 1.0f);
            this.parent.matrix[0][2] = 1.0f;
            this.parent.matrix[1][1] = Engine.xdimen;
            this.parent.matrix[1][2] = 1.0f;
            this.parent.matrix[2][2] = 1.0f;
            this.parent.matrix[2][3] = (float)Engine.ydimen * (ratioratio >= 1.6f ? 1.2f : 1.0f);
            this.parent.matrix[3][2] = -1.0f;
        } else {
            this.parent.matrix[2][3] = 1.0f;
            this.parent.matrix[0][0] = 1.0f;
            this.parent.matrix[1][1] = (float)Engine.xdim / (float)Engine.ydim;
            this.parent.matrix[2][2] = 1.0001f;
            this.parent.matrix[3][2] = 1.0f - this.parent.matrix[2][2];
        }
        this.gl.glLoadMatrixf(this.parent.matrix);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        if ((hudInfo.flags & 8) != 0) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
            this.gl.glClear(256);
        }
        this.gl.glDisable(2912);
        this.parent.globalorientation = this.hudsprite.cstat;
        this.parent.mddraw(this.hudsprite, 0, 0);
        Engine.viewingrange = oldviewingrange;
        this.parent.gxyaspect = ogxyaspect;
        Engine.globalshade = ogshade;
        Engine.globalpal = ogpal;
        this.parent.gchang = ogchang;
        this.parent.gshang = ogshang;
        this.parent.gctang = ogctang;
        this.parent.gstang = ogstang;
    }

    @Override
    public void init() {
        if (this.polymosttext == null) {
            int j;
            int i;
            int tptr;
            this.polymosttext = BufferUtils.newIntBuffer(1);
            byte[] tbuf = new byte[32768];
            ByteBuffer fbuf = BufferUtils.newByteBuffer(32768);
            int h = 0;
            while (h < 256) {
                tptr = h % 32 * 8 + h / 32 * 256 * 8;
                i = 0;
                while (i < 8) {
                    j = 0;
                    while (j < 8) {
                        if ((Engine.textfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0) {
                            tbuf[tptr + j] = -1;
                        }
                        ++j;
                    }
                    tptr += 256;
                    ++i;
                }
                ++h;
            }
            h = 0;
            while (h < 256) {
                tptr = 16384 + h % 32 * 8 + h / 32 * 256 * 8;
                i = 1;
                while (i < 7) {
                    j = 2;
                    while (j < 6) {
                        if ((Engine.smalltextfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0) {
                            tbuf[tptr + j - 2] = -1;
                        }
                        ++j;
                    }
                    tptr += 256;
                    ++i;
                }
                ++h;
            }
            fbuf.put(tbuf);
            fbuf.rewind();
            this.gl.glBindTexture(3553, this.polymosttext);
            this.gl.glTexImage2D(3553, 0, 32841, 256, 128, 0, 6409, 5121, fbuf);
            this.gl.glTexParameteri(3553, 10240, 9728);
            this.gl.glTexParameteri(3553, 10241, 9728);
        }
    }

    @Override
    public void uninit() {
        if (this.polymosttext != null) {
            this.gl.glDeleteTextures(1, this.polymosttext);
        }
        this.polymosttext = null;
    }

    @Override
    public void nextpage() {
    }

    class raster {
        float x;
        float y;
        float xi;
        int i;

        raster() {
        }

        public void set(raster src) {
            this.x = src.x;
            this.y = src.y;
            this.xi = src.xi;
            this.i = src.i;
        }
    }
}

