/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Software;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.Software.PermFifo;
import ru.m210projects.Build.Render.Software.Software;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.TileFont;
import ru.m210projects.Build.Types.WALL;

public class SoftwareOrpho
extends OrphoRenderer {
    private Software parent;
    private Engine engine;
    private final int MAXPERMS;
    protected final int MAXNODESPERLINE = 42;
    protected int[] dotp1 = new int[3072];
    protected int[] dotp2 = new int[3072];
    protected final int MAXWALLSB = (Engine.MAXWALLS >> 2) + (Engine.MAXWALLS >> 3);
    protected short[] p2 = new short[this.MAXWALLSB];
    protected int[] xb1 = new int[this.MAXWALLSB];
    protected int[] xb2 = new int[this.MAXWALLSB];
    protected int[] rx1 = new int[this.MAXWALLSB];
    protected int[] rx2 = new int[this.MAXWALLSB];
    protected int[] ry1 = new int[this.MAXWALLSB];
    protected int[] ry2 = new int[this.MAXWALLSB];
    protected short globalpicnum;
    protected int globalorientation;
    protected int globalx1;
    protected int globaly1;
    protected int globalx2;
    protected int globaly2;
    protected int asm1;
    protected int asm2;
    protected int globalpolytype;
    public int[] nrx1 = new int[8];
    public int[] nry1 = new int[8];
    public int[] nrx2 = new int[8];
    public int[] nry2 = new int[8];

    public SoftwareOrpho(Software parent) {
        this.parent = parent;
        this.engine = parent.engine;
        parent.getClass();
        this.MAXPERMS = 512;
    }

    @Override
    public void printext(TileFont font, int xpos, int ypos, char[] text, int col, int shade, Renderer.Transparent bit, float scale) {
        if (font.type == TileFont.FontType.Tilemap) {
            int nTile;
            if (Engine.palookup[col] == null) {
                col = 0;
            }
            if (Engine.waloff[nTile = ((Integer)font.ptr).intValue()] == null && this.engine.loadtile(nTile) == null) {
                return;
            }
            int flags = 0;
            if (bit == Renderer.Transparent.Bit1) {
                flags = 1;
            }
            if (bit == Renderer.Transparent.Bit2) {
                flags = 33;
            }
            int mscale = (int)(scale * 65536.0f);
            int textsize = Pragmas.mulscale(font.charsizx, mscale, 16);
            int i = 0;
            while (i < text.length && text[i] != '\u0000') {
                if (xpos >= 0) {
                    float tx = (float)(text[i] % font.cols) / (float)font.cols;
                    float ty = (float)(text[i] / font.cols) / (float)font.rows;
                    int ctx = Pragmas.mulscale((int)(tx * (float)Engine.tilesizx[nTile]), mscale, 16);
                    int cty = Pragmas.mulscale((int)(ty * (float)Engine.tilesizy[nTile]), mscale, 16);
                    this.engine.rotatesprite(xpos - ctx << 16, ypos - cty << 16, mscale, 0, nTile, shade, col, 0x18 | flags, xpos, ypos, xpos + textsize - 1, ypos + textsize - 1);
                }
                ++i;
                xpos += textsize;
            }
        } else {
            int fontsize = 0;
            if (font.ptr == Engine.smalltextfont) {
                fontsize = 1;
            }
            this.printext(xpos, ypos, col, -1, text, fontsize, scale);
        }
    }

    @Override
    public void printext(int xpos, int ypos, int col, int backcol, char[] text, int fontsize, float scale) {
        int stx = xpos;
        int charxsiz = 8;
        int charysiz = (int)(scale * 7.0f);
        byte[] fontptr = Engine.textfont;
        if (fontsize != 0) {
            fontptr = Engine.smalltextfont;
            charxsiz = 4;
        }
        int i = 0;
        while (i < text.length && text[i] != '\u0000') {
            int ptr = this.parent.bytesperline * (ypos + charysiz) + (stx - fontsize);
            if (ptr >= 0) {
                int y = charysiz;
                while (y >= 0) {
                    int x = (int)(scale * (float)(charxsiz - 1));
                    while (x >= 0) {
                        if ((fontptr[Math.round((float)y / scale) + (text[i] << 3)] & Engine.pow2char[7 - fontsize - Math.round((float)x / scale)]) != 0) {
                            this.parent.getA().drawpixel(ptr + x, (byte)col);
                        } else if (backcol >= 0) {
                            this.parent.getA().drawpixel(ptr + x, (byte)backcol);
                        }
                        --x;
                    }
                    ptr -= this.parent.bytesperline;
                    --y;
                }
                stx = (int)((float)stx + scale * (float)charxsiz);
            }
            ++i;
        }
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int c) {
        byte col = Engine.palookup[0][c];
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx >= 0) {
            if (x1 >= Engine.wx2 || x2 < Engine.wx1) {
                return;
            }
            if (x1 < Engine.wx1) {
                y1 += Pragmas.scale(Engine.wx1 - x1, dy, dx);
                x1 = Engine.wx1;
            }
            if (x2 > Engine.wx2) {
                y2 += Pragmas.scale(Engine.wx2 - x2, dy, dx);
                x2 = Engine.wx2;
            }
        } else {
            if (x2 >= Engine.wx2 || x1 < Engine.wx1) {
                return;
            }
            if (x2 < Engine.wx1) {
                y2 += Pragmas.scale(Engine.wx1 - x2, dy, dx);
                x2 = Engine.wx1;
            }
            if (x1 > Engine.wx2) {
                y1 += Pragmas.scale(Engine.wx2 - x1, dy, dx);
                x1 = Engine.wx2;
            }
        }
        if (dy >= 0) {
            if (y1 >= Engine.wy2 || y2 < Engine.wy1) {
                return;
            }
            if (y1 < Engine.wy1) {
                x1 += Pragmas.scale(Engine.wy1 - y1, dx, dy);
                y1 = Engine.wy1;
            }
            if (y2 > Engine.wy2) {
                x2 += Pragmas.scale(Engine.wy2 - y2, dx, dy);
                y2 = Engine.wy2;
            }
        } else {
            if (y2 >= Engine.wy2 || y1 < Engine.wy1) {
                return;
            }
            if (y2 < Engine.wy1) {
                x2 += Pragmas.scale(Engine.wy1 - y2, dx, dy);
                y2 = Engine.wy1;
            }
            if (y1 > Engine.wy2) {
                x1 += Pragmas.scale(Engine.wy2 - y1, dx, dy);
                y1 = Engine.wy2;
            }
        }
        if (Pragmas.klabs(dx) >= Pragmas.klabs(dy)) {
            int i;
            if (dx == 0) {
                return;
            }
            if (dx < 0) {
                i = x1;
                x1 = x2;
                x2 = i;
                i = y1;
                y1 = y2;
                y2 = i;
            }
            int inc = Pragmas.divscale(dy, dx, 12);
            int plc = y1 + Pragmas.mulscale(2047 - x1 & 0xFFF, inc, 12);
            i = x1 + 2048 >> 12;
            int daend = x2 + 2048 >> 12;
            while (i < daend) {
                int j = plc >> 12;
                if (j >= this.parent.startumost[i] && j < this.parent.startdmost[i]) {
                    this.parent.getA().drawpixel(this.parent.ylookup[j] + i, col);
                }
                plc += inc;
                ++i;
            }
        } else {
            int i;
            if (dy < 0) {
                i = x1;
                x1 = x2;
                x2 = i;
                i = y1;
                y1 = y2;
                y2 = i;
            }
            int inc = Pragmas.divscale(dx, dy, 12);
            int plc = x1 + Pragmas.mulscale(2047 - y1 & 0xFFF, inc, 12);
            i = y1 + 2048 >> 12;
            int daend = y2 + 2048 >> 12;
            int p = this.parent.ylookup[i];
            while (i < daend) {
                int j = plc >> 12;
                if (i >= this.parent.startumost[j] && i < this.parent.startdmost[j]) {
                    this.parent.getA().drawpixel(p + j, col);
                }
                plc += inc;
                p += this.parent.ylookup[1];
                ++i;
            }
        }
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        int baky1;
        int bakx1;
        int y;
        int x;
        int oy;
        int ox;
        int j;
        int i;
        int npoints;
        SECTOR sec = null;
        Engine.beforedrawrooms = 0;
        Arrays.fill(Engine.gotsector, (byte)0);
        int cx1 = Engine.windowx1 << 12;
        int cy1 = Engine.windowy1 << 12;
        int cx2 = (Engine.windowx2 + 1 << 12) - 1;
        int cy2 = (Engine.windowy2 + 1 << 12) - 1;
        int bakgxvect = Pragmas.divscale(Engine.sintable[1536 - ang & 0x7FF], zoome <<= 8, 28);
        int bakgyvect = Pragmas.divscale(Engine.sintable[2048 - ang & 0x7FF], zoome, 28);
        int xvect = Pragmas.mulscale(Engine.sintable[2048 - ang & 0x7FF], zoome, 8);
        int yvect = Pragmas.mulscale(Engine.sintable[1536 - ang & 0x7FF], zoome, 8);
        int xvect2 = Pragmas.mulscale(xvect, Engine.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, Engine.yxaspect, 16);
        int sortnum = 0;
        int s = 0;
        while (s < Engine.numsectors) {
            block44: {
                block46: {
                    int startwall;
                    block45: {
                        sec = Engine.sector[s];
                        if (!this.fullmap && (Engine.show2dsector[s >> 3] & Engine.pow2char[s & 7]) == 0) break block44;
                        npoints = 0;
                        i = 0;
                        j = startwall = sec.wallptr;
                        if (startwall < 0) break block44;
                        int w = sec.wallnum;
                        while (w > 0) {
                            WALL wal = Engine.wall[j];
                            if (wal != null) {
                                ox = wal.x - dax;
                                oy = wal.y - day;
                                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                                this.rx1[npoints] = x;
                                this.ry1[npoints] = y;
                                this.xb1[npoints] = wal.point2 - startwall;
                                if (this.xb1[npoints] < 0) {
                                    this.xb1[npoints] = 0;
                                }
                                ++npoints;
                            }
                            --w;
                            ++j;
                        }
                        if ((i & 0xF0) != 240) break block44;
                        bakx1 = this.rx1[0];
                        baky1 = Pragmas.mulscale(this.ry1[0] - (Engine.ydim << 11), Engine.xyaspect, 16) + (Engine.ydim << 11);
                        if ((i & 0xF) != 0 && (npoints = this.clippoly(npoints, i)) < 3) break block44;
                        if (this.showflspr) {
                            i = Engine.headspritesect[s];
                            while (i >= 0) {
                                if ((Engine.sprite[i].cstat & 0x30) == 32 && sortnum < 1024 && (Engine.sprite[i].cstat & 0x48) != 72) {
                                    if (Engine.tsprite[sortnum] == null) {
                                        Engine.tsprite[sortnum] = new SPRITE();
                                    }
                                    Engine.tsprite[sortnum].set(Engine.sprite[i]);
                                    Engine.tsprite[sortnum++].owner = (short)i;
                                }
                                i = Engine.nextspritesect[i];
                            }
                        }
                        int n = s >> 3;
                        Engine.gotsector[n] = (byte)(Engine.gotsector[n] | Engine.pow2char[s & 7]);
                        this.globalorientation = sec.floorstat;
                        if ((this.globalorientation & 1) != 0) break block44;
                        Engine.globalpal = sec.floorpal;
                        if (sec.floorpal != this.parent.globalpalwritten) {
                            this.parent.globalpalwritten = sec.floorpal;
                            this.parent.getA().setpalookupaddress(Engine.palookup[this.parent.globalpalwritten]);
                        }
                        this.globalpicnum = sec.floorpicnum;
                        if (this.globalpicnum >= Engine.MAXTILES) {
                            this.globalpicnum = 0;
                        }
                        this.engine.setgotpic(this.globalpicnum);
                        if (Engine.tilesizx[this.globalpicnum] <= 0 || Engine.tilesizy[this.globalpicnum] <= 0) break block44;
                        if ((Engine.picanm[this.globalpicnum] & 0xC0) != 0) {
                            this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, s));
                        }
                        if (Engine.waloff[this.globalpicnum] == null) {
                            this.engine.loadtile(this.globalpicnum);
                        }
                        this.parent.globalbufplc = Engine.waloff[this.globalpicnum];
                        Engine.globalshade = Math.max(Math.min(sec.floorshade, Engine.numshades - 1), 0);
                        if ((this.globalorientation & 0x40) != 0) break block45;
                        Engine.globalposx = dax;
                        this.globalx1 = bakgxvect;
                        this.globaly1 = bakgyvect;
                        Engine.globalposy = day;
                        this.globalx2 = bakgxvect;
                        this.globaly2 = bakgyvect;
                        break block46;
                    }
                    ox = Engine.wall[Engine.wall[startwall].point2].x - Engine.wall[startwall].x;
                    oy = Engine.wall[Engine.wall[startwall].point2].y - Engine.wall[startwall].y;
                    i = this.engine.ksqrt(ox * ox + oy * oy);
                    if (i == 0) break block44;
                    i = 0x100000 / i;
                    this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                    this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                    ox = (bakx1 >> 4) - (Engine.xdim << 7);
                    oy = (baky1 >> 4) - (Engine.ydim << 7);
                    Engine.globalposx = Pragmas.dmulscale(-oy, this.globalx1, -ox, this.globaly1, 28);
                    Engine.globalposy = Pragmas.dmulscale(-ox, this.globalx1, oy, this.globaly1, 28);
                    this.globalx2 = -this.globalx1;
                    this.globaly2 = -this.globaly1;
                    short daslope = Engine.sector[s].floorheinum;
                    i = this.engine.ksqrt(daslope * daslope + 0x1000000);
                    Engine.globalposy = Pragmas.mulscale(Engine.globalposy, i, 12);
                    this.globalx2 = Pragmas.mulscale(this.globalx2, i, 12);
                    this.globaly2 = Pragmas.mulscale(this.globaly2, i, 12);
                }
                int globalxshift = 8 - (Engine.picsiz[this.globalpicnum] & 0xF);
                int globalyshift = 8 - (Engine.picsiz[this.globalpicnum] >> 4);
                if ((this.globalorientation & 8) != 0) {
                    ++globalxshift;
                    ++globalyshift;
                }
                this.parent.globvis = this.parent.globalhisibility;
                if (sec.visibility != 0) {
                    this.parent.globvis = Pragmas.mulscale(this.parent.globvis, sec.visibility + 16 & 0xFF, 4);
                }
                this.globalpolytype = 0;
                if ((this.globalorientation & 4) > 0) {
                    i = Engine.globalposx;
                    Engine.globalposx = -Engine.globalposy;
                    Engine.globalposy = -i;
                    i = this.globalx2;
                    this.globalx2 = this.globaly1;
                    this.globaly1 = i;
                    i = this.globalx1;
                    this.globalx1 = -this.globaly2;
                    this.globaly2 = -i;
                }
                if ((this.globalorientation & 0x10) > 0) {
                    this.globalx1 = -this.globalx1;
                    this.globaly1 = -this.globaly1;
                    Engine.globalposx = -Engine.globalposx;
                }
                if ((this.globalorientation & 0x20) > 0) {
                    this.globalx2 = -this.globalx2;
                    this.globaly2 = -this.globaly2;
                    Engine.globalposy = -Engine.globalposy;
                }
                this.asm1 = this.globaly1 << globalxshift;
                this.asm2 = this.globalx2 << globalyshift;
                this.globalx1 <<= globalxshift;
                this.globaly2 <<= globalyshift;
                Engine.globalposx = (Engine.globalposx << 20 + globalxshift) + (sec.floorxpanning << 24);
                Engine.globalposy = (Engine.globalposy << 20 + globalyshift) - (sec.floorypanning << 24);
                this.fillpolygon(npoints);
            }
            ++s;
        }
        if (this.showspr) {
            int gap = 1;
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                i = 0;
                while (i < sortnum - gap) {
                    j = i;
                    while (j >= 0) {
                        if (Engine.sprite[Engine.tsprite[j].owner].z <= Engine.sprite[Engine.tsprite[j + gap].owner].z) break;
                        short tmp = Engine.tsprite[j].owner;
                        Engine.tsprite[j].owner = Engine.tsprite[j + gap].owner;
                        Engine.tsprite[j + gap].owner = tmp;
                        j -= gap;
                    }
                    ++i;
                }
                gap >>= 1;
            }
            s = sortnum - 1;
            while (s >= 0) {
                SPRITE spr = Engine.sprite[Engine.tsprite[s].owner];
                if ((spr.cstat & 0x30) == 32) {
                    npoints = 0;
                    short tilenum = spr.picnum;
                    int xoff = (byte)(Engine.picanm[tilenum] >> 8 & 0xFF) + spr.xoffset;
                    int yoff = (byte)(Engine.picanm[tilenum] >> 16 & 0xFF) + spr.yoffset;
                    if ((spr.cstat & 4) > 0) {
                        xoff = -xoff;
                    }
                    if ((spr.cstat & 8) > 0) {
                        yoff = -yoff;
                    }
                    int k = spr.ang & 0x7FF;
                    short cosang = Engine.sintable[k + 512 & 0x7FF];
                    short sinang = Engine.sintable[k];
                    short xspan = Engine.tilesizx[tilenum];
                    short xrepeat = spr.xrepeat;
                    short yspan = Engine.tilesizy[tilenum];
                    short yrepeat = spr.yrepeat;
                    ox = ((xspan >> 1) + xoff) * xrepeat;
                    oy = ((yspan >> 1) + yoff) * yrepeat;
                    int x1 = spr.x + Pragmas.mulscale(sinang, ox, 16) + Pragmas.mulscale(cosang, oy, 16);
                    int y1 = spr.y + Pragmas.mulscale(sinang, oy, 16) - Pragmas.mulscale(cosang, ox, 16);
                    int l = xspan * xrepeat;
                    int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                    int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                    l = yspan * yrepeat;
                    k = -Pragmas.mulscale(cosang, l, 16);
                    int x3 = x2 + k;
                    int x4 = x1 + k;
                    k = -Pragmas.mulscale(sinang, l, 16);
                    int y3 = y2 + k;
                    int y4 = y1 + k;
                    this.xb1[0] = 1;
                    this.xb1[1] = 2;
                    this.xb1[2] = 3;
                    this.xb1[3] = 0;
                    npoints = 4;
                    i = 0;
                    ox = x1 - dax;
                    oy = y1 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[0] = x;
                    this.ry1[0] = y;
                    ox = x2 - dax;
                    oy = y2 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[1] = x;
                    this.ry1[1] = y;
                    ox = x3 - dax;
                    oy = y3 - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (Engine.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (Engine.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[2] = x;
                    this.ry1[2] = y;
                    x = this.rx1[0] + this.rx1[2] - this.rx1[1];
                    y = this.ry1[0] + this.ry1[2] - this.ry1[1];
                    this.rx1[3] = x;
                    this.ry1[3] = y;
                    if (((i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y)) & 0xF0) == 240) {
                        bakx1 = this.rx1[0];
                        baky1 = Pragmas.mulscale(this.ry1[0] - (Engine.ydim << 11), Engine.xyaspect, 16) + (Engine.ydim << 11);
                        if ((i & 0xF) == 0 || (npoints = this.clippoly(npoints, i)) >= 3) {
                            this.globalpicnum = spr.picnum;
                            Engine.globalpal = spr.pal;
                            if (this.globalpicnum >= Engine.MAXTILES) {
                                this.globalpicnum = 0;
                            }
                            this.engine.setgotpic(this.globalpicnum);
                            if (Engine.tilesizx[this.globalpicnum] > 0 && Engine.tilesizy[this.globalpicnum] > 0) {
                                if ((Engine.picanm[this.globalpicnum] & 0xC0) != 0) {
                                    this.globalpicnum = (short)(this.globalpicnum + this.engine.animateoffs(this.globalpicnum, s));
                                }
                                if (Engine.waloff[this.globalpicnum] == null) {
                                    this.engine.loadtile(this.globalpicnum);
                                }
                                this.parent.globalbufplc = Engine.waloff[this.globalpicnum];
                                Engine.globalshade = (Engine.sector[spr.sectnum].ceilingstat & 1) > 0 ? (int)Engine.sector[spr.sectnum].ceilingshade : (int)Engine.sector[spr.sectnum].floorshade;
                                Engine.globalshade = Math.max(Math.min(Engine.globalshade + spr.shade + 6, Engine.numshades - 1), 0);
                                this.parent.globvis = this.parent.globalhisibility;
                                if (sec.visibility != 0) {
                                    this.parent.globvis = Pragmas.mulscale(this.parent.globvis, sec.visibility + 16 & 0xFF, 4);
                                }
                                this.globalpolytype = ((spr.cstat & 2) >> 1) + 1;
                                this.parent.getA().setuphline(Engine.palookup[spr.pal], Engine.globalshade << 8);
                                ox = x2 - x1;
                                oy = y2 - y1;
                                i = ox * ox + oy * oy;
                                if (i != 0) {
                                    i = 0x40000000 / i;
                                    this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                                    this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                                    ox = y1 - y4;
                                    oy = x4 - x1;
                                    i = ox * ox + oy * oy;
                                    if (i != 0) {
                                        i = 0x40000000 / i;
                                        this.globalx2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                                        this.globaly2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                                        ox = Engine.picsiz[this.globalpicnum];
                                        oy = ox >> 4 & 0xF;
                                        if (Engine.pow2long[ox &= 0xF] != xspan) {
                                            this.globalx1 = Pragmas.mulscale(this.globalx1, xspan, ++ox);
                                            this.globaly1 = Pragmas.mulscale(this.globaly1, xspan, ox);
                                        }
                                        bakx1 = (bakx1 >> 4) - (Engine.xdim << 7);
                                        baky1 = (baky1 >> 4) - (Engine.ydim << 7);
                                        Engine.globalposx = Pragmas.dmulscale(-baky1, this.globalx1, -bakx1, this.globaly1, 28);
                                        Engine.globalposy = Pragmas.dmulscale(bakx1, this.globalx2, -baky1, this.globaly2, 28);
                                        if ((spr.cstat & 2) == 0) {
                                            this.parent.getA().msethlineshift(ox, oy);
                                        } else {
                                            if ((spr.cstat & 0x200) != 0) {
                                                this.parent.getA().settransreverse();
                                            } else {
                                                this.parent.getA().settransnormal();
                                            }
                                            this.parent.getA().tsethlineshift(ox, oy);
                                        }
                                        if ((spr.cstat & 4) > 0) {
                                            this.globalx1 = -this.globalx1;
                                            this.globaly1 = -this.globaly1;
                                            Engine.globalposx = -Engine.globalposx;
                                        }
                                        this.asm1 = this.globaly1 << 2;
                                        this.globalx1 <<= 2;
                                        Engine.globalposx <<= 22;
                                        this.asm2 = this.globalx2 << 2;
                                        this.globaly2 <<= 2;
                                        Engine.globalposy <<= 22;
                                        this.globalorientation = (spr.cstat & 2) << 7 | (spr.cstat & 0x200) >> 2;
                                        this.fillpolygon(npoints);
                                    }
                                }
                            }
                        }
                    }
                }
                --s;
            }
        }
    }

    private int clippoly(int npoints, int clipstat) {
        int t;
        int z4;
        short z3;
        int z2;
        short z1;
        int s1;
        int zz;
        int s2;
        int splitcnt;
        int z;
        int start2;
        int npoints2;
        int cx1 = Engine.windowx1;
        int cy1 = Engine.windowy1;
        int cx2 = Engine.windowx2 + 1;
        int cy2 = Engine.windowy2 + 1;
        cx1 <<= 12;
        cy1 <<= 12;
        cx2 <<= 12;
        cy2 <<= 12;
        if ((clipstat & 0xA) != 0) {
            npoints2 = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = cx1 - this.rx1[z];
                do {
                    zz = this.xb1[z];
                    this.xb1[z] = -1;
                    s1 = s2;
                    s2 = cx1 - this.rx1[zz];
                    if (s1 < 0) {
                        this.rx2[npoints2] = this.rx1[z];
                        this.ry2[npoints2] = this.ry1[z];
                        this.xb2[npoints2] = npoints2 + 1;
                        ++npoints2;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx2[npoints2] = this.rx1[z] + Pragmas.scale(this.rx1[zz] - this.rx1[z], s1, s1 - s2);
                    this.ry2[npoints2] = this.ry1[z] + Pragmas.scale(this.ry1[zz] - this.ry1[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints2;
                    }
                    this.xb2[npoints2] = npoints2 + 1;
                    ++npoints2;
                } while (this.xb1[z = zz] >= 0);
                if (npoints2 >= start2 + 3) {
                    this.xb2[npoints2 - 1] = start2;
                    start2 = npoints2;
                } else {
                    npoints2 = start2;
                }
                z = 1;
                while (z < npoints && this.xb1[z] < 0) {
                    ++z;
                }
            } while (z < npoints);
            if (npoints2 <= 2) {
                return 0;
            }
            z = 1;
            while (z < splitcnt) {
                zz = 0;
                while (zz < z) {
                    z1 = this.p2[z];
                    z2 = this.xb2[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb2[z3];
                    s1 = Pragmas.klabs(this.rx2[z1] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z2]);
                    s2 = Pragmas.klabs(this.rx2[z1] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z4]);
                    if ((s2 += Pragmas.klabs(this.rx2[z3] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z2])) < (s1 += Pragmas.klabs(this.rx2[z3] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z4]))) {
                        t = this.xb2[this.p2[z]];
                        this.xb2[this.p2[z]] = this.xb2[this.p2[zz]];
                        this.xb2[this.p2[zz]] = t;
                    }
                    ++zz;
                }
                ++z;
            }
            npoints = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = cy1 - this.ry2[z];
                do {
                    zz = this.xb2[z];
                    this.xb2[z] = -1;
                    s1 = s2;
                    s2 = cy1 - this.ry2[zz];
                    if (s1 < 0) {
                        this.rx1[npoints] = this.rx2[z];
                        this.ry1[npoints] = this.ry2[z];
                        this.xb1[npoints] = npoints + 1;
                        ++npoints;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx1[npoints] = this.rx2[z] + Pragmas.scale(this.rx2[zz] - this.rx2[z], s1, s1 - s2);
                    this.ry1[npoints] = this.ry2[z] + Pragmas.scale(this.ry2[zz] - this.ry2[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints;
                    }
                    this.xb1[npoints] = npoints + 1;
                    ++npoints;
                } while (this.xb2[z = zz] >= 0);
                if (npoints >= start2 + 3) {
                    this.xb1[npoints - 1] = start2;
                    start2 = npoints;
                } else {
                    npoints = start2;
                }
                z = 1;
                while (z < npoints2 && this.xb2[z] < 0) {
                    ++z;
                }
            } while (z < npoints2);
            if (npoints <= 2) {
                return 0;
            }
            z = 1;
            while (z < splitcnt) {
                zz = 0;
                while (zz < z) {
                    z1 = this.p2[z];
                    z2 = this.xb1[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb1[z3];
                    s1 = Pragmas.klabs(this.rx1[z1] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z2]);
                    s2 = Pragmas.klabs(this.rx1[z1] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z4]);
                    if ((s2 += Pragmas.klabs(this.rx1[z3] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z2])) < (s1 += Pragmas.klabs(this.rx1[z3] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z4]))) {
                        t = this.xb1[this.p2[z]];
                        this.xb1[this.p2[z]] = this.xb1[this.p2[zz]];
                        this.xb1[this.p2[zz]] = t;
                    }
                    ++zz;
                }
                ++z;
            }
        }
        if ((clipstat & 5) != 0) {
            npoints2 = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = this.rx1[z] - cx2;
                do {
                    zz = this.xb1[z];
                    this.xb1[z] = -1;
                    s1 = s2;
                    s2 = this.rx1[zz] - cx2;
                    if (s1 < 0) {
                        this.rx2[npoints2] = this.rx1[z];
                        this.ry2[npoints2] = this.ry1[z];
                        this.xb2[npoints2] = npoints2 + 1;
                        ++npoints2;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx2[npoints2] = this.rx1[z] + Pragmas.scale(this.rx1[zz] - this.rx1[z], s1, s1 - s2);
                    this.ry2[npoints2] = this.ry1[z] + Pragmas.scale(this.ry1[zz] - this.ry1[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints2;
                    }
                    this.xb2[npoints2] = npoints2 + 1;
                    ++npoints2;
                } while (this.xb1[z = zz] >= 0);
                if (npoints2 >= start2 + 3) {
                    this.xb2[npoints2 - 1] = start2;
                    start2 = npoints2;
                } else {
                    npoints2 = start2;
                }
                z = 1;
                while (z < npoints && this.xb1[z] < 0) {
                    ++z;
                }
            } while (z < npoints);
            if (npoints2 <= 2) {
                return 0;
            }
            z = 1;
            while (z < splitcnt) {
                zz = 0;
                while (zz < z) {
                    z1 = this.p2[z];
                    z2 = this.xb2[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb2[z3];
                    s1 = Pragmas.klabs(this.rx2[z1] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z2]);
                    s2 = Pragmas.klabs(this.rx2[z1] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z1] - this.ry2[z4]);
                    if ((s2 += Pragmas.klabs(this.rx2[z3] - this.rx2[z2]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z2])) < (s1 += Pragmas.klabs(this.rx2[z3] - this.rx2[z4]) + Pragmas.klabs(this.ry2[z3] - this.ry2[z4]))) {
                        t = this.xb2[this.p2[z]];
                        this.xb2[this.p2[z]] = this.xb2[this.p2[zz]];
                        this.xb2[this.p2[zz]] = t;
                    }
                    ++zz;
                }
                ++z;
            }
            npoints = 0;
            start2 = 0;
            z = 0;
            splitcnt = 0;
            do {
                s2 = this.ry2[z] - cy2;
                do {
                    zz = this.xb2[z];
                    this.xb2[z] = -1;
                    s1 = s2;
                    s2 = this.ry2[zz] - cy2;
                    if (s1 < 0) {
                        this.rx1[npoints] = this.rx2[z];
                        this.ry1[npoints] = this.ry2[z];
                        this.xb1[npoints] = npoints + 1;
                        ++npoints;
                    }
                    if ((s1 ^ s2) >= 0) continue;
                    this.rx1[npoints] = this.rx2[z] + Pragmas.scale(this.rx2[zz] - this.rx2[z], s1, s1 - s2);
                    this.ry1[npoints] = this.ry2[z] + Pragmas.scale(this.ry2[zz] - this.ry2[z], s1, s1 - s2);
                    if (s1 < 0) {
                        this.p2[splitcnt++] = (short)npoints;
                    }
                    this.xb1[npoints] = npoints + 1;
                    ++npoints;
                } while (this.xb2[z = zz] >= 0);
                if (npoints >= start2 + 3) {
                    this.xb1[npoints - 1] = start2;
                    start2 = npoints;
                } else {
                    npoints = start2;
                }
                z = 1;
                while (z < npoints2 && this.xb2[z] < 0) {
                    ++z;
                }
            } while (z < npoints2);
            if (npoints <= 2) {
                return 0;
            }
            z = 1;
            while (z < splitcnt) {
                zz = 0;
                while (zz < z) {
                    z1 = this.p2[z];
                    z2 = this.xb1[z1];
                    z3 = this.p2[zz];
                    z4 = this.xb1[z3];
                    s1 = Pragmas.klabs(this.rx1[z1] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z2]);
                    s2 = Pragmas.klabs(this.rx1[z1] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z1] - this.ry1[z4]);
                    if ((s2 += Pragmas.klabs(this.rx1[z3] - this.rx1[z2]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z2])) < (s1 += Pragmas.klabs(this.rx1[z3] - this.rx1[z4]) + Pragmas.klabs(this.ry1[z3] - this.ry1[z4]))) {
                        t = this.xb1[this.p2[z]];
                        this.xb1[this.p2[z]] = this.xb1[this.p2[zz]];
                        this.xb1[this.p2[zz]] = t;
                    }
                    ++zz;
                }
                ++z;
            }
        }
        return npoints;
    }

    private void fillpolygon(int npoints) {
        int x2;
        int x1;
        int day2;
        int zz;
        int day1;
        int y;
        this.parent.getA().sethlinesizes(Engine.picsiz[this.globalpicnum] & 0xF, Engine.picsiz[this.globalpicnum] >> 4, this.parent.globalbufplc);
        int miny = Integer.MAX_VALUE;
        int maxy = Integer.MIN_VALUE;
        int z = npoints - 1;
        while (z >= 0) {
            y = this.ry1[z];
            miny = Math.min(miny, y);
            maxy = Math.max(maxy, y);
            --z;
        }
        maxy >>= 12;
        if ((miny >>= 12) < 0) {
            miny = 0;
        }
        if (maxy >= Engine.ydim) {
            maxy = Engine.ydim - 1;
        }
        int ptr = 0;
        y = miny;
        while (y <= maxy) {
            this.dotp1[y] = ptr;
            this.dotp2[y] = ptr + 21;
            ptr += 42;
            ++y;
        }
        z = npoints - 1;
        while (z >= 0) {
            int y1 = this.ry1[z];
            day1 = y1 >> 12;
            zz = this.xb1[z];
            int y2 = this.ry1[zz];
            day2 = y2 >> 12;
            if (day1 != day2) {
                x1 = this.rx1[z];
                x2 = this.rx1[zz];
                int xinc = Pragmas.divscale(x2 - x1, y2 - y1, 12);
                if (day2 > day1) {
                    x1 += Pragmas.mulscale((day1 << 12) + 4095 - y1, xinc, 12);
                    y = day1;
                    while (y < day2) {
                        int n = y++;
                        int n2 = this.dotp2[n];
                        this.dotp2[n] = n2 + 1;
                        this.parent.smost[n2] = (short)(x1 >> 12);
                        x1 += xinc;
                    }
                } else {
                    x2 += Pragmas.mulscale((day2 << 12) + 4095 - y2, xinc, 12);
                    y = day2;
                    while (y < day1) {
                        int n = y++;
                        int n3 = this.dotp1[n];
                        this.dotp1[n] = n3 + 1;
                        this.parent.smost[n3] = (short)(x2 >> 12);
                        x2 += xinc;
                    }
                }
            }
            --z;
        }
        this.globalx1 = Pragmas.mulscale(this.globalx1, Engine.xyaspect, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, Engine.xyaspect, 16);
        int oy = miny + 1 - (Engine.ydim >> 1);
        Engine.globalposx += oy * this.globalx1;
        Engine.globalposy += oy * this.globaly2;
        this.parent.getA().setuphlineasm4(this.asm1, this.asm2);
        ptr = 0;
        y = miny;
        while (y <= maxy) {
            int cnt = this.dotp1[y] - ptr;
            int ptr2 = ptr + 21;
            z = cnt - 1;
            while (z >= 0) {
                day1 = 0;
                day2 = 0;
                zz = z;
                while (zz > 0) {
                    if (this.parent.smost[ptr + zz] < this.parent.smost[ptr + day1]) {
                        day1 = zz;
                    }
                    if (this.parent.smost[ptr2 + zz] < this.parent.smost[ptr2 + day2]) {
                        day2 = zz;
                    }
                    --zz;
                }
                x1 = this.parent.smost[ptr + day1];
                this.parent.smost[ptr + day1] = this.parent.smost[ptr + z];
                x2 = this.parent.smost[ptr2 + day2] - 1;
                this.parent.smost[ptr2 + day2] = this.parent.smost[ptr2 + z];
                if (x1 <= x2) {
                    int p;
                    int by;
                    int bx;
                    int ox;
                    if (this.globalpolytype < 1) {
                        ox = x2 + 1 - (Engine.xdim >> 1);
                        bx = ox * this.asm1 + Engine.globalposx;
                        by = ox * this.asm2 - Engine.globalposy;
                        p = this.parent.ylookup[y] + x2;
                        this.parent.getA().hlineasm4(x2 - x1, -1, Engine.globalshade << 8, by, bx, p);
                    } else {
                        ox = x1 + 1 - (Engine.xdim >> 1);
                        bx = ox * this.asm1 + Engine.globalposx;
                        by = ox * this.asm2 - Engine.globalposy;
                        p = this.parent.ylookup[y] + x1;
                        if (this.globalpolytype == 1) {
                            this.parent.getA().mhline(this.parent.globalbufplc, bx, x2 - x1 << 16, 0, by, p);
                        } else {
                            this.parent.getA().thline(this.parent.globalbufplc, bx, x2 - x1 << 16, 0, by, p);
                        }
                    }
                }
                --z;
            }
            Engine.globalposx += this.globalx1;
            Engine.globalposy += this.globaly2;
            ptr += 42;
            ++y;
        }
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        if ((Engine.picanm[picnum] & 0xC0) != 0) {
            picnum += this.engine.animateoffs((short)picnum, 49152);
        }
        if (Engine.tilesizx[picnum] <= 0 || Engine.tilesizy[picnum] <= 0) {
            return;
        }
        if ((dastat & 0x80) == 0 || this.parent.numpages < 2 || Engine.beforedrawrooms != 0) {
            this.dorotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, this.parent.guniqhudid);
        }
        if ((dastat & 0x40) != 0 && cx1 <= 0 && cy1 <= 0 && cx2 >= Engine.xdim - 1 && cy2 >= Engine.ydim - 1 && sx == 0xA00000 && sy == 0x640000 && (long)z == 65536L && a == 0 && (dastat & 1) == 0) {
            this.parent.permtail = 0;
            this.parent.permhead = 0;
        }
        if ((dastat & 0x80) == 0) {
            return;
        }
        if (this.parent.numpages >= 2) {
            PermFifo per = this.parent.permfifo[this.parent.permhead];
            if (per == null) {
                per = new PermFifo();
            }
            per.sx = sx;
            per.sy = sy;
            per.z = z;
            per.a = (short)a;
            per.picnum = (short)picnum;
            per.dashade = (short)dashade;
            per.dapalnum = (short)dapalnum;
            per.dastat = (short)dastat;
            per.pagesleft = (short)(this.parent.numpages + ((Engine.beforedrawrooms & 1) << 7));
            per.cx1 = cx1;
            per.cy1 = cy1;
            per.cx2 = cx2;
            per.cy2 = cy2;
            per.uniqid = this.parent.guniqhudid;
            if ((dastat & 0x40) != 0) {
                PermFifo per2;
                int i = this.parent.permtail;
                while (i != this.parent.permhead) {
                    per2 = this.parent.permfifo[i];
                    if (per2 == null) {
                        per2 = new PermFifo();
                    }
                    if ((per2.pagesleft & 0x7F) != 0 && per2.sx == per.sx && per2.sy == per.sy && per2.z == per.z && per2.a == per.a && Engine.tilesizx[per2.picnum] <= Engine.tilesizx[per.picnum] && Engine.tilesizy[per2.picnum] <= Engine.tilesizy[per.picnum] && per2.cx1 >= per.cx1 && per2.cy1 >= per.cy1 && per2.cx2 <= per.cx2 && per2.cy2 <= per.cy2) {
                        per2.pagesleft = 0;
                    }
                    i = i + 1 & this.MAXPERMS - 1;
                }
                if (per.z == 65536 && per.a == 0) {
                    i = this.parent.permtail;
                    while (i != this.parent.permhead) {
                        per2 = this.parent.permfifo[i];
                        if (per2 == null) {
                            per2 = new PermFifo();
                        }
                        if ((per2.pagesleft & 0x7F) != 0 && per2.z == 65536 && per2.a == 0 && per2.cx1 >= per.cx1 && per2.cy1 >= per.cy1 && per2.cx2 <= per.cx2 && per2.cy2 <= per.cy2 && per2.sx >> 16 >= per.sx >> 16 && per2.sy >> 16 >= per.sy >> 16 && (per2.sx >> 16) + Engine.tilesizx[per2.picnum] <= (per.sx >> 16) + Engine.tilesizx[per.picnum] && (per2.sy >> 16) + Engine.tilesizy[per2.picnum] <= (per.sy >> 16) + Engine.tilesizy[per.picnum]) {
                            per2.pagesleft = 0;
                        }
                        i = i + 1 & this.MAXPERMS - 1;
                    }
                }
            }
            this.parent.permhead = this.parent.permhead + 1 & this.MAXPERMS - 1;
        }
    }

    private void dorotatesprite(int sx, int sy, int z, int ang, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int yv2;
        int xv2;
        if (dapalnum < 0 || dapalnum >= Engine.palookup.length || Engine.palookup[dapalnum] == null) {
            dapalnum = 0;
        }
        if (cx1 < 0) {
            cx1 = 0;
        }
        if (cy1 < 0) {
            cy1 = 0;
        }
        if (cx2 > Engine.xdim - 1) {
            cx2 = Engine.xdim - 1;
        }
        if (cy2 > Engine.ydim - 1) {
            cy2 = Engine.ydim - 1;
        }
        short xsiz = Engine.tilesizx[picnum];
        short ysiz = Engine.tilesizy[picnum];
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = (byte)(Engine.picanm[picnum] >> 8 & 0xFF) + (xsiz >> 1);
            yoff = (byte)(Engine.picanm[picnum] >> 16 & 0xFF) + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        short cosang = Engine.sintable[ang + 512 & 0x7FF];
        short sinang = Engine.sintable[ang & 0x7FF];
        int ourxyaspect = Engine.xyaspect;
        int ouryxaspect = Engine.yxaspect;
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * Engine.xdim) {
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = Engine.xdim;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * Engine.ydim <= 3 * xdim) {
                xdim = 4 * Engine.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = Engine.windowx1 + Engine.windowx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(Engine.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = Engine.xdimenscale;
                sy = (Engine.windowy1 + Engine.windowy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + 32768 + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (Engine.ydim << 15) + 32768 + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        int xv = Pragmas.mulscale(cosang, z, 14);
        int yv = Pragmas.mulscale(sinang, z, 14);
        if ((dastat & 2) != 0 || (dastat & 8) == 0) {
            xv2 = Pragmas.mulscale(xv, ourxyaspect, 16);
            yv2 = Pragmas.mulscale(yv, ourxyaspect, 16);
        } else {
            xv2 = xv;
            yv2 = yv;
        }
        this.nry1[0] = sy - (yv * xoff + xv * yoff);
        this.nry1[1] = this.nry1[0] + yv * xsiz;
        this.nry1[3] = this.nry1[0] + xv * ysiz;
        this.nry1[2] = this.nry1[1] + this.nry1[3] - this.nry1[0];
        int i = cy1 << 16;
        if (this.nry1[0] < i && this.nry1[1] < i && this.nry1[2] < i && this.nry1[3] < i) {
            return;
        }
        i = cy2 << 16;
        if (this.nry1[0] > i && this.nry1[1] > i && this.nry1[2] > i && this.nry1[3] > i) {
            return;
        }
        this.nrx1[0] = sx - (xv2 * xoff - yv2 * yoff);
        this.nrx1[1] = this.nrx1[0] + xv2 * xsiz;
        this.nrx1[3] = this.nrx1[0] - yv2 * ysiz;
        this.nrx1[2] = this.nrx1[1] + this.nrx1[3] - this.nrx1[0];
        i = cx1 << 16;
        if (this.nrx1[0] < i && this.nrx1[1] < i && this.nrx1[2] < i && this.nrx1[3] < i) {
            return;
        }
        i = cx2 << 16;
        if (this.nrx1[0] > i && this.nrx1[1] > i && this.nrx1[2] > i && this.nrx1[3] > i) {
            return;
        }
        int gx1 = this.nrx1[0];
        int gy1 = this.nry1[0];
        int npoints = this.clippoly4(cx1 << 16, cy1 << 16, cx2 + 1 << 16, cy2 + 1 << 16);
        if (npoints < 3) {
            return;
        }
        int lx = this.nrx1[0];
        int rx = this.nrx1[0];
        int nextv = 0;
        int v = npoints - 1;
        while (v >= 0) {
            int x1 = this.nrx1[v];
            int x2 = this.nrx1[nextv];
            int dax1 = x1 >> 16;
            if (x1 < lx) {
                lx = x1;
            }
            int dax2 = x2 >> 16;
            if (x1 > rx) {
                rx = x1;
            }
            if (dax1 != dax2) {
                int yplc;
                int y1 = this.nry1[v];
                int y2 = this.nry1[nextv];
                long yinc = Pragmas.divscale(y2 - y1, x2 - x1, 16);
                if (dax2 > dax1) {
                    yplc = y1 + Pragmas.mulscale((dax1 << 16) + 65535 - x1, yinc, 16);
                    this.parent.qinterpolatedown16short(this.parent.uplc, dax1, dax2 - dax1, yplc, yinc);
                } else {
                    yplc = y2 + Pragmas.mulscale((dax2 << 16) + 65535 - x2, yinc, 16);
                    this.parent.qinterpolatedown16short(this.parent.dplc, dax2, dax1 - dax2, yplc, yinc);
                }
            }
            nextv = v--;
        }
        if (Engine.waloff[picnum] == null) {
            this.engine.loadtile(picnum);
        }
        this.engine.setgotpic(picnum);
        byte[] bufplc = Engine.waloff[picnum];
        int palookupshade = this.engine.getpalookup(0, dashade) << 8;
        i = Pragmas.divscale(1L, z, 32);
        xv = Pragmas.mulscale(sinang, i, 14);
        yv = Pragmas.mulscale(cosang, i, 14);
        if ((dastat & 2) != 0 || (dastat & 8) == 0) {
            yv2 = Pragmas.mulscale(-xv, ouryxaspect, 16);
            xv2 = Pragmas.mulscale(yv, ouryxaspect, 16);
        } else {
            yv2 = -xv;
            xv2 = yv;
        }
        int x1 = lx >> 16;
        int x2 = rx >> 16;
        short oy = 0;
        int x = (x1 << 16) - 1 - gx1;
        int y = (oy << 16) + 65535 - gy1;
        int bx = Pragmas.dmulscale(x, xv2, y, xv, 16);
        int by = Pragmas.dmulscale(x, yv2, y, yv, 16);
        if ((dastat & 4) != 0) {
            yv = -yv;
            yv2 = -yv2;
            by = (ysiz << 16) - 1 - by;
        }
        if ((dastat & 1) == 0) {
            if ((dastat & 0x40) != 0) {
                this.parent.getA().setupspritevline(Engine.palookup[dapalnum], palookupshade, xv, yv, ysiz);
            } else {
                this.parent.getA().msetupspritevline(Engine.palookup[dapalnum], palookupshade, xv, yv, ysiz);
            }
        } else {
            this.parent.getA().tsetupspritevline(Engine.palookup[dapalnum], palookupshade, xv, yv, ysiz);
            if ((dastat & 0x20) != 0) {
                this.parent.getA().settransreverse();
            } else {
                this.parent.getA().settransnormal();
            }
        }
        if (x1 < 0) {
            return;
        }
        x = x1;
        while (x < x2) {
            bx += xv2;
            by += yv2;
            short y1 = this.parent.uplc[x];
            short y2 = this.parent.dplc[x];
            if ((dastat & 8) == 0) {
                if (this.parent.startumost[x] > y1) {
                    y1 = this.parent.startumost[x];
                }
                if (this.parent.startdmost[x] < y2) {
                    y2 = this.parent.startdmost[x];
                }
            }
            if (y2 > y1) {
                switch (y1 - oy) {
                    case -1: {
                        bx -= xv;
                        by -= yv;
                        oy = y1;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        bx += xv;
                        by += yv;
                        oy = y1;
                        break;
                    }
                    default: {
                        bx += xv * (y1 - oy);
                        by += yv * (y1 - oy);
                        oy = y1;
                    }
                }
                int p = this.parent.ylookup[y1] + x;
                if ((dastat & 1) == 0) {
                    if ((dastat & 0x40) != 0) {
                        this.parent.getA().spritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
                    } else {
                        this.parent.getA().mspritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
                    }
                } else {
                    this.parent.getA().tspritevline(bx & 0xFFFF, by & 0xFFFF, y2 - y1 + 1, bufplc, (bx >> 16) * ysiz + (by >> 16), p);
                }
            }
            ++x;
        }
    }

    private int clippoly4(int cx1, int cy1, int cx2, int cy2) {
        int t;
        int zz;
        int nn = 0;
        int z = 0;
        do {
            int x;
            zz = z + 1 & 3;
            int x1 = this.nrx1[z];
            int x2 = this.nrx1[zz] - x1;
            if (cx1 <= x1 && x1 <= cx2) {
                this.nrx2[nn] = x1;
                this.nry2[nn] = this.nry1[z];
                ++nn;
            }
            if (((t = (x = x2 <= 0 ? cx2 : cx1) - x1) - x2 ^ t) < 0) {
                this.nrx2[nn] = x;
                this.nry2[nn] = this.nry1[z] + Pragmas.scale(t, this.nry1[zz] - this.nry1[z], x2);
                ++nn;
            }
            if (((t = (x = x2 <= 0 ? cx1 : cx2) - x1) - x2 ^ t) >= 0) continue;
            this.nrx2[nn] = x;
            this.nry2[nn] = this.nry1[z] + Pragmas.scale(t, this.nry1[zz] - this.nry1[z], x2);
            ++nn;
        } while ((z = zz) != 0);
        if (nn < 3) {
            return 0;
        }
        int n = 0;
        z = 0;
        do {
            int y;
            if ((zz = z + 1) == nn) {
                zz = 0;
            }
            int y1 = this.nry2[z];
            int y2 = this.nry2[zz] - y1;
            if (cy1 <= y1 && y1 <= cy2) {
                this.nry1[n] = y1;
                this.nrx1[n] = this.nrx2[z];
                ++n;
            }
            if (((t = (y = y2 <= 0 ? cy2 : cy1) - y1) - y2 ^ t) < 0) {
                this.nry1[n] = y;
                this.nrx1[n] = this.nrx2[z] + Pragmas.scale(t, this.nrx2[zz] - this.nrx2[z], y2);
                ++n;
            }
            if (((t = (y = y2 <= 0 ? cy1 : cy2) - y1) - y2 ^ t) >= 0) continue;
            this.nry1[n] = y;
            this.nrx1[n] = this.nrx2[z] + Pragmas.scale(t, this.nrx2[zz] - this.nrx2[z], y2);
            ++n;
        } while ((z = zz) != 0);
        return n;
    }

    @Override
    public void nextpage() {
    }

    @Override
    public void init() {
    }

    @Override
    public void uninit() {
    }
}

