/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import ru.m210projects.Build.CRC32;

public class Palette {
    private long crc32;
    private byte[] bytes = new byte[768];
    private int[] values = new int[256];

    public void update(byte[] palette) {
        System.arraycopy(palette, 0, this.bytes, 0, palette.length);
        int p = 0;
        int len = palette.length / 3;
        int i = 0;
        while (i < len) {
            this.values[i] = this.bytes[p++] & 0xFF | (this.bytes[p++] & 0xFF) << 8 | (this.bytes[p++] & 0xFF) << 16 | 0xFF000000;
            ++i;
        }
        this.crc32 = CRC32.getChecksum(this.bytes);
    }

    public long getCrc32() {
        return this.crc32;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getRed(int index) {
        return this.values[index] & 0xFF;
    }

    public int getGreen(int index) {
        return (this.values[index] & 0xFF00) >> 8;
    }

    public int getBlue(int index) {
        return (this.values[index] & 0xFF0000) >> 16;
    }

    public int getRGB(int index) {
        return this.values[index] & 0xFFFFFF;
    }

    public int getRGBA(int index, byte alphaMask) {
        return this.getRGB(index) | alphaMask << 24;
    }

    public int getRGBA(int index) {
        return this.values[index];
    }
}

