/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DataResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;

public class SECTOR {
    public static final int sizeof = 40;
    private static final ByteBuffer buffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
    public short wallptr;
    public short wallnum;
    public int ceilingz;
    public int floorz;
    public short ceilingstat;
    public short floorstat;
    public short ceilingpicnum;
    public short ceilingheinum;
    public byte ceilingshade;
    public short ceilingpal;
    public short ceilingxpanning;
    public short ceilingypanning;
    public short floorpicnum;
    public short floorheinum;
    public byte floorshade;
    public short floorpal;
    public short floorxpanning;
    public short floorypanning;
    public short visibility;
    public short filler;
    public short lotag;
    public short hitag;
    public short extra;

    public SECTOR() {
    }

    public SECTOR(byte[] data) {
        this.buildSector(new DataResource(data));
    }

    public SECTOR(Resource data) {
        this.buildSector(data);
    }

    public void buildSector(Resource bb) {
        this.wallptr = bb.readShort();
        if (this.wallptr < 0 || this.wallptr >= Engine.MAXWALLS) {
            this.wallptr = 0;
        }
        this.wallnum = bb.readShort();
        this.ceilingz = bb.readInt();
        this.floorz = bb.readInt();
        this.ceilingstat = bb.readShort();
        this.floorstat = bb.readShort();
        this.ceilingpicnum = bb.readShort();
        if (!Gameutils.isValidTile(this.ceilingpicnum)) {
            this.ceilingpicnum = 0;
        }
        this.ceilingheinum = bb.readShort();
        this.ceilingshade = bb.readByte();
        this.ceilingpal = (short)(bb.readByte() & 0xFF);
        this.ceilingxpanning = (short)(bb.readByte() & 0xFF);
        this.ceilingypanning = (short)(bb.readByte() & 0xFF);
        this.floorpicnum = bb.readShort();
        if (!Gameutils.isValidTile(this.floorpicnum)) {
            this.floorpicnum = 0;
        }
        this.floorheinum = bb.readShort();
        this.floorshade = bb.readByte();
        this.floorpal = (short)(bb.readByte() & 0xFF);
        this.floorxpanning = (short)(bb.readByte() & 0xFF);
        this.floorypanning = (short)(bb.readByte() & 0xFF);
        this.visibility = (short)(bb.readByte() & 0xFF);
        this.filler = bb.readByte().byteValue();
        this.lotag = bb.readShort();
        this.hitag = bb.readShort();
        this.extra = bb.readShort();
    }

    public void set(SECTOR src) {
        this.wallptr = src.wallptr;
        this.wallnum = src.wallnum;
        this.ceilingz = src.ceilingz;
        this.floorz = src.floorz;
        this.ceilingstat = src.ceilingstat;
        this.floorstat = src.floorstat;
        this.ceilingpicnum = src.ceilingpicnum;
        this.ceilingheinum = src.ceilingheinum;
        this.ceilingshade = src.ceilingshade;
        this.ceilingpal = src.ceilingpal;
        this.ceilingxpanning = src.ceilingxpanning;
        this.ceilingypanning = src.ceilingypanning;
        this.floorpicnum = src.floorpicnum;
        this.floorheinum = src.floorheinum;
        this.floorshade = src.floorshade;
        this.floorpal = src.floorpal;
        this.floorxpanning = src.floorxpanning;
        this.floorypanning = src.floorypanning;
        this.visibility = src.visibility;
        this.filler = src.filler;
        this.lotag = src.lotag;
        this.hitag = src.hitag;
        this.extra = src.extra;
    }

    public byte[] getBytes() {
        buffer.clear();
        buffer.putShort(this.wallptr);
        buffer.putShort(this.wallnum);
        buffer.putInt(this.ceilingz);
        buffer.putInt(this.floorz);
        buffer.putShort(this.ceilingstat);
        buffer.putShort(this.floorstat);
        buffer.putShort(this.ceilingpicnum);
        buffer.putShort(this.ceilingheinum);
        buffer.put(this.ceilingshade);
        buffer.put((byte)this.ceilingpal);
        buffer.put((byte)this.ceilingxpanning);
        buffer.put((byte)this.ceilingypanning);
        buffer.putShort(this.floorpicnum);
        buffer.putShort(this.floorheinum);
        buffer.put(this.floorshade);
        buffer.put((byte)this.floorpal);
        buffer.put((byte)this.floorxpanning);
        buffer.put((byte)this.floorypanning);
        buffer.put((byte)this.visibility);
        buffer.put((byte)this.filler);
        buffer.putShort(this.lotag);
        buffer.putShort(this.hitag);
        buffer.putShort(this.extra);
        return buffer.array();
    }

    public String toString() {
        String out = "wallptr " + this.wallptr + " \r\n";
        out = String.valueOf(out) + "wallnum " + this.wallnum + " \r\n";
        out = String.valueOf(out) + "ceilingz " + this.ceilingz + " \r\n";
        out = String.valueOf(out) + "floorz " + this.floorz + " \r\n";
        out = String.valueOf(out) + "ceilingstat " + this.ceilingstat + " \r\n";
        out = String.valueOf(out) + "floorstat " + this.floorstat + " \r\n";
        out = String.valueOf(out) + "ceilingpicnum " + this.ceilingpicnum + " \r\n";
        out = String.valueOf(out) + "ceilingheinum " + this.ceilingheinum + " \r\n";
        out = String.valueOf(out) + "ceilingshade " + this.ceilingshade + " \r\n";
        out = String.valueOf(out) + "ceilingpal " + this.ceilingpal + " \r\n";
        out = String.valueOf(out) + "ceilingxpanning " + this.ceilingxpanning + " \r\n";
        out = String.valueOf(out) + "ceilingypanning " + this.ceilingypanning + " \r\n";
        out = String.valueOf(out) + "floorpicnum " + this.floorpicnum + " \r\n";
        out = String.valueOf(out) + "floorheinum " + this.floorheinum + " \r\n";
        out = String.valueOf(out) + "floorshade " + this.floorshade + " \r\n";
        out = String.valueOf(out) + "floorpal " + this.floorpal + " \r\n";
        out = String.valueOf(out) + "floorxpanning " + this.floorxpanning + " \r\n";
        out = String.valueOf(out) + "floorypanning " + this.floorypanning + " \r\n";
        out = String.valueOf(out) + "visibility " + this.visibility + " \r\n";
        out = String.valueOf(out) + "filler " + this.filler + " \r\n";
        out = String.valueOf(out) + "lotag " + this.lotag + " \r\n";
        out = String.valueOf(out) + "hitag " + this.hitag + " \r\n";
        out = String.valueOf(out) + "extra " + this.extra + " \r\n";
        return out;
    }
}

