/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.Controllers;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Arrays;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import ru.m210projects.Build.Architecture.BuildController;
import ru.m210projects.Build.Engine;

public class JController
implements BuildController {
    private final float[] directions = new float[]{0.25f, 0.75f, 1.0f, 0.5f, 0.125f, 0.375f, 0.875f, 0.625f};
    protected Controller controller;
    protected Array<Component> povs;
    protected Array<Component> buttons;
    protected Array<Component> axises;
    protected boolean[] buttonStatus;
    protected boolean[] hitButton;
    protected int allButtonsCount;
    protected boolean buttonPressed = false;
    protected Vector2 stickVector = new Vector2();

    public JController(Controller src) {
        this.controller = src;
        Component[] components = this.controller.getComponents();
        this.povs = new Array();
        this.buttons = new Array();
        this.axises = new Array();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            Component.Identifier componentIdentifier = component.getIdentifier();
            if (componentIdentifier instanceof Component.Identifier.Button) {
                this.buttons.add(component);
            }
            if (componentIdentifier == Component.Identifier.Axis.POV) {
                this.povs.add(component);
            } else if (component.isAnalog()) {
                this.axises.add(component);
            }
            ++i;
        }
        this.allButtonsCount = this.buttons.size + this.povs.size * 4 + (this.axises.size > 3 ? 2 : 0);
        this.buttonStatus = new boolean[this.allButtonsCount];
        this.hitButton = new boolean[this.allButtonsCount];
    }

    @Override
    public int getButtonCount() {
        return this.allButtonsCount;
    }

    @Override
    public int getAxisCount() {
        return this.axises.size;
    }

    @Override
    public int getPovCount() {
        return this.povs.size;
    }

    @Override
    public Vector2 getStickValue(int aCode1, int aCode2, float deadZone) {
        if (aCode1 >= this.axises.size || aCode2 >= this.axises.size) {
            return this.stickVector.set(0.0f, 0.0f);
        }
        float lx = this.axises.get(aCode1).getPollData();
        float ly = this.axises.get(aCode2).getPollData();
        float mag = (float)Math.sqrt(lx * lx + ly * ly);
        float nlx = lx / mag;
        float nly = ly / mag;
        float nlm = 0.0f;
        if (mag > deadZone) {
            if (mag > 1.0f) {
                mag = 1.0f;
            }
            nlm = (mag -= deadZone) / (1.0f - deadZone);
            float x1 = nlx * nlm;
            float y1 = nly * nlm;
            return this.stickVector.set(x1, y1);
        }
        return this.stickVector.set(0.0f, 0.0f);
    }

    @Override
    public String getName() {
        return this.controller.getName();
    }

    @Override
    public void update() {
        if (!this.controller.poll()) {
            System.err.println("Disconnected");
        }
        this.buttonPressed = false;
        this.dPadHandler();
        this.triggerHandler();
        int i = 0;
        while (i < this.buttons.size) {
            if (this.buttons.get(i).getPollData() == 1.0f) {
                this.buttonPressed = true;
                if (!this.hitButton[i]) {
                    Engine.getInput().setKey(256, 1);
                    this.buttonStatus[i] = true;
                    this.hitButton[i] = true;
                }
            } else {
                this.buttonStatus[i] = false;
                this.hitButton[i] = false;
            }
            ++i;
        }
    }

    @Override
    public boolean buttonPressed() {
        return this.buttonPressed;
    }

    @Override
    public void resetButtonStatus() {
        Arrays.fill(this.buttonStatus, false);
    }

    @Override
    public boolean buttonPressed(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount) {
            return this.hitButton[buttonCode];
        }
        return false;
    }

    @Override
    public boolean buttonStatusOnce(int buttonCode) {
        if (buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode]) {
            this.buttonStatus[buttonCode] = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean buttonStatus(int buttonCode) {
        return buttonCode >= 0 && buttonCode < this.allButtonsCount && this.buttonStatus[buttonCode];
    }

    private void dPadHandler() {
        int i = 0;
        while (i < this.povs.size) {
            float dir = this.povs.get(i).getPollData();
            if (Float.compare(dir, 0.0f) != 0) {
                int num = this.buttons.size + 4 * i;
                int d = 0;
                while (d < 4) {
                    if (Float.compare(dir, this.directions[d]) == 0) {
                        this.buttonPressed = true;
                        if (!this.hitButton[num + d]) {
                            Engine.getInput().setKey(256, 1);
                            this.buttonStatus[num + d] = true;
                            this.hitButton[num + d] = true;
                        }
                    } else {
                        this.buttonStatus[num + d] = false;
                        this.hitButton[num + d] = false;
                    }
                    ++d;
                }
                d = 0;
                while (d < 4) {
                    int fbut = num + d / 2;
                    int sbut = num + 2 + d % 2;
                    if (Float.compare(dir, this.directions[d + 4]) == 0) {
                        Engine.getInput().setKey(256, 1);
                        this.buttonStatus[fbut] = true;
                        this.hitButton[fbut] = true;
                        this.buttonStatus[sbut] = true;
                        this.hitButton[sbut] = true;
                    }
                    ++d;
                }
            } else {
                int b = 0;
                while (b < 4) {
                    int num = this.buttons.size + 4 * i + b;
                    this.buttonStatus[num] = false;
                    this.hitButton[num] = false;
                    ++b;
                }
            }
            ++i;
        }
    }

    private void triggerHandler() {
        if (this.axises.size < 5) {
            return;
        }
        float value = this.axises.get(4).getPollData();
        int num = this.buttons.size + 4 * this.povs.size;
        if (value >= 0.9f) {
            this.buttonPressed = true;
            if (!this.hitButton[num]) {
                Engine.getInput().setKey(256, 1);
                this.buttonStatus[num] = true;
                this.hitButton[num] = true;
            }
        } else {
            this.buttonStatus[num] = false;
            this.hitButton[num] = false;
        }
        if (value <= -0.9f) {
            this.buttonPressed = true;
            if (!this.hitButton[num + 1]) {
                Engine.getInput().setKey(256, 1);
                this.buttonStatus[num + 1] = true;
                this.hitButton[num + 1] = true;
            }
        } else {
            this.buttonStatus[num + 1] = false;
            this.hitButton[num + 1] = false;
        }
    }
}

