/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.Lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import ru.m210projects.Build.Architecture.BuildConfiguration;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.desktop.Lwjgl.LwjglGL10;

public class LwjglGraphics
extends BuildGraphics {
    private static Array<String> extensions;
    private static GLVersion glVersion;
    private BuildConfiguration config;
    private Graphics.BufferFormat bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 16, 8, 0, false);
    private boolean usingGL30;
    private int rate;

    public LwjglGraphics(BuildConfiguration config) {
        LwjglNativesLoader.load();
        this.config = config;
    }

    @Override
    protected int getRefreshRate() {
        return this.rate;
    }

    @Override
    protected boolean isDirty() {
        return Display.isDirty();
    }

    @Override
    protected void sync(int fps) {
        Display.sync(fps);
    }

    @Override
    protected void init() throws Exception {
        if (this.config.useHDPI) {
            System.setProperty("org.lwjgl.opengl.Display.enableHighDPI", "true");
        }
        boolean displayCreated = false;
        if (!this.config.fullscreen) {
            displayCreated = this.setWindowedMode(this.config.width, this.config.height);
        } else {
            Graphics.DisplayMode bestMode = null;
            Graphics.DisplayMode[] displayModeArray = this.getDisplayModes();
            int n = displayModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Graphics.DisplayMode mode = displayModeArray[n2];
                if (mode.width == this.config.width && mode.height == this.config.height && (bestMode == null || bestMode.refreshRate < mode.refreshRate)) {
                    bestMode = mode;
                }
                ++n2;
            }
            if (bestMode == null) {
                bestMode = this.getDesktopDisplayMode();
            }
            displayCreated = this.setFullscreenMode(bestMode);
        }
        if (!displayCreated) {
            throw new GdxRuntimeException("Couldn't set display mode " + this.config.width + "x" + this.config.height + ", fullscreen: " + this.config.fullscreen);
        }
        Array<String> iconPaths = this.config.getIconPaths();
        if (iconPaths.size > 0) {
            ByteBuffer[] icons = new ByteBuffer[iconPaths.size];
            int i = 0;
            int n = iconPaths.size;
            while (i < n) {
                Pixmap pixmap = new Pixmap(BuildGdx.files.getFileHandle(iconPaths.get(i), this.config.getIconFileTypes().get(i)));
                if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
                    Pixmap rgba = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), Pixmap.Format.RGBA8888);
                    rgba.drawPixmap(pixmap, 0, 0);
                    pixmap.dispose();
                    pixmap = rgba;
                }
                icons[i] = ByteBuffer.allocateDirect(pixmap.getPixels().limit());
                icons[i].put(pixmap.getPixels()).flip();
                pixmap.dispose();
                ++i;
            }
            Display.setIcon(icons);
        }
        Display.setTitle(this.config.title);
        Display.setResizable(this.config.resizable);
        Display.setInitialBackground(0.0f, 0.0f, 0.0f);
        Display.setLocation(this.config.x, this.config.y);
        this.setUndecorated(this.config.borderless);
        int gles30ContextMajorVersion = 3;
        int gles30ContextMinorVersion = 2;
        this.createDisplayPixelFormat(this.config.useGL30, gles30ContextMajorVersion, gles30ContextMinorVersion);
        this.initiateGL();
    }

    private void initiateGL() throws Exception {
        this.extractVersion();
        this.extractExtensions();
        this.gl10 = new LwjglGL10();
        if (this.usingGL30) {
            Class<?> GL302 = Class.forName("com.badlogic.gdx.backends.lwjgl.LwjglGL30");
            Constructor<?> LwjglGL302 = GL302.getDeclaredConstructor(new Class[0]);
            LwjglGL302.setAccessible(true);
            this.gl30 = (GL30)LwjglGL302.newInstance(new Object[0]);
            this.gl20 = this.gl30;
        } else {
            Class<?> GL20Class = Class.forName("com.badlogic.gdx.backends.lwjgl.LwjglGL20");
            Constructor<?> LwjglGL202 = GL20Class.getDeclaredConstructor(new Class[0]);
            LwjglGL202.setAccessible(true);
            this.gl20 = (GL20)LwjglGL202.newInstance(new Object[0]);
        }
    }

    private void extractVersion() {
        String versionString = GL11.glGetString(7938);
        String vendorString = GL11.glGetString(7936);
        String rendererString = GL11.glGetString(7937);
        glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
    }

    private void extractExtensions() {
        extensions = new Array();
        if (glVersion.isVersionEqualToOrHigher(3, 2)) {
            int numExtensions = GL11.glGetInteger(33309);
            int i = 0;
            while (i < numExtensions) {
                extensions.add(org.lwjgl.opengl.GL30.glGetStringi(7939, i));
                ++i;
            }
        } else {
            extensions.addAll((String[])GL11.glGetString(7939).split(" "));
        }
    }

    private void createDisplayPixelFormat(boolean useGL30, int gles30ContextMajor, int gles30ContextMinor) {
        block19: {
            try {
                int samples = 0;
                int r = 8;
                int g = 8;
                int b = 8;
                int a = 8;
                if (useGL30) {
                    ContextAttribs context = new ContextAttribs(gles30ContextMajor, gles30ContextMinor).withForwardCompatible(false).withProfileCore(true);
                    try {
                        Display.create(new PixelFormat(r + g + b, a, this.config.depth, this.config.stencil, samples), context);
                    }
                    catch (Exception e) {
                        System.out.println("GLGraphics: OpenGL " + gles30ContextMajor + "." + gles30ContextMinor + "+ core profile (GLES 3.0) not supported.");
                        this.createDisplayPixelFormat(false, gles30ContextMajor, gles30ContextMinor);
                        return;
                    }
                    System.out.println("GLGraphics: created OpenGL " + gles30ContextMajor + "." + gles30ContextMinor + "+ core profile (GLES 3.0) context. This is experimental!");
                    this.usingGL30 = true;
                } else {
                    Display.create(new PixelFormat(r + g + b, a, this.config.depth, this.config.stencil, samples));
                    this.usingGL30 = false;
                }
                this.bufferFormat = new Graphics.BufferFormat(r, g, b, a, this.config.depth, this.config.stencil, samples, false);
            }
            catch (Exception ex) {
                Display.destroy();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException r) {
                    // empty catch block
                }
                try {
                    Display.create(new PixelFormat(0, 16, 8));
                    if (this.getDesktopDisplayMode().bitsPerPixel == 16) {
                        this.bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 16, 8, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 24) {
                        this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 0, 16, 8, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 32) {
                        this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 16, 8, 0, false);
                    }
                }
                catch (Exception ex2) {
                    Display.destroy();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException g) {
                        // empty catch block
                    }
                    try {
                        Display.create(new PixelFormat());
                    }
                    catch (Exception ex3) {
                        throw new GdxRuntimeException("OpenGL is not supported by the video driver.", ex3);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 16) {
                        this.bufferFormat = new Graphics.BufferFormat(5, 6, 5, 0, 8, 0, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel == 24) {
                        this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 0, 8, 0, 0, false);
                    }
                    if (this.getDesktopDisplayMode().bitsPerPixel != 32) break block19;
                    this.bufferFormat = new Graphics.BufferFormat(8, 8, 8, 8, 8, 0, 0, false);
                }
            }
        }
    }

    @Override
    protected void update() {
        Display.update(false);
    }

    @Override
    protected void updateSize(int width, int height) {
        if (BuildGdx.gl != null) {
            BuildGdx.gl.glViewport(0, 0, width, height);
        }
    }

    @Override
    protected boolean wasResized() {
        return Display.wasResized();
    }

    @Override
    protected int getX() {
        return Display.getX();
    }

    @Override
    protected int getY() {
        return Display.getY();
    }

    @Override
    protected boolean isActive() {
        return Display.isActive();
    }

    @Override
    protected boolean isCloseRequested() {
        return Display.isCloseRequested();
    }

    @Override
    protected void dispose() {
        Display.setResizable(false);
        Display.destroy();
    }

    @Override
    public int getWidth() {
        return (int)((float)Display.getWidth() * Display.getPixelScaleFactor());
    }

    @Override
    public int getHeight() {
        return (int)((float)Display.getHeight() * Display.getPixelScaleFactor());
    }

    @Override
    public void setFramesPerSecond(int fps) {
        this.config.foregroundFPS = fps;
        this.config.backgroundFPS = fps;
    }

    @Override
    public BuildFrame.FrameType getFrameType() {
        return BuildFrame.FrameType.GL;
    }

    @Override
    public GLVersion getGLVersion() {
        return glVersion;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return true;
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        return new LwjglMonitor(0, 0, "Primary Monitor");
    }

    @Override
    public Graphics.Monitor getMonitor() {
        return this.getPrimaryMonitor();
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[]{this.getPrimaryMonitor()};
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        try {
            DisplayMode[] availableDisplayModes = Display.getAvailableDisplayModes();
            Graphics.DisplayMode[] modes = new Graphics.DisplayMode[availableDisplayModes.length];
            int idx = 0;
            DisplayMode[] displayModeArray = availableDisplayModes;
            int n = availableDisplayModes.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayMode mode = displayModeArray[n2];
                if (mode.isFullscreenCapable()) {
                    modes[idx++] = new LwjglDisplayMode(mode.getWidth(), mode.getHeight(), mode.getFrequency(), mode.getBitsPerPixel(), mode);
                }
                ++n2;
            }
            return modes;
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException("Couldn't fetch available display modes", e);
        }
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return this.getDisplayModes();
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        DisplayMode mode = Display.getDisplayMode();
        return new LwjglDisplayMode(mode.getWidth(), mode.getHeight(), mode.getFrequency(), mode.getBitsPerPixel(), mode);
    }

    @Override
    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMode mode = Display.getDesktopDisplayMode();
        return new LwjglDisplayMode(mode.getWidth(), mode.getHeight(), mode.getFrequency(), mode.getBitsPerPixel(), mode);
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        DisplayMode mode = ((LwjglDisplayMode)displayMode).mode;
        try {
            if (!mode.isFullscreenCapable()) {
                Display.setDisplayMode(mode);
            } else {
                Display.setDisplayModeAndFullscreen(mode);
            }
            float scaleFactor = Display.getPixelScaleFactor();
            this.config.width = (int)((float)mode.getWidth() * scaleFactor);
            this.config.height = (int)((float)mode.getHeight() * scaleFactor);
            if (BuildGdx.gl != null) {
                BuildGdx.gl.glViewport(0, 0, this.config.width, this.config.height);
            }
            this.resize = true;
            this.rate = mode.getFrequency();
            return true;
        }
        catch (LWJGLException e) {
            return false;
        }
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        if (this.getWidth() == width && this.getHeight() == height && !Display.isFullscreen()) {
            return true;
        }
        try {
            boolean fullscreen = false;
            DisplayMode targetDisplayMode = new DisplayMode(width, height);
            boolean resizable = !fullscreen && this.config.resizable;
            Display.setDisplayMode(targetDisplayMode);
            Display.setFullscreen(fullscreen);
            if (resizable == Display.isResizable()) {
                Display.setResizable(!resizable);
            }
            Display.setResizable(resizable);
            float scaleFactor = Display.getPixelScaleFactor();
            this.config.width = (int)((float)targetDisplayMode.getWidth() * scaleFactor);
            this.config.height = (int)((float)targetDisplayMode.getHeight() * scaleFactor);
            if (BuildGdx.gl != null) {
                BuildGdx.gl.glViewport(0, 0, this.config.width, this.config.height);
            }
            this.resize = true;
            this.rate = Display.getDesktopDisplayMode().getFrequency();
            return true;
        }
        catch (LWJGLException e) {
            return false;
        }
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        Display.setTitle(title);
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        System.setProperty("org.lwjgl.opengl.Window.undecorated", undecorated ? "true" : "false");
    }

    @Override
    public void setResizable(boolean resizable) {
        this.config.resizable = resizable;
        Display.setResizable(resizable);
    }

    @Override
    public void setVSync(boolean vsync) {
        this.vsync = vsync;
        Display.setVSyncEnabled(vsync);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return extensions.contains(extension, false);
    }

    @Override
    public boolean isFullscreen() {
        return Display.isFullscreen();
    }

    @Override
    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return new LwjglCursor(pixmap, xHotspot, yHotspot);
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (SharedLibraryLoader.isMac) {
            return;
        }
        try {
            Mouse.setNativeCursor(((LwjglCursor)cursor).lwjglCursor);
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Could not set cursor image.", e);
        }
    }

    @Override
    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
        if (SharedLibraryLoader.isMac) {
            return;
        }
        try {
            Mouse.setNativeCursor(null);
        }
        catch (LWJGLException e) {
            throw new GdxRuntimeException("Couldn't set system cursor");
        }
    }

    @Override
    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.LWJGL;
    }

    @Override
    public Object extra(BuildGraphics.Option opt, Object ... obj) {
        switch (opt) {
            case GLSetConfiguration: {
                if (obj.length < 3) {
                    return false;
                }
                float gamma = ((Float)obj[0]).floatValue();
                float brightness = ((Float)obj[1]).floatValue();
                float contrast = ((Float)obj[2]).floatValue();
                return this.setDisplayConfiguration(gamma, brightness, contrast);
            }
            case GLDefConfiguration: {
                return this.setDisplayConfiguration(1.0f, 0.0f, 1.0f);
            }
        }
        throw new UnsupportedOperationException("not implemented");
    }

    private boolean setDisplayConfiguration(float gamma, float brightness, float contrast) {
        if (!(Display.isCreated() && Mouse.isCreated() && Keyboard.isCreated())) {
            return false;
        }
        try {
            Display.setDisplayConfiguration(gamma, brightness, contrast);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private class LwjglCursor
    implements Cursor {
        org.lwjgl.input.Cursor lwjglCursor = null;

        public LwjglCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
            if (SharedLibraryLoader.isMac) {
                return;
            }
            try {
                if (pixmap == null) {
                    this.lwjglCursor = null;
                    return;
                }
                if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
                    throw new GdxRuntimeException("Cursor image pixmap is not in RGBA8888 format.");
                }
                if ((pixmap.getWidth() & pixmap.getWidth() - 1) != 0) {
                    throw new GdxRuntimeException("Cursor image pixmap width of " + pixmap.getWidth() + " is not a power-of-two greater than zero.");
                }
                if ((pixmap.getHeight() & pixmap.getHeight() - 1) != 0) {
                    throw new GdxRuntimeException("Cursor image pixmap height of " + pixmap.getHeight() + " is not a power-of-two greater than zero.");
                }
                if (xHotspot < 0 || xHotspot >= pixmap.getWidth()) {
                    throw new GdxRuntimeException("xHotspot coordinate of " + xHotspot + " is not within image width bounds: [0, " + pixmap.getWidth() + ").");
                }
                if (yHotspot < 0 || yHotspot >= pixmap.getHeight()) {
                    throw new GdxRuntimeException("yHotspot coordinate of " + yHotspot + " is not within image height bounds: [0, " + pixmap.getHeight() + ").");
                }
                IntBuffer pixelBuffer = pixmap.getPixels().asIntBuffer();
                int[] pixelsRGBA = new int[pixelBuffer.capacity()];
                pixelBuffer.get(pixelsRGBA);
                int[] pixelsARGBflipped = new int[pixelBuffer.capacity()];
                if (pixelBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    int y = 0;
                    while (y < pixmap.getHeight()) {
                        int x = 0;
                        while (x < pixmap.getWidth()) {
                            int pixel = pixelsRGBA[x + y * pixmap.getWidth()];
                            pixelsARGBflipped[x + (pixmap.getHeight() - 1 - y) * pixmap.getWidth()] = pixel >> 8 & 0xFFFFFF | pixel << 24 & 0xFF000000;
                            ++x;
                        }
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < pixmap.getHeight()) {
                        int x = 0;
                        while (x < pixmap.getWidth()) {
                            int pixel = pixelsRGBA[x + y * pixmap.getWidth()];
                            pixelsARGBflipped[x + (pixmap.getHeight() - 1 - y) * pixmap.getWidth()] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                            ++x;
                        }
                        ++y;
                    }
                }
                this.lwjglCursor = new org.lwjgl.input.Cursor(pixmap.getWidth(), pixmap.getHeight(), xHotspot, pixmap.getHeight() - yHotspot - 1, 1, IntBuffer.wrap(pixelsARGBflipped), null);
            }
            catch (LWJGLException e) {
                throw new GdxRuntimeException("Could not create cursor image.", e);
            }
        }

        @Override
        public void dispose() {
        }
    }

    private class LwjglDisplayMode
    extends Graphics.DisplayMode {
        DisplayMode mode;

        public LwjglDisplayMode(int width, int height, int refreshRate, int bitsPerPixel, DisplayMode mode) {
            super(width, height, refreshRate, bitsPerPixel);
            this.mode = mode;
        }
    }

    private class LwjglMonitor
    extends Graphics.Monitor {
        protected LwjglMonitor(int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
        }
    }
}

