/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.Lwjgl;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.Pool;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildInput;

public class LwjglInput
implements BuildInput {
    protected BuildFrame frame;
    protected Cursor emptyCursor;
    protected Cursor defCursor = Mouse.getNativeCursor();
    public static float keyRepeatInitialTime = 0.4f;
    public static float keyRepeatTime = 0.1f;
    List<KeyEvent> keyEvents = new ArrayList<KeyEvent>();
    List<TouchEvent> touchEvents = new ArrayList<TouchEvent>();
    boolean mousePressed = false;
    int mouseX;
    int mouseY;
    int deltaX;
    int deltaY;
    int pressedKeys = 0;
    boolean keyJustPressed = false;
    boolean[] justPressedKeys = new boolean[256];
    boolean[] justPressedButtons = new boolean[5];
    boolean justTouched = false;
    IntSet pressedButtons = new IntSet();
    InputProcessor processor;
    char lastKeyCharPressed;
    float keyRepeatTimer;
    long currentEventTimeStamp;
    float deltaTime;
    long lastTime;
    Pool<KeyEvent> usedKeyEvents = new Pool<KeyEvent>(16, 1000){

        @Override
        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    Pool<TouchEvent> usedTouchEvents = new Pool<TouchEvent>(16, 1000){

        @Override
        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };

    public LwjglInput() {
        Keyboard.enableRepeatEvents(false);
        Mouse.setClipMouseCoordinatesToWindow(false);
    }

    @Override
    public void init(BuildFrame frame) {
        this.frame = frame;
    }

    @Override
    public float getAccelerometerX() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerY() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerZ() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeX() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeY() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeZ() {
        return 0.0f;
    }

    @Override
    public void getTextInput(final Input.TextInputListener listener, final String title, final String text, final String hint) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new FlowLayout());
                JPanel textPanel = new JPanel();
                textPanel.setLayout(new OverlayLayout(textPanel));
                panel.add(textPanel);
                final JTextField textField = new JTextField(20);
                textField.setText(text);
                textField.setAlignmentX(0.0f);
                textPanel.add(textField);
                final JLabel placeholderLabel = new JLabel(hint);
                placeholderLabel.setForeground(Color.GRAY);
                placeholderLabel.setAlignmentX(0.0f);
                textPanel.add((Component)placeholderLabel, 0);
                textField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent arg0) {
                        this.updated();
                    }

                    private void updated() {
                        if (textField.getText().length() == 0) {
                            placeholderLabel.setVisible(true);
                        } else {
                            placeholderLabel.setVisible(false);
                        }
                    }
                });
                JOptionPane pane = new JOptionPane(panel, 3, 2, null, null, null);
                pane.setInitialValue(null);
                pane.setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
                Border border = textField.getBorder();
                placeholderLabel.setBorder(new EmptyBorder(border.getBorderInsets(textField)));
                JDialog dialog = pane.createDialog(null, title);
                pane.selectInitialValue();
                dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent arg0) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent arg0) {
                        textField.requestFocusInWindow();
                    }
                });
                dialog.setModal(true);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                dialog.dispose();
                Object selectedValue = pane.getValue();
                if (selectedValue != null && selectedValue instanceof Integer && (Integer)selectedValue == 0) {
                    listener.input(textField.getText());
                } else {
                    listener.canceled();
                }
            }
        });
    }

    @Override
    public int getMaxPointers() {
        return 1;
    }

    @Override
    public int getX() {
        return (int)((float)Mouse.getX() * Display.getPixelScaleFactor());
    }

    @Override
    public int getY() {
        return BuildGdx.graphics.getHeight() - 1 - (int)((float)Mouse.getY() * Display.getPixelScaleFactor());
    }

    public boolean isAccelerometerAvailable() {
        return false;
    }

    public boolean isGyroscopeAvailable() {
        return false;
    }

    @Override
    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeys > 0;
        }
        int code = this.getLwjglKeyCode(key);
        if (code == 0) {
            return false;
        }
        return Keyboard.isCreated() && Keyboard.isKeyDown(code);
    }

    @Override
    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    @Override
    public boolean isTouched() {
        boolean button = Mouse.isButtonDown(0) || Mouse.isButtonDown(1) || Mouse.isButtonDown(2);
        return button;
    }

    @Override
    public int getX(int pointer) {
        if (pointer > 0) {
            return 0;
        }
        return this.getX();
    }

    @Override
    public int getY(int pointer) {
        if (pointer > 0) {
            return 0;
        }
        return this.getY();
    }

    @Override
    public boolean isTouched(int pointer) {
        if (pointer > 0) {
            return false;
        }
        return this.isTouched();
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1 : 0;
    }

    public boolean supportsMultitouch() {
        return false;
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    @Override
    public void setCatchBackKey(boolean catchBack) {
    }

    @Override
    public boolean isCatchBackKey() {
        return false;
    }

    @Override
    public void setCatchMenuKey(boolean catchMenu) {
    }

    @Override
    public boolean isCatchMenuKey() {
        return false;
    }

    @Override
    public void setCatchKey(int keycode, boolean catchKey) {
    }

    @Override
    public boolean isCatchKey(int keycode) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents() {
        LwjglInput lwjglInput = this;
        synchronized (lwjglInput) {
            if (this.processor != null) {
                Object e;
                InputProcessor processor = this.processor;
                int len = this.keyEvents.size();
                int i = 0;
                while (i < len) {
                    e = this.keyEvents.get(i);
                    this.currentEventTimeStamp = ((KeyEvent)e).timeStamp;
                    switch (((KeyEvent)e).type) {
                        case 0: {
                            processor.keyDown(((KeyEvent)e).keyCode);
                            break;
                        }
                        case 1: {
                            processor.keyUp(((KeyEvent)e).keyCode);
                            break;
                        }
                        case 2: {
                            processor.keyTyped(((KeyEvent)e).keyChar);
                        }
                    }
                    this.usedKeyEvents.free((KeyEvent)e);
                    ++i;
                }
                len = this.touchEvents.size();
                i = 0;
                while (i < len) {
                    e = this.touchEvents.get(i);
                    this.currentEventTimeStamp = ((TouchEvent)e).timeStamp;
                    switch (((TouchEvent)e).type) {
                        case 0: {
                            processor.touchDown(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, ((TouchEvent)e).button);
                            break;
                        }
                        case 1: {
                            processor.touchUp(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, ((TouchEvent)e).button);
                            break;
                        }
                        case 2: {
                            processor.touchDragged(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer);
                            break;
                        }
                        case 4: {
                            processor.mouseMoved(((TouchEvent)e).x, ((TouchEvent)e).y);
                            break;
                        }
                        case 3: {
                            processor.scrolled(((TouchEvent)e).scrollAmount);
                        }
                    }
                    this.usedTouchEvents.free((TouchEvent)e);
                    ++i;
                }
            } else {
                int len = this.touchEvents.size();
                int i = 0;
                while (i < len) {
                    this.usedTouchEvents.free(this.touchEvents.get(i));
                    ++i;
                }
                len = this.keyEvents.size();
                i = 0;
                while (i < len) {
                    this.usedKeyEvents.free(this.keyEvents.get(i));
                    ++i;
                }
            }
            this.keyEvents.clear();
            this.touchEvents.clear();
        }
    }

    protected int getGdxKeyCode(int eventKey) {
        switch (eventKey) {
            case 197: {
                return 237;
            }
            case 58: {
                return 238;
            }
            case 70: {
                return 239;
            }
            case 83: {
                return 240;
            }
        }
        return com.badlogic.gdx.backends.lwjgl.LwjglInput.getGdxKeyCode(eventKey);
    }

    protected int getLwjglKeyCode(int gdxKeyCode) {
        switch (gdxKeyCode) {
            case 237: {
                return 197;
            }
            case 238: {
                return 58;
            }
            case 239: {
                return 70;
            }
            case 240: {
                return 83;
            }
        }
        return com.badlogic.gdx.backends.lwjgl.LwjglInput.getLwjglKeyCode(gdxKeyCode);
    }

    @Override
    public void update() {
        this.updateTime();
        this.updateMouse();
        this.updateKeyboard();
    }

    private int toGdxButton(int button) {
        if (button == 0) {
            return 0;
        }
        if (button == 1) {
            return 1;
        }
        if (button == 2) {
            return 2;
        }
        if (button == 3) {
            return 3;
        }
        if (button == 4) {
            return 4;
        }
        return -1;
    }

    void updateTime() {
        long thisTime = System.nanoTime();
        this.deltaTime = (float)(thisTime - this.lastTime) / 1.0E9f;
        this.lastTime = thisTime;
    }

    void updateMouse() {
        if (this.justTouched) {
            this.justTouched = false;
            Arrays.fill(this.justPressedButtons, false);
        }
        if (Mouse.isCreated()) {
            int events = 0;
            while (Mouse.next()) {
                ++events;
                int x = (int)((float)Mouse.getEventX() * Display.getPixelScaleFactor());
                int y = BuildGdx.graphics.getHeight() - (int)((float)Mouse.getEventY() * Display.getPixelScaleFactor()) - 1;
                int button = Mouse.getEventButton();
                int gdxButton = this.toGdxButton(button);
                if (button != -1 && gdxButton == -1) continue;
                TouchEvent event = this.usedTouchEvents.obtain();
                event.x = x;
                event.y = y;
                event.button = gdxButton;
                event.pointer = 0;
                event.timeStamp = Mouse.getEventNanoseconds();
                if (button == -1) {
                    if (Mouse.getEventDWheel() != 0) {
                        event.type = 3;
                        event.scrollAmount = (int)(-Math.signum(Mouse.getEventDWheel()));
                    } else {
                        event.type = this.pressedButtons.size > 0 ? 2 : 4;
                    }
                } else if (Mouse.getEventButtonState()) {
                    event.type = 0;
                    this.pressedButtons.add(event.button);
                    this.justPressedButtons[event.button] = true;
                    this.justTouched = true;
                } else {
                    event.type = 1;
                    this.pressedButtons.remove(event.button);
                }
                this.touchEvents.add(event);
                this.mouseX = event.x;
                this.mouseY = event.y;
                this.deltaX = (int)((float)Mouse.getEventDX() * Display.getPixelScaleFactor());
                this.deltaY = (int)((float)Mouse.getEventDY() * Display.getPixelScaleFactor());
            }
            if (events == 0) {
                this.deltaX = 0;
                this.deltaY = 0;
            } else {
                BuildGdx.graphics.requestRendering();
            }
        }
    }

    void updateKeyboard() {
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            Arrays.fill(this.justPressedKeys, false);
        }
        if (this.lastKeyCharPressed != '\u0000') {
            this.keyRepeatTimer -= this.deltaTime;
            if (this.keyRepeatTimer < 0.0f) {
                this.keyRepeatTimer = keyRepeatTime;
                KeyEvent event = this.usedKeyEvents.obtain();
                event.keyCode = 0;
                event.keyChar = this.lastKeyCharPressed;
                event.type = 2;
                event.timeStamp = System.nanoTime();
                this.keyEvents.add(event);
                BuildGdx.graphics.requestRendering();
            }
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
                int keyCode = this.getGdxKeyCode(Keyboard.getEventKey());
                int keyChar = Keyboard.getEventCharacter();
                if (Keyboard.getEventKeyState() || keyCode == 0 && keyChar != 0 && Character.isDefined((char)keyChar)) {
                    KeyEvent event;
                    long timeStamp = Keyboard.getEventNanoseconds();
                    switch (keyCode) {
                        case 67: {
                            keyChar = 8;
                            break;
                        }
                        case 112: {
                            keyChar = 127;
                        }
                    }
                    if (keyCode != 0) {
                        event = this.usedKeyEvents.obtain();
                        event.keyCode = keyCode;
                        event.keyChar = '\u0000';
                        event.type = 0;
                        event.timeStamp = timeStamp;
                        this.keyEvents.add(event);
                        ++this.pressedKeys;
                        this.keyJustPressed = true;
                        this.justPressedKeys[keyCode] = true;
                        this.lastKeyCharPressed = (char)keyChar;
                        this.keyRepeatTimer = keyRepeatInitialTime;
                    }
                    event = this.usedKeyEvents.obtain();
                    event.keyCode = 0;
                    event.keyChar = (char)keyChar;
                    event.type = 2;
                    event.timeStamp = timeStamp;
                    this.keyEvents.add(event);
                } else {
                    KeyEvent event = this.usedKeyEvents.obtain();
                    event.keyCode = keyCode;
                    event.keyChar = '\u0000';
                    event.type = 1;
                    event.timeStamp = Keyboard.getEventNanoseconds();
                    this.keyEvents.add(event);
                    --this.pressedKeys;
                    if (this.pressedKeys < 0) {
                        this.pressedKeys = 0;
                    }
                    this.lastKeyCharPressed = '\u0000';
                }
                BuildGdx.graphics.requestRendering();
            }
        }
    }

    @Override
    public void setInputProcessor(InputProcessor processor) {
        this.processor = processor;
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    @Override
    public void vibrate(int milliseconds) {
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isButtonPressed(int button) {
        if (button >= 5) {
            return false;
        }
        return Mouse.isButtonDown(button);
    }

    @Override
    public boolean isButtonJustPressed(int button) {
        if (button < 0 || button >= this.justPressedButtons.length) {
            return false;
        }
        return this.justPressedButtons[button];
    }

    @Override
    public void vibrate(long[] pattern, int repeat) {
    }

    @Override
    public void cancelVibrate() {
    }

    @Override
    public float getAzimuth() {
        return 0.0f;
    }

    @Override
    public float getPitch() {
        return 0.0f;
    }

    @Override
    public float getRoll() {
        return 0.0f;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        return peripheral == Input.Peripheral.HardwareKeyboard;
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    @Override
    public void setCursorCatched(boolean catched) {
        Mouse.setGrabbed(catched);
    }

    @Override
    public boolean isCursorCatched() {
        return Mouse.isGrabbed();
    }

    @Override
    public int getDeltaX() {
        return this.deltaX;
    }

    @Override
    public int getDeltaX(int pointer) {
        if (pointer == 0) {
            return this.getDeltaX();
        }
        return 0;
    }

    @Override
    public int getDeltaY() {
        return -this.deltaY;
    }

    @Override
    public int getDeltaY(int pointer) {
        if (pointer == 0) {
            return this.getDeltaY();
        }
        return 0;
    }

    @Override
    public void setCursorPosition(int x, int y) {
        Mouse.setCursorPosition(x, BuildGdx.graphics.getHeight() - 1 - y);
    }

    @Override
    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    @Override
    public void getRotationMatrix(float[] matrix) {
    }

    @Override
    public void processMessages() {
        Display.processMessages();
    }

    @Override
    public boolean cursorHandler() {
        try {
            if (this.emptyCursor == null) {
                this.emptyCursor = new Cursor(1, 1, 0, 0, 1, BufferUtils.createIntBuffer(1), null);
            }
            if (this.emptyCursor != null && Mouse.isInsideWindow() && Display.isActive()) {
                Mouse.setNativeCursor(this.emptyCursor);
            } else {
                Mouse.setNativeCursor(this.defCursor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getDWheel() {
        return Mouse.getDWheel();
    }

    @Override
    public void dispose() {
    }

    class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_UP = 1;
        static final int KEY_TYPED = 2;
        long timeStamp;
        int type;
        int keyCode;
        char keyChar;

        KeyEvent() {
        }
    }

    class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_UP = 1;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_SCROLLED = 3;
        static final int TOUCH_MOVED = 4;
        long timeStamp;
        int type;
        int x;
        int y;
        int scrollAmount;
        int button;
        int pointer;

        TouchEvent() {
        }
    }
}

