/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.audio;

import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Audio.SourceCallback;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.desktop.audio.ALAudio;
import ru.m210projects.Build.desktop.audio.ALSoundDrv;

public class ALSource
extends Source {
    private ALSoundDrv drv;
    private ALAudio al;

    public ALSource(ALSoundDrv drv, int bufferId, int sourceId) {
        super(bufferId, sourceId, 0);
        this.drv = drv;
        this.al = drv.getALAudio();
    }

    @Override
    public int dispose() {
        if (!this.drv.isInited()) {
            return -1;
        }
        this.drv.sourceManager.stopSound(this);
        return this.sourceId;
    }

    @Override
    public boolean isLooping() {
        if (!this.drv.isInited()) {
            return false;
        }
        return this.al.alGetSourcei(this.sourceId, 4103) == 1;
    }

    @Override
    public boolean isPlaying() {
        if (!this.drv.isInited()) {
            return false;
        }
        return this.al.alGetSourcei(this.sourceId, 4112) == 4114;
    }

    @Override
    public void setPosition(float x, float y, float z) {
        if (!this.drv.isInited()) {
            return;
        }
        this.al.alSource3f(this.sourceId, 4100, x, y, z);
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setPosition " + error + ", values: [" + x + ", " + y + ", " + z + "]", Console.OSDTEXT_RED);
        }
    }

    @Override
    public void setVolume(float volume) {
        if (!this.drv.isInited()) {
            return;
        }
        volume = Math.min(Math.max(volume, 0.0f), 1.0f);
        this.al.alSourcef(this.sourceId, 4106, volume *= this.drv.getVolume());
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setVolume " + error + ", value is " + volume, Console.OSDTEXT_RED);
        }
    }

    @Override
    public float getVolume() {
        if (!this.drv.isInited()) {
            return 0.0f;
        }
        return this.al.alGetSourcef(this.sourceId, 4106);
    }

    @Override
    public float getPitch() {
        if (!this.drv.isInited()) {
            return 0.0f;
        }
        return this.al.alGetSourcef(this.sourceId, 4099);
    }

    @Override
    public void setPitch(float pitch) {
        if (!this.drv.isInited()) {
            return;
        }
        pitch = Math.min(Math.max(pitch, 0.0f), 2.0f);
        this.al.alSourcef(this.sourceId, 4099, pitch);
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setPitch " + error + ", value is " + pitch, Console.OSDTEXT_RED);
        }
    }

    @Override
    public void setGlobal(int num) {
        if (!this.drv.isInited()) {
            return;
        }
        this.al.alSourcei(this.sourceId, 514, num);
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setGlobal " + error + ", value is " + num, Console.OSDTEXT_RED);
        }
    }

    @Override
    public boolean isGlobal() {
        if (!this.drv.isInited()) {
            return false;
        }
        return this.al.alGetSourcei(this.sourceId, 514) == 1;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean isActive() {
        if (!this.drv.isInited()) {
            return false;
        }
        return (this.isPlaying() || this.al.alGetSourcei(this.sourceId, 4112) == 4115) && this.priority != 0 && !this.free;
    }

    @Override
    public void setLooping(boolean loop, int loopstart, int loopend) {
        if (!this.drv.isInited()) {
            return;
        }
        if (!loop) {
            this.al.alSourcei(this.sourceId, 4103, 0);
            this.loopInfo.clear();
        } else {
            int start = 0;
            int end = this.data.capacity();
            if (loopstart >= 0 && loopstart < this.data.capacity()) {
                start = loopstart;
            }
            if (loopend < this.data.capacity()) {
                end = loopend;
            }
            int bufferID = this.drv.buffers.get(this.bufferId);
            if (start > 0) {
                this.al.alSourcei(this.sourceId, 4105, 0);
                this.al.alSourcei(this.sourceId, 4103, 0);
                this.al.alSourceQueueBuffers(this.sourceId, bufferID);
                this.drv.loopedSource.add(this);
                this.loopInfo.set(this.data, start, end, this.format, this.rate);
            } else {
                if (end > 0) {
                    this.data.limit(end);
                }
                this.al.alSourcei(this.sourceId, 4103, 1);
                this.al.alSourcei(this.sourceId, 4105, bufferID);
            }
        }
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error setLooping " + error, Console.OSDTEXT_RED);
        }
    }

    @Override
    public void play(float volume) {
        if (!this.drv.isInited()) {
            return;
        }
        this.setVolume(volume);
        this.al.alSourcePlay(this.sourceId);
        int error = this.al.alGetError();
        if (error != 0) {
            Console.Println("OpenAL Error play " + error, Console.OSDTEXT_RED);
        }
    }

    @Override
    public void stop() {
        if (!this.drv.isInited()) {
            return;
        }
        this.al.alSourceStop(this.sourceId);
    }

    @Override
    public void pause() {
        if (!this.drv.isInited()) {
            return;
        }
        this.al.alSourcePause(this.sourceId);
    }

    @Override
    public void resume() {
        if (!this.drv.isInited()) {
            return;
        }
        if (this.al.alGetSourcei(this.sourceId, 4112) == 4115) {
            this.al.alSourcePlay(this.sourceId);
        }
    }

    @Override
    public <T> void setCallback(SourceCallback<T> callback, T num) {
        this.callback = callback;
        this.channel = num;
    }
}

