/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.LSP.Fonts.MenuFont;
import ru.m210projects.LSP.Menus.MenuInterfaceSet;

public class LSPMenuHandler
extends MenuHandler {
    public BuildMenu[] mMenus = new BuildMenu[16];
    private Engine engine;
    private BuildGame app;
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int LOADGAME = 3;
    public static final int SAVEGAME = 4;
    public static final int QUIT = 6;
    public static final int HELP = 7;
    public static final int AUDIOSET = 8;
    public static final int CONTROLSET = 9;
    public static final int OPTIONS = 10;
    public static final int COLORCORR = 11;
    public static final int CREDITS = 12;
    public static final int ADVERTISING = 13;
    public static final int LASTSAVE = 14;
    public static final int CORRUPTLOAD = 15;

    public LSPMenuHandler(BuildGame app) {
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings) && !(this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 611;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.getClass().getSuperclass().equals(MenuSlider.class) && !item.isEnabled()) {
            return -127;
        }
        if (item != null && item.isFocused()) {
            return 16 - (Engine.totalclock & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (item.isFocused()) {
                return 70;
            }
            if (!item.isEnabled()) {
                return 96;
            }
            if (font != null && font.getClass().equals(MenuFont.class)) {
                return item.pal;
            }
            return 228;
        }
        return 228;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 4 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, Engine.tilesizx[9216] - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        int size = Pragmas.mulscale(Engine.tilesizx[9216], zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
    }

    @Override
    public void mPostDraw(MenuItem item) {
        if (item.isFocused()) {
            int scale = 32768;
            int xoff = 0;
            int yoff = 6;
            if (item instanceof MenuList) {
                if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    scale = 24000;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    xoff = 35;
                    yoff = 3;
                    this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 626, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuKeyboardList || item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int py = list.y + (list.l_nFocus - list.l_nMin) * list.mFontOffset();
                    scale = 24000;
                    xoff = -10;
                    yoff = 3;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 626, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else {
                int px = item.x;
                int py = item.y;
                if (item.align == 1) {
                    int centre;
                    xoff = centre = 80;
                    if (item.font != this.app.getFont(2)) {
                        xoff -= 15;
                    }
                }
                if (item.font != this.app.getFont(2)) {
                    xoff -= 10;
                    yoff -= 3;
                    scale = 24000;
                }
                if (item instanceof MenuVariants) {
                    xoff += 10;
                    yoff += 15;
                }
                this.engine.rotatesprite(px + xoff << 16, py + yoff << 16, scale, 0, 626, 0, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
        }
    }
}

