/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.LSP.Animate;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Factory.LSPInput;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Menus.MenuCorruptGame;
import ru.m210projects.LSP.Quotes;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Types.ANIMATION;
import ru.m210projects.LSP.Types.LSInfo;
import ru.m210projects.LSP.Types.SafeLoader;

public class LoadSave {
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static final String savsign = "LSP0";
    public static final int gdxSave = 100;
    public static final int currentGdxSave = 100;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 8;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16272;
    public static String lastload;
    public static int quickslot;
    public static SafeLoader loader;
    public static final char[] filenum;

    static {
        lsInf = new LSInfo();
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 8;
        quickslot = 0;
        loader = new SafeLoader();
        filenum = new char[4];
    }

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null || signature.isEmpty()) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) >= 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource file = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (file != null) {
            if (Engine.waloff[SaveManager.Screenshot] == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = LoadSave.checkSave(file) & 0xFFFF;
            lsInf.clear();
            if (nVersion == 100) {
                file.seek(SAVEVERSION, Resource.Whence.Set);
                LoadSave.lsInf.date = Main.game.date.getDate(file.readLong());
                file.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                lsInf.read(file);
                if (file.remaining() <= 16000) {
                    file.close();
                    return -1;
                }
                file.read(Engine.waloff[SaveManager.Screenshot], 0, 16000);
                Main.engine.invalidatetile(SaveManager.Screenshot, 0, -1);
                file.close();
                return 1;
            }
            LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 100;
            if (!file.isClosed()) {
                file.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = LoadSave.checkSave(bb);
        if (nVersion != 100) {
            return false;
        }
        return loader.load(bb);
    }

    public static void load() {
        if (Globals.rec != null) {
            Globals.rec.close();
        }
        Globals.recstat = 0;
        Sounds.stopallsounds();
        Globals.mapnum = LoadSave.loader.mapnum;
        Globals.nDifficult = (short)LoadSave.loader.skill;
        LoadSave.LoadGDXBlock();
        LoadSave.LoadStuff();
        LoadSave.MapLoad();
        LoadSave.SectorLoad();
        LoadSave.AnimationLoad();
        Globals.screenpeek = Mmulti.myconnectindex;
        Main.engine.setTilesPath(Globals.mapnum == 0 ? 0 : 1);
        short i = Engine.headspritestat[21];
        while (i >= 0) {
            short nexti = Engine.nextspritestat[i];
            Main.engine.changespritestat(i, 2);
            Engine.sprite[i].picnum = Engine.sprite[i].extra;
            i = nexti;
        }
        Globals.nKickSprite = -1;
        if (Globals.mapnum == 0) {
            short sec = 0;
            while (sec < Engine.numsectors) {
                int spr = Engine.headspritesect[sec];
                while (spr != -1) {
                    if (Engine.sprite[spr].picnum == 51) {
                        Globals.nKickSprite = spr;
                    }
                    spr = Engine.nextspritesect[spr];
                }
                sec = (short)(sec + 1);
            }
        }
        Globals.gPlayer[Globals.screenpeek].isWeaponsSwitching = 0;
        Globals.gPlayer[Globals.screenpeek].nSwitchingClock = 0;
        int mnum = Globals.maps[Globals.mapnum].num & 0xFF;
        Globals.book = mnum % 100 % 10;
        Globals.chapter = mnum / 100;
        Globals.verse = mnum % 100 / 10;
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                Main.game.nNetMode = BuildGame.NetMode.Single;
                if (Globals.mUserFlag != Main.UserFlag.UserMap) {
                    Sounds.startmusic(Globals.maps[Globals.mapnum].music - 1);
                } else {
                    Sounds.stopmusic();
                }
                Main.game.changeScreen(Main.gGameScreen);
                Main.game.pInput.resetMousePos();
                ((LSPInput)Main.game.pInput).reset();
                Main.game.gPaused = false;
                Engine.totalclock = Globals.lockclock;
                Main.game.pNet.ototalclock = Globals.lockclock;
                Quotes.resetQuotes();
                Quotes.viewSetMessage("Game loaded");
                System.gc();
                Main.game.pNet.ResetTimers();
                Main.game.pNet.ready2send = true;
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = LoadSave.checkfile(fil);
            fil.close();
            if (status) {
                LoadSave.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                return true;
            }
        }
        Quotes.viewSetMessage("Incompatible version of saved game found!");
        return false;
    }

    public static void LoadGDXBlock() {
        Globals.mUserFlag = Main.UserFlag.None;
    }

    public static void SectorLoad() {
        System.arraycopy(LoadSave.loader.waterfountainwall, 0, Globals.waterfountainwall, 0, LoadSave.loader.waterfountainwall.length);
        System.arraycopy(LoadSave.loader.waterfountaincnt, 0, Globals.waterfountaincnt, 0, LoadSave.loader.waterfountaincnt.length);
        Globals.ypanningwallcnt = LoadSave.loader.ypanningwallcnt;
        System.arraycopy(LoadSave.loader.ypanningwalllist, 0, Globals.ypanningwalllist, 0, LoadSave.loader.ypanningwalllist.length);
        Globals.floorpanningcnt = LoadSave.loader.floorpanningcnt;
        System.arraycopy(LoadSave.loader.floorpanninglist, 0, Globals.floorpanninglist, 0, LoadSave.loader.floorpanninglist.length);
        Globals.warpsectorcnt = LoadSave.loader.warpsectorcnt;
        System.arraycopy(LoadSave.loader.warpsectorlist, 0, Globals.warpsectorlist, 0, LoadSave.loader.warpsectorlist.length);
        Globals.xpanningsectorcnt = LoadSave.loader.xpanningsectorcnt;
        System.arraycopy(LoadSave.loader.xpanningsectorlist, 0, Globals.xpanningsectorlist, 0, LoadSave.loader.xpanningsectorlist.length);
        Globals.warpsector2cnt = LoadSave.loader.warpsector2cnt;
        System.arraycopy(LoadSave.loader.warpsector2list, 0, Globals.warpsector2list, 0, LoadSave.loader.warpsector2list.length);
        Globals.subwaytrackcnt = LoadSave.loader.subwaytrackcnt;
        int i = 0;
        while (i < 5) {
            System.arraycopy(LoadSave.loader.subwaytracksector[i], 0, Globals.subwaytracksector[i], 0, LoadSave.loader.subwaytracksector[i].length);
            ++i;
        }
        System.arraycopy(LoadSave.loader.subwaynumsectors, 0, Globals.subwaynumsectors, 0, LoadSave.loader.subwaynumsectors.length);
        i = 0;
        while (i < 5) {
            System.arraycopy(LoadSave.loader.subwaystop[i], 0, Globals.subwaystop[i], 0, LoadSave.loader.subwaystop[i].length);
            ++i;
        }
        System.arraycopy(LoadSave.loader.subwaystopcnt, 0, Globals.subwaystopcnt, 0, LoadSave.loader.subwaystopcnt.length);
        System.arraycopy(LoadSave.loader.subwaytrackx1, 0, Globals.subwaytrackx1, 0, LoadSave.loader.subwaytrackx1.length);
        System.arraycopy(LoadSave.loader.subwaytracky1, 0, Globals.subwaytracky1, 0, LoadSave.loader.subwaytracky1.length);
        System.arraycopy(LoadSave.loader.subwaytrackx2, 0, Globals.subwaytrackx2, 0, LoadSave.loader.subwaytrackx2.length);
        System.arraycopy(LoadSave.loader.subwaytracky2, 0, Globals.subwaytracky2, 0, LoadSave.loader.subwaytracky2.length);
        System.arraycopy(LoadSave.loader.subwayx, 0, Globals.subwayx, 0, LoadSave.loader.subwayx.length);
        System.arraycopy(LoadSave.loader.subwaygoalstop, 0, Globals.subwaygoalstop, 0, LoadSave.loader.subwaygoalstop.length);
        System.arraycopy(LoadSave.loader.subwayvel, 0, Globals.subwayvel, 0, LoadSave.loader.subwayvel.length);
        System.arraycopy(LoadSave.loader.subwaypausetime, 0, Globals.subwaypausetime, 0, LoadSave.loader.subwaypausetime.length);
        Globals.revolvecnt = LoadSave.loader.revolvecnt;
        System.arraycopy(LoadSave.loader.revolvesector, 0, Globals.revolvesector, 0, LoadSave.loader.revolvesector.length);
        System.arraycopy(LoadSave.loader.revolveang, 0, Globals.revolveang, 0, LoadSave.loader.revolveang.length);
        i = 0;
        while (i < 4) {
            System.arraycopy(LoadSave.loader.revolvex[i], 0, Globals.revolvex[i], 0, LoadSave.loader.revolvex[i].length);
            ++i;
        }
        i = 0;
        while (i < 4) {
            System.arraycopy(LoadSave.loader.revolvey[i], 0, Globals.revolvey[i], 0, LoadSave.loader.revolvey[i].length);
            ++i;
        }
        System.arraycopy(LoadSave.loader.revolvepivotx, 0, Globals.revolvepivotx, 0, LoadSave.loader.revolvepivotx.length);
        System.arraycopy(LoadSave.loader.revolvepivoty, 0, Globals.revolvepivoty, 0, LoadSave.loader.revolvepivoty.length);
        Globals.swingcnt = LoadSave.loader.swingcnt;
        i = 0;
        while (i < 32) {
            Globals.swingdoor[i].copy(LoadSave.loader.swingdoor[i]);
            ++i;
        }
        Globals.dragsectorcnt = LoadSave.loader.dragsectorcnt;
        System.arraycopy(LoadSave.loader.dragsectorlist, 0, Globals.dragsectorlist, 0, LoadSave.loader.dragsectorlist.length);
        System.arraycopy(LoadSave.loader.dragxdir, 0, Globals.dragxdir, 0, LoadSave.loader.dragxdir.length);
        System.arraycopy(LoadSave.loader.dragydir, 0, Globals.dragydir, 0, LoadSave.loader.dragydir.length);
        System.arraycopy(LoadSave.loader.dragx1, 0, Globals.dragx1, 0, LoadSave.loader.dragx1.length);
        System.arraycopy(LoadSave.loader.dragy1, 0, Globals.dragy1, 0, LoadSave.loader.dragy1.length);
        System.arraycopy(LoadSave.loader.dragx2, 0, Globals.dragx2, 0, LoadSave.loader.dragx2.length);
        System.arraycopy(LoadSave.loader.dragy2, 0, Globals.dragy2, 0, LoadSave.loader.dragy2.length);
        System.arraycopy(LoadSave.loader.dragfloorz, 0, Globals.dragfloorz, 0, LoadSave.loader.dragfloorz.length);
    }

    public static void LoadStuff() {
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            Enemies.gEnemyClock[i] = LoadSave.loader.gEnemyClock[i];
            Enemies.gMoveStatus[i] = LoadSave.loader.gMoveStatus[i];
            ++i;
        }
        i = 0;
        while (i < 6) {
            Enemies.nKills[i] = LoadSave.loader.nKills[i];
            Enemies.nTotalKills[i] = LoadSave.loader.nTotalKills[i];
            ++i;
        }
        Enemies.nEnemyKills = LoadSave.loader.nEnemyKills;
        Enemies.nEnemyMax = LoadSave.loader.nEnemyMax;
        Globals.nDiffDoor = LoadSave.loader.nDiffDoor;
        Globals.nDiffDoorBack = LoadSave.loader.nDiffDoorBack;
        Globals.nTrainWall = LoadSave.loader.nTrainWall;
        Globals.bActiveTrain = LoadSave.loader.bActiveTrain;
        Globals.bTrainSoundSwitch = LoadSave.loader.bTrainSoundSwitch;
        Globals.lockclock = LoadSave.loader.lockclock;
        Globals.totalmoves = LoadSave.loader.totalmoves;
        Engine.visibility = LoadSave.loader.visibility;
        Main.engine.srand(LoadSave.loader.randomseed);
        System.arraycopy(LoadSave.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        System.arraycopy(LoadSave.loader.show2dwall, 0, Engine.show2dwall, 0, 1024);
        System.arraycopy(LoadSave.loader.show2dsprite, 0, Engine.show2dsprite, 0, Engine.MAXSPRITES + 7 >> 3);
        Engine.automapping = LoadSave.loader.automapping;
        Engine.pskybits = LoadSave.loader.pskybits;
        Engine.parallaxyscale = LoadSave.loader.parallaxyscale;
        System.arraycopy(LoadSave.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Engine.parallaxtype = 0;
        Engine.parallaxyoffs = 256;
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        i = 0;
        while (i < 16) {
            Globals.gPlayer[i].copy(LoadSave.loader.plr[i]);
            ++i;
        }
        Globals.nPlayerFirstWeapon = LoadSave.loader.nPlayerFirstWeapon;
        Globals.oldchoose = LoadSave.loader.oldchoose;
        Globals.oldpic = LoadSave.loader.oldpic;
    }

    public static void MapLoad() {
        Engine.numsectors = LoadSave.loader.numsectors;
        int s = 0;
        while (s < Engine.numsectors) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(LoadSave.loader.sector[s]);
            ++s;
        }
        Engine.numwalls = LoadSave.loader.numwalls;
        int w = 0;
        while (w < Engine.numwalls) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(LoadSave.loader.wall[w]);
            ++w;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(LoadSave.loader.sprite[i]);
            ++i;
        }
        System.arraycopy(LoadSave.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(LoadSave.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(LoadSave.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
    }

    public static void AnimationLoad() {
        int i = 0;
        while (i < 512) {
            Animate.gAnimationData[i].id = LoadSave.loader.gAnimationData[i].id;
            Animate.gAnimationData[i].type = LoadSave.loader.gAnimationData[i].type;
            Animate.gAnimationData[i].ptr = LoadSave.loader.gAnimationData[i].ptr;
            Animate.gAnimationData[i].goal = LoadSave.loader.gAnimationData[i].goal;
            Animate.gAnimationData[i].vel = LoadSave.loader.gAnimationData[i].vel;
            Animate.gAnimationData[i].acc = LoadSave.loader.gAnimationData[i].acc;
            ++i;
        }
        Animate.gAnimationCount = LoadSave.loader.gAnimationCount;
        i = Animate.gAnimationCount - 1;
        while (i >= 0) {
            ANIMATION gAnm = Animate.gAnimationData[i];
            Object object = gAnm.ptr = Animate.getobject(gAnm.id, gAnm.type);
            switch (gAnm.type) {
                case 1: 
                case 2: {
                    Main.game.pInt.setwallinterpolate(gAnm.id, (WALL)object);
                    break;
                }
                case 4: {
                    Main.game.pInt.setfloorinterpolate(gAnm.id, (SECTOR)object);
                    break;
                }
                case 8: {
                    Main.game.pInt.setceilinterpolate(gAnm.id, (SECTOR)object);
                }
            }
            --i;
        }
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LoadSave.checkSave(fil) & 0xFFFF;
            if (nVersion != 100 && nVersion >= 100) {
                loader.LoadGDXHeader(fil);
                if (LoadSave.loader.mapnum <= Globals.maps.length && LoadSave.loader.skill >= 0 && LoadSave.loader.skill < 4) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[15];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Globals.nDifficult = (short)LoadSave.loader.skill;
                            Main.gGameScreen.newgame(LoadSave.loader.mapnum);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 100;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        System.err.println("load");
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LoadSave.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen);
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LoadSave.loadgame(loadname)) {
                        Main.game.setPrevScreen();
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            Quotes.viewSetMessage("Incompatible version of saved game found!");
                            Main.game.pNet.ready2send = true;
                        }
                    }
                }
            });
        }
    }

    private static void save(FileResource fil, String savename, long time) {
        LoadSave.SaveHeader(fil, savename, time);
        LoadSave.SaveGDXBlock(fil);
        LoadSave.StuffSave(fil);
        LoadSave.MapSave(fil);
        LoadSave.SectorSave(fil);
        LoadSave.AnimationSave(fil);
        fil.close();
        System.gc();
        Quotes.viewSetMessage("Game saved");
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            LoadSave.save(fil, savename, time);
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            return 0;
        }
        Quotes.viewSetMessage("Game not saved. Access denied!");
        return -1;
    }

    public static void SaveHeader(FileResource fil, String savename, long time) {
        LoadSave.SaveVersion(fil, 100);
        byte[] buf = new byte[8];
        LittleEndian.putLong(buf, 0, time);
        fil.writeBytes(buf, 8);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeInt(Globals.mapnum);
        fil.writeInt(Globals.nDifficult);
    }

    public static void SaveGDXBlock(FileResource fil) {
        ByteBuffer bb = ByteBuffer.allocate(16272);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(Main.gGameScreen.captBuffer);
        Main.gGameScreen.captBuffer = null;
        fil.writeBytes(bb.array(), 16272);
    }

    public static void SectorSave(FileResource fil) {
        int j;
        int b;
        ByteBuffer bb = ByteBuffer.allocate(6848);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 16) {
            bb.putShort(Globals.waterfountainwall[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.waterfountaincnt[i]);
            ++i;
        }
        bb.putShort(Globals.ypanningwallcnt);
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.ypanningwalllist[i]);
            ++i;
        }
        bb.putShort(Globals.floorpanningcnt);
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.floorpanninglist[i]);
            ++i;
        }
        bb.putShort(Globals.warpsectorcnt);
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.warpsectorlist[i]);
            ++i;
        }
        bb.putShort(Globals.xpanningsectorcnt);
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.xpanningsectorlist[i]);
            ++i;
        }
        bb.putShort(Globals.warpsector2cnt);
        i = 0;
        while (i < 32) {
            bb.putShort(Globals.warpsector2list[i]);
            ++i;
        }
        bb.putShort(Globals.subwaytrackcnt);
        int a = 0;
        while (a < 5) {
            b = 0;
            while (b < 128) {
                bb.putShort(Globals.subwaytracksector[a][b]);
                ++b;
            }
            ++a;
        }
        i = 0;
        while (i < 5) {
            bb.putShort(Globals.subwaynumsectors[i]);
            ++i;
        }
        a = 0;
        while (a < 5) {
            b = 0;
            while (b < 8) {
                bb.putInt(Globals.subwaystop[a][b]);
                ++b;
            }
            ++a;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaystopcnt[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaytrackx1[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaytracky1[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaytrackx2[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaytracky2[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwayx[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaygoalstop[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwayvel[i]);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putInt(Globals.subwaypausetime[i]);
            ++i;
        }
        bb.putShort(Globals.revolvecnt);
        i = 0;
        while (i < 4) {
            bb.putShort(Globals.revolvesector[i]);
            bb.putShort(Globals.revolveang[i]);
            j = 0;
            while (j < 48) {
                bb.putInt(Globals.revolvex[i][j]);
                bb.putInt(Globals.revolvey[i][j]);
                ++j;
            }
            bb.putInt(Globals.revolvepivotx[i]);
            bb.putInt(Globals.revolvepivoty[i]);
            ++i;
        }
        bb.putShort(Globals.swingcnt);
        i = 0;
        while (i < 32) {
            j = 0;
            while (j < 8) {
                bb.putShort((short)Globals.swingdoor[i].wall[j]);
                ++j;
            }
            bb.putShort((short)Globals.swingdoor[i].sector);
            bb.putShort((short)Globals.swingdoor[i].angopen);
            bb.putShort((short)Globals.swingdoor[i].angclosed);
            bb.putShort((short)Globals.swingdoor[i].angopendir);
            bb.putShort((short)Globals.swingdoor[i].ang);
            bb.putShort((short)Globals.swingdoor[i].anginc);
            j = 0;
            while (j < 8) {
                bb.putInt(Globals.swingdoor[i].x[j]);
                ++j;
            }
            j = 0;
            while (j < 8) {
                bb.putInt(Globals.swingdoor[i].y[j]);
                ++j;
            }
            ++i;
        }
        bb.putShort(Globals.dragsectorcnt);
        i = 0;
        while (i < 16) {
            bb.putShort(Globals.dragsectorlist[i]);
            bb.putShort(Globals.dragxdir[i]);
            bb.putShort(Globals.dragydir[i]);
            bb.putInt(Globals.dragx1[i]);
            bb.putInt(Globals.dragy1[i]);
            bb.putInt(Globals.dragx2[i]);
            bb.putInt(Globals.dragy2[i]);
            bb.putInt(Globals.dragfloorz[i]);
            ++i;
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void StuffSave(FileResource fil) {
        int bufsize = 29481;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.putInt(Enemies.gEnemyClock[i]);
            bb.putShort(Enemies.gMoveStatus[i]);
            ++i;
        }
        i = 0;
        while (i < 6) {
            bb.putShort(Enemies.nKills[i]);
            bb.putShort(Enemies.nTotalKills[i]);
            ++i;
        }
        bb.putInt(Enemies.nEnemyKills);
        bb.putInt(Enemies.nEnemyMax);
        bb.putShort(Globals.nDiffDoor);
        bb.putShort(Globals.nDiffDoorBack);
        bb.putShort(Globals.nTrainWall);
        bb.put(Globals.bActiveTrain ? (byte)1 : 0);
        bb.put(Globals.bTrainSoundSwitch ? (byte)1 : 0);
        bb.putInt(Globals.lockclock);
        bb.putInt(Globals.totalmoves);
        bb.putInt(Engine.visibility);
        bb.putInt(Main.engine.getrand());
        bb.put(Engine.show2dsector);
        bb.put(Engine.show2dwall);
        bb.put(Engine.show2dsprite);
        bb.put(Engine.automapping);
        bb.putShort(Engine.pskybits);
        bb.putInt(Engine.parallaxyscale);
        i = 0;
        while (i < 256) {
            bb.putShort(Engine.pskyoff[i]);
            ++i;
        }
        bb.putShort(Mmulti.connecthead);
        i = 0;
        while (i < 16) {
            bb.putShort(Mmulti.connectpoint2[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            bb.put(Globals.gPlayer[i].getBytes());
            ++i;
        }
        bb.putShort(Globals.nPlayerFirstWeapon);
        bb.putInt(Globals.oldchoose);
        bb.putShort(Globals.oldpic);
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void MapSave(FileResource fil) {
        int bufsize = 2 + Engine.numsectors * 40 + 2 + Engine.numwalls * 32 + Engine.MAXSPRITES * 44 + (Engine.MAXSECTORS + 1) * 2 + 2050 + Engine.MAXSPRITES * 8;
        ByteBuffer bb = ByteBuffer.allocate(bufsize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort(Engine.numwalls);
        int w = 0;
        while (w < Engine.numwalls) {
            bb.put(Engine.wall[w].getBytes());
            ++w;
        }
        bb.putShort(Engine.numsectors);
        int s = 0;
        while (s < Engine.numsectors) {
            bb.put(Engine.sector[s].getBytes());
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.put(Engine.sprite[i].getBytes());
            ++i;
        }
        i = 0;
        while (i <= Engine.MAXSECTORS) {
            bb.putShort(Engine.headspritesect[i]);
            ++i;
        }
        i = 0;
        while (i <= 1024) {
            bb.putShort(Engine.headspritestat[i]);
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            bb.putShort(Engine.prevspritesect[i]);
            bb.putShort(Engine.prevspritestat[i]);
            bb.putShort(Engine.nextspritesect[i]);
            bb.putShort(Engine.nextspritestat[i]);
            ++i;
        }
        fil.writeBytes(bb.array(), bb.capacity());
    }

    public static void SaveVersion(FileResource fil, int nVersion) {
        fil.writeBytes(savsign.toCharArray(), 4);
        fil.writeShort(nVersion);
    }

    public static void AnimationSave(FileResource fil) {
        int i = 0;
        while (i < 512) {
            fil.writeShort(Animate.gAnimationData[i].id);
            fil.writeByte(Animate.gAnimationData[i].type);
            fil.writeInt(Animate.gAnimationData[i].goal);
            fil.writeInt(Animate.gAnimationData[i].vel);
            fil.writeInt(Animate.gAnimationData[i].acc);
            ++i;
        }
        fil.writeInt(Animate.gAnimationCount);
    }

    public static void quicksave() {
        if (Globals.gPlayer[Mmulti.myconnectindex].nHealth != 0) {
            gQuickSaving = true;
        }
    }
}

