/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Menus;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.PCXFile;

public class ItemPCX
extends MenuItem {
    private PCXFile fil;
    private byte index;

    public ItemPCX(int x, int y, int index) {
        super(null, null);
        this.x = x;
        this.y = y;
        this.flags |= 0xB;
        this.index = (byte)index;
    }

    @Override
    public void draw(MenuHandler handler) {
        Main.engine.rotatesprite(this.x << 16, this.y << 16, 65536, 512, Globals.TILE_ANIM, -128, 251, 94, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case BSPACE: 
            case RMB: {
                this.m_pMenu.mNavUp();
                return false;
            }
            case RIGHT: 
            case ENTER: 
            case SPACE: 
            case LMB: {
                this.m_pMenu.mNavDown();
                return false;
            }
            case UP: 
            case DW: 
            case ESC: 
            case DELETE: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    public void show() {
        if (this.fil == null) {
            try {
                this.fil = new PCXFile(BuildGdx.cache.open(this.index & 0xFF, ""));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        Main.engine.changepalette(this.fil.getPalette());
        Engine.waloff[Globals.TILE_ANIM] = this.fil.getData();
        Engine.tilesizx[Globals.TILE_ANIM] = (short)this.fil.getHeight();
        Engine.tilesizy[Globals.TILE_ANIM] = (short)this.fil.getWidth();
        Main.engine.invalidatetile(Globals.TILE_ANIM, 251, 16);
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int x, int y) {
        return false;
    }
}

