/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.BuildNet;

public class Input
implements BuildNet.NetInput {
    public int xvel;
    public int yvel;
    public float angvel;
    public int bits;
    public float horiz;
    private static ByteBuffer InputBuffer = ByteBuffer.allocate(Input.sizeof(100)).order(ByteOrder.LITTLE_ENDIAN);

    public Input() {
    }

    public Input(Resource bb) {
        this.xvel = bb.readInt();
        this.yvel = bb.readInt();
        this.angvel = bb.readFloat().floatValue();
        this.bits = bb.readInt();
        this.horiz = bb.readFloat().floatValue();
    }

    @Override
    public int GetInput(byte[] p, int offset, BuildNet.NetInput oldInput) {
        return 0;
    }

    @Override
    public int PutInput(byte[] p, int offset, BuildNet.NetInput oldInput) {
        return 0;
    }

    @Override
    public void Reset() {
        this.xvel = 0;
        this.yvel = 0;
        this.angvel = 0.0f;
        this.horiz = 0.0f;
        this.bits = 0;
    }

    @Override
    public BuildNet.NetInput Copy(BuildNet.NetInput src) {
        Input i = (Input)src;
        this.xvel = i.xvel;
        this.yvel = i.yvel;
        this.angvel = i.angvel;
        this.horiz = i.horiz;
        this.bits = i.bits;
        return this;
    }

    public static int sizeof(int version) {
        return 20;
    }

    public byte[] getBytes() {
        InputBuffer.clear();
        InputBuffer.putInt(this.xvel);
        InputBuffer.putInt(this.yvel);
        InputBuffer.putFloat(this.angvel);
        InputBuffer.putInt(this.bits);
        InputBuffer.putFloat(this.horiz);
        return InputBuffer.array();
    }
}

