/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.LSP.Enemies;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Weapons;

public class View {
    public static final int kView2D = 2;
    public static final int kView3D = 3;
    public static final int kView2DIcon = 4;
    public static int[] zofslope = new int[2];
    public static int nPalDiff;
    public static int nPalDelay;
    public static int rtint;
    public static int btint;
    public static int gtint;
    public static byte[] curpal;
    private static char[] statbuffer;

    static {
        curpal = new byte[768];
        statbuffer = new char[80];
    }

    public static void drawscreen(int snum, int dasmoothratio) {
        int cposx = Globals.gPlayer[snum].x;
        int cposy = Globals.gPlayer[snum].y;
        int cposz = Globals.gPlayer[snum].z;
        float choriz = Globals.gPlayer[snum].horiz + Globals.gPlayer[snum].nBobbing;
        int czoom = Globals.gPlayer[snum].zoom;
        float cang = Globals.gPlayer[snum].ang;
        short csect = Globals.gPlayer[snum].sectnum;
        if (!Main.game.menu.gShowMenu && !Console.IsShown() || Globals.recstat == 2) {
            int ix = Globals.gPlayer[snum].ox;
            int iy = Globals.gPlayer[snum].oy;
            int iz = Globals.gPlayer[snum].oz;
            float iHoriz = Globals.gPlayer[snum].ohoriz;
            float inAngle = Globals.gPlayer[snum].oang;
            int izoom = Globals.gPlayer[snum].ozoom;
            ix += Pragmas.mulscale(cposx - Globals.gPlayer[snum].ox, dasmoothratio, 16);
            iy += Pragmas.mulscale(cposy - Globals.gPlayer[snum].oy, dasmoothratio, 16);
            iz += Pragmas.mulscale(cposz - Globals.gPlayer[snum].oz, dasmoothratio, 16);
            iHoriz += (choriz - Globals.gPlayer[snum].ohoriz) * (float)dasmoothratio / 65536.0f;
            inAngle += (Gameutils.BClampAngle(cang - Globals.gPlayer[snum].oang + 1024.0f) - 1024.0f) * (float)dasmoothratio / 65536.0f;
            izoom += Pragmas.mulscale(czoom - Globals.gPlayer[snum].ozoom, dasmoothratio, 16);
            cposx = ix;
            cposy = iy;
            cposz = iz;
            czoom = izoom;
            choriz = iHoriz;
            cang = inAngle;
        }
        Main.engine.getzsofslope(csect, cposx, cposy, zofslope);
        int lz = 1024;
        if (cposz < zofslope[0] + lz) {
            cposz = zofslope[0] + lz;
        }
        if (cposz > zofslope[1] - lz) {
            cposz = zofslope[1] - lz;
        }
        if (Globals.gPlayer[snum].gViewMode != 4) {
            Main.engine.drawrooms(cposx, cposy, cposz, cang, choriz, csect);
            View.analyzesprites(snum, dasmoothratio);
            Main.engine.drawmasks();
            int i = 0;
            while (i < Engine.numsectors) {
                if ((Engine.gotsector[i >> 3] & Engine.pow2char[i & 7]) != 0) {
                    View.MarkSectorSeen(i);
                }
                ++i;
            }
        }
        if (Globals.gPlayer[snum].gViewMode != 3) {
            if (Globals.followmode) {
                cposx = Globals.followx;
                cposy = Globals.followy;
                cang = Globals.followa;
            }
            if (Globals.gPlayer[snum].gViewMode == 4) {
                Main.engine.clearview(0);
                Main.engine.drawmapview(cposx, cposy, czoom, (int)cang);
            }
            Main.engine.drawoverheadmap(cposx, cposy, czoom, (short)cang);
        }
    }

    public static void MarkSectorSeen(int sect) {
        if (!Gameutils.isValidSector(sect)) {
            return;
        }
        if ((1 << (sect & 7) & Engine.show2dsector[sect >> 3]) == 0) {
            int n = sect >> 3;
            Engine.show2dsector[n] = (byte)(Engine.show2dsector[n] | 1 << (sect & 7));
            int startwall = Engine.sector[sect].wallptr;
            int endwall = startwall + Engine.sector[sect].wallnum;
            int j = startwall;
            while (j < endwall) {
                int n2 = j >> 3;
                Engine.show2dwall[n2] = (byte)(Engine.show2dwall[n2] | 1 << (j & 7));
                ++j;
            }
        }
    }

    public static void analyzesprites(int snum, int smoothratio) {
        int i = 0;
        while (i < Engine.spritesortcnt) {
            Interpolation.ILoc oldLoc;
            SPRITE pTSprite = Engine.tsprite[i];
            if (pTSprite.owner != -1 && (oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.owner)) != null) {
                int x = oldLoc.x;
                int y = oldLoc.y;
                int z = oldLoc.z;
                short nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + Pragmas.mulscale((pTSprite.ang - oldLoc.ang + 1024 & 0x7FF) - 1024, smoothratio, 16));
                pTSprite.x = x += Pragmas.mulscale(pTSprite.x - oldLoc.x, smoothratio, 16);
                pTSprite.y = y += Pragmas.mulscale(pTSprite.y - oldLoc.y, smoothratio, 16);
                pTSprite.z = z += Pragmas.mulscale(pTSprite.z - oldLoc.z, smoothratio, 16);
                pTSprite.ang = nAngle;
            }
            ++i;
        }
        int dax = Globals.gPlayer[snum].x;
        int day = Globals.gPlayer[snum].y;
        int i2 = 0;
        while (i2 < Engine.spritesortcnt) {
            SPRITE tspr = Engine.tsprite[i2];
            short owner = tspr.owner;
            int dx = tspr.x - dax;
            int dy = tspr.y - day;
            int k = Main.engine.getangle(dx, dy);
            k = (tspr.ang + 3072 + 128 - k & 0x7FF) >> 8 & 7;
            switch (tspr.picnum) {
                case 275: 
                case 339: {
                    if (k <= 4) {
                        tspr.picnum = (short)(tspr.picnum + (k + 3 & 4));
                        tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                        break;
                    }
                    tspr.picnum = (short)(tspr.picnum + (8 - k + 3 & 4));
                    tspr.cstat = (short)(tspr.cstat | 4);
                    break;
                }
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    int fz;
                    if (Engine.sprite[owner].statnum == 1 || Engine.sprite[owner].statnum == 2) {
                        if (k <= 4) {
                            tspr.picnum = (short)(tspr.picnum + 4 * k);
                            tspr.cstat = (short)(tspr.cstat & 0xFFFFFFFB);
                        } else {
                            tspr.picnum = (short)(tspr.picnum + 4 * (8 - k));
                            tspr.cstat = (short)(tspr.cstat | 4);
                        }
                    }
                    if (tspr.statnum == 99 || Engine.spritesortcnt >= 1022 || (fz = Engine.sector[Engine.sprite[owner].sectnum].floorz) <= Globals.gPlayer[snum].z) break;
                    if (Engine.tsprite[Engine.spritesortcnt] == null) {
                        Engine.tsprite[Engine.spritesortcnt] = new SPRITE();
                    }
                    SPRITE tshadow = Engine.tsprite[Engine.spritesortcnt];
                    tshadow.set(tspr);
                    short camangle = Main.engine.getangle(dax - tshadow.x, day - tshadow.y);
                    tshadow.x -= Pragmas.mulscale(Engine.sintable[camangle + 512 & 0x7FF], 100L, 16);
                    tshadow.y += Pragmas.mulscale(Engine.sintable[camangle + 1024 & 0x7FF], 100L, 16);
                    tshadow.z = fz + 1;
                    tshadow.statnum = (short)99;
                    tshadow.yrepeat = (short)(tspr.yrepeat >> 3);
                    if (tshadow.yrepeat < 4) {
                        tshadow.yrepeat = (short)4;
                    }
                    tshadow.shade = (byte)127;
                    tshadow.cstat = (short)(tshadow.cstat | 2);
                    ++Engine.spritesortcnt;
                }
            }
            ++i2;
        }
    }

    public static void drawhealth(int snum, int x, int y, int scale, int nFlags) {
        String name = "health: ";
        Main.game.getFont(1).drawText(x, y, name, scale, 0, 175, BuildFont.TextAlign.Left, 264, true);
        int nGauge = Globals.gPlayer[snum].nHealth * Engine.tilesizx[641] / 320;
        Main.engine.rotatesprite((x += Main.game.getFont(1).getWidth(name, scale)) << 16, y << 16, scale, 0, 641, 0, 0, 0x18 | nFlags, 0, 0, x + Pragmas.scale(nGauge, scale, 65536L), Engine.ydim);
    }

    public static void drawmana(int snum, int x, int y, int scale, int nFlags) {
        String name = "mana:  ";
        Main.game.getFont(1).drawText(x, y, name, scale, 0, 197, BuildFont.TextAlign.Left, 264, true);
        int nGauge = Globals.gPlayer[snum].nMana * Engine.tilesizx[641] / 320;
        Main.engine.rotatesprite((x += Main.game.getFont(1).getWidth(name, scale)) - Pragmas.scale(Engine.tilesizx[641] / 2, scale, 65536L) - 1 << 16, y << 16, scale, 0, 641, 0, 0, 0x18 | nFlags, x, 0, x + Pragmas.scale(nGauge, scale, 65536L), Engine.ydim);
    }

    public static void drawammo(int snum, int x, int y, int scale, int nFlags) {
        String name = "ammo:   ";
        Main.game.getFont(1).drawText(x, y, name, scale, 0, 120, BuildFont.TextAlign.Left, 264, true);
        int nGauge = Globals.gPlayer[snum].nAmmo[Globals.gPlayer[snum].nLastChoosedWeapon] * Engine.tilesizx[640] / 320;
        Main.engine.rotatesprite((x += Main.game.getFont(1).getWidth(name, scale)) - Pragmas.scale(Engine.tilesizx[640] / 2, scale, 65536L) - 1 << 16, y << 16, scale, 0, 640, 0, 0, 0x18 | nFlags, x, 0, x + Pragmas.scale(nGauge, scale, 65536L), Engine.ydim);
    }

    public static void drawbar(int x, int y, int scale, int snum) {
        float fscale = (float)scale / 65536.0f;
        int sx1 = (int)((float)(x - 6) * fscale);
        int sy1 = y + (int)(4.0f * fscale);
        int sx2 = (int)((float)(x + 230) * fscale);
        int sy2 = y + (int)(45.0f * fscale);
        Main.engine.rotatesprite(sx1 << 16, sy1 << 16, scale, 0, 611, 64, 0, 313, 0, 0, sx2, sy2);
        x = (int)((float)x * fscale);
        int yoffs = (int)(10.0f * fscale);
        if (Globals.gPlayer[snum].nWeapon > 6) {
            View.drawmana(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        } else {
            View.drawammo(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        }
        View.drawhealth(Mmulti.myconnectindex, x, y += yoffs, scale, 256);
        y += yoffs;
        int i = 1;
        while (i < 13) {
            if (Globals.gPlayer[snum].nAmmo[i] != 0) {
                Main.engine.rotatesprite(x + 1 << 16, y + 1 << 16, scale, 0, Weapons.getIcon(i), 48, 0, 280, 0, 0, Engine.xdim, Engine.ydim);
                Main.engine.rotatesprite(x << 16, y << 16, scale, 0, Weapons.getIcon(i), 0, 0, 280, 0, 0, Engine.xdim, Engine.ydim);
            } else {
                Main.engine.rotatesprite(x + 1 << 16, y + 1 << 16, scale, 0, Weapons.getIcon(i), 48, 0, 280, 0, 0, Engine.xdim, Engine.ydim);
            }
            if (Globals.gPlayer[snum].nWeapon == i) {
                Main.engine.rotatesprite(x + 1 << 16, y + (int)(13.0f * fscale) << 16, scale / 2, 0, 9258, 0, 0, 280, 0, 0, Engine.xdim, Engine.ydim);
            }
            x += (int)(19.0f * fscale);
            ++i;
        }
    }

    public static void TintPalette(int r, int g, int b) {
        r = Gameutils.BClipRange(r, 0, 63);
        g = Gameutils.BClipRange(g, 0, 63);
        b = Gameutils.BClipRange(b, 0, 63);
        if (g != 0 && gtint > 64) {
            return;
        }
        gtint += g;
        if (r != 0 && rtint > 64) {
            return;
        }
        rtint += r;
        if (b != 0 && btint > 64) {
            return;
        }
        btint += b;
        int nDiff = r;
        if (nDiff <= g) {
            nDiff = g;
        }
        if (nDiff <= b) {
            nDiff = b;
        }
        nPalDiff += nDiff;
        if (Main.engine.glrender() == null) {
            int i = 0;
            while (i < 256) {
                View.curpal[3 * i + 0] = (byte)Gameutils.BClipHigh((curpal[3 * i + 0] & 0xFF) + r, 63);
                View.curpal[3 * i + 1] = (byte)Gameutils.BClipHigh((curpal[3 * i + 1] & 0xFF) + g, 63);
                View.curpal[3 * i + 2] = (byte)Gameutils.BClipHigh((curpal[3 * i + 2] & 0xFF) + b, 63);
                ++i;
            }
        }
        nPalDelay = 0;
    }

    public static void GrabPalette() {
        System.arraycopy(Engine.palette, 0, curpal, 0, 768);
        Main.engine.setbrightness(BuildSettings.paletteGamma.get(), curpal, GLRenderer.GLInvalidateFlag.All);
        nPalDiff = 0;
        nPalDelay = 0;
        btint = 0;
        gtint = 0;
        rtint = 0;
    }

    public static void FixPalette() {
        if (nPalDiff == 0) {
            return;
        }
        if (nPalDelay-- > 0) {
            return;
        }
        nPalDelay = 1;
        if (Main.engine.glrender() == null) {
            int i = 0;
            while (i < 768) {
                int dP = (curpal[i] & 0xFF) - (Engine.palette[i] & 0xFF);
                if (dP > 0) {
                    if (dP <= 5) {
                        View.curpal[i] = Engine.palette[i];
                    } else {
                        int n = i;
                        curpal[n] = (byte)(curpal[n] - 3);
                    }
                }
                ++i;
            }
            Main.engine.setbrightness(BuildSettings.paletteGamma.get(), curpal, GLRenderer.GLInvalidateFlag.All);
        } else {
            Main.engine.setpalettefade(rtint, gtint, btint, 0);
        }
        nPalDiff = Gameutils.BClipLow(nPalDiff - 3, 0);
        rtint = Gameutils.BClipLow(rtint - 3, 0);
        gtint = Gameutils.BClipLow(gtint - 3, 0);
        btint = Gameutils.BClipLow(btint - 3, 0);
    }

    public static void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Main.cfg.gShowStat == 2 && Globals.gPlayer[Mmulti.myconnectindex].gViewMode == 3) {
            return;
        }
        int nBits = 256;
        float fscale = (float)zoom / 65536.0f;
        BuildFont f = Main.game.getFont(1);
        int yoffset = (int)(2.5f * (float)f.getHeight() * fscale);
        int sx1 = (int)((float)(x - 6) * fscale);
        int sy1 = y - (int)(4.0f * fscale) - yoffset;
        int sx2 = (int)((float)(x + (11 * f.getWidth('x') + 6)) * fscale);
        int sy2 = y - (int)fscale;
        Main.engine.rotatesprite(sx1 << 16, sy1 << 16, zoom, 0, 611, 64, 0, 0x39 | nBits, 0, 0, sx2, sy2);
        Strhandler.buildString(statbuffer, 0, "k: ");
        int alignx = f.getWidth(statbuffer, zoom);
        x = (int)((float)x * fscale);
        int statx = x;
        int staty = y -= yoffset;
        f.drawText(statx, staty, statbuffer, zoom, 0, 175, BuildFont.TextAlign.Left, 8 | nBits, true);
        int offs = Strhandler.Bitoa(Enemies.nEnemyKills, statbuffer);
        offs = Strhandler.buildString(statbuffer, offs, " / ", Enemies.nEnemyMax);
        f.drawText(statx += alignx + 2, staty, statbuffer, zoom, 0, 4, BuildFont.TextAlign.Left, 8 | nBits, true);
        statx = x;
        staty = y + f.getHeight(zoom);
        Strhandler.buildString(statbuffer, 0, "t: ");
        f.drawText(statx, staty, statbuffer, zoom, 0, 175, BuildFont.TextAlign.Left, 8 | nBits, true);
        alignx = f.getWidth(statbuffer, zoom);
        int sec = Globals.totalmoves / 30 % 60;
        int minutes = Globals.totalmoves / 1800 % 60;
        int hours = Globals.totalmoves / 108000 % 60;
        offs = Strhandler.Bitoa(hours, statbuffer, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", minutes, 2);
        offs = Strhandler.buildString(statbuffer, offs, ":", sec, 2);
        f.drawText(statx += alignx + 2, staty, statbuffer, zoom, 0, 4, BuildFont.TextAlign.Left, 8 | nBits, true);
    }
}

