/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.Components;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Launcher.desktop.BoundsPopupMenuListener;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.ComboItem;
import ru.m210projects.Launcher.desktop.Components.Buttons.OpenButton;
import ru.m210projects.Launcher.desktop.Components.Buttons.SettingsButton;
import ru.m210projects.Launcher.desktop.Components.DirectoryBrowser;
import ru.m210projects.Launcher.desktop.Components.GamePanel;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.RRRAEntry;
import ru.m210projects.Launcher.desktop.GetSteamLibraries;
import ru.m210projects.Launcher.desktop.JLauncher;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Launcher.desktop.WinReg;

public class RRRAPanel
extends GamePanel {
    private static final long serialVersionUID = 1L;
    private JTextField pathField;
    private JButton launchButton;
    private OpenButton openButton;
    private JLauncher main;
    private JComboBox<ComboItem> gameFoldersList;
    private JLabel messageField = new JLabel();
    private boolean isPortable;
    private boolean Init = false;
    private boolean initialized = false;

    public RRRAPanel(JLauncher main, RRRAEntry entry, boolean isPortable) {
        super(entry);
        this.main = main;
        this.isPortable = isPortable;
    }

    @Override
    public void init() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow][]"));
        if (Main.isWindows & !this.isPortable) {
            this.gameFoldersList = new JComboBox();
            final BuildConfig cfg = this.entry.getConfig();
            final ComboItem cfgPath = new ComboItem(cfg.path, cfg.path);
            if (cfg.path != null) {
                this.gameFoldersList.addItem(cfgPath);
            }
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (!RRRAPanel.this.Init) {
                        int count = 3;
                        while (count < 5) {
                            String regPath = null;
                            String regKey = null;
                            String pathToGame = null;
                            String label = null;
                            switch (count) {
                                case 3: {
                                    regPath = "HKLM\\Software\\WOW6432Node\\GOG.com\\GOGCREDNECKRIDESAGAIN";
                                    regKey = "path";
                                    label = "[GOG] ";
                                    break;
                                }
                                case 4: {
                                    regPath = "HKLM\\Software\\GOG.com\\GOGCREDNECKRIDESAGAIN";
                                    regKey = "path";
                                    label = "[GOG] ";
                                }
                            }
                            pathToGame = WinReg.getRegKey(regPath, regKey);
                            if (pathToGame != null && new File(pathToGame).exists()) {
                                if (!pathToGame.endsWith("\\")) {
                                    pathToGame = String.valueOf(pathToGame) + "\\";
                                }
                                if (Objects.equals(pathToGame, cfg.path)) {
                                    RRRAPanel.this.gameFoldersList.insertItemAt(new ComboItem(pathToGame, String.valueOf(label) + pathToGame), 0);
                                    RRRAPanel.this.gameFoldersList.removeItem(cfgPath);
                                } else {
                                    RRRAPanel.this.gameFoldersList.addItem(new ComboItem(pathToGame, String.valueOf(label) + pathToGame));
                                }
                            }
                            ++count;
                        }
                        int i = 0;
                        while (i < GetSteamLibraries.steamLibraries.size()) {
                            ComboItem path = new ComboItem(String.valueOf(GetSteamLibraries.steamLibraries.get(i)) + "common\\Redneck Rampage Rides Again\\AGAIN\\", "[Steam] " + GetSteamLibraries.steamLibraries.get(i) + "common\\Redneck Rampage Rides Again\\AGAIN\\");
                            if (new File(path.getValue()).exists()) {
                                if (Objects.equals(path.getValue(), cfg.path)) {
                                    RRRAPanel.this.gameFoldersList.insertItemAt(path, 0);
                                    RRRAPanel.this.gameFoldersList.removeItem(cfgPath);
                                } else {
                                    RRRAPanel.this.gameFoldersList.addItem(path);
                                }
                            }
                            ++i;
                        }
                        RRRAPanel.this.Init = true;
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            this.gameFoldersList.addPopupMenuListener(popupMenuListener);
            this.gameFoldersList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RRRAPanel.this.path = ((ComboItem)RRRAPanel.this.gameFoldersList.getSelectedItem()).getValue();
                    CheckFiles result = RRRAPanel.this.entry.checkResources(RRRAPanel.this.path, true);
                    boolean access = result.getValue();
                    RRRAPanel.this.messageField.setText(result.getLabel());
                    RRRAPanel.this.entry.getConfig().path = RRRAPanel.this.path;
                    RRRAPanel.this.startButtonStatus(access);
                }
            });
            BoundsPopupMenuListener listener = new BoundsPopupMenuListener(true, false);
            this.gameFoldersList.addPopupMenuListener(listener);
            this.gameFoldersList.setPrototypeDisplayValue(new ComboItem("", ""));
            this.add(this.gameFoldersList, "cell 0 0,grow");
        } else {
            this.pathField = new JTextField();
            this.pathField.setToolTipText("Path to " + this.entry.getResourceName() + " files");
            this.pathField.setEditable(false);
            this.add((Component)this.pathField, "cell 0 0,grow");
            this.pathField.setColumns(10);
        }
        JButton browseTW = new JButton("...");
        browseTW.setToolTipText("Choose folder");
        browseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DirectoryBrowser.showDirectoryChooser(Main.fr.getFrame(), RRRAPanel.this.path, RRRAPanel.this.entry.getResourceName(), RRRAPanel.this.entry.getIcon16());
                if (f != null) {
                    RRRAPanel.this.path = String.valueOf(f.getAbsolutePath()) + File.separator;
                }
                if (Main.isWindows) {
                    ComboItem addedPath = new ComboItem(RRRAPanel.this.path, RRRAPanel.this.path);
                    RRRAPanel.this.gameFoldersList.addItem(addedPath);
                    RRRAPanel.this.gameFoldersList.setSelectedItem(addedPath);
                }
                if (!Main.isWindows) {
                    RRRAPanel.this.pathField.setText(RRRAPanel.this.path);
                }
                CheckFiles result = RRRAPanel.this.entry.checkResources(RRRAPanel.this.path, true);
                boolean access = result.getValue();
                RRRAPanel.this.messageField.setText(result.getLabel());
                RRRAPanel.this.entry.getConfig().path = RRRAPanel.this.path;
                RRRAPanel.this.startButtonStatus(access);
            }
        });
        if (!this.isPortable) {
            this.add((Component)browseTW, "cell 2 0,grow");
        }
        this.openButton = new OpenButton();
        this.add((Component)this.openButton, "cell 3 0,grow");
        this.add((Component)this.messageField, "cell 0 1 4, grow");
        this.messageField.setVerticalAlignment(1);
        this.launchButton = new JButton();
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RRRAPanel.this.launchButton.setText("Loading...");
                RRRAPanel.this.launchButton.setEnabled(false);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).RRRAPanel.this.entry.startGame((this).RRRAPanel.this.path);
                    }
                });
            }
        });
        this.add((Component)this.launchButton, "cell 0 3 3 1,grow");
        this.add((Component)new SettingsButton(this.main, this.entry, null, "Settings"), "cell 3 3,alignx right,growy");
    }

    @Override
    public void update() {
        BuildConfig cfg = this.entry.getConfig();
        this.path = cfg.path != null ? cfg.path : GameEntry.getDirPath();
        this.openButton.update(this.path);
        if (!this.initialized) {
            CheckFiles result = this.entry.checkResources(this.path, true);
            boolean access = result.getValue();
            this.messageField.setText(result.getLabel());
            this.startButtonStatus(access);
            if (!Main.isWindows || this.isPortable) {
                this.pathField.setText(this.path);
            }
            this.initialized = true;
        }
    }

    public void startButtonStatus(boolean access) {
        this.launchButton.setEnabled(access);
        if (access) {
            this.launchButton.setText("Play " + this.entry.getResourceName());
        } else {
            this.launchButton.setText(String.valueOf(this.entry.getResourceName()) + " resources not found!");
        }
    }
}

