/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.AnimStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Anim {
    public static final int MAX_LIL_ANIM = 400;
    public static int nAnimsFree;
    private static short[] AnimsFree;
    private static int[] AnimRunRec;
    public static byte[] AnimFlags;
    public static AnimStruct[] AnimList;

    static {
        AnimsFree = new short[400];
        AnimRunRec = new int[400];
        AnimFlags = new byte[400];
        AnimList = new AnimStruct[400];
    }

    public static void InitAnims() {
        int i = 0;
        while (i < 400) {
            Anim.AnimsFree[i] = i;
            if (AnimList[i] != null) {
                Anim.AnimList[i].nSprite = (short)-1;
            }
            i = (short)(i + 1);
        }
        nAnimsFree = 400;
        Globals.nMagicSeq = Seq.SeqOffsets[41] + 21;
        Globals.nPreMagicSeq = Seq.SeqOffsets[64];
        Globals.nSavePointSeq = Seq.SeqOffsets[41] + 12;
    }

    public static ByteBuffer saveAnm() {
        int nAnims = 0;
        int i = 0;
        while (i < 400) {
            if (AnimList[i] != null && Anim.AnimList[i].nSprite != -1) {
                ++nAnims;
            }
            ++i;
        }
        ByteBuffer bb = ByteBuffer.allocate(nAnims * 8 + 2000 + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nAnimsFree);
        int i2 = 0;
        while (i2 < 400) {
            bb.putShort(AnimsFree[i2]);
            bb.putShort((short)AnimRunRec[i2]);
            bb.put(AnimFlags[i2]);
            ++i2;
        }
        if (nAnims != 0) {
            i2 = 0;
            while (i2 < 400) {
                if (AnimList[i2] != null && Anim.AnimList[i2].nSprite != -1) {
                    bb.putShort((short)i2);
                    AnimList[i2].save(bb);
                }
                ++i2;
            }
        }
        return bb;
    }

    public static void loadAnm(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i = 0;
            while (i < 400) {
                if (loader.AnimList[i] != null) {
                    loader.AnimList[i].nSprite = (short)-1;
                }
                ++i;
            }
            loader.nAnimsFree = bb.readShort().shortValue();
            i = 0;
            while (i < 400) {
                loader.AnimsFree[i] = bb.readShort();
                loader.AnimRunRec[i] = bb.readShort().shortValue();
                loader.AnimFlags[i] = bb.readByte();
                ++i;
            }
            int nAnims = 400 - loader.nAnimsFree;
            while (nAnims > 0) {
                short i2 = bb.readShort();
                if (loader.AnimList[i2] == null) {
                    loader.AnimList[i2] = new AnimStruct();
                }
                loader.AnimList[i2].load(bb);
                --nAnims;
            }
        } else {
            nAnimsFree = loader.nAnimsFree;
            System.arraycopy(loader.AnimsFree, 0, AnimsFree, 0, 400);
            System.arraycopy(loader.AnimRunRec, 0, AnimRunRec, 0, 400);
            System.arraycopy(loader.AnimFlags, 0, AnimFlags, 0, 400);
            int i = 0;
            while (i < 400) {
                if (AnimList[i] != null) {
                    Anim.AnimList[i].nSprite = (short)-1;
                }
                if (loader.AnimList[i] != null && loader.AnimList[i].nSprite != -1) {
                    if (AnimList[i] == null) {
                        Anim.AnimList[i] = new AnimStruct();
                    }
                    AnimList[i].copy(loader.AnimList[i]);
                }
                ++i;
            }
            Globals.nMagicSeq = Seq.SeqOffsets[41] + 21;
            Globals.nPreMagicSeq = Seq.SeqOffsets[64];
            Globals.nSavePointSeq = Seq.SeqOffsets[41] + 12;
        }
    }

    public static int BuildAnim(int spr, int a2, int a3, int x, int y, int z, int sectnum, int size, int flags) {
        int v20 = a2;
        int v21 = a3;
        if (--nAnimsFree != 0) {
            short nAnim = AnimsFree[nAnimsFree];
            if (spr == -1) {
                spr = Main.engine.insertsprite((short)sectnum, (short)500);
            }
            Engine.sprite[spr].y = y;
            Engine.sprite[spr].z = z;
            Engine.sprite[spr].x = x;
            Engine.sprite[spr].cstat = 0;
            if ((flags & 4) != 0) {
                Engine.sprite[spr].pal = (short)4;
                Engine.sprite[spr].shade = (byte)-64;
            } else {
                Engine.sprite[spr].pal = 0;
                Engine.sprite[spr].shade = (byte)-12;
            }
            Engine.sprite[spr].clipdist = 10;
            Engine.sprite[spr].xrepeat = (short)size;
            Engine.sprite[spr].yrepeat = (short)size;
            Engine.sprite[spr].picnum = 1;
            Engine.sprite[spr].ang = 0;
            Engine.sprite[spr].xoffset = 0;
            Engine.sprite[spr].yoffset = 0;
            Engine.sprite[spr].xvel = 0;
            Engine.sprite[spr].zvel = 0;
            Engine.sprite[spr].yvel = 0;
            if (Engine.sprite[spr].statnum < 900) {
                Engine.sprite[spr].hitag = (short)-1;
            }
            Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
            Engine.sprite[spr].owner = (short)-1;
            Engine.sprite[spr].extra = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x100000 | nAnim);
            Anim.AnimRunRec[nAnim] = RunList.AddRunRec(RunList.NewRun, 0x100000 | nAnim);
            Anim.AnimFlags[nAnim] = (byte)flags;
            if ((flags & 0x80) != 0) {
                Engine.sprite[spr].cstat = (short)(Engine.sprite[spr].cstat | 2);
            }
            if (AnimList[nAnim] == null) {
                Anim.AnimList[nAnim] = new AnimStruct();
            }
            Anim.AnimList[nAnim].nAction = (short)(v21 + Seq.SeqOffsets[v20]);
            Anim.AnimList[nAnim].nSeq = 0;
            Anim.AnimList[nAnim].nSprite = (short)spr;
            return nAnim;
        }
        nAnimsFree = 0;
        return -1;
    }

    public static int GetAnimSprite(int a1) {
        return Anim.AnimList[a1].nSprite;
    }

    public static void DestroyAnim(int a1) {
        short nSprite = Anim.AnimList[a1].nSprite;
        if (nSprite >= 0) {
            Sound.StopSpriteSound(nSprite);
            RunList.SubRunRec(AnimRunRec[a1]);
            RunList.DoSubRunRec(Engine.sprite[nSprite].extra);
            RunList.FreeRun(Engine.sprite[nSprite].lotag - 1);
        }
        Anim.AnimList[a1].nSprite = (short)-1;
        if (nAnimsFree == 400) {
            return;
        }
        Anim.AnimsFree[Anim.nAnimsFree] = (short)a1;
        ++nAnimsFree;
    }

    public static void FuncAnim(int a1, int a2, int a3) {
        short nAnim = (short)(RunList.RunData[a3].RunEvent & 0xFFFF);
        if (nAnim < 0 || nAnim >= 400) {
            Main.game.ThrowError("nAnim>=0 && nAnim<MAX_LIL_ANIM");
            return;
        }
        short nSprite = Anim.AnimList[nAnim].nSprite;
        short nSeq = Anim.AnimList[nAnim].nAction;
        switch (a1 & 0x7F0000) {
            case 131072: {
                short nSource;
                if ((Engine.sprite[nSprite].cstat & 0x8000) == 0) {
                    Seq.MoveSequence(nSprite, nSeq, Anim.AnimList[nAnim].nSeq);
                }
                if (Engine.sprite[nSprite].statnum != 404 || (nSource = Engine.sprite[nSprite].hitag) <= -1) break;
                SPRITE pSource = Engine.sprite[nSource];
                Engine.sprite[nSprite].x = pSource.x;
                Engine.sprite[nSprite].y = pSource.y;
                Engine.sprite[nSprite].z = pSource.z;
                short v11 = pSource.sectnum;
                if (v11 != Engine.sprite[nSprite].sectnum) {
                    if (v11 < 0 || v11 >= 1024) {
                        Anim.DestroyAnim(nAnim);
                        Main.engine.mydeletesprite(nSprite);
                        return;
                    }
                    Main.engine.mychangespritesect(nSprite, v11);
                }
                if (Anim.AnimList[nAnim].nSeq != 0) break;
                short v13 = pSource.hitag;
                if (pSource.cstat != Short.MIN_VALUE) {
                    pSource.hitag = (short)(pSource.hitag - 1);
                }
                if (pSource.cstat == Short.MIN_VALUE || v13 < 15) {
                    pSource.hitag = 1;
                    Anim.DestroyAnim(nAnim);
                    Main.engine.mydeletesprite(nSprite);
                    break;
                }
                Sprites.DamageEnemy(nSource, -1, 2 * (pSource.hitag - 14));
                if (pSource.shade < 100) {
                    pSource.pal = 0;
                    pSource.shade = (byte)(pSource.shade + 1);
                }
                if ((pSource.cstat & 0x101) != 0) break;
                Anim.DestroyAnim(nAnim);
                Main.engine.mydeletesprite(nSprite);
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), nSeq, Anim.AnimList[nAnim].nSeq, 257);
                return;
            }
            default: {
                return;
            }
        }
        if ((Anim.AnimList[nAnim].nSeq = (short)(Anim.AnimList[nAnim].nSeq + 1)) < Seq.SeqSize[nSeq]) {
            return;
        }
        if ((AnimFlags[nAnim] & 0x10) != 0) {
            Anim.AnimList[nAnim].nSeq = 0;
            return;
        }
        if (nSeq == Globals.nPreMagicSeq) {
            Anim.AnimList[nAnim].nSeq = 0;
            Anim.AnimList[nAnim].nAction = (short)Globals.nMagicSeq;
            short s = nAnim;
            AnimFlags[s] = (byte)(AnimFlags[s] | 0x10);
            Engine.sprite[Anim.AnimList[nAnim].nSprite].cstat = (short)(Engine.sprite[Anim.AnimList[nAnim].nSprite].cstat | 2);
            return;
        }
        if (nSeq == Globals.nSavePointSeq) {
            Anim.AnimList[nAnim].nSeq = (short)(Globals.nSavePointSeq ^ nSeq);
            Anim.AnimList[nAnim].nAction = (short)(Anim.AnimList[nAnim].nAction + 1);
            short s = nAnim;
            AnimFlags[s] = (byte)(AnimFlags[s] | 0x10);
            return;
        }
        Anim.DestroyAnim(nAnim);
        Main.engine.mydeletesprite(nSprite);
    }
}

