/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Enemies;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Enemies.Enemy;
import ru.m210projects.Powerslave.Enemies.Spider;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.SafeLoader;

public class Scorp {
    public static final int MAXSCORP = 5;
    private static int ScorpCount;
    private static ScorpStruct[] ScorpList;
    private static short[] ScorpChan;
    private static final short[][] ActionSeq_X_7;

    static {
        ScorpList = new ScorpStruct[5];
        ScorpChan = new short[5];
        short[][] sArrayArray = new short[10][];
        sArrayArray[0] = new short[2];
        short[] sArray = new short[2];
        sArray[0] = 8;
        sArrayArray[1] = sArray;
        short[] sArray2 = new short[2];
        sArray2[0] = 29;
        sArrayArray[2] = sArray2;
        short[] sArray3 = new short[2];
        sArray3[0] = 19;
        sArrayArray[3] = sArray3;
        sArrayArray[4] = new short[]{45, 1};
        sArrayArray[5] = new short[]{46, 1};
        sArrayArray[6] = new short[]{47, 1};
        sArrayArray[7] = new short[]{48, 1};
        sArrayArray[8] = new short[]{50, 1};
        sArrayArray[9] = new short[]{53, 1};
        ActionSeq_X_7 = sArrayArray;
    }

    public static void InitScorp() {
        ScorpCount = 5;
    }

    public static ByteBuffer saveScorp() {
        ByteBuffer bb = ByteBuffer.allocate((5 - ScorpCount) * 18 + 2 + 10);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)ScorpCount);
        int i = ScorpCount;
        while (i < 5) {
            ScorpList[i].save(bb);
            ++i;
        }
        i = 0;
        while (i < 5) {
            bb.putShort(ScorpChan[i]);
            ++i;
        }
        return bb;
    }

    public static void loadScorp(SafeLoader loader, Resource bb) {
        if (bb != null) {
            int i = loader.ScorpCount = (int)bb.readShort().shortValue();
            while (i < 5) {
                if (loader.ScorpList[i] == null) {
                    loader.ScorpList[i] = new ScorpStruct();
                }
                loader.ScorpList[i].load(bb);
                ++i;
            }
            i = 0;
            while (i < 5) {
                loader.ScorpChan[i] = bb.readShort();
                ++i;
            }
        } else {
            ScorpCount = loader.ScorpCount;
            int i = loader.ScorpCount;
            while (i < 5) {
                if (ScorpList[i] == null) {
                    Scorp.ScorpList[i] = new ScorpStruct();
                }
                ScorpList[i].copy(loader.ScorpList[i]);
                ++i;
            }
            System.arraycopy(loader.ScorpChan, 0, ScorpChan, 0, 5);
        }
    }

    public static void BuildScorp(int spr, int x, int y, int z, int sectnum, int ang, int channel) {
        int count;
        if ((count = --ScorpCount) < 0) {
            return;
        }
        if (spr == -1) {
            spr = Main.engine.insertsprite((short)sectnum, (short)122);
        } else {
            x = Engine.sprite[spr].x;
            y = Engine.sprite[spr].y;
            z = Engine.sector[Engine.sprite[spr].sectnum].floorz;
            ang = Engine.sprite[spr].ang;
            Main.engine.changespritestat((short)spr, 122);
        }
        if (spr < 0 || spr >= Engine.MAXSPRITES) {
            Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
            return;
        }
        Engine.sprite[spr].x = x;
        Engine.sprite[spr].y = y;
        Engine.sprite[spr].z = z;
        Engine.sprite[spr].cstat = (short)257;
        Engine.sprite[spr].xoffset = 0;
        Engine.sprite[spr].shade = (byte)-12;
        Engine.sprite[spr].yoffset = 0;
        Engine.sprite[spr].picnum = 1;
        Engine.sprite[spr].pal = Engine.sector[Engine.sprite[spr].sectnum].ceilingpal;
        Engine.sprite[spr].clipdist = 70;
        Engine.sprite[spr].ang = (short)ang;
        Engine.sprite[spr].xrepeat = (short)80;
        Engine.sprite[spr].yrepeat = (short)80;
        Engine.sprite[spr].xvel = 0;
        Engine.sprite[spr].yvel = 0;
        Engine.sprite[spr].zvel = 0;
        Engine.sprite[spr].hitag = 0;
        Engine.sprite[spr].lotag = (short)(RunList.HeadRun() + 1);
        Engine.sprite[spr].extra = (short)-1;
        if (ScorpList[count] == null) {
            Scorp.ScorpList[count] = new ScorpStruct();
        }
        Scorp.ScorpList[count].nState = 0;
        Scorp.ScorpList[count].nHealth = (short)20000;
        Scorp.ScorpList[count].nSeq = 0;
        Scorp.ScorpList[count].nSprite = (short)spr;
        Scorp.ScorpList[count].nTarget = (short)-1;
        Scorp.ScorpList[count].field_A = 1;
        Scorp.ScorpList[count].field_C = 0;
        Scorp.ScorpChan[count] = (short)channel;
        Engine.sprite[spr].owner = (short)RunList.AddRunRec(Engine.sprite[spr].lotag - 1, 0x220000 | count);
        Scorp.ScorpList[count].nFunc = (short)RunList.AddRunRec(RunList.NewRun, 0x220000 | count);
        ++Globals.nCreaturesLeft;
        ++Globals.nCreaturesMax;
    }

    public static void FuncScorp(int a1, int nDamage, int RunPtr) {
        short nScorp = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nScorp < 0 || nScorp >= 5) {
            Main.game.ThrowError("scorp>=0 && scorp<MAXSCORP");
            return;
        }
        ScorpStruct pScorp = ScorpList[nScorp];
        short nSprite = pScorp.nSprite;
        SPRITE pSprite = Engine.sprite[nSprite];
        short nState = pScorp.nState;
        short nTarget = pScorp.nTarget;
        short nObject = (short)(a1 & 0xFFFF);
        boolean v5 = false;
        block0 : switch (a1 & 0x7F0000) {
            case 131072: {
                if (pScorp.nHealth != 0) {
                    Sprites.Gravity(nSprite);
                }
                int nSeq = ActionSeq_X_7[nState][0] + Seq.SeqOffsets[24];
                pSprite.picnum = (short)Seq.GetSeqPicnum2(nSeq, pScorp.nSeq);
                Seq.MoveSequence(nSprite, nSeq, pScorp.nSeq);
                pScorp.nSeq = (short)(pScorp.nSeq + 1);
                if (pScorp.nSeq >= Seq.SeqSize[nSeq]) {
                    pScorp.nSeq = 0;
                    v5 = true;
                }
                short nFlags = Seq.FrameFlag[pScorp.nSeq + Seq.SeqBase[nSeq]];
                switch (nState) {
                    case 0: {
                        if (pScorp.field_C <= 0) {
                            int nNewTarget;
                            if ((nScorp & 0x1F) == (Globals.totalmoves & 0x1F) && nTarget < 0 && (nNewTarget = Enemy.FindPlayer(nSprite, 500)) >= 0) {
                                Sound.D3PlayFX(Sound.StaticSound[41], nSprite);
                                pScorp.nSeq = 0;
                                pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                                pScorp.nState = 1;
                                pScorp.nTarget = (short)nNewTarget;
                                pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                            }
                        } else {
                            pScorp.field_C = (short)(pScorp.field_C - 1);
                        }
                        return;
                    }
                    case 1: {
                        pScorp.field_A = (short)(pScorp.field_A - 1);
                        if (pScorp.field_A <= 0) {
                            pScorp.field_A = (short)Random.RandomSize(5);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(7) - 63));
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                            break block0;
                        }
                        int hitMove = Enemy.MoveCreatureWithCaution(nSprite);
                        switch (hitMove & 0xC000) {
                            case 32768: 
                            case 49152: {
                                if ((hitMove & 0x3FFF) == nTarget && Sprites.AngleDiff(pSprite.ang, Main.engine.getangle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y)) < 64) {
                                    pScorp.nState = (short)2;
                                    pScorp.nSeq = 0;
                                    break;
                                }
                                Enemy.PlotCourseToSprite(nSprite, nTarget);
                                pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(7) - 63));
                                pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                                pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                            }
                        }
                        break block0;
                    }
                    case 2: {
                        if (nTarget == -1) {
                            pScorp.nState = 0;
                            pScorp.field_C = (short)5;
                            break block0;
                        }
                        if (Enemy.PlotCourseToSprite(nSprite, nTarget) >= 768) {
                            pScorp.nState = 1;
                            break block0;
                        }
                        if ((nFlags & 0x80) == 0) break block0;
                        Sprites.DamageEnemy(nTarget, nSprite, 7);
                        break block0;
                    }
                    case 3: {
                        int nBullet;
                        if (v5 && (pScorp.field_B = (short)(pScorp.field_B - 1)) <= 0) {
                            pScorp.nState = 1;
                            pScorp.nSeq = 0;
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                        } else if ((nFlags & 0x80) != 0 && (nBullet = Bullet.BuildBullet(nSprite, 16, 0, 0, -1, pSprite.ang, nTarget + 10000, 1)) > -1) {
                            Enemy.PlotCourseToSprite((short)(nBullet & 0xFFFF), nTarget);
                        }
                        return;
                    }
                    case 8: {
                        if (v5) {
                            pScorp.nState = (short)(pScorp.nState + 1);
                            pScorp.nSeq = 0;
                            RunList.ChangeChannel(ScorpChan[nScorp], 1);
                        } else {
                            int nSpider = Spider.BuildSpider(-1, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, pSprite.ang);
                            if (nSpider != -1) {
                                SPRITE pSpider = Engine.sprite[nSpider];
                                pSpider.ang = (short)(Random.RandomSize(11) & 0x7FF);
                                int vel = Random.RandomSize(5) + 1;
                                pSpider.xvel = (short)(vel * (Engine.sintable[pSpider.ang + 512 & 0x7FF] >> 8));
                                pSpider.yvel = (short)(vel * (Engine.sintable[pSpider.ang] >> 8));
                                pSpider.zvel = (short)(-256 * (Random.RandomSize(5) + 3));
                            }
                        }
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (v5) {
                            if (pScorp.nHealth > 0) {
                                pScorp.nState = 1;
                                pScorp.nSeq = 0;
                                pScorp.field_C = 0;
                            } else {
                                pScorp.field_C = (short)(pScorp.field_C - 1);
                                pScorp.nState = pScorp.field_C > 0 ? (short)(Random.RandomBit() + 6) : (short)8;
                            }
                        }
                        return;
                    }
                    case 9: {
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        if (v5) {
                            RunList.SubRunRec(pScorp.nFunc);
                            RunList.DoSubRunRec(pSprite.owner);
                            RunList.FreeRun(pSprite.lotag - 1);
                            Main.engine.mydeletesprite(nSprite);
                        }
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence(nObject, ActionSeq_X_7[nState][0] + Seq.SeqOffsets[24], pScorp.nSeq, ActionSeq_X_7[nState][1]);
                return;
            }
            case 655360: {
                nDamage = Sprites.CheckRadialDamage(nSprite);
            }
            case 524288: {
                if (nDamage != 0 && pScorp.nHealth > 0) {
                    pScorp.nHealth = (short)(pScorp.nHealth - nDamage);
                    if (pScorp.nHealth > 0) {
                        if (nObject >= 0 && (Engine.sprite[nObject].statnum == 100 || Engine.sprite[nObject].statnum < 199 && Random.RandomSize(5) == 0)) {
                            pScorp.nTarget = nObject;
                        }
                        if (Random.RandomSize(5) == 0) {
                            pScorp.nState = (short)(Random.RandomSize(2) + 4);
                            pScorp.nSeq = 0;
                            return;
                        }
                        if (Random.RandomSize(2) == 0) {
                            Sound.D3PlayFX(Sound.StaticSound[41], nSprite);
                            Enemy.PlotCourseToSprite(nSprite, nTarget);
                            pSprite.ang = (short)(pSprite.ang + (Random.RandomSize(7) - 63));
                            pSprite.xvel = Engine.sintable[pSprite.ang + 512 & 0x7FF];
                            pSprite.yvel = Engine.sintable[pSprite.ang & 0x7FF];
                            break;
                        }
                    } else {
                        pSprite.zvel = 0;
                        pScorp.nHealth = 0;
                        pSprite.yvel = 0;
                        pScorp.nState = (short)4;
                        pSprite.xvel = 0;
                        pScorp.nSeq = 0;
                        pSprite.cstat = (short)(pSprite.cstat & 0xFFFFFEFE);
                        pScorp.field_C = (short)10;
                        --Globals.nCreaturesLeft;
                    }
                }
                return;
            }
        }
        if (nState != 2) {
            if (pScorp.field_C != 0) {
                pScorp.field_C = (short)(pScorp.field_C - 1);
            } else {
                pScorp.field_C = (short)45;
                if (nTarget != -1 && Main.engine.cansee(pSprite.x, pSprite.y, pSprite.z - Sprites.GetSpriteHeight(nSprite), pSprite.sectnum, Engine.sprite[nTarget].x, Engine.sprite[nTarget].y, Engine.sprite[nTarget].z - Sprites.GetSpriteHeight(nTarget), Engine.sprite[nTarget].sectnum)) {
                    pSprite.yvel = 0;
                    pSprite.xvel = 0;
                    pSprite.ang = Main.engine.GetMyAngle(Engine.sprite[nTarget].x - pSprite.x, Engine.sprite[nTarget].y - pSprite.y);
                    int v41 = Random.RandomSize(3);
                    pScorp.field_B = (short)(v41 + Random.RandomSize(2));
                    if (pScorp.field_B != 0) {
                        pScorp.nState = (short)3;
                        pScorp.nSeq = 0;
                    } else {
                        pScorp.field_C = (short)Random.RandomSize(5);
                    }
                }
            }
        }
        if (nState != 0 && nTarget != -1 && (Engine.sprite[nTarget].cstat & 0x101) == 0) {
            pScorp.nState = 0;
            pScorp.nSeq = 0;
            pScorp.field_C = (short)30;
            pScorp.nTarget = (short)-1;
            pSprite.xvel = 0;
            pSprite.yvel = 0;
        }
    }

    public static class ScorpStruct
    extends Enemy.EnemyStruct {
        public static final int size = 18;
        public short field_B;

        @Override
        public void save(ByteBuffer bb) {
            super.save(bb);
            bb.putShort(this.field_B);
        }

        @Override
        public void load(Resource bb) {
            super.load(bb);
            this.field_B = bb.readShort();
        }

        public void copy(ScorpStruct src) {
            super.copy(src);
            this.field_B = src.field_B;
        }
    }
}

