/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.FlashStruct;
import ru.m210projects.Powerslave.Type.FlickerStruct;
import ru.m210projects.Powerslave.Type.FlowStruct;
import ru.m210projects.Powerslave.Type.GrowStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.View;

public class Light {
    public static int bDoFlicks;
    public static int bDoGlows;
    private static int nFlickerCount;
    private static int nGlowCount;
    private static int nFlowCount;
    private static int nFlashes;
    private static int nFirstFlash;
    private static int nLastFlash;
    private static short[] nFreeFlash;
    private static short[] nNextFlash;
    private static FlashStruct[] sFlash;
    private static GrowStruct[] sGlow;
    private static FlickerStruct[] sFlicker;
    private static FlowStruct[] sFlowInfo;
    public static int[] flickermask;
    public static int nFlashDepth;
    public static int bTorch;

    static {
        nFirstFlash = -1;
        nLastFlash = -1;
        nFreeFlash = new short[2000];
        nNextFlash = new short[2000];
        sFlash = new FlashStruct[2000];
        sGlow = new GrowStruct[50];
        sFlicker = new FlickerStruct[100];
        sFlowInfo = new FlowStruct[375];
        flickermask = new int[25];
        nFlashDepth = 2;
    }

    public static FlashStruct GrabFlash() {
        if (nFlashes < 2000) {
            int nFlash = nFreeFlash[nFlashes++];
            Light.nNextFlash[nFlash] = -1;
            if (nLastFlash <= -1) {
                nFirstFlash = nFlash;
            } else {
                Light.nNextFlash[Light.nLastFlash] = nFlash;
            }
            nLastFlash = nFlash;
            if (sFlash[nFlash] == null) {
                Light.sFlash[nFlash] = new FlashStruct();
            }
            return sFlash[nFlash];
        }
        return null;
    }

    public static ByteBuffer saveLights() {
        ByteBuffer bb = ByteBuffer.allocate(8006 + 4 * nFlashes + 8 * nGlowCount + 2 + 28 * nFlowCount + 2 + 8 * nFlickerCount + 2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        Light.saveFlashes(bb);
        Light.saveGlows(bb);
        Light.saveFlows(bb);
        Light.saveFlickers(bb);
        return bb;
    }

    public static void loadLights(SafeLoader loader, Resource bb) {
        Light.loadFlashes(loader, bb);
        Light.loadGlows(loader, bb);
        Light.loadFlows(loader, bb);
        Light.loadFlickers(loader, bb);
        if (bb != null) {
            return;
        }
        int i = 0;
        while (i < 25) {
            Light.flickermask[i] = 2 * Random.RandomSize(31);
            ++i;
        }
        bDoFlicks = 0;
        bDoGlows = 0;
    }

    private static void saveFlashes(ByteBuffer bb) {
        bb.putShort((short)nFlashes);
        bb.putShort((short)nFirstFlash);
        bb.putShort((short)nLastFlash);
        int i = 0;
        while (i < 2000) {
            bb.putShort(nFreeFlash[i]);
            bb.putShort(nNextFlash[i]);
            ++i;
        }
        if (nFlashes != 0) {
            i = nFirstFlash;
            while (i >= 0) {
                sFlash[i].save(bb);
                i = nNextFlash[i];
            }
        }
    }

    private static void loadFlashes(SafeLoader loader, Resource bb) {
        block7: {
            block6: {
                if (bb == null) break block6;
                loader.nFlashes = bb.readShort().shortValue();
                loader.nFirstFlash = bb.readShort().shortValue();
                loader.nLastFlash = bb.readShort().shortValue();
                int i = 0;
                while (i < 2000) {
                    loader.nFreeFlash[i] = bb.readShort();
                    loader.nNextFlash[i] = bb.readShort();
                    ++i;
                }
                if (loader.nFlashes == 0) break block7;
                i = loader.nFirstFlash;
                while (i >= 0) {
                    if (loader.sFlash[i] == null) {
                        loader.sFlash[i] = new FlashStruct();
                    }
                    loader.sFlash[i].load(bb);
                    i = loader.nNextFlash[i];
                }
                break block7;
            }
            nFlashes = loader.nFlashes;
            nFirstFlash = loader.nFirstFlash;
            nLastFlash = loader.nLastFlash;
            System.arraycopy(loader.nFreeFlash, 0, nFreeFlash, 0, 2000);
            System.arraycopy(loader.nNextFlash, 0, nNextFlash, 0, 2000);
            if (nFlashes != 0) {
                int i = nFirstFlash;
                while (i >= 0) {
                    if (sFlash[i] == null) {
                        Light.sFlash[i] = new FlashStruct();
                    }
                    sFlash[i].copy(loader.sFlash[i]);
                    i = nNextFlash[i];
                }
            }
        }
    }

    private static void saveGlows(ByteBuffer bb) {
        bb.putShort((short)nGlowCount);
        int i = 0;
        while (i < nGlowCount) {
            sGlow[i].save(bb);
            ++i;
        }
    }

    private static void loadGlows(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nGlowCount = bb.readShort().shortValue();
            int i = 0;
            while (i < loader.nGlowCount) {
                if (loader.sGlow[i] == null) {
                    loader.sGlow[i] = new GrowStruct();
                }
                loader.sGlow[i].load(bb);
                ++i;
            }
        } else {
            nGlowCount = loader.nGlowCount;
            int i = 0;
            while (i < loader.nGlowCount) {
                if (sGlow[i] == null) {
                    Light.sGlow[i] = new GrowStruct();
                }
                sGlow[i].copy(loader.sGlow[i]);
                ++i;
            }
        }
    }

    private static void saveFlows(ByteBuffer bb) {
        bb.putShort((short)nFlowCount);
        int i = 0;
        while (i < nFlowCount) {
            sFlowInfo[i].save(bb);
            ++i;
        }
    }

    private static void loadFlows(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nFlowCount = bb.readShort().shortValue();
            int i = 0;
            while (i < loader.nFlowCount) {
                if (loader.sFlowInfo[i] == null) {
                    loader.sFlowInfo[i] = new FlowStruct();
                }
                loader.sFlowInfo[i].load(bb);
                ++i;
            }
        } else {
            nFlowCount = loader.nFlowCount;
            int i = 0;
            while (i < loader.nFlowCount) {
                if (sFlowInfo[i] == null) {
                    Light.sFlowInfo[i] = new FlowStruct();
                }
                sFlowInfo[i].copy(loader.sFlowInfo[i]);
                ++i;
            }
        }
    }

    private static void saveFlickers(ByteBuffer bb) {
        bb.putShort((short)nFlickerCount);
        int i = 0;
        while (i < nFlickerCount) {
            sFlicker[i].save(bb);
            ++i;
        }
    }

    private static void loadFlickers(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nFlickerCount = bb.readShort().shortValue();
            int i = 0;
            while (i < loader.nFlickerCount) {
                if (loader.sFlicker[i] == null) {
                    loader.sFlicker[i] = new FlickerStruct();
                }
                loader.sFlicker[i].load(bb);
                ++i;
            }
        } else {
            nFlickerCount = loader.nFlickerCount;
            int i = 0;
            while (i < loader.nFlickerCount) {
                if (sFlicker[i] == null) {
                    Light.sFlicker[i] = new FlickerStruct();
                }
                sFlicker[i].copy(loader.sFlicker[i]);
                ++i;
            }
        }
    }

    public static void InitLights() {
        nFlickerCount = 0;
        int i = 0;
        while (i < 25) {
            Light.flickermask[i] = 2 * Random.RandomSize(31);
            ++i;
        }
        nGlowCount = 0;
        nFlowCount = 0;
        nFlashes = 0;
        bDoFlicks = 0;
        bDoGlows = 0;
        i = 0;
        while (i < 2000) {
            Light.nFreeFlash[i] = (short)i;
            Light.nNextFlash[i] = -1;
            ++i;
        }
        nFirstFlash = -1;
        nLastFlash = -1;
    }

    public static void AddFlash(int sectnum, int x, int y, int z, int a5) {
        int nDepth = a5 >> 8;
        int nShade = 0;
        if (nDepth < nFlashDepth) {
            FlashStruct v23;
            int v37 = a5 & 0x80;
            int v42 = nDepth + 1 << 8 | a5 & 0xFF;
            SECTOR pSector = Engine.sector[sectnum];
            int v40 = 0;
            int i = pSector.wallptr;
            int n = 0;
            while (n < pSector.wallnum) {
                WALL pWall = Engine.wall[i];
                int cx = (Engine.wall[pWall.point2].x + pWall.x) / 2;
                int cy = (Engine.wall[pWall.point2].y + pWall.y) / 2;
                short nNextSector = pWall.nextsector;
                SECTOR pNextSector = nNextSector <= -1 ? null : Engine.sector[nNextSector];
                int v14 = -255;
                if ((a5 & 0x40) == 0) {
                    v14 = (Pragmas.klabs(x - cx) + Pragmas.klabs(y - cy) >> 4) - 255;
                }
                if (v14 < 0) {
                    ++v40;
                    nShade += v14;
                    if (pWall.pal < 5 && (pNextSector == null || pNextSector.floorz < pSector.floorz)) {
                        FlashStruct pFlash = Light.GrabFlash();
                        if (pFlash == null) {
                            return;
                        }
                        pFlash.field_0 = (byte)(v37 | 2);
                        pFlash.nShade = pWall.shade;
                        pFlash.nObject = (short)i;
                        pWall.shade = (byte)Gameutils.BClipLow(v14 + pWall.shade, -127);
                        pWall.pal = (short)(pWall.pal + 7);
                        if (nDepth == 0 && pWall.overpicnum == 0 && pNextSector != null) {
                            Light.AddFlash(pWall.nextsector, x, y, z, v42);
                        }
                    }
                }
                ++n;
                ++i;
            }
            if (v40 == 0 || pSector.floorpal >= 4) {
                return;
            }
            FlashStruct v21 = Light.GrabFlash();
            if (v21 == null) {
                return;
            }
            v21.field_0 = (byte)(v37 | 1);
            v21.nShade = pSector.floorshade;
            v21.nObject = (short)sectnum;
            pSector.floorshade = (byte)Gameutils.BClipLow(nShade + pSector.floorshade, -127);
            pSector.floorpal = (short)(pSector.floorpal + 7);
            if ((pSector.ceilingstat & 1) == 0 && pSector.ceilingpal < 4 && (v23 = Light.GrabFlash()) != null) {
                v23.field_0 = (byte)(v37 | 3);
                v23.nShade = pSector.ceilingshade;
                v23.nObject = (short)sectnum;
                pSector.ceilingshade = (byte)Gameutils.BClipLow(nShade + pSector.ceilingshade, -127);
                pSector.ceilingpal = (short)(pSector.ceilingpal + 7);
            }
            short j = Engine.headspritesect[sectnum];
            while (j != -1) {
                FlashStruct pFlash;
                SPRITE pSprite = Engine.sprite[j];
                if (pSprite.pal < 4 && (pFlash = Light.GrabFlash()) != null) {
                    pFlash.field_0 = (byte)(v37 | 4);
                    pFlash.nShade = pSprite.shade;
                    pFlash.nObject = j;
                    pSprite.pal = (short)(pSprite.pal + 7);
                    int v14 = -255;
                    if ((a5 & 0x40) == 0) {
                        v14 = (Pragmas.klabs(x - pSprite.x) + Pragmas.klabs(y - pSprite.y) >> 4) - 255;
                    }
                    if (v14 < 0) {
                        pSprite.shade = (byte)Gameutils.BClipLow(pSprite.shade + v14, -127);
                    }
                }
                j = Engine.nextspritesect[j];
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void UndoFlashes() {
        block14: {
            nNext = -1;
            if (Light.nFlashes == 0) break block14;
            i = Light.nFirstFlash;
            while (i >= 0) {
                v3 = Light.sFlash[i];
                nObject = v3.nObject;
                switch ((v3.field_0 & 63) - 1) {
                    case 0: {
                        if ((v3.field_0 & 128) != 0 && Engine.sector[nObject].floorshade + 6 < v3.nShade) {
                            nNext = i;
                            Engine.sector[nObject].floorshade = (byte)(Engine.sector[nObject].floorshade + 6);
                            break;
                        }
                        Engine.sector[nObject].floorpal = (short)(Engine.sector[nObject].floorpal - 7);
                        Engine.sector[nObject].floorshade = v3.nShade;
                        ** GOTO lbl40
                    }
                    case 1: {
                        if ((v3.field_0 & 128) != 0 && Engine.wall[nObject].shade + 6 < v3.nShade) {
                            nNext = i;
                            Engine.wall[nObject].shade = (byte)(Engine.wall[nObject].shade + 6);
                            break;
                        }
                        Engine.wall[nObject].pal = (short)(Engine.wall[nObject].pal - 7);
                        Engine.wall[nObject].shade = v3.nShade;
                        ** GOTO lbl40
                    }
                    case 2: {
                        if ((v3.field_0 & 128) != 0 && Engine.sector[nObject].ceilingshade + 6 < v3.nShade) {
                            nNext = i;
                            Engine.sector[nObject].ceilingshade = (byte)(Engine.sector[nObject].ceilingshade + 6);
                            break;
                        }
                        Engine.sector[nObject].ceilingpal = (short)(Engine.sector[nObject].ceilingpal - 7);
                        Engine.sector[nObject].ceilingshade = v3.nShade;
                        ** GOTO lbl40
                    }
                    case 3: {
                        if (Engine.sprite[nObject].pal >= 7) {
                            if ((v3.field_0 & 128) != 0 && Engine.sprite[nObject].shade + 6 < v3.nShade) {
                                nNext = i;
                                Engine.sprite[nObject].shade = (byte)(Engine.sprite[nObject].shade + 6);
                                break;
                            }
                            Engine.sprite[nObject].pal = (short)(Engine.sprite[nObject].pal - 7);
                            Engine.sprite[nObject].shade = v3.nShade;
                        }
                    }
lbl40:
                    // 7 sources

                    default: {
                        Light.nFreeFlash[--Light.nFlashes] = (short)i;
                        if (nNext != -1) {
                            Light.nNextFlash[nNext] = Light.nNextFlash[i];
                        }
                        if (i == Light.nFirstFlash) {
                            Light.nFirstFlash = Light.nNextFlash[Light.nFirstFlash];
                        }
                        if (i != Light.nLastFlash) break;
                        Light.nLastFlash = nNext;
                    }
                }
                i = Light.nNextFlash[i];
            }
        }
    }

    public static void AddGlow(int a1, int a2) {
        if (nGlowCount < 50) {
            if (sGlow[nGlowCount] == null) {
                Light.sGlow[Light.nGlowCount] = new GrowStruct();
            }
            Light.sGlow[Light.nGlowCount].field_6 = (short)a2;
            Light.sGlow[Light.nGlowCount].field_4 = (short)a1;
            Light.sGlow[Light.nGlowCount].field_0 = (short)-1;
            Light.sGlow[Light.nGlowCount].field_2 = 0;
            ++nGlowCount;
        }
    }

    public static void AddFlicker(int a1, int a2) {
        if (nFlickerCount < 100) {
            if (sFlicker[nFlickerCount] == null) {
                Light.sFlicker[Light.nFlickerCount] = new FlickerStruct();
            }
            Light.sFlicker[Light.nFlickerCount].field_0 = (short)a2;
            Light.sFlicker[Light.nFlickerCount].field_2 = (short)a1;
            if (a2 >= 25) {
                a2 = 24;
            }
            ++nFlickerCount;
            Light.sFlicker[v0].field_4 = flickermask[a2];
        }
    }

    public static void DoGlows() {
        if (++bDoGlows < 3) {
            return;
        }
        int v0 = 0;
        int v1 = 0;
        bDoGlows = 0;
        while (v0 < nGlowCount) {
            int v8;
            int v2 = Light.sGlow[v1].field_2 + 1;
            short v3 = Light.sGlow[v1].field_4;
            Light.sGlow[v1].field_2 = (short)v2;
            short v4 = Light.sGlow[v1].field_0;
            if (v2 >= Light.sGlow[v1].field_6) {
                Light.sGlow[v1].field_2 = 0;
                Light.sGlow[v1].field_0 = -Light.sGlow[v1].field_0;
            }
            short v5 = v3;
            Engine.sector[v5].ceilingshade = (byte)(Engine.sector[v5].ceilingshade + v4);
            Engine.sector[v5].floorshade = (byte)(Engine.sector[v5].floorshade + v4);
            short v6 = Engine.sector[v5].wallptr;
            int i = v8 = v6 + Engine.sector[v5].wallnum - 1;
            while (i >= v6) {
                Engine.wall[i].shade = (byte)(Engine.wall[i].shade + v4);
                --i;
            }
            ++v1;
            ++v0;
        }
    }

    public static void DoFlickers() {
        if ((bDoFlicks ^= 1) == 0) {
            return;
        }
        int v0 = 0;
        int v1 = 0;
        while (v0 < nFlickerCount) {
            int v2 = Light.sFlicker[v1].field_4 & 1;
            short v3 = Light.sFlicker[v1].field_2;
            int v4 = Light.sFlicker[v1].field_4 >>> 1 & 1;
            Light.sFlicker[v1].field_4 = Light.sFlicker[v1].field_4 << 31 | Light.sFlicker[v1].field_4 >>> 1;
            if ((v2 ^ v4) != 0) {
                short v5 = Light.sFlicker[v1].field_0;
                if (v2 == 0) {
                    v5 = -Light.sFlicker[v1].field_0;
                }
                Engine.sector[v3].ceilingshade = (byte)(Engine.sector[v3].ceilingshade + v5);
                Engine.sector[v3].floorshade = (byte)(Engine.sector[v3].floorshade + v5);
                int i = Engine.sector[v3].wallptr + Engine.sector[v3].wallnum - 1;
                while (i >= Engine.sector[v3].wallptr) {
                    Engine.wall[i].shade = (byte)(Engine.wall[i].shade + v5);
                    --i;
                }
            }
            ++v1;
            ++v0;
        }
    }

    public static void AddFlow(short nObject, int nVelocity, int nState) {
        if (nFlowCount < 375) {
            if (sFlowInfo[nFlowCount] == null) {
                Light.sFlowInfo[Light.nFlowCount] = new FlowStruct();
            }
            FlowStruct pFlow = sFlowInfo[nFlowCount];
            ++nFlowCount;
            switch (nState) {
                case 0: 
                case 1: {
                    SPRITE pSprite = Engine.sprite[nObject];
                    nObject = pSprite.sectnum;
                    SECTOR pSector = Engine.sector[nObject];
                    pFlow.xmax = (Engine.tilesizx[pSector.floorpicnum] << 14) - 1;
                    pFlow.ymax = (Engine.tilesizy[pSector.floorpicnum] << 14) - 1;
                    pFlow.xvel = nVelocity * -Engine.sintable[pSprite.ang + 512 & 0x7FF];
                    pFlow.yvel = nVelocity * Engine.sintable[pSprite.ang & 0x7FF];
                    break;
                }
                case 2: 
                case 3: {
                    int nDirection = 1536;
                    if (nState == 2) {
                        nDirection = 512;
                    }
                    WALL pWall = Engine.wall[nObject];
                    pFlow.xmax = pWall.xrepeat * Engine.tilesizx[pWall.picnum] << 8;
                    pFlow.ymax = pWall.yrepeat * Engine.tilesizy[pWall.picnum] << 8;
                    pFlow.xvel = nVelocity * -Engine.sintable[nDirection + 512 & 0x7FF];
                    pFlow.yvel = nVelocity * Engine.sintable[nDirection & 0x7FF];
                }
            }
            pFlow.ypanning = 0;
            pFlow.xpanning = 0;
            pFlow.nObject = nObject;
            pFlow.nState = (short)nState;
        }
    }

    public static void DoFlows() {
        int i = 0;
        while (i < nFlowCount) {
            FlowStruct pFlow = sFlowInfo[i];
            pFlow.xpanning += pFlow.xvel;
            pFlow.ypanning += pFlow.yvel;
            switch (pFlow.nState) {
                case 0: {
                    pFlow.xpanning &= pFlow.xmax;
                    pFlow.ypanning &= pFlow.ymax;
                    Engine.sector[pFlow.nObject].floorxpanning = (short)(pFlow.xpanning >> 14);
                    Engine.sector[pFlow.nObject].floorypanning = (short)(pFlow.ypanning >> 14);
                    break;
                }
                case 1: {
                    Engine.sector[pFlow.nObject].ceilingxpanning = (short)(pFlow.xpanning >> 14);
                    Engine.sector[pFlow.nObject].ceilingypanning = (short)(pFlow.ypanning >> 14);
                    pFlow.xpanning &= pFlow.xmax;
                    pFlow.ypanning &= pFlow.ymax;
                    break;
                }
                case 2: {
                    Engine.wall[pFlow.nObject].xpanning = (short)(pFlow.xpanning >> 14);
                    Engine.wall[pFlow.nObject].ypanning = (short)(pFlow.ypanning >> 14);
                    if (pFlow.xpanning < 0) {
                        pFlow.xpanning += pFlow.xmax;
                    }
                    if (pFlow.ypanning >= 0) break;
                    pFlow.ypanning += pFlow.ymax;
                    break;
                }
                case 3: {
                    Engine.wall[pFlow.nObject].xpanning = (short)(pFlow.xpanning >> 14);
                    Engine.wall[pFlow.nObject].ypanning = (short)(pFlow.ypanning >> 14);
                    if (pFlow.xpanning >= pFlow.xmax) {
                        pFlow.xpanning -= pFlow.xmax;
                    }
                    if (pFlow.ypanning < pFlow.ymax) break;
                    pFlow.ypanning -= pFlow.ymax;
                }
            }
            ++i;
        }
    }

    public static void DoLights() {
        Light.DoFlickers();
        Light.DoGlows();
        Light.DoFlows();
    }

    public static void BuildFlash(int player, int sectnum, int value) {
        if (player == Globals.nLocalPlayer) {
            Globals.flash = -value;
        }
    }

    public static void SetTorch(int nPlayer, int nTorch) {
        if (nTorch != bTorch && nPlayer == Globals.nLocalPlayer) {
            byte[] v2 = Engine.palookup[2];
            Engine.palookup[2] = Engine.palookup[3];
            Engine.palookup[3] = v2;
            byte[] v3 = Globals.origpalookup[2];
            Globals.origpalookup[2] = Globals.origpalookup[3];
            Globals.origpalookup[3] = v3;
            byte[] v4 = Globals.origpalookup[9];
            Globals.origpalookup[9] = Globals.origpalookup[10];
            Globals.origpalookup[10] = v4;
            byte[] v5 = Engine.palookup[10];
            Engine.palookup[10] = Engine.palookup[9];
            Engine.palookup[9] = v5;
            bTorch = nTorch == 2 ? (bTorch == 0 ? 1 : 0) : nTorch;
            if (bTorch != 0) {
                Sound.PlayLocalSound(12, 0);
            }
            View.StatusMessage(150, "TORCH IS " + (bTorch != 0 ? "LIT" : "OUT"), nPlayer);
        }
    }

    public static void UseTorch(int nPlayer) {
        if (Globals.nPlayerTorch[nPlayer] == 0) {
            Light.SetTorch(nPlayer, 1);
        }
        Globals.nPlayerTorch[nPlayer] = 900;
    }
}

