/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Sound;

public class MovieScreen
extends SkippableAdapter {
    private LmfFile lmf;
    private Runnable callback;
    private int gCutsClock;
    private long movtime;
    private long LastMS;
    private long lastCrc32;
    private int backgroundCol = 0;
    private int nScale;
    private int nAngle;
    private ByteBuffer audbuf = ByteBuffer.allocateDirect(4096);
    private int currSub;
    private Subtitle[] subs = new Subtitle[]{new Subtitle(new String[]{"During the time of the pharaohs, the city of Karnak", "was a shining example of a civilization that all", "others nations could only hope to emulate"}, 35, 132), new Subtitle(new String[]{"Today Karnak lives on, surrounded by the spirits", "of the past, however something has gone terribly wrong."}, 143, 228), new Subtitle(new String[]{"Unknown forces have seized the city and great", "turmoil is spreading into neighboring lands."}, 242, 302), new Subtitle(new String[]{"World leaders from all parts of the globe have sent", "forces into the Karnak Valley, but none have returned."}, 308, 384), new Subtitle(new String[]{"The great power of this new empire is quickly crushing", "the best forces the human world has to offer."}, 392, 456), new Subtitle(new String[]{"The only known information about this crisis came from", "a Karnak villager, found wandering through the desert", "miles from his home, dazed, dehydrated and close to death."}, 477, 594), new Subtitle(new String[]{"In his final moments among the living, the villager told", "horrifying stories of fierce alien creatures that invaded", "the city, devoured the women and children, and made slaves", "of the men."}, 610, 733), new Subtitle(new String[]{"Many of the unfortunate victims were", "skinned alive or brutally dismembered."}, 741, 794), new Subtitle(new String[]{"Others were subjected to unbearable tortures, injected with", "strange substances and then mummified while still alive."}, 803, 886), new Subtitle(new String[]{"According to the villager, even the mummified body of the", "great King Ramses was unearthed and taken away."}, 893, 967), new Subtitle(new String[]{"You have been chosen from a group of the best operatives in the", "world to infiltrate Karnak and destroy the threatening forces."}, 979, 1055), new Subtitle(new String[]{"But as your helicopter nears the Karnak Valley, it is shot down.", "You barely escape with your life."}, 1059, 1128), new Subtitle(new String[]{"With no possible contact to the outside world,"}, 1134, 1164), new Subtitle(new String[]{"you begin your adventure,"}, 1168, 1185), new Subtitle(new String[]{"ready to accomplish your mission..."}, 1190, 1208), new Subtitle(new String[]{"praying to return alive."}, 1215, 1235)};
    private int oldAngle;
    private int oldScale;

    private void changepalette(byte[] pal) {
        int j;
        if (pal == null) {
            return;
        }
        this.engine.changepalette(pal);
        int white = -1;
        int k = 0;
        int i = 0;
        while (i < 256) {
            j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j > k) {
                k = j;
                white = i;
            }
            i += 3;
        }
        this.backgroundCol = 0;
        k = 255;
        i = 0;
        while (i < 256) {
            j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j < k) {
                k = j;
                this.backgroundCol = i;
            }
            i += 3;
        }
        if (white == -1) {
            return;
        }
        int palnum = 251;
        byte[] remapbuf = new byte[768];
        int i2 = 0;
        while (i2 < 768) {
            remapbuf[i2] = (byte)white;
            ++i2;
        }
        this.engine.makepalookup(palnum, remapbuf, 0, 1, 0, 1);
        i2 = 0;
        while (i2 < 256) {
            int tile = this.game.getFont(0).getTile(i2);
            if (tile >= 0) {
                this.engine.invalidatetile(tile, palnum, -1);
            }
            ++i2;
        }
    }

    public MovieScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
        Sound.StopAllSounds();
        Sound.StopMusic();
    }

    @Override
    public void hide() {
        this.engine.setbrightness(BuildSettings.paletteGamma.get(), Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    public void skip() {
        this.lmfClose();
        super.skip();
    }

    public MovieScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn) {
        if (this.lmf != null) {
            return false;
        }
        try {
            this.engine.loadtile(764);
            this.lmf = new LmfFile(fn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean play() {
        if (this.lmf != null) {
            if (this.lmf.isEof() || Engine.tilesizx[764] <= 0) {
                return false;
            }
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.movtime += dt;
            float tick = 100.0f;
            if ((float)this.movtime >= tick) {
                if (this.lmf.ReadFrame()) {
                    Engine.waloff[764] = this.lmf.framebuf;
                    long crc32 = CRC32.getChecksum(this.lmf.framebuf);
                    if (this.lastCrc32 != crc32) {
                        this.engine.invalidatetile(764, 0, -1);
                        this.lastCrc32 = crc32;
                    }
                }
                this.oldScale = this.nScale;
                if (this.nScale < 65536) {
                    this.nScale += 2048;
                }
                this.oldAngle = this.nAngle;
                if (this.nAngle != 0) {
                    this.nAngle += 16;
                    if (this.nAngle == 2048) {
                        this.nAngle = 0;
                    }
                }
                this.movtime = (long)((float)this.movtime - tick);
            }
            this.LastMS = ms;
            if (Engine.waloff[764] != null) {
                int ang = this.oldAngle;
                int scale = this.oldScale;
                if (this.nAngle != this.oldAngle && this.nScale != this.oldScale) {
                    int smoothratio = (int)((float)this.movtime / tick * 65536.0f);
                    ang += Pragmas.mulscale((this.nAngle - this.oldAngle + 1024 & 0x7FF) - 1024, smoothratio, 16);
                    scale += Pragmas.mulscale(this.nScale - this.oldScale, smoothratio, 16);
                }
                this.engine.rotatesprite(0xA00000, 0x640000, scale, ang, 764, 0, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            if (Main.cfg.bSubtitles && this.currSub != -1 && this.lmf.framenum < this.subs[this.currSub].to) {
                String[] text = this.subs[this.currSub].text;
                int pos = 190 - 8 * text.length;
                String[] stringArray = text;
                int n = text.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.game.getFont(0).drawText(160, pos += 8, s, 48000, 0, 251, BuildFont.TextAlign.Center, 2, true);
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(float delta) {
        this.engine.clearview(this.backgroundCol);
        if (!this.play() && this.skipCallback != null) {
            this.lmfClose();
            if (this.callback != null) {
                BuildGdx.app.postRunnable(this.callback);
                this.callback = null;
            }
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.game.getFont(0).drawText(160, 5, "Press ESC to skip", shade, 251, BuildFont.TextAlign.Center, 2, true);
        }
    }

    private void lmfClose() {
        if (this.lmf != null) {
            this.lmf.close();
        }
        this.lmf = null;
    }

    private class LmfFile {
        private Resource res;
        private byte[] framebuf;
        public int framenum;

        public LmfFile(String fn) throws Exception {
            this.res = BuildGdx.cache.open(fn, 0);
            if (this.res == null) {
                throw new FileNotFoundException();
            }
            int size = this.res.size();
            if (size < 32 || !this.res.readString(4).equals("LMF ")) {
                this.res.close();
                throw new Exception("Wrong file format");
            }
            this.res.seek(28L, Resource.Whence.Current);
            this.framebuf = new byte[64000];
            MovieScreen.this.lastCrc32 = 0L;
            this.framenum = 0;
            MovieScreen.this.currSub = -1;
            MovieScreen.this.backgroundCol = 96;
            MovieScreen.this.nScale = 0;
            MovieScreen.this.nAngle = 1536;
        }

        public boolean ReadFrame() {
            Byte id;
            block6: while ((id = this.res.readByte()) != null && id != 0) {
                int cSize = this.res.readInt();
                switch (id) {
                    case 1: {
                        byte[] pal = new byte[768];
                        this.res.read(pal);
                        this.res.readByte();
                        int i = 0;
                        while (i < 768) {
                            int n = i++;
                            pal[n] = (byte)(pal[n] << 2);
                        }
                        MovieScreen.this.changepalette(pal);
                        continue block6;
                    }
                    case 2: {
                        this.res.read(MovieScreen.this.audbuf, 0, cSize);
                        MovieScreen.this.audbuf.rewind().limit(cSize);
                        Source hVoice = BuildGdx.audio.newSound(MovieScreen.this.audbuf, 22050, 8, 255);
                        if (hVoice == null) continue block6;
                        hVoice.setGlobal(1);
                        hVoice.play(255.0f);
                        continue block6;
                    }
                    case 3: {
                        if (cSize == 0) continue block6;
                        int ptr = 200 * this.res.readShort();
                        cSize -= 2;
                        while (true) {
                            if (cSize <= 0) continue block6;
                            ptr += this.res.readByte() & 0xFF;
                            int len = this.res.readByte() & 0xFF;
                            cSize -= 2;
                            if (len == 0) continue;
                            this.res.read(this.framebuf, ptr, len);
                            ptr += len;
                            cSize -= len;
                        }
                    }
                    case 4: {
                        ++this.framenum;
                        int nextSub = MovieScreen.this.currSub + 1;
                        if (nextSub < MovieScreen.this.subs.length && this.framenum >= ((MovieScreen)MovieScreen.this).subs[((MovieScreen)MovieScreen.this).currSub + 1].from) {
                            MovieScreen movieScreen = MovieScreen.this;
                            movieScreen.currSub = movieScreen.currSub + 1;
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isEof() {
            return this.res.position() >= this.res.size();
        }

        public void close() {
            this.res.close();
        }
    }

    private class Subtitle {
        public String[] text;
        public int from;
        public int to;

        public Subtitle(String[] text, int from, int to) {
            this.text = text;
            this.from = from;
            this.to = to;
        }
    }
}

