/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.CommonMenus.MenuVideoMode;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Tekwar.Menus.MenuInterfaceSet;
import ru.m210projects.Tekwar.Teksnd;

public class TekMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int LOADGAME = 3;
    public static final int SAVEGAME = 4;
    public static final int QUIT = 6;
    public static final int HELP = 7;
    public static final int AUDIOSET = 8;
    public static final int CONTROLSET = 9;
    public static final int OPTIONS = 10;
    public static final int COLORCORR = 11;
    public static final int LASTSAVE = 12;
    public static final int CORRUPTLOAD = 13;
    public BuildMenu[] mMenus;
    private Engine engine;
    private BuildGame app;

    public TekMenuHandler(BuildGame app, int nMaxMenus) {
        this.mMenus = new BuildMenu[nMaxMenus];
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings) && !(this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = 321;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        if (!(this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            this.engine.rotatesprite(0xA00000, 0x3C0000, 32768, 0, 1529, 0, 0, 1034, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            this.engine.rotatesprite(0xA00000, 0xB40000, 32768, 0, 1530, 0, 0, 1034, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    @Override
    public int getShade(MenuItem item) {
        if (item != null && item.isFocused()) {
            return 16 - (Engine.totalclock & 0x3F);
        }
        return 0;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 2;
            }
            if (item.isFocused()) {
                return 4;
            }
            return item.pal;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                if (this.mCount == 1) {
                    Teksnd.playsound(52, 0, 0, 0, 1);
                    break;
                }
                Teksnd.playsound(53, 0, 0, 0, 1);
                break;
            }
            case Close: {
                if (this.mCount == 1) {
                    Teksnd.playsound(53, 0, 0, 0, 1);
                    break;
                }
                Teksnd.playsound(54, 0, 0, 0, 1);
                break;
            }
            case UP: 
            case DW: {
                Teksnd.playsound(55, 0, 0, 0, 1);
                break;
            }
            case LEFT: 
            case RIGHT: 
            case ENTER: {
                if (opt == MenuHandler.MenuOpt.ENTER && item instanceof MenuConteiner && item.getClass().getEnclosingClass() == MenuVideoMode.class || !(item instanceof MenuSlider) && !(item instanceof MenuSwitch) && !(item instanceof MenuConteiner)) break;
                Teksnd.playsound(52, 0, 0, 0, 1);
                break;
            }
        }
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 4 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, Engine.tilesizx[9216] - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        int size = Pragmas.mulscale(Engine.tilesizx[9216], zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }
}

