/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.BuildSmacker.SMKAudio;
import ru.m210projects.BuildSmacker.SMKFile;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Teksnd;

public class CutsceneScreen
extends MovieScreen {
    public CutsceneScreen(BuildGame game) {
        super(game, Engine.MAXTILES - 3);
        this.nFlags |= 4;
    }

    public boolean init(String path) {
        if (!Main.tekcfg.showCutscenes || this.isInited()) {
            return false;
        }
        return this.open(path);
    }

    @Override
    public void hide() {
        this.engine.setbrightness(BuildSettings.paletteGamma.get(), Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            return new SMKMovieFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        Teksnd.stopallsounds();
        Teksnd.sndStopMusic();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        byte[] pic = this.mvfil.getFrame(num);
        if (((SMKMovieFile)this.mvfil).paletteChanged) {
            this.changepalette(this.mvfil.getPalette());
        }
        return pic;
    }

    @Override
    protected BuildFont GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void DrawEscText(BuildFont font, int pal) {
        int shade = 16 + Pragmas.mulscale(32L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        this.game.getFont(0).drawText(160, 5, "Press ESC to skip", shade, 251, BuildFont.TextAlign.Center, 2, false);
    }

    protected static class SMKMovieFile
    implements MovieScreen.MovieFile {
        protected SMKFile smkfil;
        protected boolean paletteChanged;
        protected Source audio;
        protected int sourceRate;
        protected int sourceBits;
        protected int sourceChannels;
        protected ByteBuffer sourceBuffer;

        public SMKMovieFile(String file) throws Exception {
            SMKAudio aud;
            byte[] smkbuf = BuildGdx.cache.getBytes(file, 0);
            if (smkbuf == null) {
                throw new FileNotFoundException();
            }
            ByteBuffer bb = ByteBuffer.wrap(smkbuf);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.smkfil = new SMKFile(bb);
            this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask() | SMKFile.Track.Audio.mask());
            if (!Main.tekcfg.noSound && (aud = this.smkfil.getAudio(0)) != null) {
                this.sourceRate = aud.getRate();
                this.sourceBits = aud.getBits().get();
                this.sourceChannels = aud.getChannels().get();
                if (this.sourceRate != 0 && this.sourceBits != 0) {
                    this.sourceBuffer = this.smkfil.getAudioBuffer(0);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    bb.rewind();
                }
            }
        }

        @Override
        public void playAudio() {
            if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
                return;
            }
            if (Main.tekcfg.noSound) {
                return;
            }
            if (this.sourceRate != 0 && this.sourceBits != 0 && this.sourceBuffer != null) {
                this.audio = BuildGdx.audio.newSound(this.sourceBuffer, this.sourceRate, this.sourceBits, this.sourceChannels, 255);
                if (this.audio != null) {
                    this.audio.setGlobal(1);
                    this.audio.play(1.0f);
                }
            }
        }

        @Override
        public int getFrames() {
            return this.smkfil.getFrames();
        }

        @Override
        public float getRate() {
            return (float)this.smkfil.getRate() / 1000.0f;
        }

        @Override
        public byte[] getFrame(int num) {
            this.paletteChanged = this.smkfil.setFrame(num) != 0;
            return this.smkfil.getVideoBuffer().array();
        }

        @Override
        public byte[] getPalette() {
            return this.smkfil.getPalette();
        }

        @Override
        public short getWidth() {
            return (short)this.smkfil.getHeight();
        }

        @Override
        public short getHeight() {
            return (short)this.smkfil.getWidth();
        }

        public boolean paletteChanged(int frame) {
            return this.smkfil.setFrame(frame) != 0;
        }

        @Override
        public void close() {
            if (this.audio != null) {
                this.audio.dispose();
            }
        }
    }
}

