/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Lava {
    private static final Decision[] LavaBattle = new Decision[]{new Decision(600, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAlertNoise), new Decision(710, Ai.InitActorRunAway), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaOffense = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] LavaBroadcast = new Decision[]{new Decision(21, Ai.InitActorAlertNoise), new Decision(51, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] LavaEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, null)};
    private static final Decision[] LavaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] LavaCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality LavaPersonality = new Personality(LavaBattle, LavaOffense, LavaBroadcast, LavaSurprised, LavaEvasive, LavaLostTarget, LavaCloseRange, LavaCloseRange);
    private static final ATTRIBUTE LavaAttrib;
    public static final int LAVA_STAND_RATE = 12;
    private static final Animator DoLavaMove;
    private static final State[][] s_LavaStand;
    public static final int LAVA_RUN_RATE = 24;
    private static final State[][] s_LavaRun;
    public static final int LAVA_THROW_RATE = 9;
    private static final Animator NullLava;
    private static final Animator InitLavaThrow;
    private static final State[][] s_LavaThrow;
    public static final int LAVA_FLAME_RATE = 18;
    private static final Animator InitLavaFlame;
    private static final State[][] s_LavaFlame;
    public static final int LAVA_DIE_RATE = 20;
    private static final State[] s_LavaDie;
    private static final State[] s_LavaDead;
    private static final Actor_Action_Set LavaActionSet;

    static {
        short[] sArray = new short[4];
        sArray[0] = 3;
        sArray[2] = -2;
        sArray[3] = -3;
        LavaAttrib = new ATTRIBUTE(new short[]{200, 220, 240, 270}, sArray, 3, new int[]{132, 135, 137, 139, 141, 133, 134, 136, 138, 140});
        DoLavaMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Lava.DoLavaMove(SpriteNum) != 0;
            }
        };
        s_LavaStand = new State[][]{{new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}, {new State(2355, 12, DoLavaMove).setNext()}};
        s_LavaRun = new State[][]{{new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}, {new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove), new State(2355, 24, DoLavaMove)}};
        NullLava = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Lava.NullLava(SpriteNum) != 0;
            }
        };
        InitLavaThrow = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitLavaThrow(SpriteNum) != 0;
            }
        };
        s_LavaThrow = new State[][]{{new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}, {new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, 18, NullLava), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaThrow), new State(2355, 9, NullLava), new State(2355, 9, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 9, DoLavaMove).setNext()}};
        InitLavaFlame = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitLavaFlame(SpriteNum) != 0;
            }
        };
        s_LavaFlame = new State[][]{{new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}, {new State(2355, 36, NullLava), new State(2355, 18, NullLava), new State(2355, 36, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, InitLavaFlame), new State(2355, 18, NullLava), new State(2355, 18, NullLava), new State(2355, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(2355, 18, DoLavaMove).setNext()}};
        s_LavaDie = new State[]{new State(2355, 20, NullLava), new State(2355, 20, Actor.DoActorDebris).setNext()};
        s_LavaDead = new State[]{new State(2355, 20, Actor.DoActorDebris).setNext()};
        LavaActionSet = new Actor_Action_Set(LavaStateGroup.sg_LavaStand, LavaStateGroup.sg_LavaRun, null, null, null, null, null, null, null, null, null, null, LavaStateGroup.sg_LavaDie, null, LavaStateGroup.sg_LavaDead, null, null, new Sprites.StateGroup[]{LavaStateGroup.sg_LavaFlame}, new short[]{1024}, new Sprites.StateGroup[]{LavaStateGroup.sg_LavaFlame, LavaStateGroup.sg_LavaThrow, LavaStateGroup.sg_LavaThrow, LavaStateGroup.sg_LavaThrow}, new short[]{256, 512, 768, 1024}, null, null, null);
    }

    public static void InitLavaStates() {
        LavaStateGroup[] lavaStateGroupArray = LavaStateGroup.values();
        int n = lavaStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            LavaStateGroup sg = lavaStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static int SetupLava(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 2355, s_LavaRun[0][0]);
            u.Health = (short)100;
        }
        Sprites.ChangeState(SpriteNum, s_LavaRun[0][0]);
        u.Attrib = LavaAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_LavaDie[0];
        u.Rot = LavaStateGroup.sg_LavaRun;
        Coolie.EnemyDefaults(SpriteNum, LavaActionSet, LavaPersonality);
        sp.yrepeat = (short)110;
        sp.xrepeat = (short)110;
        sp.clipdist = 128;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE | Gameutils.SPR_ELECTRO_TOLERANT;
        u.loz = sp.z;
        return 0;
    }

    private static int NullLava(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoLavaMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void LavaSaveable() {
        Saveable.SaveData(InitLavaThrow);
        Saveable.SaveData(InitLavaFlame);
        Saveable.SaveData(NullLava);
        Saveable.SaveData(DoLavaMove);
        Saveable.SaveData(LavaPersonality);
        Saveable.SaveData(LavaAttrib);
        Saveable.SaveData(s_LavaStand);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaStand);
        Saveable.SaveData(s_LavaRun);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaRun);
        Saveable.SaveData(s_LavaThrow);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaThrow);
        Saveable.SaveData(s_LavaFlame);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaFlame);
        Saveable.SaveData(s_LavaDie);
        Saveable.SaveData(s_LavaDead);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaDie);
        Saveable.SaveGroup(LavaStateGroup.sg_LavaDead);
        Saveable.SaveData(LavaActionSet);
    }

    static /* synthetic */ State[][] access$2() {
        return s_LavaStand;
    }

    static /* synthetic */ State[][] access$3() {
        return s_LavaRun;
    }

    static /* synthetic */ State[] access$4() {
        return s_LavaDie;
    }

    static /* synthetic */ State[] access$5() {
        return s_LavaDead;
    }

    static /* synthetic */ State[][] access$6() {
        return s_LavaFlame;
    }

    static /* synthetic */ State[][] access$7() {
        return s_LavaThrow;
    }

    public static enum LavaStateGroup implements Sprites.StateGroup
    {
        sg_LavaStand(Lava.access$2()[0], Lava.access$2()[1], Lava.access$2()[2], Lava.access$2()[3], Lava.access$2()[4]),
        sg_LavaRun(Lava.access$3()[0], Lava.access$3()[1], Lava.access$3()[2], Lava.access$3()[3], Lava.access$3()[4]),
        sg_LavaDie(new State[][]{Lava.access$4()}),
        sg_LavaDead(new State[][]{Lava.access$5()}),
        sg_LavaFlame(Lava.access$6()[0], Lava.access$6()[1], Lava.access$6()[2], Lava.access$6()[3], Lava.access$6()[4]),
        sg_LavaThrow(Lava.access$7()[0], Lava.access$7()[1], Lava.access$7()[2], Lava.access$7()[3], Lava.access$7()[4]);

        private final State[][] group;
        private int index = -1;

        private LavaStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

