/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Factory;

import com.badlogic.gdx.Screen;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Type.LONGp;

public class WangEngine
extends BuildEngine {
    public WangEngine(BuildGame game) throws Exception {
        super(game, 3);
        this.fpscol = 4;
    }

    @Override
    public void updatesmoothticks() {
        super.updatesmoothticks();
        Main.game.pIntSkip2.requestUpdating();
        Main.game.pIntSkip4.requestUpdating();
    }

    @Override
    public void nextpage() {
        super.nextpage();
        Main.game.pIntSkip2.clearinterpolations();
        Main.game.pIntSkip4.clearinterpolations();
    }

    @Override
    public int getsmoothratio() {
        if (Game.nInterpolation == 0 || Game.nInterpolation == 3) {
            return 65536;
        }
        return super.getsmoothratio();
    }

    @Override
    public void sampletimer() {
        if (this.timerfreq == 0) {
            return;
        }
        long n = System.nanoTime() * (long)timerticspersec / (long)(this.timerfreq * 1000000) - this.timerlastsample;
        if (n > 0L) {
            totalclock = (int)((long)totalclock + n);
            this.timerlastsample += n;
        }
    }

    public Interpolation getInterpolation(int type) {
        if (Game.nInterpolation >= 2) {
            switch (type) {
                case 2: {
                    return Main.game.pIntSkip2;
                }
                case 4: {
                    return Main.game.pIntSkip4;
                }
            }
        }
        return Main.game.pInt;
    }

    public void dragpoint(int moveskip, short pointhighlight, int dax, int day) {
        if (Game.nInterpolation == 1) {
            super.dragpoint(pointhighlight, dax, day);
            return;
        }
        Interpolation pInt = this.getInterpolation(moveskip);
        pInt.setwallinterpolate(pointhighlight, wall[pointhighlight]);
        WangEngine.wall[pointhighlight].x = dax;
        WangEngine.wall[pointhighlight].y = day;
        int cnt = MAXWALLS;
        short tempshort = pointhighlight;
        block0: do {
            if (WangEngine.wall[tempshort].nextwall >= 0) {
                tempshort = WangEngine.wall[WangEngine.wall[tempshort].nextwall].point2;
                pInt.setwallinterpolate(tempshort, wall[tempshort]);
                WangEngine.wall[tempshort].x = dax;
                WangEngine.wall[tempshort].y = day;
                continue;
            }
            tempshort = pointhighlight;
            while (WangEngine.wall[this.lastwall((int)tempshort)].nextwall >= 0) {
                tempshort = WangEngine.wall[this.lastwall((int)tempshort)].nextwall;
                pInt.setwallinterpolate(tempshort, wall[tempshort]);
                WangEngine.wall[tempshort].x = dax;
                WangEngine.wall[tempshort].y = day;
                if (tempshort != pointhighlight && --cnt > 0) continue;
                break block0;
            }
            break;
        } while (tempshort != pointhighlight && --cnt > 0);
    }

    @Override
    public int setrendermode(Renderer render) {
        Screen screen;
        if (this.render != null && this.render != render && render.getType() != Renderer.RenderType.Software && (screen = Main.game.getScreen()) instanceof GameAdapter) {
            Main.gPrecacheScreen.init(true, new Runnable(){

                @Override
                public void run() {
                    Main.game.changeScreen(screen);
                    if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                        Main.game.net.ready2send = true;
                    }
                }
            });
            Main.game.changeScreen(Main.gPrecacheScreen);
        }
        return super.setrendermode(render);
    }

    @Override
    public int krand() {
        this.randomseed = this.randomseed * 21 + 1 & 0xFFFF;
        return this.randomseed;
    }

    public void getzrange(int x, int y, int z, short sectnum, LONGp hiz, LONGp ceilhit, LONGp loz, LONGp florhit, int walldist, int cliptype) {
        super.getzrange(x, y, z, sectnum, walldist, cliptype);
        if (hiz != null) {
            hiz.value = zr_ceilz;
        }
        if (ceilhit != null) {
            ceilhit.value = zr_ceilhit;
        }
        if (loz != null) {
            loz.value = zr_florz;
        }
        if (florhit != null) {
            florhit.value = zr_florhit;
        }
    }

    public short setspritez(int spritenum, int newx, int newy, int newz) {
        WangEngine.sprite[spritenum].x = newx;
        WangEngine.sprite[spritenum].y = newy;
        WangEngine.sprite[spritenum].z = newz;
        short tempsectnum = this.updatesectorz(newx, newy, newz, WangEngine.sprite[spritenum].sectnum);
        if (tempsectnum < 0) {
            return -1;
        }
        if (tempsectnum != WangEngine.sprite[spritenum].sectnum) {
            this.changespritesect((short)spritenum, tempsectnum);
        }
        return 0;
    }

    public void getzrangepoint(int x, int y, int z, short sectnum, LONGp ceilz, LONGp ceilhit, LONGp florz, LONGp florhit) {
        if (!ru.m210projects.Build.Gameutils.isValidSector(sectnum)) {
            if (ceilz != null) {
                ceilz.value = Integer.MIN_VALUE;
            }
            if (ceilhit != null) {
                ceilhit.value = -1;
            }
            if (florz != null) {
                florz.value = Integer.MAX_VALUE;
            }
            if (florhit != null) {
                florhit.value = -1;
            }
            return;
        }
        this.getzsofslope(sectnum, x, y, zofslope);
        if (ceilz != null) {
            ceilz.value = zofslope[0];
        }
        if (florz != null) {
            florz.value = zofslope[1];
        }
        if (ceilhit != null) {
            ceilhit.value = sectnum + 16384;
        }
        if (florhit != null) {
            florhit.value = sectnum + 16384;
        }
        short j = headspritesect[sectnum];
        while (j >= 0) {
            SPRITE spr = sprite[j];
            short cstat = spr.cstat;
            if ((cstat & 0x31) == 33) {
                int daz = spr.z;
                if ((cstat & 0x40) == 0 || z > daz != ((cstat & 8) == 0)) {
                    short tilenum = spr.picnum;
                    int xoff = (byte)(picanm[tilenum] >> 8 & 0xFF) + spr.xoffset;
                    int yoff = (byte)(picanm[tilenum] >> 16 & 0xFF) + spr.yoffset;
                    if ((cstat & 4) != 0) {
                        xoff = -xoff;
                    }
                    if ((cstat & 8) != 0) {
                        yoff = -yoff;
                    }
                    short cosang = sintable[Gameutils.NORM_ANGLE(spr.ang + 512)];
                    short sinang = sintable[spr.ang];
                    short xspan = tilesizx[tilenum];
                    int dax = ((xspan >> 1) + xoff) * spr.xrepeat;
                    short yspan = tilesizy[tilenum];
                    int day = ((yspan >> 1) + yoff) * spr.yrepeat;
                    int x1 = spr.x + Pragmas.dmulscale(sinang, dax, cosang, day, 16) - x;
                    int y1 = spr.y + Pragmas.dmulscale(sinang, day, -cosang, dax, 16) - y;
                    int l = xspan * spr.xrepeat;
                    int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                    int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                    l = yspan * spr.yrepeat;
                    int k = -Pragmas.mulscale(cosang, l, 16);
                    int x3 = x2 + k;
                    int x4 = x1 + k;
                    k = -Pragmas.mulscale(sinang, l, 16);
                    int y3 = y2 + k;
                    int y4 = y1 + k;
                    boolean clipyou = false;
                    if ((y1 ^ y2) < 0) {
                        if ((x1 ^ x2) < 0) {
                            clipyou ^= x1 * y2 < x2 * y1 ^ y1 < y2;
                        } else if (x1 >= 0) {
                            clipyou ^= true;
                        }
                    }
                    if ((y2 ^ y3) < 0) {
                        if ((x2 ^ x3) < 0) {
                            clipyou ^= x2 * y3 < x3 * y2 ^ y2 < y3;
                        } else if (x2 >= 0) {
                            clipyou ^= true;
                        }
                    }
                    if ((y3 ^ y4) < 0) {
                        if ((x3 ^ x4) < 0) {
                            clipyou ^= x3 * y4 < x4 * y3 ^ y3 < y4;
                        } else if (x3 >= 0) {
                            clipyou ^= true;
                        }
                    }
                    if ((y4 ^ y1) < 0) {
                        if ((x4 ^ x1) < 0) {
                            clipyou ^= x4 * y1 < x1 * y4 ^ y4 < y1;
                        } else if (x4 >= 0) {
                            clipyou ^= true;
                        }
                    }
                    if (clipyou) {
                        if (z > daz) {
                            if (ceilz != null && daz > ceilz.value) {
                                ceilz.value = daz;
                                if (ceilhit != null) {
                                    ceilhit.value = j + 49152;
                                }
                            }
                        } else if (florz != null && daz < florz.value) {
                            florz.value = daz;
                            if (florhit != null) {
                                florhit.value = j + 49152;
                            }
                        }
                    }
                }
            }
            j = nextspritesect[j];
        }
    }

    public void compare(SPRITE src, SPRITE dst) {
        Console.Println("Comparing...", Console.OSDTEXT_GREEN);
        if (dst.x != src.x) {
            Console.Println("Not match x: " + dst.x + " != " + src.x, Console.OSDTEXT_RED);
        }
        if (dst.y != src.y) {
            Console.Println("Not match y: " + dst.y + " != " + src.y, Console.OSDTEXT_RED);
        }
        if (dst.z != src.z) {
            Console.Println("Not match z: " + dst.z + " != " + src.z, Console.OSDTEXT_RED);
        }
        if (dst.cstat != src.cstat) {
            Console.Println("Not match cstat: " + dst.cstat + " != " + src.cstat, Console.OSDTEXT_RED);
        }
        if (dst.picnum != src.picnum) {
            Console.Println("Not match picnum: " + dst.picnum + " != " + src.picnum, Console.OSDTEXT_RED);
        }
        if (dst.shade != src.shade) {
            Console.Println("Not match shade: " + dst.shade + " != " + src.shade, Console.OSDTEXT_RED);
        }
        if (dst.pal != src.pal) {
            Console.Println("Not match pal: " + dst.pal + " != " + src.pal, Console.OSDTEXT_RED);
        }
        if (dst.clipdist != src.clipdist) {
            Console.Println("Not match clipdist: " + dst.clipdist + " != " + src.clipdist, Console.OSDTEXT_RED);
        }
        if (dst.detail != src.detail) {
            Console.Println("Not match detail: " + dst.detail + " != " + src.detail, Console.OSDTEXT_RED);
        }
        if (dst.xrepeat != src.xrepeat) {
            Console.Println("Not match xrepeat: " + dst.xrepeat + " != " + src.xrepeat, Console.OSDTEXT_RED);
        }
        if (dst.yrepeat != src.yrepeat) {
            Console.Println("Not match xrepeat: " + dst.yrepeat + " != " + src.yrepeat, Console.OSDTEXT_RED);
        }
        if (dst.xoffset != src.xoffset) {
            Console.Println("Not match xoffset: " + dst.xoffset + " != " + src.xoffset, Console.OSDTEXT_RED);
        }
        if (dst.yoffset != src.yoffset) {
            Console.Println("Not match yoffset: " + dst.yoffset + " != " + src.yoffset, Console.OSDTEXT_RED);
        }
        if (dst.sectnum != src.sectnum) {
            Console.Println("Not match sectnum: " + dst.sectnum + " != " + src.sectnum, Console.OSDTEXT_RED);
        }
        if (dst.statnum != src.statnum) {
            Console.Println("Not match statnum: " + dst.statnum + " != " + src.statnum, Console.OSDTEXT_RED);
        }
        if (dst.ang != src.ang) {
            Console.Println("Not match ang: " + dst.ang + " != " + src.ang, Console.OSDTEXT_RED);
        }
        if (dst.owner != src.owner) {
            Console.Println("Not match owner: " + dst.owner + " != " + src.owner, Console.OSDTEXT_RED);
        }
        if (dst.xvel != src.xvel) {
            Console.Println("Not match xvel: " + dst.xvel + " != " + src.xvel, Console.OSDTEXT_RED);
        }
        if (dst.yvel != src.yvel) {
            Console.Println("Not match yvel: " + dst.yvel + " != " + src.yvel, Console.OSDTEXT_RED);
        }
        if (dst.zvel != src.zvel) {
            Console.Println("Not match zvel: " + dst.zvel + " != " + src.zvel, Console.OSDTEXT_RED);
        }
        if (dst.lotag != src.lotag) {
            Console.Println("Not match lotag: " + dst.lotag + " != " + src.lotag, Console.OSDTEXT_RED);
        }
        if (dst.hitag != src.hitag) {
            Console.Println("Not match hitag: " + dst.hitag + " != " + src.hitag, Console.OSDTEXT_RED);
        }
        if (dst.extra != src.extra) {
            Console.Println("Not match extra: " + dst.extra + " != " + src.extra, Console.OSDTEXT_RED);
        }
        Console.Println("Compare completed", Console.OSDTEXT_GREEN);
    }
}

