/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Fonts;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.TileFont;

public class StandartFont
extends BuildFont {
    private TileFont font;
    private char[] sym = new char[1];

    public StandartFont(Engine draw) {
        super(draw, 4, 32768, 0);
        this.font = Engine.pTextfont;
    }

    public void reinit() {
        this.font.atlas = null;
    }

    @Override
    public int getWidth(char[] text) {
        int width = 0;
        if (text != null) {
            int pos = 0;
            while (pos < text.length && text[pos++] != '\u0000') {
                width += 8;
            }
        }
        return width;
    }

    @Override
    public int drawChar(int x, int y, char ch, int shade, int pal, int nBits, boolean shadow) {
        this.sym[0] = ch;
        this.drawText(x, y, this.sym, shade, pal, BuildFont.TextAlign.Center, nBits, shadow);
        return (int)((float)this.nScale / 65536.0f * (float)this.font.charsizx);
    }

    @Override
    public int drawText(int x, int y, char[] text, int shade, int pal, BuildFont.TextAlign align, int nBits, boolean shadow) {
        if (text == null) {
            return 0;
        }
        x = Gameutils.coordsConvertXScaled(x, Gameutils.ConvertType.Normal);
        y = Gameutils.coordsConvertYScaled(y);
        if (align != BuildFont.TextAlign.Left) {
            int nWidth = this.getWidth(text);
            if (align == BuildFont.TextAlign.Center) {
                nWidth >>= 1;
            }
            x -= nWidth;
        }
        int xdim = 4 * Engine.ydim / 3;
        float scale = (float)this.nScale / 65536.0f * (float)xdim / 320.0f;
        shade = Math.min(Math.max(shade, 0), Engine.numshades - 1);
        if (Engine.palookup[pal] == null) {
            pal = 0;
        }
        byte dacol = Engine.palookup[pal][shade << 8];
        if (shadow) {
            this.draw.getrender().printext(this.font, x + 1, y + 1, text, 96, 0, Renderer.Transparent.None, scale);
        }
        this.draw.getrender().printext(this.font, x, y, text, dacol & 0xFF, shade, Renderer.Transparent.None, scale);
        return 0;
    }
}

