/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.BufferResource;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Draw;
import ru.m210projects.Wang.Enemies.Bunny;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.JSector;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuCorruptGame;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LSInfo;
import ru.m210projects.Wang.Type.List;
import ru.m210projects.Wang.Type.MirrorType;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.ResourceHandler;
import ru.m210projects.Wang.Type.SafeLoader;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Weapon;

public class LoadSave {
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static SafeLoader loader;
    public static final String savsign = "SHWR";
    public static final int gdxVersionSave = 100;
    public static final int gdxCurrentSave = 101;
    public static final int SAVEVERSION;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 32;
    public static final int SAVELEVELINFO = 8;
    public static final int SAVEHEADER;
    public static final int SAVESCREENSHOTSIZE = 16000;
    public static final int SAVEGDXDATA = 16128;
    public static int quickslot;
    public static String lastload;
    public static final char[] filenum;

    static {
        lsInf = new LSInfo();
        loader = new SafeLoader();
        SAVEVERSION = savsign.length() + 2;
        SAVEHEADER = SAVEVERSION + 8 + 32 + 8;
        quickslot = 0;
        filenum = new char[4];
    }

    public static void FindSaves() {
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.User).getFiles().values()) {
            short nVersion;
            if (!file.getExtension().equals("sav") || (fil = BuildGdx.compat.open(file)) == null) continue;
            String signature = fil.readString(4);
            if (signature == null) {
                fil.close();
                continue;
            }
            if (signature.equals(savsign) && (nVersion = fil.readShort().shortValue()) >= 100) {
                long time = fil.readLong();
                String savname = fil.readString(32).trim();
                Main.game.pSavemgr.add(savname, time, file.getName());
            }
            fil.close();
        }
        Main.game.pSavemgr.sort();
    }

    public static int lsReadLoadData(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            if (Engine.waloff[SaveManager.Screenshot] == null) {
                Main.engine.allocatepermanenttile(SaveManager.Screenshot, 160, 100);
            }
            int nVersion = LoadSave.checkSave(fil) & 0xFFFF;
            lsInf.clear();
            if (nVersion >= 100) {
                fil.seek(SAVEVERSION, Resource.Whence.Set);
                LoadSave.lsInf.date = Main.game.date.getDate(fil.readLong());
                fil.seek(SAVEVERSION + 8 + 32, Resource.Whence.Set);
                if (nVersion != 101) {
                    lsInf.read(fil);
                    LoadSave.lsInf.info = "Incompatible ver. " + nVersion + " != " + 101;
                } else {
                    lsInf.read(fil);
                }
                if (fil.remaining() <= 16000) {
                    fil.close();
                    return -1;
                }
                fil.read(Engine.waloff[SaveManager.Screenshot], 0, 16000);
                LoadSave.lsInf.addonfile = null;
                if (fil.readBoolean().booleanValue()) {
                    boolean isPackage = fil.readBoolean();
                    String fullname = fil.readString(144).trim();
                    if (isPackage && !fullname.isEmpty()) {
                        LoadSave.lsInf.addonfile = "File: " + FileUtils.getFullName(fullname);
                    } else if (!fullname.isEmpty()) {
                        LoadSave.lsInf.addonfile = "Addon: " + FileUtils.getFullName(fullname);
                    }
                }
                Main.engine.invalidatetile(SaveManager.Screenshot, 0, -1);
                fil.close();
                return 1;
            }
            if (!fil.isClosed()) {
                fil.close();
            }
        } else {
            lsInf.clear();
        }
        return -1;
    }

    public static String makeNum(int num) {
        LoadSave.filenum[3] = (char)(num % 10 + 48);
        LoadSave.filenum[2] = (char)(num / 10 % 10 + 48);
        LoadSave.filenum[1] = (char)(num / 100 % 10 + 48);
        LoadSave.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static int checkSave(Resource bb) {
        String signature = bb.readString(4);
        if (signature == null || !signature.equals(savsign)) {
            return 0;
        }
        return bb.readShort().shortValue();
    }

    public static int savegame(String savename, String filename) {
        FileResource fil;
        File file = BuildGdx.compat.checkFile(filename, Compat.Path.User);
        if (file != null) {
            file.delete();
        }
        if ((fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write)) != null) {
            long time = Main.game.date.getCurrentDate();
            BufferResource res = LoadSave.save(savename, time);
            fil.writeBytes(res.getBytes(), res.size());
            fil.close();
            System.gc();
            Main.game.pSavemgr.add(savename, time, filename);
            lastload = filename;
            Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Game saved");
            return 0;
        }
        Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Game not saved. Access denied!");
        return -1;
    }

    public static BufferResource save(String savename, long time) {
        BufferResource res = new BufferResource();
        LoadSave.SaveHeader(res, savename, time);
        LoadSave.SaveGDXBlock(res);
        LoadSave.SaveMap(res);
        LoadSave.SavePanelSprites(res);
        LoadSave.SavePlayers(res);
        LoadSave.SaveSectorUserInfos(res);
        LoadSave.SaveUserInfos(res);
        LoadSave.SaveSectorObjects(res);
        LoadSave.SaveSineSect(res);
        res.writeInt(Sector.x_min_bound);
        res.writeInt(Sector.y_min_bound);
        res.writeInt(Sector.x_max_bound);
        res.writeInt(Sector.y_max_bound);
        LoadSave.SaveTracks(res);
        res.writeInt(Game.screenpeek);
        res.writeInt(Game.totalsynctics);
        LoadSave.SaveAnims(res);
        res.writeInt(Engine.totalclock);
        res.writeInt(Main.engine.getrand());
        res.writeShort(Player.NormalVisibility);
        res.writeInt(Engine.visibility);
        res.writeByte(Engine.parallaxtype);
        res.writeInt(Engine.parallaxyoffs);
        res.writeBytes(Engine.pskyoff);
        res.writeShort(Engine.pskybits);
        res.writeBoolean(Sprites.MoveSkip2);
        res.writeInt(Sprites.MoveSkip4);
        res.writeInt(Sprites.MoveSkip8);
        LoadSave.SaveMirrors(res);
        LoadSave.SaveQueues(res);
        LoadSave.SaveStuff(res);
        return res;
    }

    private static void SaveStuff(BufferResource fil) {
        fil.writeInt(Game.PlayClock);
        fil.writeInt(Game.Kills);
        fil.writeInt(Game.TotalKillable);
        Main.gNet.save(fil);
        fil.writeBytes(Engine.picanm);
        fil.writeShort(Sector.LevelSecrets);
        fil.writeBytes((Object)Engine.show2dwall);
        fil.writeBytes((Object)Engine.show2dsprite);
        fil.writeBytes((Object)Engine.show2dsector);
        fil.writeInt(Bunny.Bunny_Count);
        fil.writeBoolean(Game.GodMode);
        fil.writeBoolean(Sumo.serpwasseen);
        fil.writeBoolean(Sumo.sumowasseen);
        fil.writeBoolean(Sumo.zillawasseen);
        fil.writeBytes(Sumo.BossSpriteNum);
    }

    private static void SaveMirrors(BufferResource res) {
        res.writeInt(JSector.mirrorcnt);
        res.writeBoolean(JSector.mirrorinview);
        int i = 0;
        while (i < 8) {
            JSector.mirror[i].save(res);
            ++i;
        }
    }

    private static void SaveQueues(BufferResource res) {
        res.writeShort(Weapon.StarQueueHead);
        res.writeBytes(Weapon.StarQueue);
        res.writeShort(Weapon.HoleQueueHead);
        res.writeBytes(Weapon.HoleQueue);
        res.writeShort(Weapon.WallBloodQueueHead);
        res.writeBytes(Weapon.WallBloodQueue);
        res.writeShort(Weapon.FloorBloodQueueHead);
        res.writeBytes(Weapon.FloorBloodQueue);
        res.writeShort(Weapon.GenericQueueHead);
        res.writeBytes(Weapon.GenericQueue);
        res.writeShort(Weapon.LoWangsQueueHead);
        res.writeBytes(Weapon.LoWangsQueue);
    }

    private static void SaveVersion(BufferResource fil, int nVersion) {
        fil.writeBytes(savsign);
        fil.writeShort(nVersion);
    }

    private static void SaveScreenshot(BufferResource fil) {
        fil.writeBytes(Main.gGameScreen.captBuffer, 16000);
        Main.gGameScreen.captBuffer = null;
    }

    private static void SaveGDXBlock(BufferResource fil) {
        LoadSave.SaveScreenshot(fil);
        ByteBuffer bb = ByteBuffer.allocate(16128);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte warp_on = 0;
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            warp_on = (byte)(Game.currentGame != null ? 1 : 2);
        }
        if (Main.mUserFlag == Main.UserFlag.UserMap) {
            warp_on = (byte)2;
        }
        bb.put(warp_on);
        if (warp_on == 1) {
            bb.put(Game.currentGame.isPackage() ? (byte)1 : 0);
            byte[] name = new byte[144];
            String path = Game.currentGame.getPath();
            System.arraycopy(path.getBytes(), 0, name, 0, Math.min(path.length(), 144));
            bb.put(name);
        }
        fil.writeBytes(bb.array(), 16128);
    }

    private static void SaveHeader(BufferResource fil, String savename, long time) {
        LoadSave.SaveVersion(fil, 101);
        fil.writeLong(time);
        fil.writeBytes(savename.toCharArray(), 32);
        fil.writeInt(Game.Level);
        fil.writeInt(Game.Skill);
    }

    private static void SavePlayers(BufferResource fil) {
        fil.writeShort(Mmulti.numplayers);
        fil.writeShort(WangNetwork.CommPlayers);
        fil.writeShort(Mmulti.myconnectindex);
        fil.writeShort(Mmulti.connecthead);
        fil.writeBytes(Mmulti.connectpoint2);
        int i = 0;
        while (i < Mmulti.numplayers) {
            fil.writeBytes((Object)Game.Player[i].getBytes());
            ++i;
        }
    }

    private static void SavePanelSprites(BufferResource fil) {
        int ndx = 0;
        int i = 0;
        while (i < Mmulti.numplayers) {
            PlayerStr pp = Game.Player[i];
            ndx = 0;
            Panel_Sprite cur = pp.PanelSpriteList.Next;
            while (cur != pp.PanelSpriteList) {
                Panel_Sprite n = cur.Next;
                fil.writeInt(ndx);
                fil.writeInt(List.PanelSpriteToNdx(pp.PanelSpriteList, cur.sibling));
                cur.save(fil);
                ++ndx;
                cur = n;
            }
            fil.writeInt(-1);
            ++i;
        }
    }

    private static void SaveMap(BufferResource fil) {
        if (Game.boardfilename != null) {
            fil.writeBytes(Game.boardfilename.toCharArray(), 144);
        } else {
            fil.writeBytes(new byte[144], 144);
        }
        fil.writeShort(Engine.numwalls);
        int w = 0;
        while (w < Engine.numwalls) {
            fil.writeBytes((Object)Engine.wall[w].getBytes());
            ++w;
        }
        fil.writeShort(Engine.numsectors);
        int s = 0;
        while (s < Engine.numsectors) {
            fil.writeBytes((Object)Engine.sector[s].getBytes());
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            fil.writeBytes((Object)Engine.sprite[i].getBytes());
            ++i;
        }
        fil.writeBytes(Engine.headspritesect);
        fil.writeBytes(Engine.headspritestat);
        fil.writeBytes(Engine.prevspritesect);
        fil.writeBytes(Engine.prevspritestat);
        fil.writeBytes(Engine.nextspritesect);
        fil.writeBytes(Engine.nextspritestat);
        fil.writeInt(Weapon.FinishTimer);
        fil.writeBoolean(Game.FinishedLevel);
        fil.writeInt(Game.FinishAnim);
        fil.writeInt(Sound.playTrack);
    }

    private static void SaveSectorUserInfos(BufferResource fil) {
        int i = 0;
        while (i < Engine.numsectors) {
            fil.writeInt(Sector.SectUser[i] != null ? i : -1);
            if (Sector.SectUser[i] != null) {
                fil.writeBytes((Object)Sector.SectUser[i].getBytes());
            }
            ++i;
        }
    }

    private static void SaveUserInfos(BufferResource fil) {
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            fil.writeInt(Gameutils.pUser[i] != null ? i : -1);
            if (Gameutils.pUser[i] != null) {
                Gameutils.pUser[i].save(fil);
            }
            ++i;
        }
    }

    private static void SaveSectorObjects(BufferResource fil) {
        int i = 0;
        while (i < 25) {
            fil.writeBytes((Object)Sprites.SectorObject[i].getBytes());
            ++i;
        }
    }

    private static void SaveSineSect(BufferResource fil) {
        int j;
        int i = 0;
        while (i < 6) {
            j = 0;
            while (j < 21) {
                Sector.SineWaveFloor[i][j].save(fil);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 64) {
                Sector.SineWall[i][j].save(fil);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            Sector.SpringBoard[i].save(fil);
            ++i;
        }
    }

    private static void SaveTracks(BufferResource fil) {
        int i = 0;
        while (i < 100) {
            TRACK tr = Track.Track[i];
            fil.writeInt(tr.ttflags);
            fil.writeShort(tr.flags);
            fil.writeShort(tr.NumPoints);
            if (tr.NumPoints != 0) {
                int j = 0;
                while (j < tr.NumPoints) {
                    TRACK_POINT tp = tr.TrackPoint[j];
                    fil.writeInt(tp.x);
                    fil.writeInt(tp.y);
                    fil.writeInt(tp.z);
                    fil.writeShort(tp.ang);
                    fil.writeShort(tp.tag_low);
                    fil.writeShort(tp.tag_high);
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void SaveAnims(BufferResource fil) {
        fil.writeInt(Sector.AnimCnt);
        int i = 0;
        while (i < 256) {
            Sector.pAnim[i].save(fil);
            ++i;
        }
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Main.game.net.FakeMultiplayer) {
            return;
        }
        if (!MyTypes.TEST(Game.Player[Mmulti.myconnectindex].Flags, Gameutils.PF_DEAD)) {
            gQuickSaving = true;
        }
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        final String loadname = Main.game.pSavemgr.getLast();
        if (loadname != null && LoadSave.canLoad(loadname)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadname));
            Main.gLoadingScreen.init(new Runnable(){

                @Override
                public void run() {
                    if (!LoadSave.loadgame(loadname)) {
                        Main.game.show();
                    }
                }
            });
        }
    }

    public static boolean checkfile(Resource bb) {
        int nVersion = LoadSave.checkSave(bb);
        if (nVersion != 101) {
            return false;
        }
        return loader.load(bb);
    }

    public static boolean canLoad(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            int nVersion = LoadSave.checkSave(fil);
            if (nVersion != 101 && nVersion >= 100) {
                final GameInfo addon = loader.LoadGDXHeader(fil);
                if (LoadSave.loader.Level <= 20 && LoadSave.loader.Skill >= 0 && LoadSave.loader.Skill < 4 && LoadSave.loader.warp_on != 2) {
                    MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
                    menu.setRunnable(new Runnable(){

                        @Override
                        public void run() {
                            GameInfo game = addon != null ? addon : Game.defGame;
                            int nEpisode = game.getNumEpisode(LoadSave.loader.Level);
                            int nLevel = game.getNumLevel(LoadSave.loader.Level);
                            Main.gGameScreen.newgame(false, game, nEpisode, nLevel, LoadSave.loader.Skill);
                        }
                    });
                    Main.game.menu.mOpen(menu, -1);
                }
            }
            fil.close();
            return nVersion == 101;
        }
        return false;
    }

    public static boolean loadgame(String filename) {
        FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Read);
        if (fil != null) {
            boolean status = LoadSave.checkfile(fil);
            fil.close();
            if (status) {
                LoadSave.load();
                if (lastload == null || lastload.isEmpty()) {
                    lastload = filename;
                }
                if (loader.getMessage() != null) {
                    Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], loader.getMessage());
                }
                return true;
            }
            Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Incompatible version of saved game found!");
            return false;
        }
        Text.PutStringInfo(Game.Player[Mmulti.myconnectindex], "Can't access to file or file not found!");
        return false;
    }

    public static void LoadGDXBlock() {
        if (LoadSave.loader.warp_on == 0) {
            Main.mUserFlag = Main.UserFlag.None;
        }
        if (LoadSave.loader.warp_on == 1) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (LoadSave.loader.warp_on == 2) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            GameInfo ini = LoadSave.loader.addon;
            ResourceHandler.checkEpisodeResources(ini);
        } else {
            ResourceHandler.resetEpisodeResources();
        }
    }

    public static void load() {
        if (Game.rec != null) {
            Game.rec.close();
        }
        Game.Level = LoadSave.loader.Level;
        Game.Skill = LoadSave.loader.Skill;
        LoadSave.LoadGDXBlock();
        LoadSave.MapLoad();
        LoadSave.LoadPlayers();
        LoadSave.LoadSectorUserInfos();
        LoadSave.LoadUserInfos();
        LoadSave.LoadSectorObjects();
        LoadSave.LoadSineSect();
        Sector.x_min_bound = LoadSave.loader.x_min_bound;
        Sector.y_min_bound = LoadSave.loader.y_min_bound;
        Sector.x_max_bound = LoadSave.loader.x_max_bound;
        Sector.y_max_bound = LoadSave.loader.y_max_bound;
        LoadSave.LoadTracks();
        Game.screenpeek = LoadSave.loader.screenpeek;
        Game.totalsynctics = LoadSave.loader.totalsynctics;
        LoadSave.LoadAnims();
        Engine.totalclock = LoadSave.loader.totalclock;
        Main.engine.srand(LoadSave.loader.randomseed);
        Player.NormalVisibility = LoadSave.loader.NormalVisibility;
        Engine.visibility = LoadSave.loader.visibility;
        Engine.parallaxtype = LoadSave.loader.parallaxtype;
        Engine.parallaxyoffs = LoadSave.loader.parallaxyoffs;
        System.arraycopy(LoadSave.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Engine.pskybits = LoadSave.loader.pskybits;
        Sprites.MoveSkip2 = LoadSave.loader.MoveSkip2;
        Sprites.MoveSkip4 = LoadSave.loader.MoveSkip4;
        Sprites.MoveSkip8 = LoadSave.loader.MoveSkip8;
        LoadSave.LoadMirrors();
        LoadSave.LoadQueues();
        LoadSave.LoadStuff();
        Sound.StopFX();
        Draw.SetRedrawScreen(Game.Player[Mmulti.myconnectindex]);
        Game.screenpeek = Mmulti.myconnectindex;
        Game.PlayingLevel = Game.Level;
        int i = Mmulti.connecthead;
        while (i != -1) {
            Game.Player[i].PlayerTalking = false;
            Game.Player[i].TalkVocnum = -1;
            Game.Player[i].TalkVocHandle = null;
            Game.Player[i].StartColor = 0;
            i = Mmulti.connectpoint2[i];
        }
        i = Sector.AnimCnt - 1;
        while (i >= 0) {
            Anim gAnm = Sector.pAnim[i];
            Object object = gAnm.ptr = Sector.GetAnimObject(gAnm.index, gAnm.type);
            switch (gAnm.type) {
                case FloorZ: {
                    Main.game.pInt.setfloorinterpolate(gAnm.index, (SECTOR)object);
                    break;
                }
                case CeilZ: {
                    Main.game.pInt.setceilinterpolate(gAnm.index, (SECTOR)object);
                    break;
                }
                case SpriteZ: {
                    Main.game.pInt.setsprinterpolate(gAnm.index, (SPRITE)object);
                    break;
                }
            }
            --i;
        }
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                ResourceHandler.InitSpecialTextures();
                Palette.DoPlayerDivePalette(Game.Player[Mmulti.myconnectindex]);
                Palette.DoPlayerNightVisionPalette(Game.Player[Mmulti.myconnectindex]);
                Main.gs.AutoAim = (Game.Player[Mmulti.myconnectindex].Flags & Gameutils.PF_AUTO_AIM) != 0;
                BuildGdx.audio.getSound().setReverb(false, 0.0f);
                Main.game.pInput.resetMousePos();
                Main.game.gPaused = false;
                Main.game.nNetMode = BuildGame.NetMode.Single;
                Main.game.changeScreen(Main.gGameScreen);
                int SavePlayClock = Game.PlayClock;
                Game.InitTimingVars();
                Game.PlayClock = SavePlayClock;
                Main.game.pNet.WaitForAllPlayers(0);
                Main.game.pNet.ready2send = true;
                Sumo.triedplay = false;
                if (LoadSave.loader.playTrack != -1) {
                    Sound.CDAudio_Play(LoadSave.loader.playTrack, true);
                } else {
                    Sound.CDAudio_Play(Sound.RedBookSong[Game.Level], true);
                }
                Sound.StartAmbientSound();
                System.gc();
            }
        });
        Main.game.changeScreen(Main.gPrecacheScreen);
    }

    private static void MapLoad() {
        Game.boardfilename = LoadSave.loader.boardfilename;
        Engine.numwalls = LoadSave.loader.numwalls;
        int w = 0;
        while (w < Engine.numwalls) {
            if (Engine.wall[w] == null) {
                Engine.wall[w] = new WALL();
            }
            Engine.wall[w].set(LoadSave.loader.wall[w]);
            ++w;
        }
        Engine.numsectors = LoadSave.loader.numsectors;
        int s = 0;
        while (s < Engine.numsectors) {
            if (Engine.sector[s] == null) {
                Engine.sector[s] = new SECTOR();
            }
            Engine.sector[s].set(LoadSave.loader.sector[s]);
            ++s;
        }
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            if (Engine.sprite[i] == null) {
                Engine.sprite[i] = new SPRITE();
            }
            Engine.sprite[i].set(LoadSave.loader.sprite[i]);
            ++i;
        }
        System.arraycopy(LoadSave.loader.headspritesect, 0, Engine.headspritesect, 0, Engine.MAXSECTORS + 1);
        System.arraycopy(LoadSave.loader.headspritestat, 0, Engine.headspritestat, 0, 1025);
        System.arraycopy(LoadSave.loader.prevspritesect, 0, Engine.prevspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.prevspritestat, 0, Engine.prevspritestat, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritesect, 0, Engine.nextspritesect, 0, Engine.MAXSPRITES);
        System.arraycopy(LoadSave.loader.nextspritestat, 0, Engine.nextspritestat, 0, Engine.MAXSPRITES);
        Weapon.FinishTimer = LoadSave.loader.FinishTimer;
        Game.FinishedLevel = LoadSave.loader.FinishedLevel;
        Game.FinishAnim = LoadSave.loader.FinishAnim;
    }

    private static void LoadPlayers() {
        Mmulti.numplayers = LoadSave.loader.numplayers;
        WangNetwork.CommPlayers = LoadSave.loader.CommPlayers;
        Mmulti.myconnectindex = LoadSave.loader.myconnectindex;
        Mmulti.connecthead = LoadSave.loader.connecthead;
        System.arraycopy(LoadSave.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, 16);
        int i = 0;
        while (i < Mmulti.numplayers) {
            Game.Player[i].copy(LoadSave.loader.Player[i]);
            ++i;
        }
    }

    private static void LoadSectorUserInfos() {
        int i = 0;
        while (i < Engine.numsectors) {
            if (LoadSave.loader.SectUser[i] != null) {
                if (Sector.SectUser[i] == null) {
                    Sector.SectUser[i] = new Sect_User();
                }
                Sector.SectUser[i].copy(LoadSave.loader.SectUser[i]);
            }
            ++i;
        }
    }

    private static void LoadUserInfos() {
        int i = 0;
        while (i < Engine.MAXSPRITES) {
            Gameutils.pUser[i] = LoadSave.loader.pUser[i];
            ++i;
        }
    }

    private static void LoadSectorObjects() {
        int i = 0;
        while (i < 25) {
            Sprites.SectorObject[i].copy(LoadSave.loader.SectorObject[i]);
            ++i;
        }
    }

    private static void LoadSineSect() {
        int i = 0;
        while (i < 6) {
            System.arraycopy(LoadSave.loader.SineWaveFloor[i], 0, Sector.SineWaveFloor[i], 0, 21);
            ++i;
        }
        i = 0;
        while (i < 10) {
            System.arraycopy(LoadSave.loader.SineWall[i], 0, Sector.SineWall[i], 0, 64);
            ++i;
        }
        System.arraycopy(LoadSave.loader.SpringBoard, 0, Sector.SpringBoard, 0, 20);
    }

    private static void LoadTracks() {
        int i = 0;
        while (i < 100) {
            if (Track.Track[i] == null) {
                Track.Track[i] = new TRACK();
            }
            Track.Track[i].copy(LoadSave.loader.Track[i]);
            ++i;
        }
    }

    private static void LoadAnims() {
        Sector.AnimCnt = LoadSave.loader.AnimCnt;
        int i = 0;
        while (i < 256) {
            Sector.pAnim[i].copy(LoadSave.loader.pAnim[i]);
            ++i;
        }
    }

    private static void LoadMirrors() {
        JSector.mirrorcnt = LoadSave.loader.mirrorcnt;
        JSector.mirrorinview = LoadSave.loader.mirrorinview;
        int i = 0;
        while (i < 8) {
            if (JSector.mirror[i] == null) {
                JSector.mirror[i] = new MirrorType();
            }
            JSector.mirror[i].copy(LoadSave.loader.mirror[i]);
            ++i;
        }
    }

    private static void LoadQueues() {
        Weapon.StarQueueHead = LoadSave.loader.StarQueueHead;
        System.arraycopy(LoadSave.loader.StarQueue, 0, Weapon.StarQueue, 0, 32);
        Weapon.HoleQueueHead = LoadSave.loader.HoleQueueHead;
        System.arraycopy(LoadSave.loader.HoleQueue, 0, Weapon.HoleQueue, 0, 64);
        Weapon.WallBloodQueueHead = LoadSave.loader.WallBloodQueueHead;
        System.arraycopy(LoadSave.loader.WallBloodQueue, 0, Weapon.WallBloodQueue, 0, 32);
        Weapon.FloorBloodQueueHead = LoadSave.loader.FloorBloodQueueHead;
        System.arraycopy(LoadSave.loader.FloorBloodQueue, 0, Weapon.FloorBloodQueue, 0, 32);
        Weapon.GenericQueueHead = LoadSave.loader.GenericQueueHead;
        System.arraycopy(LoadSave.loader.GenericQueue, 0, Weapon.GenericQueue, 0, 32);
        Weapon.LoWangsQueueHead = LoadSave.loader.LoWangsQueueHead;
        System.arraycopy(LoadSave.loader.LoWangsQueue, 0, Weapon.LoWangsQueue, 0, 16);
    }

    private static void LoadStuff() {
        Game.PlayClock = LoadSave.loader.PlayClock;
        Game.Kills = LoadSave.loader.Kills;
        Game.TotalKillable = LoadSave.loader.TotalKillable;
        Main.gNet.KillLimit = LoadSave.loader.TotalKillable;
        Main.gNet.TimeLimit = LoadSave.loader.TimeLimit;
        Main.gNet.TimeLimitClock = LoadSave.loader.TimeLimitClock;
        Main.gNet.MultiGameType = LoadSave.loader.MultiGameType;
        Main.gNet.TeamPlay = LoadSave.loader.TeamPlay;
        Main.gNet.HurtTeammate = LoadSave.loader.HurtTeammate;
        Main.gNet.SpawnMarkers = LoadSave.loader.SpawnMarkers;
        Main.gNet.NoRespawn = LoadSave.loader.NoRespawn;
        Main.gNet.Nuke = LoadSave.loader.Nuke;
        System.arraycopy(LoadSave.loader.picanm, 0, Engine.picanm, 0, Engine.MAXTILES);
        Sector.LevelSecrets = LoadSave.loader.LevelSecrets;
        System.arraycopy(LoadSave.loader.show2dwall, 0, Engine.show2dwall, 0, Engine.MAXWALLS + 7 >> 3);
        System.arraycopy(LoadSave.loader.show2dsprite, 0, Engine.show2dsprite, 0, Engine.MAXSPRITES + 7 >> 3);
        System.arraycopy(LoadSave.loader.show2dsector, 0, Engine.show2dsector, 0, Engine.MAXSECTORS + 7 >> 3);
        Bunny.Bunny_Count = LoadSave.loader.Bunny_Count;
        Game.GodMode = LoadSave.loader.GodMode;
        Sumo.serpwasseen = LoadSave.loader.serpwasseen;
        Sumo.sumowasseen = LoadSave.loader.sumowasseen;
        Sumo.zillawasseen = LoadSave.loader.zillawasseen;
        System.arraycopy(LoadSave.loader.BossSpriteNum, 0, Sumo.BossSpriteNum, 0, 3);
    }
}

