/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.AnimFile;

public class AnmScreen
extends MovieScreen {
    private String[] ANIMname = new String[]{"sw.anm", "swend.anm", "sumocinm.anm", "zfcin.anm"};
    private int ANIMnum;
    private float ANIMrate;

    public AnmScreen(BuildGame game) {
        super(game, Engine.MAXTILES - 2);
        this.nFlags = 76;
    }

    public boolean init(int anim_num) {
        if (this.isInited()) {
            return false;
        }
        if (anim_num < 0 || anim_num >= this.ANIMname.length) {
            return false;
        }
        if (!this.open(this.ANIMname[anim_num])) {
            return false;
        }
        float kt = (float)Engine.tilesizy[this.TILE_MOVIE] / (float)Engine.tilesizx[this.TILE_MOVIE];
        float kv = (float)Engine.xdim / (float)Engine.ydim;
        float scale = 1.0f;
        scale = kv >= kt ? (float)Engine.ydim / (float)Engine.tilesizx[this.TILE_MOVIE] : (float)Engine.xdim / (float)Engine.tilesizy[this.TILE_MOVIE];
        this.nScale = (int)(scale * 65536.0f);
        this.nPosX = Engine.xdim / 2;
        this.nPosY = Engine.ydim / 2;
        this.ANIMnum = anim_num;
        this.ANIMrate = 0.0f;
        this.frame = 1;
        return true;
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        byte[] animbuf = BuildGdx.cache.getBytes(file, 0);
        if (animbuf == null) {
            return null;
        }
        return new AnimFile(animbuf){

            @Override
            public float getRate() {
                return AnmScreen.this.ANIMrate;
            }
        };
    }

    @Override
    protected void StopAllSounds() {
        Sound.COVER_SetReverb(0);
        if (this.ANIMnum != 0) {
            Sound.StopSound();
        }
    }

    @Override
    protected byte[] DoDrawFrame(int i) {
        this.ANIMrate = 0.0f;
        switch (this.ANIMnum) {
            case 0: {
                this.AnimShareIntro(i, this.mvfil.getFrames());
                break;
            }
            case 1: {
                this.AnimSerp(i, this.mvfil.getFrames());
                break;
            }
            case 2: {
                this.AnimSumo(i, this.mvfil.getFrames());
                break;
            }
            case 3: {
                this.AnimZilla(i, this.mvfil.getFrames());
            }
        }
        return this.mvfil.getFrame(this.frame);
    }

    @Override
    protected BuildFont GetFont() {
        return this.game.getFont(0);
    }

    @Override
    protected void DrawEscText(BuildFont font, int pal) {
        int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        font.drawText(160, 5, "Press ESC to skip", shade, pal, BuildFont.TextAlign.Center, 2, true);
    }

    protected void AnimShareIntro(int frame, int numframes) {
        if (frame == numframes - 1) {
            this.ANIMrate += 1000.0f;
        } else if (frame == 1) {
            Sound.PlaySound(344, null, 0);
            this.ANIMrate += 3000.0f;
        } else {
            this.ANIMrate += 60.0f;
        }
        if (frame == 5) {
            Sound.PlaySound(485, null, 0);
        } else if (frame == 15) {
            Sound.PlaySound(487, null, 0);
        }
    }

    protected void AnimSerp(int frame, int numframes) {
        this.ANIMrate += 130.0f;
        if (frame == numframes - 1) {
            this.ANIMrate += 1250.0f;
        }
        if (frame == 1) {
            Sound.PlaySound(497, null, 0);
        } else if (frame == 16) {
            Sound.PlaySound(507, null, 0);
        } else if (frame == 35) {
            Sound.PlaySound(498, null, 0);
        } else if (frame == 51) {
            Sound.PlaySound(505, null, 0);
        } else if (frame == 64) {
            Sound.PlaySound(506, null, 0);
        }
    }

    protected void AnimSumo(int frame, int numframes) {
        this.ANIMrate += 60.0f;
        if (frame == numframes - 1) {
            this.ANIMrate += 1000.0f;
        }
        if (frame == 1) {
            this.ANIMrate += 250.0f;
        }
        if (frame == 2) {
            Sound.PlaySound(516, null, 0);
        } else if (frame == 30) {
            Sound.PlaySound(508, null, 0);
        } else if (frame == 42) {
            Sound.PlaySound(508, null, 0);
        } else if (frame == 59) {
            Sound.PlaySound(518, null, 0);
        }
    }

    protected void AnimZilla(int frame, int numframes) {
        this.ANIMrate += 130.0f;
        if (frame == numframes - 1) {
            this.ANIMrate += 1250.0f;
        }
        if (frame == 1) {
            Sound.PlaySound(616, null, 0);
        } else if (frame == 5) {
            Sound.PlaySound(612, null, 0);
        } else if (frame == 14) {
            Sound.PlaySound(617, null, 0);
        } else if (frame == 30) {
            Sound.PlaySound(618, null, 0);
        } else if (frame == 32) {
            Sound.PlaySound(619, null, 0);
        } else if (frame == 37) {
            Sound.PlaySound(620, null, 0);
        } else if (frame == 63) {
            Sound.PlaySound(625, null, 0);
            Sound.PlaySound(621, null, 0);
            Sound.PlaySound(622, null, 0);
        } else if (frame == 72) {
            Sound.PlaySound(622, null, 0);
        } else if (frame == 73) {
            Sound.PlaySound(619, null, 0);
        } else if (frame == 77) {
            Sound.PlaySound(620, null, 0);
        } else if (frame == 87) {
            Sound.PlaySound(623, null, 0);
        } else if (frame == 103) {
            Sound.PlaySound(622, null, 0);
        } else if (frame == 108) {
            Sound.PlaySound(624, null, 0);
        } else if (frame == 120) {
            Sound.PlaySound(613, null, 0);
        }
    }
}

