/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.Engine;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Weapon;

public class Rail {
    private static final int RAIL_YOFF = 200;
    private static final int RAIL_XOFF = 166;
    private static final int RAIL_REST = 2010;
    private static final int RAIL_CHARGE = 2015;
    private static final int RAIL_FIRE = 2018;
    private static final int ID_RailPresent0 = 2010;
    private static final int ID_RailRest0 = 2010;
    private static final int ID_RailRest1 = 2011;
    private static final int ID_RailRest2 = 2012;
    private static final int ID_RailRest3 = 2013;
    private static final int ID_RailRest4 = 2014;
    private static final int ID_RailFire0 = 2018;
    private static final int ID_RailFire1 = 2019;
    private static final int ID_RailCharge0 = 2015;
    private static final int ID_RailCharge1 = 2016;
    private static final int ID_RailCharge2 = 2017;
    private static final int Rail_BEAT_RATE = 24;
    private static final int Rail_ACTION_RATE = 3;
    private static final int Rail_CHARGE_RATE = 3;
    private static final Panel_Sprite_Func pRailHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Engine.tilesizy[picnum]) {
                psp.y = 200 + Engine.tilesizy[picnum];
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State[] ps_RailHide = new Panel_State[]{new Panel_State(2010, 24, pRailHide).setNext().setFlags(Panel.psf_ShadeNone)};
    private static final Panel_Sprite_Func pRailRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force;
            boolean bl = force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_RailHide[0])) {
                return;
            }
            Rail.pRailBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) {
                if (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force) {
                    psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                    if (!Panel.WeaponOK(psp.PlayerP())) {
                        return;
                    }
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    if (psp.PlayerP().WpnRailType == 0) {
                        Panel.pSetState(psp, ps_RailFire[0]);
                    } else {
                        Panel.pSetState(psp, ps_RailFireEMP[0]);
                    }
                }
            } else {
                Panel.WeaponOK(psp.PlayerP());
            }
        }
    };
    private static final Panel_State ps_RailRest_0 = new Panel_State(2010, 24, pRailRest);
    private static final Panel_State ps_RailRest_1 = new Panel_State(2011, 24, pRailRest);
    private static final Panel_State ps_RailRest_2 = new Panel_State(2012, 24, pRailRest);
    private static final Panel_State ps_RailRest_3 = new Panel_State(2013, 24, pRailRest);
    private static final Panel_State ps_RailRest_4 = new Panel_State(2014, 24, pRailRest);
    private static final Panel_State[] ps_RailRest = new Panel_State[]{ps_RailRest_0.setNext(ps_RailRest_1).setFlags(Panel.psf_ShadeNone), ps_RailRest_1.setNext(ps_RailRest_2).setFlags(Panel.psf_ShadeNone), ps_RailRest_2.setNext(ps_RailRest_3).setFlags(Panel.psf_ShadeNone), ps_RailRest_3.setNext(ps_RailRest_4).setFlags(Panel.psf_ShadeNone), ps_RailRest_4.setNext(ps_RailRest_0).setFlags(Panel.psf_ShadeNone)};
    private static final Panel_Sprite_Func pRailAction = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Rail.pRailBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
        }
    };
    private static final Panel_Sprite_Func pRailRestTest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force;
            boolean bl = force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_RailHide[0])) {
                return;
            }
            Rail.pRailBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if ((Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) && (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force)) {
                psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                if (!Panel.WeaponOK(psp.PlayerP())) {
                    return;
                }
                Panel.DoPlayerChooseYell(psp.PlayerP());
                return;
            }
            Panel.pSetState(psp, psp.RestState);
        }
    };
    private static final Panel_Sprite_Func pRailFire = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Vis.SpawnVis(psp.PlayerP().PlayerSprite, -1, -1, -1, -1, 16);
            if (psp.PlayerP().WpnRailType == 0) {
                Weapon.InitRail(psp.PlayerP());
            } else {
                Weapon.InitEMP(psp.PlayerP());
            }
        }
    };
    private static final Panel_State ps_RailFireEMP_0 = new Panel_State(2015, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_1 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_2 = new Panel_State(2017, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_3 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_4 = new Panel_State(2018, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_5 = new Panel_State(2019, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_6 = new Panel_State(2019, 3, pRailAction);
    private static final Panel_State ps_RailFireEMP_7 = new Panel_State(2019, 0, pRailFire);
    private static final Panel_State ps_RailFireEMP_8 = new Panel_State(2015, 3, pRailRestTest);
    private static final Panel_State ps_RailFireEMP_9 = new Panel_State(2016, 3, pRailRest);
    private static final Panel_State[] ps_RailFireEMP = new Panel_State[]{ps_RailFireEMP_0.setNext(ps_RailFireEMP_1).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_1.setNext(ps_RailFireEMP_2).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_2.setNext(ps_RailFireEMP_3).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_3.setNext(ps_RailFireEMP_4).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_4.setNext(ps_RailFireEMP_5).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_5.setNext(ps_RailFireEMP_6).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_6.setNext(ps_RailFireEMP_7).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_7.setNext(ps_RailFireEMP_8).setFlags(Panel.psf_ShadeNone | Panel.psf_QuickCall), ps_RailFireEMP_8.setNext(ps_RailFireEMP_9).setFlags(Panel.psf_ShadeNone), ps_RailFireEMP_9.setNext(ps_RailRest[0]).setFlags(Panel.psf_ShadeNone)};
    private static final Panel_Sprite_Func pRailRecoilDown = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Panel.setLong(psp, x += psp.vel * 3 * Engine.sintable[Gameutils.NORM_ANGLE(psp.ang + 512)] >> 6, y += psp.vel * 3 * -Engine.sintable[psp.ang] >> 6);
            psp.vel = (short)(psp.vel - 72);
            if (psp.vel < 800) {
                psp.vel = (short)800;
                psp.ang = Gameutils.NORM_ANGLE(psp.ang + 1024);
                Panel.pStatePlusOne(psp);
            }
        }
    };
    private static final Panel_Sprite_Func pRailRecoilUp = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            int x = Panel.castLongX(psp);
            int y = Panel.castLongY(psp);
            Panel.setLong(psp, x += psp.vel * 3 * Engine.sintable[Gameutils.NORM_ANGLE(psp.ang + 512)] >> 6, y += psp.vel * 3 * -Engine.sintable[psp.ang] >> 6);
            psp.vel = (short)(psp.vel + 45);
            if (psp.y < 200) {
                psp.y = 200;
                psp.x = 166;
                Rail.pRailSetRecoil(psp);
                Panel.pStatePlusOne(psp);
                psp.flags &= ~Panel.PANF_BOB;
            }
        }
    };
    private static final Panel_Sprite_Func pRailOkTest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (Panel.pWeaponHideKeys(psp, ps_RailHide[0])) {
                return;
            }
            Panel.WeaponOK(psp.PlayerP());
        }
    };
    private static final Panel_State ps_RailFire_0 = new Panel_State(2015, 3, pRailAction);
    private static final Panel_State ps_RailFire_1 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFire_2 = new Panel_State(2017, 3, pRailAction);
    private static final Panel_State ps_RailFire_3 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFire_4 = new Panel_State(2018, 3, pRailAction);
    private static final Panel_State ps_RailFire_5 = new Panel_State(2019, 3, pRailAction);
    private static final Panel_State ps_RailFire_6 = new Panel_State(2019, 3, pRailAction);
    private static final Panel_State ps_RailFire_7 = new Panel_State(2019, 0, pRailFire);
    private static final Panel_State ps_RailFire_8 = new Panel_State(2010, 24, pRailRecoilDown);
    private static final Panel_State ps_RailFire_9 = new Panel_State(2010, 24, pRailRecoilUp);
    private static final Panel_State ps_RailFire_10 = new Panel_State(2015, 3, pRailOkTest);
    private static final Panel_State ps_RailFire_11 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFire_12 = new Panel_State(2017, 3, pRailOkTest);
    private static final Panel_State ps_RailFire_13 = new Panel_State(2016, 3, pRailAction);
    private static final Panel_State ps_RailFire_14 = new Panel_State(2015, 4, pRailAction);
    private static final Panel_State ps_RailFire_15 = new Panel_State(2016, 4, pRailAction);
    private static final Panel_State ps_RailFire_16 = new Panel_State(2017, 4, pRailAction);
    private static final Panel_State ps_RailFire_17 = new Panel_State(2016, 5, pRailAction);
    private static final Panel_State ps_RailFire_18 = new Panel_State(2015, 5, pRailAction);
    private static final Panel_State ps_RailFire_19 = new Panel_State(2016, 5, pRailAction);
    private static final Panel_State ps_RailFire_20 = new Panel_State(2017, 6, pRailAction);
    private static final Panel_State ps_RailFire_21 = new Panel_State(2016, 6, pRailAction);
    private static final Panel_State ps_RailFire_22 = new Panel_State(2015, 7, pRailAction);
    private static final Panel_State ps_RailFire_23 = new Panel_State(2016, 7, pRailAction);
    private static final Panel_State ps_RailFire_24 = new Panel_State(2017, 7, pRailAction);
    private static final Panel_State ps_RailFire_25 = new Panel_State(2015, 8, pRailAction);
    private static final Panel_State ps_RailFire_26 = new Panel_State(2016, 8, pRailAction);
    private static final Panel_State ps_RailFire_27 = new Panel_State(2017, 8, pRailAction);
    private static final Panel_State ps_RailFire_28 = new Panel_State(2015, 3, pRailRestTest);
    private static final Panel_State ps_RailFire_29 = new Panel_State(2016, 3, pRailRest);
    private static final Panel_State[] ps_RailFire = new Panel_State[]{ps_RailFire_0.setNext(ps_RailFire_1).setFlags(Panel.psf_ShadeNone), ps_RailFire_1.setNext(ps_RailFire_2).setFlags(Panel.psf_ShadeNone), ps_RailFire_2.setNext(ps_RailFire_3).setFlags(Panel.psf_ShadeNone), ps_RailFire_3.setNext(ps_RailFire_4).setFlags(Panel.psf_ShadeNone), ps_RailFire_4.setNext(ps_RailFire_5).setFlags(Panel.psf_ShadeNone), ps_RailFire_5.setNext(ps_RailFire_6).setFlags(Panel.psf_ShadeNone), ps_RailFire_6.setNext(ps_RailFire_7).setFlags(Panel.psf_ShadeNone), ps_RailFire_7.setNext(ps_RailFire_8).setFlags(Panel.psf_ShadeNone | Panel.psf_QuickCall), ps_RailFire_8.setNext().setPlusOne(ps_RailFire_9).setFlags(Panel.psf_ShadeNone), ps_RailFire_9.setNext().setPlusOne(ps_RailFire_10).setFlags(Panel.psf_ShadeNone), ps_RailFire_10.setNext(ps_RailFire_11).setFlags(Panel.psf_ShadeNone), ps_RailFire_11.setNext(ps_RailFire_12).setFlags(Panel.psf_ShadeNone), ps_RailFire_12.setNext(ps_RailFire_13).setFlags(Panel.psf_ShadeNone), ps_RailFire_13.setNext(ps_RailFire_14).setFlags(Panel.psf_ShadeNone), ps_RailFire_14.setNext(ps_RailFire_15).setFlags(Panel.psf_ShadeNone), ps_RailFire_15.setNext(ps_RailFire_16).setFlags(Panel.psf_ShadeNone), ps_RailFire_16.setNext(ps_RailFire_17).setFlags(Panel.psf_ShadeNone), ps_RailFire_17.setNext(ps_RailFire_18).setFlags(Panel.psf_ShadeNone), ps_RailFire_18.setNext(ps_RailFire_19).setFlags(Panel.psf_ShadeNone), ps_RailFire_19.setNext(ps_RailFire_20).setFlags(Panel.psf_ShadeNone), ps_RailFire_20.setNext(ps_RailFire_21).setFlags(Panel.psf_ShadeNone), ps_RailFire_21.setNext(ps_RailFire_22).setFlags(Panel.psf_ShadeNone), ps_RailFire_22.setNext(ps_RailFire_23).setFlags(Panel.psf_ShadeNone), ps_RailFire_23.setNext(ps_RailFire_24).setFlags(Panel.psf_ShadeNone), ps_RailFire_24.setNext(ps_RailFire_25).setFlags(Panel.psf_ShadeNone), ps_RailFire_25.setNext(ps_RailFire_26).setFlags(Panel.psf_ShadeNone), ps_RailFire_26.setNext(ps_RailFire_27).setFlags(Panel.psf_ShadeNone), ps_RailFire_27.setNext(ps_RailFire_28).setFlags(Panel.psf_ShadeNone), ps_RailFire_28.setNext(ps_RailFire_29).setFlags(Panel.psf_ShadeNone), ps_RailFire_29.setNext(ps_RailRest[0]).setFlags(Panel.psf_ShadeNone)};
    private static final Panel_Sprite_Func pRailPresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.ang = Gameutils.NORM_ANGLE(384);
            Rail.pRailSetRecoil(psp);
            psp.y -= 9;
            if (psp.y < 200) {
                psp.yorig = psp.y = 200;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State[] ps_PresentRail = new Panel_State[]{new Panel_State(2010, 24, pRailPresent).setNext().setFlags(Panel.psf_ShadeNone)};
    private static final Panel_Sprite_Func pRailRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Engine.tilesizy[picnum] + 50) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[psp.WeaponType] = null;
                Sound.DeleteNoSoundOwner(psp.PlayerP().PlayerSprite);
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State[] ps_RetractRail = new Panel_State[]{new Panel_State(2010, 24, pRailRetract).setNext().setFlags(Panel.psf_ShadeNone)};

    public static void InitWeaponRail(PlayerStr pp) {
        Panel_Sprite psp = null;
        if (WangNetwork.Prediction) {
            return;
        }
        pp.WeaponType = (byte)7;
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(pp.WeaponType)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[pp.WeaponType] == null) {
            psp = pp.Wpn[pp.WeaponType] = Panel.pSpawnSprite(pp, ps_PresentRail[0], 128, 166, 200);
            psp.y += Engine.tilesizy[psp.picndx];
        }
        if (pp.CurWpn == pp.Wpn[pp.WeaponType]) {
            return;
        }
        psp.WeaponType = pp.WeaponType;
        Panel.PlayerUpdateWeapon(pp, pp.WeaponType);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[pp.WeaponType];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_RailFire[0];
        psp.RetractState = ps_RetractRail[0];
        psp.PresentState = ps_PresentRail[0];
        psp.RestState = ps_RailRest[0];
        Panel.pSetState(psp, psp.PresentState);
        Sound.PlaySound(243, pp, 1);
        VOC3D voc = Sound.PlaySound(270, pp, 9);
        Sound.Set3DSoundOwner(psp.PlayerP().PlayerSprite, voc);
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void pRailSetRecoil(Panel_Sprite psp) {
        psp.vel = (short)900;
        psp.ang = Gameutils.NORM_ANGLE(-256);
    }

    private static void pRailBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = (short)12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = (short)3;
    }

    public static void RailSaveable() {
        Saveable.SaveData(ps_PresentRail);
        Saveable.SaveData(ps_RailRest);
        Saveable.SaveData(ps_RailHide);
        Saveable.SaveData(ps_RailFire);
        Saveable.SaveData(ps_RailFireEMP);
        Saveable.SaveData(ps_RetractRail);
        Saveable.SaveData(pRailHide);
        Saveable.SaveData(pRailRest);
        Saveable.SaveData(pRailAction);
        Saveable.SaveData(pRailRestTest);
        Saveable.SaveData(pRailFire);
        Saveable.SaveData(pRailRecoilDown);
        Saveable.SaveData(pRailRecoilUp);
        Saveable.SaveData(pRailOkTest);
        Saveable.SaveData(pRailPresent);
        Saveable.SaveData(pRailRetract);
    }
}

