/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;
import ru.m210projects.Witchaven.WHScreen;

public class AIWillow {
    public static final AIState willowDrain = new AIState(){

        @Override
        public void process(PLAYER plr, short i) {
            SPRITE spr = Engine.sprite[i];
            spr.lotag = (short)(spr.lotag - 3);
            if (spr.lotag < 0) {
                WHSND.playsound_loc(WHSND.S_FIREBALL, spr.x, spr.y);
                int oldz = spr.z;
                spr.z += 6144;
                Ai.castspell(plr, i);
                spr.z = oldz;
                WHOBJ.newstatus(i, 2);
            }
        }
    };

    public static void create() {
        Ai.enemy[22] = new Enemy();
        Ai.enemy[22].info = new EnemyInfo(32, 32, 512, 120, 0, 64, true, Main.game.WH2 ? 5 : 400, 0);
        Ai.enemy[22].chase = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    spr.lotag = (short)250;
                }
                short osectnum = spr.sectnum;
                if (Main.engine.krand() % 63 == 0) {
                    if (Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, Engine.sprite[i].x, Engine.sprite[i].y, Engine.sprite[i].z - (Engine.tilesizy[Engine.sprite[i].picnum] << 7), Engine.sprite[i].sectnum) && plr.invisibletime < 0) {
                        WHOBJ.newstatus(i, 6);
                    }
                    return;
                }
                int dax = Engine.sintable[Engine.sprite[i].ang + 512 & 0x7FF] * 3 << 3;
                int day = Engine.sintable[Engine.sprite[i].ang & 0x7FF] * 3 << 3;
                Ai.checksight(plr, i);
                if (!Ai.checkdist(plr, i)) {
                    Ai.checkmove(i, dax, day);
                } else if (Main.engine.krand() % 8 == 0) {
                    WHOBJ.newstatus(i, 6);
                } else {
                    Engine.sprite[i].ang = (short)((Main.engine.krand() & 0x100) + Engine.sprite[i].ang + 1024 & 0x7FF);
                    WHOBJ.newstatus(i, 2);
                }
                Main.engine.getzrange(spr.x, spr.y, spr.z - 1, spr.sectnum, spr.clipdist << 2, 65537);
                if (spr.sectnum != osectnum && Engine.sector[spr.sectnum].lotag == 10) {
                    WHFX.warpsprite(i);
                }
                if (spr.z > Engine.zr_florz) {
                    spr.z = Engine.zr_florz;
                }
                if (spr.z < Engine.zr_ceilz - 8192) {
                    spr.z = Engine.zr_ceilz - 8192;
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, true);
                if (Engine.sector[osectnum].lotag == 4444) {
                    spr.hitag = (short)(spr.hitag - 1);
                    if (spr.hitag < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                if ((Engine.zr_florhit & 0xE000) == 16384 && (Engine.sector[spr.sectnum].floorpicnum == 79 || Engine.sector[spr.sectnum].floorpicnum == 62 || Engine.sector[spr.sectnum].floorpicnum == 61)) {
                    spr.hitag = (short)(spr.hitag - 1);
                    if (spr.hitag < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
            }
        };
        Ai.enemy[22].attack = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                int floorz;
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (plr.z < spr.z) {
                    spr.z -= 768;
                }
                if (plr.z > spr.z) {
                    spr.z += 768;
                }
                if (spr.lotag < 0) {
                    if (Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum)) {
                        if (Ai.checkdist(plr, i)) {
                            if (plr.shockme < 0 && (Main.engine.krand() & 1) != 0) {
                                plr.shockme = 120;
                                if (!Main.game.WH2) {
                                    --plr.lvl;
                                    switch (plr.lvl) {
                                        case 1: {
                                            plr.score = 0;
                                            plr.maxhealth = 100;
                                            break;
                                        }
                                        case 2: {
                                            plr.score = 2350;
                                            plr.maxhealth = 120;
                                            break;
                                        }
                                        case 3: {
                                            plr.score = 4550;
                                            plr.maxhealth = 140;
                                            break;
                                        }
                                        case 4: {
                                            plr.score = 9300;
                                            plr.maxhealth = 160;
                                            break;
                                        }
                                        case 5: {
                                            plr.score = 18400;
                                            plr.maxhealth = 180;
                                            break;
                                        }
                                        case 6: {
                                            plr.score = 36700;
                                            plr.maxhealth = 200;
                                            break;
                                        }
                                        case 7: {
                                            plr.score = 75400;
                                            plr.maxhealth = 200;
                                        }
                                    }
                                    if (plr.lvl < 1) {
                                        plr.lvl = 1;
                                        plr.health = -1;
                                    }
                                    WHScreen.showmessage("Level Drained", 360);
                                } else {
                                    WHScreen.showmessage("Shocked", 360);
                                }
                            }
                        } else {
                            WHOBJ.newstatus(i, 143);
                        }
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                }
                if (spr.z > (floorz = Main.engine.getflorzofslope(spr.sectnum, spr.x, spr.y) - 4096)) {
                    spr.z = floorz;
                }
            }
        };
        Ai.enemy[22].face = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                if (Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum) && plr.invisibletime < 0) {
                    spr.ang = (short)(Main.engine.getangle(plr.x - spr.x, plr.y - spr.y) & 0x7FF);
                    if (plr.shadowtime > 0) {
                        spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.owner = plr.spritenum;
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.owner == plr.spritenum) {
                    spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang & 0x7FF);
                    WHOBJ.newstatus(i, 142);
                } else {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(plr, i)) {
                    WHOBJ.newstatus(i, 6);
                }
            }
        };
        Ai.enemy[22].search = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                Ai.aisearch(plr, i, true);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[22].flee = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                short osectnum = spr.sectnum;
                int movestat = Ai.aifly(i);
                if (movestat != 0) {
                    if ((movestat & 0xE000) == 32768) {
                        int nWall = movestat & 0x1FFF;
                        int nx = -(Engine.wall[Engine.wall[nWall].point2].y - Engine.wall[nWall].y) >> 4;
                        int ny = Engine.wall[Engine.wall[nWall].point2].x - Engine.wall[nWall].x >> 4;
                        spr.ang = Main.engine.getangle(nx, ny);
                    } else {
                        spr.ang = Main.engine.getangle(plr.x - spr.x, plr.y - spr.y);
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.lotag < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if (spr.sectnum != osectnum && Engine.sector[spr.sectnum].lotag == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, true);
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
            }
        };
        Ai.enemy[22].die = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag <= 0) {
                    spr.picnum = (short)(spr.picnum + 1);
                    spr.lotag = (short)20;
                    if (Engine.sprite[i].picnum == 653 || Engine.sprite[i].picnum == 654 || Engine.sprite[i].picnum == 655) {
                        Engine.sprite[i].xrepeat = Engine.sprite[i].yrepeat = (short)(Engine.sprite[i].yrepeat << 1);
                    }
                    if (spr.picnum == 655) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
        Ai.enemy[22].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                if (Main.game.WH2) {
                    WHPLR.chunksofmeat(plr, i, spr.x, spr.y, spr.z, spr.sectnum, spr.ang);
                    WHOBJ.trailingsmoke(i, false);
                    WHOBJ.newstatus(i, 107);
                }
            }
        };
    }

    public static void willowProcess(PLAYER plr) {
        short i = Engine.headspritestat[143];
        while (i >= 0) {
            short nextsprite = Engine.nextspritestat[i];
            SPRITE spr = Engine.sprite[i];
            switch (spr.detail) {
                case 22: {
                    willowDrain.process(plr, i);
                }
            }
            i = nextsprite;
        }
    }

    public static void premap(short i) {
        SPRITE spr = Engine.sprite[i];
        spr.detail = (short)22;
        Ai.enemy[22].info.set(spr);
        spr.cstat = (short)(spr.cstat | 0x80);
        spr.z -= Engine.tilesizy[Names.WILLOW] << 8;
        Main.engine.changespritestat(i, 109);
    }
}

